# -*- coding: utf-8 -*-

"""
/***************************************************************************
 DeepLearningTools
                                 A QGIS plugin
 QGIS plugin to aid training Deep Learning Models
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2020-03-12
        copyright            : (C) 2020 by Philipe Borba
        email                : philipeborba@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Philipe Borba'
__date__ = '2020-03-12'
__copyright__ = '(C) 2020 by Philipe Borba'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.core import QgsProcessingProvider
from DeepLearningTools.core.processing_algorithms.create_training_labels_from_layer_algorithm import \
    CreateTrainingLabelsFromLayerAlgorithm
from DeepLearningTools.core.processing_algorithms.load_images_from_dataset_algorithm import \
    LoadDatasetImagesAlgorithm
# from DeepLearningTools.core.processing_algorithms.create_grid_algorithm import \
#     CreateGridAlgorithm
from DeepLearningTools.core.processing_algorithms.create_train_test_validate_samples_algorithm import \
    CreateTrainTestValidateSamplesAlgorithm
from DeepLearningTools.core.processing_algorithms.find_polygon_statistics_algorithm import \
    FindPolygonStatisticsAlgorithm

class DeepLearningToolsProvider(QgsProcessingProvider):

    def __init__(self):
        """
        Default constructor.
        """
        QgsProcessingProvider.__init__(self)

    def unload(self):
        """
        Unloads the provider. Any tear-down steps required by the provider
        should be implemented here.
        """
        pass

    def getAlgList(self):
        algList = [
            CreateTrainingLabelsFromLayerAlgorithm(),
            LoadDatasetImagesAlgorithm(),
            # CreateGridAlgorithm(),
            CreateTrainTestValidateSamplesAlgorithm(),
            FindPolygonStatisticsAlgorithm()
        ]
        return algList

    def loadAlgorithms(self):
        """
        Loads all algorithms belonging to this provider.
        """
        for alg in self.getAlgList():
            self.addAlgorithm(alg)
        # add additional algorithms here
        # self.addAlgorithm(MyOtherAlgorithm())

    def id(self):
        """
        Returns the unique provider id, used for identifying the provider. This
        string should be a unique, short, character only string, eg "qgis" or
        "gdal". This string should not be localised.
        """
        return 'DeepLearningTools'

    def name(self):
        """
        Returns the provider name, which is used to describe the provider
        within the GUI.

        This string should be short (e.g. "Lastools") and localised.
        """
        return self.tr('DeepLearningTools')

    def icon(self):
        """
        Should return a QIcon which is used for your provider inside
        the Processing toolbox.
        """
        return QgsProcessingProvider.icon(self)

    def longName(self):
        """
        Returns the a longer version of the provider name, which can include
        extra details such as version numbers. E.g. "Lastools LIDAR tools
        (version 2.2.1)". This string should be localised. The default
        implementation returns the same string as name().
        """
        return self.name()
