# -*- coding: utf-8 -*-

"""
/***************************************************************************
 DeepLearningTools
                                 A QGIS plugin
 QGIS plugin to aid training Deep Learning Models
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2020-04-03
        copyright            : (C) 2020 by Philipe Borba
        email                : philipeborba@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from PyQt5.QtCore import QCoreApplication

import os
from pathlib import Path
from qgis.PyQt.QtCore import QCoreApplication
from qgis.core import (QgsProcessing,
                       QgsFeatureSink,
                       QgsProcessingAlgorithm,
                       QgsProcessingParameterFeatureSource,
                       QgsProcessingParameterFeatureSink,
                       QgsProcessingParameterField,
                       QgsProcessingParameterVectorLayer,
                       QgsProcessingParameterBoolean,
                       QgsProcessingException,
                       QgsProcessingParameterNumber,
                       QgsProcessingParameterExpression,
                       QgsProcessingParameterString,
                       QgsProcessingOutputMultipleLayers,
                       QgsProcessingParameterExtent,
                       QgsFeatureRequest,
                       QgsProject,
                       QgsRasterLayer,
                       QgsExpression,
                       QgsExpressionContext,
                       QgsExpressionContextUtils
                       )
from DeepLearningTools.core.image_processing.image_utils import ImageUtils
from qgis.utils import iface


class LoadDatasetImagesAlgorithm(QgsProcessingAlgorithm):
    """
    Algorithm to group layers according to primitive, dataset and a category.
    INPUT_LAYERS: list of QgsVectorLayer
    CATEGORY_TOKEN: token used to split layer name
    CATEGORY_TOKEN_INDEX: index of the split list
    OUTPUT: list of outputs
    """
    INPUT = 'INPUT'
    SELECTED = 'SELECTED'
    EXTENT = 'EXTENT'
    IMAGE_ATTRIBUTE = 'IMAGE_ATTRIBUTE'
    GROUP_EXPRESSION = 'GROUP_EXPRESSION'
    NAME_TAG = 'NAME_TAG'
    ADD_TO_CANVAS = 'ADD_TO_CANVAS'
    UNIQUE_LOAD = 'UNIQUE_LOAD'
    OUTPUT = 'OUTPUT'
    def initAlgorithm(self, config):
        """
        Parameter setting.
        """
        self.addParameter(
            QgsProcessingParameterVectorLayer(
                self.INPUT,
                self.tr('Input layer'),
                [QgsProcessing.TypeVectorPolygon]
            )
        )

        self.addParameter(
            QgsProcessingParameterBoolean(
                self.SELECTED,
                self.tr('Process only selected features')
            )
        )
        self.addParameter(
            QgsProcessingParameterExtent(
                self.EXTENT,
                self.tr('Extent'),
                optional=True
            )
        )
        self.addParameter(
            QgsProcessingParameterField(
                self.IMAGE_ATTRIBUTE,
                self.tr('Image attribute'),
                None, 
                'INPUT',
                QgsProcessingParameterField.String
            )
        )
        self.addParameter(
            QgsProcessingParameterBoolean(
                self.ADD_TO_CANVAS,
                self.tr('Add to canvas'),
                defaultValue=True
            )
        )
        self.addParameter(
            QgsProcessingParameterBoolean(
                self.UNIQUE_LOAD,
                self.tr('Unique load'),
                defaultValue=True
            )
        )
        self.addParameter(
            QgsProcessingParameterExpression(
                self.GROUP_EXPRESSION,
                self.tr('Group expression'),
                defaultValue="",
                optional=True
            )
        )
        self.addParameter(
            QgsProcessingParameterString(
                self.NAME_TAG,
                self.tr('String used as prefix in images'),
                defaultValue="",
                optional=True
            )
        )
        self.addOutput(
            QgsProcessingOutputMultipleLayers(
                self.OUTPUT,
                self.tr('Loaded raster layers')
            )
        )

    def processAlgorithm(self, parameters, context, feedback):
        """
        Here is where the processing itself takes place.
        """
        inputLyr = self.parameterAsVectorLayer(
            parameters,
            self.INPUT,
            context
        )
        if inputLyr is None:
            raise QgsProcessingException(
                self.invalidSourceError(
                    parameters,
                    self.INPUT
                )
            )
        onlySelected = self.parameterAsBool(
            parameters,
            self.SELECTED,
            context
        )
        attributeName = self.parameterAsFields(
            parameters,
            self.IMAGE_ATTRIBUTE,
            context
        )[0]
        groupExpression = self.parameterAsExpression(
            parameters,
            self.GROUP_EXPRESSION,
            context
        )
        imageTag = self.parameterAsString(
            parameters,
            self.NAME_TAG,
            context
        )
        boundingBoxGeometry = self.parameterAsExtentGeometry(
            parameters,
            self.EXTENT,
            context
        )
        loadToCanvas = self.parameterAsBoolean(
            parameters,
            self.ADD_TO_CANVAS,
            context
        )
        uniqueLoad = self.parameterAsBoolean(
            parameters,
            self.UNIQUE_LOAD,
            context
        )
        loadedLayers = {
            i.dataProvider().dataSourceUri() : i.id()
                for i in iface.mapCanvas().layers()\
                    if isinstance(i, QgsRasterLayer)
         } if uniqueLoad else {}
        outputLayers = {}
        request = QgsFeatureRequest()
        if boundingBoxGeometry is not None:
            request.setFilterRect(boundingBoxGeometry.boundingBox())
        request.setFlags(QgsFeatureRequest.NoGeometry)
        request.addOrderBy(
            attributeName,
            ascending=True
        )
        features = inputLyr.getFeatures(request) if not onlySelected \
            else inputLyr.getSelectedFeatures(request)
        #calculate size
        featList = [i for i in features]
        listSize = len(featList)
        progressStep = 100/listSize if listSize else 0
        #remaining parameters
        if loadToCanvas:
            rootNode = QgsProject.instance().layerTreeRoot()
            datasetImageNode = self.createGroup(
                self.tr('Dataset Images'),
                rootNode
            )
            iface.mapCanvas().freeze(True)
        else:
            datasetImageNode = None
        for current, feat in enumerate(featList):
            if feedback.isCanceled():
                break
            image_path = feat[attributeName]
            if image_path in loadedLayers:
                outputLayers[image_path] = loadedLayers[image_path]
                feedback.setProgress(current*progressStep)
                continue
            newImage = QgsRasterLayer(
                image_path,
                '_'.join(
                    [imageTag, os.path.basename(image_path)] if imageTag != ''\
                    else [os.path.basename(image_path)]
                )
            )
            QgsProject.instance().addMapLayer(newImage, False)
            if datasetImageNode is not None:
                currentNode = datasetImageNode if groupExpression is None\
                    else self.getLayerCategoryNode(
                        newImage,
                        datasetImageNode,
                        groupExpression
                    )
                currentNode.addLayer(newImage)
            outputLayers[image_path] = newImage.id()
            feedback.setProgress(current*progressStep)
        if loadToCanvas:
            iface.mapCanvas().freeze(False)
            iface.mapCanvas().refresh()
        return {self.OUTPUT: list(outputLayers.values())}

    def getLayerCategoryNode(self, lyr, rootNode, categoryExpression):
        """
        Finds category node based on category expression
        and creates it (if not exists a node)
        """
        try:
            exp = QgsExpression(categoryExpression)
            context = QgsExpressionContext()
            context.appendScopes(
                QgsExpressionContextUtils.globalProjectLayerScopes(lyr)
            )
            if exp.hasParserError():
                raise Exception(exp.parserErrorString())
            if exp.hasEvalError():
                raise ValueError(exp.evalErrorString())
            categoryText = exp.evaluate(context)
        except:
            return rootNode
        return self.createGroup(categoryText, rootNode)

    def createGroup(self, groupName, rootNode):
        """
        Create group with the name groupName and parent rootNode.
        """
        groupNode = rootNode.findGroup(groupName)
        return groupNode if groupNode else rootNode.addGroup(groupName)

    def name(self):
        """
        Returns the algorithm name, used for identifying the algorithm. This
        string should be fixed for the algorithm, and must not be localised.
        The name should be unique within each provider. Names should contain
        lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'loadimages'

    def displayName(self):
        """
        Returns the translated algorithm name, which should be used for any
        user-visible display of the algorithm name.
        """
        return self.tr('Load images from dataset')

    def group(self):
        """
        Returns the name of the group this algorithm belongs to. This string
        should be localised.
        """
        return self.tr('Dataset Tools')

    def groupId(self):
        """
        Returns the unique ID of the group this algorithm belongs to. This
        string should be fixed for the algorithm, and must not be localised.
        The group id should be unique within each provider. Group id should
        contain lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'datasettools'

    def tr(self, string):
        """
        Translates input string.
        """
        return QCoreApplication.translate('LoadDatasetImagesAlgorithm', string)

    def createInstance(self):
        """
        Creates an instance of this class
        """
        return LoadDatasetImagesAlgorithm()

    def flags(self):
        """
        This process is not thread safe due to the fact that removeChildNode
        method from QgsLayerTreeGroup is not thread safe.
        """
        return super().flags() | QgsProcessingAlgorithm.FlagNoThreading
