# -*- coding: utf-8 -*-
"""
/***************************************************************************
 DamengPluginDialog
                                 A QGIS plugin
 -This plugin is designed for Dameng Database. It can be used to connect to 
Dameng Database and import the selected spatial data tables into QGIS (Quantum 
Geographic Information System) for display as temporary layers. Additionally, the 
plugin allows setting filter conditions for the data in the selected spatial data 
tables, such as SRID (Spatial Reference Identifier), data type, and ROWNUM.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2025-07-16
        git sha              : $Format:%H$
        copyright            : (C) 2025 by Dameng
        email                : yangzhenyu@dameng.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
import asyncio
import dmPython
import uuid
import ipaddress
import socket

from qgis.PyQt.QtGui import QRegExpValidator
from PyQt5.QtCore import QVariant, QRegExp
from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from qgis.PyQt.QtCore import pyqtSignal, QCoreApplication
from qgis.utils import iface
from PyQt5.QtWidgets import QPushButton, QComboBox, QLineEdit, QMessageBox
from qgis.core import (
    QgsVectorLayer, QgsGeometry, QgsFeature, QgsProject,
    QgsFields, QgsField, Qgis
)
# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
#FORM_CLASS, _ = uic.loadUiType(os.path.join(
#    os.path.dirname(__file__), 'damengplugin_dialog_base.ui'))
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'connect.ui'))


class DamengPluginDialog(QtWidgets.QDialog, FORM_CLASS):
    closingPlugin = pyqtSignal()
    loop: asyncio.AbstractEventLoop

    TestConnectButton: QPushButton
    ConnectButton: QPushButton
    QuitButton: QPushButton
    conn: object


    def __init__(self, plugin):
        """Constructor."""
        super().__init__(plugin.iface.mainWindow())
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)
        self.plugin = plugin
        self.init_layout()
        self.conn = None


    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('DamengPluginDialog', message)


    #Init connection ui layout:
    #Test bottun: Test connect to the DM server
    #Connect bottun: Connect to DM database
    #Quit bottun: Quit
    def init_layout(self):
        int_validator = QRegExpValidator(QRegExp("^[0-9]+$"), self.lineEditPort)
        self.lineEditPort.setValidator(int_validator)
        # Associate the button with the function; clicking the button will trigger the function.
        self.TestConnectButton.clicked.connect(self.test_connection_button_clicked)
        self.ConnectButton.clicked.connect(self.connection_button_clicked)
        self.QuitButton.clicked.connect(self.quit_button_clicked)


    def fill_params(self, data):
        if data.get("host", ""):
            self.lineEditHost.setText(data.get("host", ""))
        else:
            self.lineEditHost.setText("localhost")
            
        if data.get("port", ""):
            self.lineEditPort.setText(str(data.get("port", "")))
        else:
            self.lineEditPort.setText("5236")

        self.lineEditUsername.setText(data.get("user", ""))
        self.lineEditPassword.setText(data.get("pwd", ""))


    def quit_button_clicked(self):
        self.plugin.quit_plugin()


    def to_ip(self, address: str):
        address = address.strip()
        if not address:
            raise ValueError(self.tr("IP address could not be empty!"))
        # Attempt direct parsing first.
        try:
            return ipaddress.ip_address(address)
        except ValueError:
            # If it fails, attempt to resolve the hostname.
            try:
                # Prioritize trying IPv4
                ip_str = socket.gethostbyname(address)
                return ipaddress.ip_address(ip_str)
            except (socket.gaierror, ValueError):
                # Try IPv6
                try:
                    for res in socket.getaddrinfo(address, None, socket.AF_INET6):
                        return ipaddress.ip_address(res[4][0])
                except (socket.gaierror, ValueError):
                    raise ValueError(self.tr("IP address is invalid!"))



    def test_connection_button_clicked(self):
        try:
            dbhosttext = self.lineEditHost.text()
            dbhost = self.to_ip(dbhosttext)
            if isinstance(dbhost, ipaddress.IPv6Address):
                dbhost = f'[{dbhosttext}]'
            dbuser = self.lineEditUsername.text()
            dbpasswd = self.lineEditPassword.text()
            dbport = int(self.lineEditPort.text())
            testconn = dmPython.connect(host=str(dbhost), port=dbport, user=dbuser, password=dbpasswd)
            # Connection Success Prompt
            iface.messageBar().pushMessage(
                "Success:", 
                self.tr("Connect to Dameng."),
                 level=Qgis.Success)
            testconn.close()
        except dmPython.Error:
        # Capture Dameng Connection Errors
            iface.messageBar().pushMessage(
                "Error:", 
                self.tr("Could not connect to database with these parameters! Please check your settings and try again."), 
                level=Qgis.Critical)
        except ValueError as e:
            QMessageBox.critical(self, "Input error", str(e))
        except Exception as e:
        # Capture other unknown Errors
            iface.messageBar().pushMessage(
                "Error:", 
                self.tr("Could not connect to database with these parameters!"), 
                level=Qgis.Critical)
            

    def connection_button_clicked(self):
        cursor = None
        try:
            dbhosttext = self.lineEditHost.text()
            dbhost = self.to_ip(dbhosttext)
            if isinstance(dbhost, ipaddress.IPv6Address):
                dbhost = f'[{dbhosttext}]'
            dbuser = self.lineEditUsername.text()
            dbpasswd = self.lineEditPassword.text()
            dbport = int(self.lineEditPort.text())
            conn = dmPython.connect(host=str(dbhost), port=dbport, user=dbuser, password=dbpasswd)
            self.conn = conn

            # Obtain the server storage encoding format information，0[UTF-8], 1[GB18030], 2[EUC-KR]
            cursor = self.conn.cursor()
            # Construct a query SQL
            sql = """SELECT SF_GET_UNICODE_FLAG();"""
            # Execute SQL
            cursor.execute(sql)
            server_code = cursor.fetchone()
            if server_code[0] == 0:
                self.conn.local_code = dmPython.PG_UTF8
            elif server_code[0] == 1:
                self.conn.local_code = dmPython.PG_GBK
            elif server_code[0] == 2:
                self.conn.local_code = dmPython.PG_EUC_KR
            else:
                raise ValueError(self.tr("Unsupported local_code"), server_code[0])
            # Connection Success Prompt
            iface.messageBar().pushMessage(
                "Success:", 
                self.tr("Connect to Dameng."),
                 level=Qgis.Success)
            # Save the connection information
            self.plugin.conn_params = {
                "host": dbhosttext,
                "user": dbuser,
                "pwd": dbpasswd,
                "port": dbport
            }
            self.hide()
            self.plugin.show_import_page()
        except dmPython.Error:
        # Capture Dameng Connection Errors
            iface.messageBar().pushMessage(
                "Error:", 
                self.tr("Could not connect to database with these parameters! Please check your settings and try again."), 
                level=Qgis.Critical)
        except ValueError as e:
            QMessageBox.critical(self, "Input error", str(e))
        except Exception as e:
        # Capture other unknown errors
            iface.messageBar().pushMessage(
                "Error:", 
                self.tr("Could not connect to database with these parameters!"), 
                level=Qgis.Critical)
        finally:
            if cursor:
                cursor.close()


    def closeEvent(self, event):
        self.plugin.quit_plugin()
        event.accept()  #