# -*- coding: utf-8 -*-
"""
/***************************************************************************

 DICT_dialog_cloture.py

 DICTDialogCloture dialog class for "Cloturer DT/DICT/DC/ATU"

                              -------------------
        begin                : 2020-08-05
        git sha              : $Format:%H$
        copyright            : (C) 2020 by Jean-Marie Arsac
        email                : jmarsac@azimut.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import os

from PyQt5 import QtCore, QtGui, QtWidgets, uic
from qgis.core import QgsExpressionContextUtils, QgsProject

from .utils import Utils

FORM_CLASS, _ = uic.loadUiType(
    os.path.join(os.path.dirname(__file__), "DICT_dialog_cloture.ui")
)


class DICTDialogCloture(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(DICTDialogCloture, self).__init__(parent)
        # Set up the user interface from Designer.
        # After setupUI you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)
        self.lineEditUrlReponse.textChanged.connect(
            self.set_variable_url_reponse_from_dialog
        )

    def set_variable_url_reponse_from_dialog(self):
        if self.lineEditUrlReponse.text():
            QgsExpressionContextUtils.setProjectVariable(
                QgsProject.instance(),
                "dict_url_reponse",
                self.lineEditUrlReponse.text(),
            )

    def set_variable_url_reponse_in_dialog(self):
        self.lineEditUrlReponse.textChanged.disconnect(
            self.set_variable_url_reponse_from_dialog
        )
        url_reponse = QgsExpressionContextUtils.projectScope(
            QgsProject.instance()
        ).variable("dict_url_reponse")
        url_reponse = Utils.expandVariablesInString(url_reponse, False, True)
        self.lineEditUrlReponse.setText(url_reponse)
        self.lineEditUrlReponse.textChanged.connect(
            self.set_variable_url_reponse_from_dialog
        )
