# -*- coding: utf-8 -*-
"""
/***************************************************************************
 UTILS
                         utilities class for plugins
                              -------------------
        begin                : 2020-06-19
        git sha              : $Format:%H$
        copyright            : (C) 2020 by Jean-Marie Arsac
        email                : jmarsac@azimut.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import os

from qgis.PyQt.QtCore import (
    QCoreApplication,
    QDir,
    QFile,
    QFileInfo,
    QSettings,
    Qt,
    QTranslator,
    QUrl,
    qVersion,
)
from qgis.core import (
    QgsApplication,
    QgsExpression,
    QgsExpressionContext,
    QgsExpressionContextUtils,
    QgsProject,
    QgsSettings,
)
from qgis.PyQt.QtCore import QRegularExpression, QRegularExpressionMatch


def expand_variables(rgx, context, str_to_expand, all_levels):
    if rgx.match(str_to_expand).hasMatch():
        iter = rgx.globalMatch(str_to_expand)
        while iter.hasNext():
            match = iter.next()
            if context.hasVariable(match.captured()[1:]):
                str_to_expand = str_to_expand.replace(
                    match.captured(), context.variable(match.captured()[1:])
                )
    if all_levels and rgx.match(str_to_expand).hasMatch():
        str_to_expand = expand_variables(rgx, context, str_to_expand)
    else:
        return str_to_expand


class Utils(object):
    """QGIS Plugin utils."""

    def __init__(self):
        """Constructor."""
        print("__init__")

    @classmethod
    def stringContainsVariable(cls, str_to_check):
        regex = QRegularExpression("@[a-zA-Z][a-zA-Z0-9_]*")
        return regex.match(str_to_check).hasMatch()

    @classmethod
    def expandVariablesInString(
        cls, str_to_expand, use_system_separator: bool = False, all_levels: bool = False
    ):
        regex = QRegularExpression("@[a-zA-Z][a-zA-Z0-9_]*")
        if regex.match(str_to_expand).hasMatch():
            context = QgsExpressionContext()
            context.appendScope(QgsExpressionContextUtils.globalScope())
            context.appendScope(
                QgsExpressionContextUtils.projectScope(QgsProject.instance())
            )
            str_to_expand = expand_variables(regex, context, str_to_expand, all_levels)
        return str_to_expand

    @classmethod
    def resolve(cls, name, basepath=None):
        if not basepath:
            basepath = os.path.dirname(os.path.realpath(__file__))
        return os.path.join(basepath, name)

    @staticmethod
    def qgis_version_int():
        try:
            from qgis.core import Qgis
        except ImportError:
            from qgis.core import QGis as Qgis

        return Qgis.QGIS_VERSION_INT
