# Tạo GitHub Release để Publish Plugin lên QGIS Repository

## Vấn Đề:
QGIS Plugin Repository báo lỗi: **"This plugin has no public version yet."**

## Nguyên Nhân:
QGIS Plugin Repository yêu cầu GitHub repository phải có một **public release/tag** khớp với version trong `metadata.txt`. Version hiện tại là `1.0.0`.

## Giải Pháp: Tạo GitHub Release

### Bước 1: Đảm Bảo Code Đã Upload Lên GitHub
1. Đăng nhập GitHub: https://github.com/nqm12a02/DEM-Downscaling
2. Kiểm tra xem tất cả files đã được upload chưa
3. Nếu chưa, upload code lên repository

### Bước 2: Tạo Release (Tag)

#### Cách A: Sử dụng GitHub Web Interface (Dễ nhất)

1. **Vào Repository**: https://github.com/nqm12a02/DEM-Downscaling

2. **Click vào "Releases"** (ở sidebar bên phải, hoặc URL: `https://github.com/nqm12a02/DEM-Downscaling/releases`)

3. **Click "Create a new release"** (hoặc "Draft a new release")

4. **Điền thông tin**:
   - **Tag version**: `1.0.0` (hoặc `v1.0.0`)
     - Chọn "Create new tag: 1.0.0 on publish"
   - **Release title**: `DEM Downscaling Plugin v1.0.0`
   - **Description**:
     ```
     ## DEM Downscaling QGIS Plugin v1.0.0
     
     Initial release of DEM Downscaling Plugin for QGIS.
     
     ### Features:
     - Increase DEM resolution using Hopfield Neural Network method
     - Spatial dependence maximization
     - Elevation constraints
     - Optional GPU acceleration (CuPy)
     - Vectorized tensor operations for fast processing
     
     ### Requirements:
     - QGIS 3.0 or higher
     - Optional: SciPy for CPU vectorization
     - Optional: CuPy for GPU acceleration
     
     ### Installation:
     Install from QGIS Plugin Manager or download the ZIP file.
     ```

5. **Target**: Chọn branch `main` (hoặc `master`)

6. **Set as latest release**: ✅ (tích nếu có)

7. **Click "Publish release"**

#### Cách B: Sử dụng Git Command Line

```bash
cd C:\Minh\DEM_Downscaling

# Tag the current commit
git tag -a v1.0.0 -m "Release version 1.0.0 - Initial release"

# Push tag to GitHub
git push origin v1.0.0

# Hoặc push all tags
git push origin --tags
```

Sau đó vào GitHub và tạo release từ tag này.

### Bước 3: Verify Release

1. Vào: https://github.com/nqm12a02/DEM-Downscaling/releases
2. Kiểm tra release `1.0.0` hoặc `v1.0.0` đã xuất hiện
3. Đảm bảo release là **Public** (không phải Draft)

### Bước 4: Upload Lại Plugin Lên QGIS Repository

Sau khi tạo release thành công:

1. Vào: https://plugins.qgis.org/publish/
2. Upload lại file `DEM_Downscaling.zip`
3. QGIS sẽ tự động tìm thấy release `1.0.0` trong GitHub repository

---

## Lưu Ý Quan Trọng:

1. **Tag version phải khớp** với version trong `metadata.txt`:
   - metadata.txt: `version=1.0.0`
   - GitHub tag: `1.0.0` hoặc `v1.0.0` (cả 2 đều được chấp nhận)

2. **Release phải là PUBLIC**, không được là Draft

3. **Release phải có ít nhất 1 file** hoặc commit trong repository

4. Nếu thay đổi version sau này (ví dụ `1.0.1`), cần tạo release mới với tag tương ứng

---

## Troubleshooting:

### Nếu vẫn báo lỗi sau khi tạo release:

1. **Đợi 1-2 phút**: GitHub cần thời gian để index release

2. **Kiểm tra tag format**:
   - Có thể dùng `1.0.0` hoặc `v1.0.0`
   - Không dùng `release-1.0.0` hoặc các format khác

3. **Kiểm tra repository visibility**:
   - Repository phải là **Public** (không được Private)

4. **Kiểm tra release visibility**:
   - Release không được là **Draft**
   - Release phải có trên trang releases

---

## Quick Checklist:

- [ ] Code đã upload lên GitHub repository
- [ ] Repository là Public
- [ ] Đã tạo release với tag `1.0.0` hoặc `v1.0.0`
- [ ] Release không phải Draft
- [ ] Đã đợi 1-2 phút sau khi tạo release
- [ ] Upload lại plugin ZIP lên QGIS repository
