"""
/***************************************************************************
CARICA CXF 
                                 A QGIS plugin

                             -------------------
        begin                : 2012-09-13
        copyright            : (C) 2012 by Arch. Fabio SAccon
        email                : saccon@gisplan.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from PyQt4.QtGui import QMessageBox  
from qgis.core import *
from qgis.utils import iface
import globals
import os

def db_view_all(self,lista):

        dirstili=""
        index=0
        for group in iface.legendInterface().groupLayerRelationship() :
          if group[0]=="Catasto":
             iface.legendInterface().removeGroup(0)
          index+=1
        uri = QgsDataSourceURI()
        if self.testdb() and self.ui.postgis.isChecked():

            uri.setConnection(str(globals.line[0]),"5432",str(globals.line[1]),str(globals.line[2]),str(globals.line[3]))
        else:
            uri.setDatabase(globals.dbName)

        uri.setDataSource(globals.schema.replace(".",""),'particelle', 'geom')
        vl_part = QgsVectorLayer(uri.uri(), 'Particelle', globals.datadb)
        uri.setDataSource(globals.schema.replace(".",""),'fabbricati', 'geom')
        vl_ed = QgsVectorLayer(uri.uri(), 'Fabbricati', globals.datadb)
        uri.setDataSource(globals.schema.replace(".",""),'strade', 'geom')
        vl_st = QgsVectorLayer(uri.uri(), 'Strade', globals.datadb)
        uri.setDataSource(globals.schema.replace(".",""),'confine', 'geom')
        vl_conf = QgsVectorLayer(uri.uri(), 'Confine', globals.datadb)
        uri.setDataSource(globals.schema.replace(".",""),'acque', 'geom')
        vl_aq = QgsVectorLayer(uri.uri(), 'Acque', globals.datadb)
        uri.setDataSource(globals.schema.replace(".",""),'linee', 'geom')
        vl_linee = QgsVectorLayer(uri.uri(), 'Linee', globals.datadb)
        uri.setDataSource(globals.schema.replace(".",""),'simboli', 'geom')
        vl_point = QgsVectorLayer(uri.uri(), 'Simboli', globals.datadb)
        uri.setDataSource(globals.schema.replace(".",""),'testi', 'geom')
        vl_testo = QgsVectorLayer(uri.uri(), 'Testi', globals.datadb)
        uri.setDataSource(globals.schema.replace(".",""),'fiduciali', 'geom')
        vl_fidu = QgsVectorLayer(uri.uri(), 'Fiduciali', globals.datadb)




        vl_part.updateExtents()
        vl_ed.updateExtents()
        vl_st.updateExtents()
        vl_aq.updateExtents()
        vl_conf.updateExtents()
        vl_linee.updateExtents()
        vl_point.updateExtents()
        vl_testo.updateExtents()
 

 

        QgsMapLayerRegistry.instance().addMapLayer(vl_part)  
        QgsMapLayerRegistry.instance().addMapLayer(vl_ed)              
        QgsMapLayerRegistry.instance().addMapLayer(vl_st)           
        QgsMapLayerRegistry.instance().addMapLayer(vl_conf)            
        QgsMapLayerRegistry.instance().addMapLayer(vl_aq)
        QgsMapLayerRegistry.instance().addMapLayer(vl_linee)          
        QgsMapLayerRegistry.instance().addMapLayer(vl_point)           
        QgsMapLayerRegistry.instance().addMapLayer(vl_testo) 
        QgsMapLayerRegistry.instance().addMapLayer(vl_fidu)  
        db_view_change_style() 
        index=iface.legendInterface().addGroup("Catasto",False) 
        livelligruppofoglio=[vl_aq,vl_st,vl_conf,vl_part,vl_testo,vl_fidu,vl_ed,vl_point,vl_linee]
        for l in livelligruppofoglio:
            iface.legendInterface().moveLayer(l, index)


        for group in iface.legendInterface().groupLayerRelationship():
            if group[0] == "Catasto":
                gruppo = group[1]
                layers = QgsMapLayerRegistry.instance().mapLayers()
                for name, layer in layers.iteritems():
                    if name in gruppo:
                        if layer.type() == QgsMapLayer.VectorLayer:
                            layer.setSubsetString(lista)

        # layers = QgsMapLayerRegistry.instance().mapLayers()
        # for name, layer in layers.iteritems():
        #   layerType = layer.type()
        #   if layerType == QgsMapLayer.VectorLayer:
        #    if sqlstring!="":
        #     layer.setSubsetString(sqlstring)
        db_view_change_style() 
            
def db_view_change_style():  
        in_file =open(os.getenv("HOME")+'/.qgis2/python/plugins/Cxf_in/setting.sty', 'r')     
        for line in in_file:
           if line[:4]=="att:":            
            dirstili=line.split (":",2)[2].replace("\n","")
            if(os.path.exists(dirstili) ==False):
                dirstili=  os.getenv("HOME")+'/.qgis2/python/plugins/Cxf_in/QML_Default'
            
        in_file.close()
        layers = iface.legendInterface().layers()
        for layer in layers:
          if layer.name() == "Particelle":
            layer.loadNamedStyle(dirstili+'/part.qml')
          elif layer.name() == "Fabbricati":
            layer.loadNamedStyle(dirstili+'/fab.qml') 
          elif layer.name() == "Strade":
            layer.loadNamedStyle(dirstili+'/strade.qml')
          elif layer.name() == "Confine":
            layer.loadNamedStyle(dirstili+'/conf.qml')        
          elif layer.name() == "Acque":           
            layer.loadNamedStyle(dirstili+'/acque.qml')
          elif layer.name() == "Linee":
            layer.loadNamedStyle(dirstili+'/linee.qml')
          elif layer.name() == "Simboli":         
            layer.loadNamedStyle(dirstili+'/Simboli.qml')
          elif layer.name() == "Testi":         
            layer.loadNamedStyle(dirstili+'/testo.qml')
          elif layer.name() == "Fiduciali":
            layer.loadNamedStyle(dirstili+'/fidu.qml')  
          iface.mapCanvas().refresh()

def db_view_sel(self,lista):
        # sele="Nomefile IN ('G994_000100') AND ((EXT='') or (Ext is Null))"
        # index=0
        # for group in iface.legendInterface().groupLayerRelationship() :
        #   if group[0]=="Catasto":
        #    index+=1
        # if index==0:
        #   db_view_all(self,lista)
        # else:
        #  layers = QgsMapLayerRegistry.instance().mapLayers()
        #  for name, layer in layers.iteritems():
        #   layerType = layer.type()
        #   if layerType == QgsMapLayer.VectorLayer:
        #     layer.setSubsetString(lista)

        index = 0
        for group in iface.legendInterface().groupLayerRelationship():
            if group[0] == "Catasto":
                index+=1
                gruppo = group[1]
                layers = QgsMapLayerRegistry.instance().mapLayers()
                for name, layer in layers.iteritems():
                    if name in gruppo:
                        if layer.type() == QgsMapLayer.VectorLayer:
                         layer.setSubsetString(lista)
        if index == 0:
                db_view_all(self, lista)


        db_view_change_style()