# -*- coding: utf-8 -*-
"""
/***************************************************************************
CARICA CXF 
                                 A QGIS plugin

                             -------------------
        begin                : 2012-09-13
        copyright            : (C) 2012 by Arch. Fabio SAccon
        email                : saccon@gisplan.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from pyspatialite import dbapi2 as sqlite3


from PyQt4.QtGui import *
from PyQt4.QtGui import QMessageBox
from PyQt4.QtCore import *
from PyQt4.QtWebKit import QWebView
from qgis.core import *
from qgis.utils import iface
from ui_cercacat import Ui_cercacat
from ui_pathstile import Ui_Pathstile
from ui_registrazione import Ui_regristrazione
from  memory_layer import *
from  db_reset import *
from  db_layer import *
from  db_view import *
from  db_create import *

# create the dialog for zoom to point
import urllib
import urllib2
import fileinput
import sys, os, imp,re

import webbrowser
import globals
path = ""



class Registazione (QDialog,Ui_regristrazione):
      def __init__(self,page):   
        QDialog.__init__(self, None)
        self.setupUi(self)    
        self.Page=page
        self.esci.clicked.connect (self.closediag  )
        if page=="register":
           self.webView.setUrl(QUrl('http://www.prgcloud.com/auth/register.php'))
        if page=="reset":
           self.webView.setUrl(QUrl('http://www.prgcloud.com/auth/reset-pwd-req.php'))
        self.webView.show()
        
        
            
      def closediag ( self ):

          self.close()     

class Pathstile(QDialog,Ui_Pathstile):
      def __init__(self,tipo):   
        QDialog.__init__(self, None)
        self.Tipo=tipo
        self.setupUi(self)    
        if tipo!="n":
            self.desc.setReadOnly(True) 
            self.dir.setText(self.Tipo.split(":",1) [1] )
            self.desc.setText(self.Tipo.split(":",1) [0] )     
        self.esci_2.clicked.connect (self.closediag  )
        self.esci.clicked.connect (self.createeditstilepath)  
        self.cercadir.clicked.connect(self.searchpath)
      
      def searchpath( self ):
          #self.hide()
          read_path=os.getenv("HOME")+'/.qgis2/python/plugins/Cxf_in/'
          (dirname) = QFileDialog.getExistingDirectory(self,
                      "Seleziona una Directory",read_path)  
          self.dir.setText(dirname)

          #self.show ()
                          
      def createeditstilepath( self ):    
           if self.Tipo=="n":
              if  self.dir.toPlainText()!="" and self.desc.toPlainText()!="" : 
               with open(os.getenv("HOME")+'/.qgis2/python/plugins/Cxf_in/setting.sty', 'ab') as in_file:    
                 in_file.writelines(self.desc.toPlainText()+":"+self.dir.toPlainText()+"\n")
               in_file.close()
               self.close() 
              else:  

                QMessageBox.information(None, "Attenzione :","Per savare una nuova configurazione di stili /ndeve essere indicata una Descrizione e un Percorso di ricerca")      
           else :
               
              for line in fileinput.input(os.getenv("HOME")+'/.qgis2/python/plugins/Cxf_in/setting.sty', inplace=True):
                      if line.split(":",1)[0]==self.desc.toPlainText():
                          line=self.desc.toPlainText()+":"+self.dir.toPlainText().replace("\n","")+"\n"
                      print  line, 
              fileinput.close()       
           self.close()
            
      def closediag ( self ):

          self.close()                 
        
class catDialog(QDockWidget):
    def __init__(self, iface):
        QDockWidget.__init__(self, None)

        self.ui = Ui_cercacat()
        self.ui.setupUi(self)
        self.ui.dbreset.clicked.connect(self.dbreset)
        self.ui.viewall.clicked.connect(self.viewall)
        self.ui.viewsel.clicked.connect(self.viewsel)
        self.ui.cxfspatialite.clicked.connect(self.dbloadcxf)
        self.ui.geoconn.clicked.connect(self.connectgeodb)
        self.ui.registrazione.clicked.connect(self.userreg)
        self.ui.rstpwd.clicked.connect(self.resetpwd)
        self.ui.cxfmemory.clicked.connect(self.cxfmemory)
        self.ui.dbdeletefg.clicked.connect(self.deletefg)
        self.ui.toolBox.currentChanged.connect(self.ric_mapp)
        self.ui.cat_com.currentIndexChanged.connect(self.populatericercaFogli)
        self.ui.del_cat_com.currentIndexChanged.connect(self.populatedeleteFogli)
        self.ui.cat_fg.currentIndexChanged.connect(self.populateMapp)
        self.ui.gisplan.clicked.connect(self.info)
        self.ui.donate.clicked.connect(self.donate)
        self.ui.listcomune.itemClicked.connect (self.Fogli_selezione)
        self.ui.selstile.clicked.connect (self.stile_selezione)
        self.ui.editstile.clicked.connect (self.edit_style)
        self.ui.newstile.clicked.connect (self.create_style)
        self.ui.delstile.clicked.connect (self.del_style)
        ocon = sqlite3.connect(globals.dbName)
        ocur = ocon.cursor() 
        ocur.execute('SELECT InitSpatialMetadata()') 

 
        

               
        self.ui.georef_db.hide()
        db_create()
        self.populateVisualizzaione() 
        
    def unload(self):
        # Remove the plugin menu item and icon
        self.iface.removePluginMenu(u"&Cxf_in", self.action)
        self.iface.removeToolBarIcon(self.action) 
        
    def del_style (self):  
           item =self.ui.lststile.invisibleRootItem()   
           for i in range(item.childCount()):        
               if item.child(i).isSelected () :
                    for line in fileinput.input(os.getenv("HOME")+'/.qgis2/python/plugins/Cxf_in/setting.sty', inplace=True):
                      if line.split(":",1)[0]==item.child(i).text(0):
                           continue
                      print  line,               

           self.populatestili() 

    def edit_style (self):  
           item =self.ui.lststile.invisibleRootItem()   
           for i in range(item.childCount()):        
               if item.child(i).isSelected () :
                self.dlg = Pathstile(item.child(i).text(0)+":"+item.child(i).data(0, Qt.UserRole))
                self.dlg.show ()                 
                result = self.dlg.exec_()
                self.populatestili() 
             
    def create_style( self ):
          self.dlg = Pathstile("n")
          self.dlg.show ()
          result = self.dlg.exec_()  
          self.populatestili()  
    def info( self ): 
          webbrowser.open("http://www.gisplan.it")
    def donate( self ): 
          webbrowser.open("https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=28M43B8FURPNW") 
    def userreg( self ):  
        self.dlg = Registazione("register")
        self.dlg.show () 
        result = self.dlg.exec_()    
    def resetpwd( self ):  
        self.dlg = Registazione("reset")
        self.dlg.show () 
        result = self.dlg.exec_()    
    def connectgeodb( self ):  
       if  self.ui.geoconn.text()== "Disconnetti Utente":
              self.ui.georef_db.hide() 
              self.ui.label_13.setText ("Registrazione utente per georeferenziazione")
              self.ui.label_14.show() 
              self.ui.label_15.show()
              self.ui.label_16.show() 
              self.ui.user.show()  
              self.ui.password.show() 
              self.ui.rstpwd.show() 
              self.ui.registrazione.show() 
      
                   
              self.ui.user.setReadOnly(False)
              self.ui.password.setReadOnly(False) 
              self.ui.user.setAutoFillBackground(False)
              self.ui.user.setStyleSheet("QLineEdit{ background-color :  rgb(255, 255, 255); color :  rgb(0, 0, 0); }")     
              self.ui.user.setText("")             
              self.ui.password.setAutoFillBackground(False)
              self.ui.password.setText("")
              self.ui.password.setStyleSheet("QLineEdit{ background-color :  rgb(255, 255, 255); color :  rgb(0, 0, 0); }")       
              self.ui.geoconn.setText ("Connessione al server di georeferenziazione")       
              
       else: 
        try:

          req='http://www.prgcloud.com/auth/usercheck.php?username='+self.ui.user.text()+'&password='+self.ui.password.text()
          try:
           with contextlib.closing(urllib.urlopen(req)) as x:
            for line in x:
               # print line
                html=line
                break          
          except urllib2.URLError as err:
                print err


          user=html.split("|")
          if user[0].strip()=='verificato':  
              self.ui.georef_db.show() 
              self.ui.label_13.setText ("Bentornato "+user[1])
              self.ui.label_14.hide() 
              self.ui.label_15.hide()  
              self.ui.label_16.hide()
              self.ui.user.hide()  
              self.ui.password.hide()
              self.ui.rstpwd.hide() 
              self.ui.registrazione.hide() 

              self.ui.user.setReadOnly(True)
              self.ui.password.setReadOnly(True) 
              self.ui.user.setAutoFillBackground(True)
              self.ui.user.setStyleSheet("QLineEdit{ background-color :  rgb(244, 217, 221); color :  rgb(0, 0, 255); }")                  
              self.ui.password.setAutoFillBackground(True)
             
              self.ui.password.setStyleSheet("QLineEdit{ background-color :  rgb(244, 217, 221); color :  rgb(0, 0, 255); }")    
              self.ui.geoconn.setText ("Disconnetti Utente")
              
              msgBox = QMessageBox()
              msgBox.setText('Utente riconosciuto')
              msgBox.addButton(QPushButton('OK'), QMessageBox.YesRole)
    
              bottone= QPushButton("Supporta lo Sviluppo")
              bottone.setIcon (QIcon(':/plugins/Cxf_in/paypal.png'))
              bottone.setIconSize(QSize(80,25))
              msgBox.addButton(bottone, QMessageBox.NoRole)
              #msgBox.setIconPixmap(QPixmap(':/plugins/Cxf_in/paypal.png'))
              ex=msgBox.exec_()
              if ex==1: 
              #QMessageBox.information(None, "Avviso :","Utente riconosciuto"+str(ex))  
                webbrowser.open("https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=28M43B8FURPNW") 
          

          else:
             if html!="":
              QMessageBox.information(None, "Errore :","Utente o password errati"  )
                                   
              
             else:
              QMessageBox.information(None, "Errore :","Devono essere inseriti user e password" ) 
              
        except ValueError:
            QMessageBox.information(None, "Errore :","il database non è stato connesso/n verifica le credenziali.")
            print "ERROR IN CONNECTION"
            
    
        
    def viewall(self ): 
        ocon = sqlite3.connect(globals.dbName)
        ocur = ocon.cursor()  
        ocur.execute("delete  FROM 'Selezione'") 
        ocon.commit()
        ocur.execute("INSERT INTO Selezione  (Nomefile,Codice_comune,Fg,Sel)  select distinct Nomefile,Codice_comune,Fg, '1' from 'particelle' order by Nomefile")
        ocon.commit()
        self.populateVisualizzaione() 

        if self.ui.singolfg.isChecked() :
          lista = "((EXT='') or (Ext is Null))"
        else:
         lista=" "
        
        db_view_all(self,lista) 
        
        iface.mapCanvas().zoomToFullExtent()

    def viewsel( self ):
        ocon = sqlite3.connect(globals.dbName)
        ocur = ocon.cursor()  
        ocur.execute("select distinct Nomefile,Sel from Selezione order by Nomefile")
        lista="("
        for d in ocur:
          if d[1] == "1":
            lista+="'"+d[0]+"',"
        lista=lista[:-1]+")"
        #QMessageBox.information(None, "Errore0 :",lista)  
        if lista!=")": 

         lista="Nomefile IN "+lista 
         if self.ui.singolfg.isChecked() :
          lista = lista + " AND ((EXT='') or (Ext is Null))"  
          #QMessageBox.information(None, "Errore :",lista)  
          db_view_sel(self,lista)
          
        else:
         lista="Nomefile=='9999'"
        #QMessageBox.information(None, "Errore1 :",lista) 
        db_view_sel(self,lista)
        
        iface.mapCanvas().zoomToFullExtent()
                
    def dbreset( self ):     
          db_reset()
          db_create()

    def deletefg( self ): 
        uri = QgsDataSourceURI()
        uri.setDatabase(globals.dbName)
        uri.setDataSource('','Particelle', 'geom')                          
        vl_part = QgsVectorLayer(uri.uri(), 'Particelle', 'spatialite')   
        uri.setDataSource('','Fabbricati', 'geom')  
        vl_ed = QgsVectorLayer(uri.uri(), 'Fabbricati', 'spatialite')
        uri.setDataSource('','Strade', 'geom')
        vl_st = QgsVectorLayer(uri.uri(), 'Strade', 'spatialite')
        uri.setDataSource('','Confine', 'geom') 
        vl_conf = QgsVectorLayer(uri.uri(), 'Confine', 'spatialite')
        uri.setDataSource('','Acque', 'geom')
        vl_aq = QgsVectorLayer(uri.uri(), 'Acque', 'spatialite')
        uri.setDataSource('','Linee', 'geom')
        vl_linee = QgsVectorLayer(uri.uri(), 'Linee', 'spatialite')
        uri.setDataSource('','Simboli', 'geom')
        vl_point = QgsVectorLayer(uri.uri(), 'Simboli', 'spatialite')
        uri.setDataSource('','Testi', 'geom')
        vl_testo = QgsVectorLayer(uri.uri(), 'Testi', 'spatialite')
        uri.setDataSource('','Fiduciali', 'geom')
        vl_fidu = QgsVectorLayer(uri.uri(), 'Fiduciali', 'spatialite')      
        layers = QgsMapLayerRegistry.instance().mapLayers()              
        ocon = sqlite3.connect(globals.dbName)
        ocur = ocon.cursor()  
        nfile = self.ui.del_cat_com.currentText()+"_"+self.ui.del_cat_fg.currentText().replace ("_","")     
        ret = QMessageBox.question(None,"ATTENZIONE", "Vuoi veramente cancellare il foglio "+self.ui.del_cat_fg.currentText()+" del Comune "+self.ui.del_cat_com.currentText(),QMessageBox.Yes, QMessageBox.No)
        if ret == QMessageBox.Yes:
          ocur.execute("delete from particelle where Nomefile='"+nfile+"'")
          ocur.execute("delete from fabbricati where   Nomefile='"+nfile+"'")                               
          ocur.execute("delete from Strade where  Nomefile='"+nfile+"'")
          ocur.execute("delete from Confine where Nomefile='"+nfile+"'")        
          ocur.execute("delete from Acque where Nomefile='"+nfile+"'")                  
          ocur.execute("delete from Linee where Nomefile='"+nfile+"'")                 
          ocur.execute("delete from Simboli where Nomefile='"+nfile+"'")                 
          ocur.execute("delete from Testi where Nomefile='"+nfile+"'")       
          ocur.execute("delete from Fiduciali where Nomefile='"+nfile+"'")                       
          vl_ed.updateExtents()
          vl_st.updateExtents()
          vl_aq.updateExtents()
          vl_conf.updateExtents()
          vl_linee.updateExtents()
          vl_point.updateExtents()
          vl_testo.updateExtents()
          ocur.execute('VACUUM')
          ocon.commit()


        ocur.close()     
         
    def dbloadcxf( self ): 
         db_load(self)
         
    def ric_mapp( self ):    
        if  self.ui.toolBox.currentIndex()==1 :
          layers = QgsMapLayerRegistry.instance().mapLayers()   
          okpart=False         
          for name, layid in layers.iteritems(): 
           if layid.name() =='Particelle':
            okpart=True          
          if okpart:  
           self.populateRicerca()     
        if  self.ui.toolBox.currentIndex()==5 :
                self.populatestili() 
        if  self.ui.toolBox.currentIndex()==0 :
                self.populateVisualizzaione() 
        if  self.ui.toolBox.currentIndex()==4 :
                self.populatedelete() 
        
    def cxfmemory( self ):
        if os.path.exists(os.getenv("HOME")+'/workpath'):
           fpath = open(os.getenv("HOME")+'/workpath', 'r') 
           read_path = fpath.read()
           fpath.close
        else:
            read_path ="."     
        (filename, filter) = QFileDialog.getOpenFileNamesAndFilter(iface.mainWindow(),
                      "Seleziona un file cxf da caricare...",read_path,
                      "CXF files (*.cxf)",
                      "Filtro per selezione file")
        if len(filename)==0:
              return
        memory_layer(self,filename)
    def stile_selezione(self):    
       item =self.ui.lststile.invisibleRootItem()   
       for i in range(item.childCount()):        
          if item.child(i).isSelected () :
            self.ui.attstile.setText(item.child(i).text(0))
            for line in fileinput.input(os.getenv("HOME")+'/.qgis2/python/plugins/Cxf_in/setting.sty', inplace=True):
              if line[:4]=="att:":
                  line="att:"+item.child(i).text(0)+":"+item.child(i).data(0, Qt.UserRole)
              print  line,
       db_view_change_style()
       

    def Fogli_selezione(self, item, column):
        ocon = sqlite3.connect(globals.dbName)
        ocur = ocon.cursor()    
    
        if item.checkState(column) == Qt.Checked:
            if item.parent():
                #selezione  il foglio per comune selezionato              
                ocur.execute("update Selezione set Sel='1' where Nomefile='"+item.data(0, Qt.UserRole)+"'")
                ocon.commit()
                allview=True                
                for i in range(item.parent().childCount()):
                    if item.parent().child(i).checkState(column) == Qt.Unchecked:
                        allview=False
                if allview==True:                   
                    item.parent().setCheckState(column, Qt.Checked)
            else:
              #selezione tutti i fogli per comune selezionato
              for i in range(item.childCount()):
                 item.child(i).setCheckState(column, Qt.Checked)
              ocur.execute("update Selezione set Sel='1' where Codice_comune='"+item.data(0, Qt.UserRole)+"'")
              ocon.commit()
              
        else:
            if item.parent():
                item.parent().setCheckState(column, Qt.Unchecked)
                ocur.execute("update Selezione set Sel=Null where Nomefile='"+item.data(0, Qt.UserRole)+"'")
                ocon.commit()
            else:
               #deselezione tutti i fogli per comune selezionato
              for i in range(item.childCount()):
                  item.child(i).setCheckState(column, Qt.Unchecked)
              
              ocur.execute("update Selezione set Sel=Null where Codice_comune='"+item.data(0, Qt.UserRole)+"'")
              ocon.commit()
              
    def populatestili(self):
        def addParent( parent, column, title, data):
            item = QTreeWidgetItem(parent,[title])
            item.setData(column, Qt.UserRole, data)
            item.setChildIndicatorPolicy(QTreeWidgetItem.ShowIndicator)
            item.setExpanded (True)

            return item
        self.ui.lststile.clear()          
        in_file =open(os.getenv("HOME")+'/.qgis2/python/plugins/Cxf_in/setting.sty', 'r')     
        for line in in_file:
           if line[:4]!="att:":            
            campo = line.split (":",1)
            parent= addParent(self.ui.lststile.invisibleRootItem(),0,campo[0],campo[1]) 
           else:
            campo = line.split (":",2)
            self.ui.attstile.setText(campo[1])
        in_file.close()
            
    def populateVisualizzaione( self ): 
        fpath =os.getenv("HOME")+'/.qgis2/python/plugins/cxf_in/CTCOMCAT.txt'
        in_file = open(fpath,"r")
        testo= in_file.readlines()
        in_file.close     
        def addParent( parent, column, title, data,sel):
            item = QTreeWidgetItem(parent,[title])
            item.setData(column, Qt.UserRole, data)
            item.setChildIndicatorPolicy(QTreeWidgetItem.ShowIndicator)
            item.setExpanded (False)
            item.setCheckState (column, sel)
            return item      
        def addChild( parent, column, title, data,sel):
            item = QTreeWidgetItem(parent, [title])
            item.setData(column, Qt.UserRole, data)
            item.setCheckState (column, sel)
            return item        
        ocon = sqlite3.connect(globals.dbName)
        ocur = ocon.cursor()
        ocur.execute("insert into Selezione (Codice_comune,Fg,Nomefile)  SELECT distinct Codice_comune,Fg,Nomefile  from particelle  where Nomefile not in (select Nomefile from Selezione)")
        ocon.commit()
        ocur.execute("delete from Selezione where Nomefile in (SELECT  Nomefile  from Selezione  where Nomefile not in (select distinct Nomefile from particelle))")
        ocon.commit()
        self.ui.listcomune.clear()            
        ocur.execute("select Codice_comune,Fg,Nomefile,Sel from Selezione order by Nomefile")
        comune=""
        for d in ocur:
          if  d[3]=="1":
           selezionato= Qt.Checked
          else:
           selezionato= Qt.Unchecked
          
          if (d[0]) !=comune:   
           for ctcom in testo:
                line=ctcom.split(",")
                if line[0].strip()==d[0]:
                      desccom=line[3].strip()
           parent= addParent(self.ui.listcomune.invisibleRootItem(),0,desccom,d[0],selezionato)             
           addChild( parent,0,d[2][5:9]+"_"+d[2][9:10]+"_"+d[2][10:11],d[2],selezionato)           
           comune = d[0]     
          else:
           item=addChild( parent,0,d[2][5:9]+"_"+d[2][9:10]+"_"+d[2][10:11],d[2],selezionato)
           if selezionato== Qt.Unchecked :
            item.parent().setCheckState(0, Qt.Unchecked)
        
        
    def populateRicerca( self ):
        self.ui.cat_com.setEditable(True)
        self.ui.cat_com.clear()

        ocon = sqlite3.connect(globals.dbName)

        ocur = ocon.cursor()
        ocur.execute("SELECT distinct Codice_comune from Selezione")
        ocon.commit()
                                                     
        myListA = []
        for d in ocur:
         myListA.append(d[0])  
        

        self.ui.cat_com.addItems( myListA )
        

        ocon.close()  
    def populatedelete( self ):
        self.ui.del_cat_com.setEditable(True)
        self.ui.del_cat_com.clear()

        ocon = sqlite3.connect(globals.dbName)
        ocur = ocon.cursor()
        ocur.execute("SELECT distinct Codice_comune from particelle")
        ocon.commit()
                                                     
        myListA = []
        for d in ocur:
         myListA.append(d[0])  
        

        self.ui.del_cat_com.addItems( myListA )
        

        ocon.close()  
        
        
    def populatericercaFogli( self ):
        self.ui.cat_fg.setEnabled(True) 
        self.ui.cat_fg.setEditable(True) 

        self.ui.cat_fg.clear()

        ocon = sqlite3.connect(globals.dbName)

        ocur = ocon.cursor()
        ocur.execute("SELECT distinct Nomefile from Selezione where Codice_comune='"+self.ui.cat_com.currentText() +"' and Sel='1'")

        ocon.commit()
                                      
        lista=[]
        for d in ocur:  
         lista.append(d[0][5:9]+"_"+d[0][9:10]+"_"+d[0][10:11])
        self.ui.cat_fg.addItems( sorted(lista) ) 
        self.ui.cat_fg.clearEditText()
        ocon.close()
        
             
    def populatedeleteFogli( self ):
        self.ui.del_cat_fg.setEnabled(True) 
        self.ui.del_cat_fg.setEditable(True) 
        comune =self.ui.del_cat_com.currentText() 
        self.ui.del_cat_fg.clear()

        ocon = sqlite3.connect(globals.dbName)

        ocur = ocon.cursor()
        ocur.execute("SELECT distinct Nomefile from particelle where Codice_comune='"+comune+"'")

        ocon.commit()
                                      
        lista=[]
        for d in ocur:  
         lista.append(d[0][5:9]+"_"+d[0][9:10]+"_"+d[0][10:11])
        self.ui.del_cat_fg.addItems( sorted(lista) ) 
        self.ui.del_cat_fg.clearEditText()
        ocon.close()  
        
        
    def populateMapp( self ):
   
        self.ui.cat_mapp.setEditable(True)
        self.ui.cat_mapp.clear()

        ocon = sqlite3.connect(globals.dbName)

        ocur = ocon.cursor()

        ocur.execute("SELECT distinct Mappale from Particelle where Nomefile='"+self.ui.cat_com.currentText()+"_"+self.ui.cat_fg.currentText().replace ("_","")+"'")

        ocon.commit()
        self.ui.cat_mapp.setEnabled(True)                                               
        lista=[]
        for d in ocur:
         lista.append(d[0])     

        
        self.ui.cat_mapp.addItems( sorted(lista) )
        self.ui.cat_mapp.clearEditText() 
        self.ui.cat_mapp.currentIndexChanged.connect(self.zoomtosel)
        ocon.close()  

    def zoomtosel( self ):        
        layer = QgsMapLayerRegistry.instance().mapLayersByName("Particelle") [0] 
        iface.setActiveLayer(layer) 
        iter= layer.getFeatures()
        nfile = layer.fieldNameIndex('Nomefile')
        map = layer.fieldNameIndex('Mappale')
        layer.removeSelection ()
        foglio=self.ui.cat_com.currentText()+"_"+self.ui.cat_fg.currentText().replace ('_','')
 
  
        for feature in iter:

         if feature.attributes()[nfile]==self.ui.cat_com.currentText()+"_"+self.ui.cat_fg.currentText().replace ('_','') and feature.attributes()[map]==self.ui.cat_mapp.currentText() :
           

           layer.select( feature.id())
           iface.actionZoomToSelected().trigger() 
        