"""
/***************************************************************************
CARICA CXF 
                                 A QGIS plugin

                             -------------------
        begin                : 2012-09-13
        copyright            : (C) 2012 by Arch. Fabio SAccon
        email                : saccon@gisplan.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from PyQt4.QtGui import QMessageBox  
from qgis.core import *
from qgis.utils import iface
import globals
import os

def db_view_all(self,sqlstring):
        
        dirstili=""
        index=0
        for group in iface.legendInterface().groupLayerRelationship() :
          if group[0]=="Catasto":
             iface.legendInterface().removeGroup(0)
          index+=1
        uri = QgsDataSourceURI()
        uri.setDatabase(globals.dbName)
        
          
        uri.setDataSource('','Particelle', 'geom')                          
        vl_part = QgsVectorLayer(uri.uri(), 'Particelle', 'spatialite')   
        uri.setDataSource('','Fabbricati', 'geom')  
        vl_ed = QgsVectorLayer(uri.uri(), 'Fabbricati', 'spatialite')
        uri.setDataSource('','Strade', 'geom')
        vl_st = QgsVectorLayer(uri.uri(), 'Strade', 'spatialite')
        uri.setDataSource('','Confine', 'geom') 
        vl_conf = QgsVectorLayer(uri.uri(), 'Confine', 'spatialite')
        uri.setDataSource('','Acque', 'geom')
        vl_aq = QgsVectorLayer(uri.uri(), 'Acque', 'spatialite')
        uri.setDataSource('','Linee', 'geom')
        vl_linee = QgsVectorLayer(uri.uri(), 'Linee', 'spatialite')
        uri.setDataSource('','Simboli', 'geom')
        vl_point = QgsVectorLayer(uri.uri(), 'Simboli', 'spatialite')
        uri.setDataSource('','Testi', 'geom')                         
        vl_testo = QgsVectorLayer(uri.uri(), 'Testi', 'spatialite')
        uri.setDataSource('','Fiduciali', 'geom')
        vl_fidu = QgsVectorLayer(uri.uri(), 'Fiduciali', 'spatialite')
        vl_part.updateExtents()
        vl_ed.updateExtents()
        vl_st.updateExtents()
        vl_aq.updateExtents()
        vl_conf.updateExtents()
        vl_linee.updateExtents()
        vl_point.updateExtents()
        vl_testo.updateExtents()
 

 

        QgsMapLayerRegistry.instance().addMapLayer(vl_part)  
        QgsMapLayerRegistry.instance().addMapLayer(vl_ed)              
        QgsMapLayerRegistry.instance().addMapLayer(vl_st)           
        QgsMapLayerRegistry.instance().addMapLayer(vl_conf)            
        QgsMapLayerRegistry.instance().addMapLayer(vl_aq)
        QgsMapLayerRegistry.instance().addMapLayer(vl_linee)          
        QgsMapLayerRegistry.instance().addMapLayer(vl_point)           
        QgsMapLayerRegistry.instance().addMapLayer(vl_testo) 
        QgsMapLayerRegistry.instance().addMapLayer(vl_fidu)  
        db_view_change_style() 
        index=iface.legendInterface().addGroup("Catasto",False) 
        livelligruppofoglio=[vl_aq,vl_st,vl_conf,vl_part,vl_testo,vl_fidu,vl_ed,vl_point,vl_linee]
        for l in livelligruppofoglio:
            iface.legendInterface().moveLayer(l, index)
            
        layers = QgsMapLayerRegistry.instance().mapLayers()
        for name, layer in layers.iteritems():
          if sqlstring!="":
            layer.setSubsetString(sqlstring)
        db_view_change_style() 
            
def db_view_change_style():  
        in_file =open(os.getenv("HOME")+'/.qgis2/python/plugins/Cxf_in/setting.sty', 'r')     
        for line in in_file:
           if line[:4]=="att:":            
            dirstili=line.split (":",2)[2].replace("\n","")
        in_file.close()
        layers = iface.legendInterface().layers()
        for layer in layers:
          if layer.name() == "Particelle":
            layer.loadNamedStyle(dirstili+'/part.qml')
          elif layer.name() == "Fabbricati":
            layer.loadNamedStyle(dirstili+'/fab.qml') 
          elif layer.name() == "Strade":
            layer.loadNamedStyle(dirstili+'/strade.qml')
          elif layer.name() == "Confine":
            layer.loadNamedStyle(dirstili+'/conf.qml')        
          elif layer.name() == "Acque":           
            layer.loadNamedStyle(dirstili+'/acque.qml')
          elif layer.name() == "Linee":
            layer.loadNamedStyle(dirstili+'/linee.qml')
          elif layer.name() == "Simboli":         
            layer.loadNamedStyle(dirstili+'/Simboli.qml')
          elif layer.name() == "Testi":         
            layer.loadNamedStyle(dirstili+'/testo.qml')
          elif layer.name() == "Fiduciali":
            layer.loadNamedStyle(dirstili+'/fidu.qml')  
          iface.mapCanvas().refresh()  
def db_view_sel(self,lista): 
        index=0
        for group in iface.legendInterface().groupLayerRelationship() :
          if group[0]=="Catasto":
           index+=1
        if index==0:
          db_view_all(self,lista)
        else:      
         layers = QgsMapLayerRegistry.instance().mapLayers()
         for name, layer in layers.iteritems():
           if layer.type() != QgsMapLayer.RasterLayer:                 
            layer.setSubsetString(lista)
         db_view_change_style()           