"""
/***************************************************************************
CARICA CXF 
                                 A QGIS plugin

                             -------------------
        begin                : 2012-09-13
        copyright            : (C) 2012 by Arch. Fabio SAccon
        email                : saccon@gisplan.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from PyQt4.QtGui import *
from PyQt4.QtCore import *  
from qgis.core import *
from qgis.utils import iface
from qgis.gui import *
from pyspatialite import dbapi2 as sqlite3
from db_load_cxf  import *
import globals
import os


def db_load():

        uri = QgsDataSourceURI()
        uri.setDatabase(globals.dbName)
        uri.setDataSource('','Particelle', 'geom')                          
        vl_part = QgsVectorLayer(uri.uri(), 'Particelle', 'spatialite')   
        uri.setDataSource('','Fabbricati', 'geom')  
        vl_ed = QgsVectorLayer(uri.uri(), 'Fabbricati', 'spatialite')
        uri.setDataSource('','Strade', 'geom')
        vl_st = QgsVectorLayer(uri.uri(), 'Strade', 'spatialite')
        uri.setDataSource('','Confine', 'geom') 
        vl_conf = QgsVectorLayer(uri.uri(), 'Confine', 'spatialite')
        uri.setDataSource('','Acque', 'geom')
        vl_aq = QgsVectorLayer(uri.uri(), 'Acque', 'spatialite')
        uri.setDataSource('','Linee', 'geom')
        vl_linee = QgsVectorLayer(uri.uri(), 'Linee', 'spatialite')
        uri.setDataSource('','Simboli', 'geom')
        vl_point = QgsVectorLayer(uri.uri(), 'Simboli', 'spatialite')
        uri.setDataSource('','Testi', 'geom')
        vl_testo = QgsVectorLayer(uri.uri(), 'Testi', 'spatialite')
        uri.setDataSource('','Fiduciali', 'geom')
        vl_fidu = QgsVectorLayer(uri.uri(), 'Fiduciali', 'spatialite')      
        layers = QgsMapLayerRegistry.instance().mapLayers() 
        
        
        if os.path.exists(os.getenv("HOME")+'/workpath'):
           fpath = open(os.getenv("HOME")+'/workpath', 'r') 
           read_path = fpath.read()
           fpath.close
        else:
            read_path ="."     
        (filename, filter) = QFileDialog.getOpenFileNamesAndFilter(iface.mainWindow(),
                      "Seleziona un file cxf da caricare...",read_path,
                      "CXF files (*.cxf)",
                      "Filtro per selezione file")
        if len(filename)==0:
              return
          
        fpath = open(os.getenv("HOME")+'/workpath', 'w')
        fpath.write(os.path.dirname(filename[0])) 
        fpath.close  
        ocon = sqlite3.connect(globals.dbName)
        ocur = ocon.cursor()       
        for f in filename:
            liv=os.path.basename (os.path.splitext( str(f))[0])
            ocur.execute("SELECT distinct Nomefile from particelle where Nomefile='"+liv[0:11]+"'")                                   
            lista=""
            conta=0
            for d in ocur:
                conta+=1
                lista+=d[0]                     
            if conta>0 :     
                ocur.execute("delete from particelle where Nomefile='"+liv[0:11]+"'")            
                ocur.execute("delete from fabbricati where Nomefile='"+liv[0:11]+"'")                                        
                ocur.execute("delete from Strade where Nomefile='"+liv[0:11]+"'")                  
                ocur.execute("delete from Confine where Nomefile='"+liv[0:11]+"'")                  
                ocur.execute("delete from Acque where Nomefile='"+liv[0:11]+"'")                  
                ocur.execute("delete from Linee where Nomefile='"+liv[0:11]+"'")                  
                ocur.execute("delete from Simboli where Nomefile='"+liv[0:11]+"'")                  
                ocur.execute("delete from Testi where Nomefile='"+liv[0:11]+"'")                 
                ocur.execute("delete from Fiduciali where Nomefile='"+liv[0:11]+"'")                   
                ocur.execute("VACUUM")  
            load_cxf(str(f),liv,ocur,ocon)   
        vl_ed.updateExtents()
        vl_st.updateExtents()
        vl_aq.updateExtents()
        vl_conf.updateExtents()
        vl_linee.updateExtents()
        vl_point.updateExtents()
        vl_testo.updateExtents()
        ocur.execute('VACUUM')
        ocon.commit()
        ocur.close() 