"""
/***************************************************************************
CARICA CXF 
                                 A QGIS plugin

                             -------------------
        begin                : 2012-09-13
        copyright            : (C) 2012 by Arch. Fabio SAccon
        email                : saccon@gisplan.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from PyQt4.QtGui import *
from PyQt4.QtGui import QMessageBox
from PyQt4.QtCore import *
from qgis.core import *
from qgis.utils import iface
from qgis.gui import *
from pyspatialite import dbapi2 as sqlite3
import math
import ntpath
CRS=""

def load_cxf(filename,liv,ocur,ocon):
  try:
      in_file = open(filename,"r")
  except IOError:
      print 'Impossibile aprire il file', filename
      sys.exit()
      
  def dispoint(livello,codice ):
        geometria=[]
        simbolo= in_file.readline().strip()
        angolo= in_file.readline().strip()
        x=float(in_file.readline().strip())
        y=float(in_file.readline().strip())
        esterno=""
        if codice[-1:]=="\\" :
          esterno = "1"
          codice=codice[:-1]
        sgeometria="point ("+str(x)+" "+str(y)+")"
        sql = "INSERT INTO Simboli (Codice_comune,Fg,Mappale,Allegato,Sez,Nomefile,Ext,Simbolo,Rot,geom) VALUES  ("
        sql +="'"+ liv[0:4] + "','" + liv[5:9] + "','" + codice + "','" + liv[9:10] + "','" + liv[10:11] + "','" + liv[0:11]+ "','" + esterno
        sql +="','"+simbolo+"','"+str(math.degrees(float(angolo)))+"',"          
        sql +="GeomFromText('"+ sgeometria+"',"+CRS+"))"          
        ocur.execute(sql)
                              
  def disfidu(livello,codice ):
        geometria=[]
        numero= in_file.readline().strip()
        idenum= in_file.readline().strip()
        x=float(in_file.readline().strip())
        y=float(in_file.readline().strip())
        relx=float(in_file.readline().strip())
        rely=float(in_file.readline().strip()) 
        esterno=""
        if codice[-1:]=="\\" :
          esterno = "1"
          codice=codice[:-1]
        sgeometria="point ("+str(x)+" "+str(y)+")"
        sql = "INSERT INTO Fiduciali (Codice_comune,Fg,Mappale,Allegato,Sez,Nomefile,Ext,Codice,Simbolo,PosX,PosY,RelPosX,RelPosY,geom) VALUES  ("
        sql +="'"+ liv[0:4] + "','" + liv[5:9] + "','" + codice + "','" + liv[9:10] + "','" + liv[10:11] + "','" + liv[0:11]+ "','" + esterno
        sql +="','"+numero+"','"+idenum+"','"+str(float(x))+"','" +str(float(y))+"','" +str(float(relx))+"','" +str(float(rely))+"',"          
        sql +="GeomFromText('"+ sgeometria+"',"+CRS+"))"          
        ocur.execute(sql)
                 
  def distesto(livello,codice ):

        geometria=[]
        testo= in_file.readline().strip()
        dim= in_file.readline().strip()
        angolo= in_file.readline().strip()
        x=float(in_file.readline().strip())
        y=float(in_file.readline().strip()) 
        esterno=""
        if codice[-1:]=="\\" :
          esterno = "1"
          codice=codice[:-1]
        testo =  testo.replace("'","''")
        sgeometria="point ("+str(x)+" "+str(y)+")"
        sql = "INSERT INTO Testi (Codice_comune,Fg,Mappale,Allegato,Sez,Nomefile,Ext,Testo,Dim,Rot,geom) VALUES  ("
        sql +="'"+ liv[0:4] + "','" + liv[5:9] + "','" + codice + "','" + liv[9:10] + "','" + liv[10:11] + "','" + liv[0:11]+ "','" + esterno
        sql +="','"+testo+"','"+str(float(dim)*float(scala)/10000)+"','"+str(math.degrees(float(angolo)))+"',"          
        sql +="GeomFromText('"+ sgeometria+"',"+CRS+"))"         
        ocur.execute(sql)
                                           
                                             
  def dislinee(livello,codice ):
        geometria=[]
        lt_testo  = in_file.readline().strip()      
        vert=int(in_file.readline().strip())
        sgeometria="Linestring ("
        for n in range (0,vert):
                  x=float(in_file.readline().strip())
                  y=float(in_file.readline().strip())    
             
                  geom= coord=[x,y]
                  if n == vert-1:
                    sgeometria=sgeometria+str(x)+" "+str(y)+")"
                  else:
                    sgeometria=sgeometria+str(x)+" "+str(y)+","   
        esterno=""
        if codice[-1:]=="\\" :
          esterno = "1"
          codice=codice[:-1]                 
        sql = "INSERT INTO Linee (Codice_comune,Fg,Mappale,Allegato,Sez,Nomefile,Ext,Cod_linea,geom) VALUES  ("
        sql +="'"+ liv[0:4] + "','" + liv[5:9] + "','" + codice + "','" + liv[9:10] + "','" + liv[10:11]+ "','" + liv [0:11]+ "','" + esterno
        sql +="','"+lt_testo+"',"          
        sql +="GeomFromText('"+ sgeometria+"',"+CRS+"))"  
        ocur.execute(sql)
                             

        
  def disarea(livello,codice ):
        geometria=[]
        area=[]
        lt_testo  = in_file.readline().strip()
        angolo  = in_file.readline().strip()
        x=float(in_file.readline().strip())
        y=float(in_file.readline().strip())

        orig1=[x,y]
        x=float(in_file.readline().strip())
        y=float(in_file.readline().strip())

        orig2=[x,y]
        nrisole=int(in_file.readline().strip())
        nrverttot=int(in_file.readline().strip())
        nrvertisola=[]
        for x in range(1,nrisole+1):
            nrvertisola.append(int(in_file.readline()))
        nrvertisola.insert(0,nrverttot-sum(nrvertisola))
        nrvertisola.insert(0,nrverttot-sum(nrvertisola))
        sgeometria="POLYGON"
        for isola,vert in enumerate(nrvertisola):
              sgeometria=sgeometria+"("
              for n in range (0,vert):
                  x=float(in_file.readline().strip())
                  y=float(in_file.readline().strip()) 
                  geom= coord=[x,y]
                  if n == vert-1:
                    if isola==nrisole+1:
                        sgeom=str(x)+" "+str(y)+")"
                    else:
                        sgeom=str(x)+" "+str(y)+"),"
                  else:
                    sgeom=str(x)+" "+str(y)+","
                  sgeometria=sgeometria+sgeom
                  geometria.append(coord)
              area.append(geometria)
        sgeometria=sgeometria+")"        
        
        
        sql = "INSERT INTO "+livello+" (Codice_comune,Fg,Mappale,Allegato,Sez,Nomefile,Htxt,Rtxt,Xtxt,Ytxt,geom) VALUES  ("
        sql +="'"+ liv[0:4] + "','" + liv[5:9] + "','" + codice + "','" + liv[9:10] + "','" + liv[10:11] + "','" + liv[0:11]
        sql +="','"+lt_testo+"','"+angolo +"','"+str(float(orig1[0])-0.1)+"','"+str(float(orig1[1])-0.25)+"',"          
        sql +="GeomFromText('"+ sgeometria+"',"+CRS+"))" 

        ocur.execute(sql)
                             
        if livello=="Particelle":    
           if (orig1[0] <>  orig2[0]) and (orig1[1] <>  orig2[1]):
              sgeometria="Linestring ("+str(orig1[0])+" "+str(orig1[1])+","+str(orig2[0])+" "+str(orig2[1])+")"      
              sql = "INSERT INTO Linee (Codice_comune,Fg,Mappale,Allegato,Sez,Nomefile,Cod_linea,geom) VALUES  ("
              sql +="'"+ liv[0:4] + "','" + liv[5:9] + "','" + codice + "','" + liv[9:10] + "','" + liv[10:11]+ "','" + liv [0:11]
              sql +="','99',"          
              sql +="GeomFromText('"+ sgeometria+"',"+CRS+"))"          
              ocur.execute(sql)
  
                       
  file =ntpath.split(filename)[1]
  ocur.execute("SELECT distinct(auth_srid) FROM 'geom_cols_ref_sys'")
  for d in ocur:
   CRS=str(d[0])  


  while True:
    in_line= in_file.readline().strip()
    if in_line == "":
        break
    if in_line == 'MAPPA':
       mappa = in_file.readline().strip()
       scala=in_file.readline().strip()
    elif in_line == 'QUADRO D\'UNIONE':
       mappa = "QU"
       scala=in_file.readline().strip() 
    elif in_line == 'BORDO':
        in_line  = in_file.readline().strip()
        if in_line[len(in_line)-1] == '+':
            disarea('FABBRICATI',in_line)
        elif in_line  == 'STRADA':
            disarea('Strade',in_line)
        elif in_line  == 'ACQUA':
            disarea('Acque',in_line)
        elif in_line  == mappa:
            disarea('Confine',in_line)
        elif mappa=="QU":
            disarea('Confine',in_line)             
        elif len(in_line) == 11 :
            disarea('Sezioni',in_line)
        else:
            disarea('Particelle',in_line)
    elif in_line == "LINEA" :
            dislinee("Linee",in_line) 
    elif in_line == "LINEA\\" :
            dislinee("Linee",in_line)
    elif in_line == "SIMBOLO" :
            dispoint("Simboli",in_line)              
    elif in_line == "SIMBOLO\\" :
            dispoint("Simboli",in_line)             
    elif in_line == "TESTO" :
            distesto("Testi",in_line)
    elif in_line == "TESTO\\" :
            distesto("Testi",in_line)
    elif in_line == "FIDUCIALE" :
            disfidu("Fiduciali",in_line)
    elif in_line == "FIDUCIALE\\" :
            disfidu("Fiduciali",in_line)           
  in_file.close()