"""
/***************************************************************************
CARICA CXF 
                                 A QGIS plugin

                             -------------------
        begin                : 2012-09-13
        copyright            : (C) 2012 by Arch. Fabio SAccon
        email                : saccon@gisplan.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from PyQt4.QtGui import QMessageBox  
from qgis.core import *
from qgis.utils import iface
import globals
import os

def db_view_all(sql):

        index=0
        for group in iface.legendInterface().groupLayerRelationship() :
          if group[0]=="Catasto":
             iface.legendInterface().removeGroup(0)
          index+=1
        uri = QgsDataSourceURI()
        uri.setDatabase(globals.dbName)
        
          
        uri.setDataSource('','Particelle', 'geom')                          
        vl_part = QgsVectorLayer(uri.uri(), 'Particelle', 'spatialite')   
        uri.setDataSource('','Fabbricati', 'geom')  
        vl_ed = QgsVectorLayer(uri.uri(), 'Fabbricati', 'spatialite')
        uri.setDataSource('','Strade', 'geom')
        vl_st = QgsVectorLayer(uri.uri(), 'Strade', 'spatialite')
        uri.setDataSource('','Confine', 'geom') 
        vl_conf = QgsVectorLayer(uri.uri(), 'Confine', 'spatialite')
        uri.setDataSource('','Acque', 'geom')
        vl_aq = QgsVectorLayer(uri.uri(), 'Acque', 'spatialite')
        uri.setDataSource('','Linee', 'geom')
        vl_linee = QgsVectorLayer(uri.uri(), 'Linee', 'spatialite')
        uri.setDataSource('','Simboli', 'geom')
        vl_point = QgsVectorLayer(uri.uri(), 'Simboli', 'spatialite')
        uri.setDataSource('','Testi', 'geom')
        vl_testo = QgsVectorLayer(uri.uri(), 'Testi', 'spatialite')
        uri.setDataSource('','Fiduciali', 'geom')
        vl_fidu = QgsVectorLayer(uri.uri(), 'Fiduciali', 'spatialite')
        vl_ed.updateExtents()
        vl_st.updateExtents()
        vl_aq.updateExtents()
        vl_conf.updateExtents()
        vl_linee.updateExtents()
        vl_point.updateExtents()
        vl_testo.updateExtents()


 
        vl_part.loadNamedStyle(os.getenv("HOME")+'/.qgis2/python/plugins/Cxf_in/part.qml')
        QgsMapLayerRegistry.instance().addMapLayer(vl_part) 
        vl_ed.loadNamedStyle(os.getenv("HOME")+'/.qgis2/python/plugins/Cxf_in/fab.qml') 
        QgsMapLayerRegistry.instance().addMapLayer(vl_ed)              
        vl_st.loadNamedStyle(os.getenv("HOME")+'/.qgis2/python/plugins/Cxf_in/strade.qml')
        QgsMapLayerRegistry.instance().addMapLayer(vl_st)    
        vl_conf.loadNamedStyle(os.getenv("HOME")+'/.qgis2/python/plugins/Cxf_in/conf.qml')        
        QgsMapLayerRegistry.instance().addMapLayer(vl_conf)            
        vl_aq.loadNamedStyle(os.getenv("HOME")+'/.qgis2/python/plugins/Cxf_in/acque.qml')
        QgsMapLayerRegistry.instance().addMapLayer(vl_aq)
        vl_linee.loadNamedStyle(os.getenv("HOME")+'/.qgis2/python/plugins/Cxf_in/linee.qml')
        QgsMapLayerRegistry.instance().addMapLayer(vl_linee)          
        vl_point.loadNamedStyle(os.getenv("HOME")+'/.qgis2/python/plugins/Cxf_in/Simboli.qml')
        QgsMapLayerRegistry.instance().addMapLayer(vl_point)           
        vl_testo.loadNamedStyle(os.getenv("HOME")+'/.qgis2/python/plugins/Cxf_in/testo.qml')
        QgsMapLayerRegistry.instance().addMapLayer(vl_testo) 
        vl_fidu.loadNamedStyle(os.getenv("HOME")+'/.qgis2/python/plugins/Cxf_in/fidu.qml')
        QgsMapLayerRegistry.instance().addMapLayer(vl_fidu)  
        index=iface.legendInterface().addGroup("Catasto",False) 
        livelligruppofoglio=[vl_aq,vl_st,vl_conf,vl_part,vl_testo,vl_fidu,vl_ed,vl_point,vl_linee]
        for l in livelligruppofoglio:
            iface.legendInterface().moveLayer(l, index)
        layers = QgsMapLayerRegistry.instance().mapLayers()

        for name, layer in layers.iteritems():
         
            layer.setSubsetString(sql)
  
  
def db_view_sel(lista): 
        index=0
        for group in iface.legendInterface().groupLayerRelationship() :
          if group[0]=="Catasto":
           index+=1
        if index==0:
          db_view_all(lista)
        
        
        
        else:
        

         layers = QgsMapLayerRegistry.instance().mapLayers()

         for name, layer in layers.iteritems():
         
            layer.setSubsetString(lista)           