# -*- coding: utf-8 -*-
"""
/***************************************************************************
CARICA CXF 
                                 A QGIS plugin

                             -------------------
        begin                : 2012-09-13
        copyright            : (C) 2012 by Arch. Fabio SAccon
        email                : saccon@gisplan.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from pyspatialite import dbapi2 as sqlite3


from PyQt4.QtGui import *
from PyQt4.QtGui import QMessageBox
from PyQt4.QtCore import *
from qgis.core import *
from qgis.utils import iface
from ui_cercacat import Ui_cercacat
from  memory_layer import *
from  db_reset import *
from  db_layer import *
from  db_view import *
from  db_create import *
# create the dialog for zoom to point
import sys, os, imp,re
import fTools
import webbrowser
import globals
path = os.path.dirname(fTools.__file__)
ftu = imp.load_source('ftools_utils', os.path.join(path,'tools','ftools_utils.py'))
 
class catDialog(QDockWidget):
    def __init__(self, iface):
        QDockWidget.__init__(self, None)

        self.ui = Ui_cercacat()
        self.ui.setupUi(self)
        self.ui.dbreset.clicked.connect(self.dbreset)
        self.ui.viewall.clicked.connect(self.viewall)
        self.ui.viewsel.clicked.connect(self.viewsel)
        self.ui.cxfspatialite.clicked.connect(self.dbloadcxf)
        self.ui.cxfmemory.clicked.connect(self.cxfmemory)
        self.ui.dbdeletefg.clicked.connect(self.deletefg)
        self.ui.toolBox.currentChanged.connect(self.ric_mapp)
        self.ui.cat_com.currentIndexChanged.connect(self.populatericercaFogli)
        self.ui.del_cat_com.currentIndexChanged.connect(self.populatedeleteFogli)
        self.ui.cat_fg.currentIndexChanged.connect(self.populateMapp)
        self.ui.gisplan.clicked.connect(self.info)
        self.ui.listcomune.itemClicked.connect (self.Fogli_selezione)

        ocon = sqlite3.connect(globals.dbName)
        ocur = ocon.cursor() 
        ocur.execute('SELECT InitSpatialMetadata()') 
        db_create()
        self.populateVisualizzaione() 
    def unload(self):
        # Remove the plugin menu item and icon
        self.iface.removePluginMenu(u"&Cxf_in", self.action)
        self.iface.removeToolBarIcon(self.action) 
    def info( self ): 
          webbrowser.open("http://www.gisplan.it")
          
    def viewall( self ): 
        ocon = sqlite3.connect(globals.dbName)
        ocur = ocon.cursor()  
        ocur.execute("delete  FROM 'Selezione'") 
        ocon.commit()
        ocur.execute("INSERT INTO Selezione  (Nomefile,Codice_comune,Fg,Sel)  select distinct Nomefile,Codice_comune,Fg, '1' from 'particelle' order by Nomefile")
        ocon.commit()
        self.populateVisualizzaione() 

        if self.ui.singolfg.isChecked() :
          lista = "((EXT='') or (Ext is Null))"
        else:
         lista=""

        db_view_all(lista) 
        
        iface.mapCanvas().zoomToFullExtent()

    def viewsel( self ):
        ocon = sqlite3.connect(globals.dbName)
        ocur = ocon.cursor()  
        ocur.execute("select distinct Nomefile,Sel from Selezione order by Nomefile")
        lista="("
        for d in ocur:
          if d[1] == "1":
            lista+="'"+d[0]+"',"
        lista=lista[:-1]+")"
        #QMessageBox.information(None, "Errore0 :",lista)  
        if lista!=")": 

         lista="Nomefile IN "+lista 
         if self.ui.singolfg.isChecked() :
          lista = lista + " AND ((EXT='') or (Ext is Null))"  
          #QMessageBox.information(None, "Errore :",lista)  
          db_view_sel(lista)
          
        else:
         lista="Nomefile=='9999'"
        #QMessageBox.information(None, "Errore1 :",lista) 
        db_view_sel(lista)
        
        iface.mapCanvas().zoomToFullExtent()
                
    def dbreset( self ):     
          db_reset()
          db_create()

    def deletefg( self ): 
        uri = QgsDataSourceURI()
        uri.setDatabase(globals.dbName)
        uri.setDataSource('','Particelle', 'geom')                          
        vl_part = QgsVectorLayer(uri.uri(), 'Particelle', 'spatialite')   
        uri.setDataSource('','Fabbricati', 'geom')  
        vl_ed = QgsVectorLayer(uri.uri(), 'Fabbricati', 'spatialite')
        uri.setDataSource('','Strade', 'geom')
        vl_st = QgsVectorLayer(uri.uri(), 'Strade', 'spatialite')
        uri.setDataSource('','Confine', 'geom') 
        vl_conf = QgsVectorLayer(uri.uri(), 'Confine', 'spatialite')
        uri.setDataSource('','Acque', 'geom')
        vl_aq = QgsVectorLayer(uri.uri(), 'Acque', 'spatialite')
        uri.setDataSource('','Linee', 'geom')
        vl_linee = QgsVectorLayer(uri.uri(), 'Linee', 'spatialite')
        uri.setDataSource('','Simboli', 'geom')
        vl_point = QgsVectorLayer(uri.uri(), 'Simboli', 'spatialite')
        uri.setDataSource('','Testi', 'geom')
        vl_testo = QgsVectorLayer(uri.uri(), 'Testi', 'spatialite')
        uri.setDataSource('','Fiduciali', 'geom')
        vl_fidu = QgsVectorLayer(uri.uri(), 'Fiduciali', 'spatialite')      
        layers = QgsMapLayerRegistry.instance().mapLayers()              
        ocon = sqlite3.connect(globals.dbName)
        ocur = ocon.cursor()  
        nfile = self.ui.del_cat_com.currentText()+"_"+self.ui.del_cat_fg.currentText().replace ("_","")     
        ret = QMessageBox.question(None,"ATTENZIONE", "Vuoi veramente cancellare il foglio "+self.ui.del_cat_fg.currentText()+" del Comune "+self.ui.del_cat_com.currentText(),QMessageBox.Yes, QMessageBox.No)
        if ret == QMessageBox.Yes:
          ocur.execute("delete from particelle where Nomefile='"+nfile+"'")
          ocur.execute("delete from fabbricati where   Nomefile='"+nfile+"'")                               
          ocur.execute("delete from Strade where  Nomefile='"+nfile+"'")
          ocur.execute("delete from Confine where Nomefile='"+nfile+"'")        
          ocur.execute("delete from Acque where Nomefile='"+nfile+"'")                  
          ocur.execute("delete from Linee where Nomefile='"+nfile+"'")                 
          ocur.execute("delete from Simboli where Nomefile='"+nfile+"'")                 
          ocur.execute("delete from Testi where Nomefile='"+nfile+"'")       
          ocur.execute("delete from Fiduciali where Nomefile='"+nfile+"'")                       
          vl_ed.updateExtents()
          vl_st.updateExtents()
          vl_aq.updateExtents()
          vl_conf.updateExtents()
          vl_linee.updateExtents()
          vl_point.updateExtents()
          vl_testo.updateExtents()
          ocur.execute('VACUUM')
          ocon.commit()


        ocur.close()     
         
    def dbloadcxf( self ): 
         db_load()
         
    def ric_mapp( self ):    
        if  self.ui.toolBox.currentIndex()==1 :
          layers = QgsMapLayerRegistry.instance().mapLayers()   
          okpart=False         
          for name, layid in layers.iteritems(): 
           if layid.name() =='Particelle':
            okpart=True          
          if okpart:  
           self.populateRicerca()     
        if  self.ui.toolBox.currentIndex()==0 :
                self.populateVisualizzaione() 
        if  self.ui.toolBox.currentIndex()==4 :
                self.populatedelete() 
        
    def cxfmemory( self ):
        if os.path.exists(os.getenv("HOME")+'/workpath'):
           fpath = open(os.getenv("HOME")+'/workpath', 'r') 
           read_path = fpath.read()
           fpath.close
        else:
            read_path ="."     
        (filename, filter) = QFileDialog.getOpenFileNamesAndFilter(iface.mainWindow(),
                      "Seleziona un file cxf da caricare...",read_path,
                      "CXF files (*.cxf)",
                      "Filtro per selezione file")
        if len(filename)==0:
              return
        memory_layer(filename)
        
        
    def Fogli_selezione(self, item, column):
        ocon = sqlite3.connect(globals.dbName)
        ocur = ocon.cursor()    
    
        if item.checkState(column) == Qt.Checked:
            if item.parent():
                #selezione  il foglio per comune selezionato              
                ocur.execute("update Selezione set Sel='1' where Nomefile='"+item.data(0, Qt.UserRole)+"'")
                ocon.commit()
                allview=True                
                for i in range(item.parent().childCount()):
                    if item.parent().child(i).checkState(column) == Qt.Unchecked:
                        allview=False
                if allview==True:                   
                    item.parent().setCheckState(column, Qt.Checked)
            else:
              #selezione tutti i fogli per comune selezionato
              for i in range(item.childCount()):
                 item.child(i).setCheckState(column, Qt.Checked)
              ocur.execute("update Selezione set Sel='1' ")
              ocon.commit()
              
        if item.checkState(column) == Qt.Unchecked:
            if item.parent():
                item.parent().setCheckState(column, Qt.Unchecked)
                ocur.execute("update Selezione set Sel=Null where Nomefile='"+item.data(0, Qt.UserRole)+"'")
                ocon.commit()
            else:
               #deselezione tutti i fogli per comune selezionato
              for i in range(item.childCount()):
                  item.child(i).setCheckState(column, Qt.Unchecked)
              ocur.execute("update Selezione set Sel=Null ")
              ocon.commit()

    def populateVisualizzaione( self ): 
      
        def addParent( parent, column, title, data,sel):
            item = QTreeWidgetItem(parent,[title])
            item.setData(column, Qt.UserRole, data)
            item.setChildIndicatorPolicy(QTreeWidgetItem.ShowIndicator)
            item.setExpanded (True)
            item.setCheckState (column, sel)
            return item      
        def addChild( parent, column, title, data,sel):
            item = QTreeWidgetItem(parent, [title])
            item.setData(column, Qt.UserRole, data)
            item.setCheckState (column, sel)
            return item    
        ocon = sqlite3.connect(globals.dbName)
        ocur = ocon.cursor()
        ocur.execute("insert into Selezione (Codice_comune,Fg,Nomefile)  SELECT distinct Codice_comune,Fg,Nomefile  from particelle  where Nomefile not in (select Nomefile from Selezione)")
        ocon.commit()
        ocur.execute("delete from Selezione where Nomefile in (SELECT  Nomefile  from Selezione  where Nomefile not in (select distinct Nomefile from particelle))")
        ocon.commit()
        self.ui.listcomune.clear()            
        ocur.execute("select Codice_comune,Fg,Nomefile,Sel from Selezione order by Nomefile")
        comune=""
        for d in ocur:
          if  d[3]=="1":
           selezionato= Qt.Checked
          else:
           selezionato= Qt.Unchecked
          
          if (d[0]) !=comune:   
           parent= addParent(self.ui.listcomune.invisibleRootItem(),0,d[0],d[0],selezionato)             
           addChild( parent,0,d[2][5:9]+"_"+d[2][9:10]+"_"+d[2][10:11],d[2],selezionato)           
           comune = d[0]     
          else:
           item=addChild( parent,0,d[2][5:9]+"_"+d[2][9:10]+"_"+d[2][10:11],d[2],selezionato)
           if selezionato== Qt.Unchecked :
            item.parent().setCheckState(0, Qt.Unchecked)

        
    def populateRicerca( self ):
        self.ui.cat_com.setEditable(True)
        self.ui.cat_com.clear()

        ocon = sqlite3.connect(globals.dbName)

        ocur = ocon.cursor()
        ocur.execute("SELECT distinct Codice_comune from Selezione")
        ocon.commit()
                                                     
        myListA = []
        for d in ocur:
         myListA.append(d[0])  
        

        self.ui.cat_com.addItems( myListA )
        

        ocon.close()  
    def populatedelete( self ):
        self.ui.del_cat_com.setEditable(True)
        self.ui.del_cat_com.clear()

        ocon = sqlite3.connect(globals.dbName)
        ocur = ocon.cursor()
        ocur.execute("SELECT distinct Codice_comune from particelle")
        ocon.commit()
                                                     
        myListA = []
        for d in ocur:
         myListA.append(d[0])  
        

        self.ui.del_cat_com.addItems( myListA )
        

        ocon.close()  
        
        
    def populatericercaFogli( self ):
        self.ui.cat_fg.setEnabled(True) 
        self.ui.cat_fg.setEditable(True) 

        self.ui.cat_fg.clear()

        ocon = sqlite3.connect(globals.dbName)

        ocur = ocon.cursor()
        ocur.execute("SELECT distinct Nomefile from Selezione where Codice_comune='"+self.ui.cat_com.currentText() +"' and Sel='1'")

        ocon.commit()
                                      
        lista=[]
        for d in ocur:  
         lista.append(d[0][5:9]+"_"+d[0][9:10]+"_"+d[0][10:11])
        self.ui.cat_fg.addItems( sorted(lista) ) 
        self.ui.cat_fg.clearEditText()
        ocon.close()
        
             
    def populatedeleteFogli( self ):
        self.ui.del_cat_fg.setEnabled(True) 
        self.ui.del_cat_fg.setEditable(True) 
        comune =self.ui.del_cat_com.currentText() 
        self.ui.del_cat_fg.clear()

        ocon = sqlite3.connect(globals.dbName)
        #ocon = sqlite3.connect('C:/Users/Gisplan/.qgis2/python/plugins/Cxf_in/catasto.sqlite')     
        ocur = ocon.cursor()
        ocur.execute("SELECT distinct Nomefile from particelle where Codice_comune='"+comune+"'")

        ocon.commit()
                                      
        lista=[]
        for d in ocur:  
         lista.append(d[0][5:9]+"_"+d[0][9:10]+"_"+d[0][10:11])
        self.ui.del_cat_fg.addItems( sorted(lista) ) 
        self.ui.del_cat_fg.clearEditText()
        ocon.close()  
        
        
    def populateMapp( self ):
   
        self.ui.cat_mapp.setEditable(True)
        self.ui.cat_mapp.clear()

        ocon = sqlite3.connect(globals.dbName)
        #ocon = sqlite3.connect('C:/Users/Gisplan/.qgis2/python/plugins/Cxf_in/catasto.sqlite')   
        ocur = ocon.cursor()

        ocur.execute("SELECT distinct Mappale from Particelle where Nomefile='"+self.ui.cat_com.currentText()+"_"+self.ui.cat_fg.currentText().replace ("_","")+"'")

        ocon.commit()
        self.ui.cat_mapp.setEnabled(True)                                               
        lista=[]
        for d in ocur:
         lista.append(d[0])     

        
        self.ui.cat_mapp.addItems( sorted(lista) )
        self.ui.cat_mapp.clearEditText() 
        self.ui.cat_mapp.currentIndexChanged.connect(self.zoomtosel)
        ocon.close()  
         # if   self.ui.cat_mapp.currentText()!='' and self.ui.cat_mapp.currentText()!='':
         #   self.ui.cat_mapp.currentIndexChanged.connect(self.zoomtosel)
         # else:
         #   self.ui.cat_mapp.currentIndexChanged.close()
    def zoomtosel( self ):        
        layer = QgsMapLayerRegistry.instance().mapLayersByName("Particelle") [0] 
        iface.setActiveLayer(layer) 
        iter= layer.getFeatures()
        nfile = layer.fieldNameIndex('Nomefile')
        map = layer.fieldNameIndex('Mappale')
        layer.removeSelection ()
        foglio=self.ui.cat_com.currentText()+"_"+self.ui.cat_fg.currentText().replace ('_','')
 
  
        for feature in iter:

         if feature.attributes()[nfile]==self.ui.cat_com.currentText()+"_"+self.ui.cat_fg.currentText().replace ('_','') and feature.attributes()[map]==self.ui.cat_mapp.currentText() :
           
           #self.ui.cat_mapp.clearEditText()
           layer.select( feature.id())
           iface.actionZoomToSelected().trigger() 
        