"""
/***************************************************************************
CARICA CXF 
                                 A QGIS plugin

                             -------------------
        begin                : 2012-09-13
        copyright            : (C) 2012 by Arch. Fabio SAccon
        email                : saccon@gisplan.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from PyQt4.QtGui import *
from PyQt4.QtCore import *

from qgis.core import *
from qgis.utils import iface
from qgis.gui import *
import sys
import math
import os
import string
import resources
import ntpath
explorer = None
class cxf_in():
    __module__ = __name__

    def __init__(self, iface):
        self.iface = iface



    def initGui(self):
        self.pluginname = '&QGIS Importatore CXF 3.1 '
        self.action = QAction(QIcon(':/plugins/Cxf_in/icon.png'), self.pluginname, self.iface.mainWindow())
        self.action.triggered.connect(self.run)
        self.iface.addToolBarIcon(self.action)
        self.iface.addPluginToMenu('&CXF import', self.action)
        for action in self.iface.pluginMenu().actions():
            if (action.text() == self.pluginname):
                action.setIcon(QIcon(':/plugins/Cxf_in/icon.png'))




    def unload(self):
        self.iface.removePluginMenu('&CXF import', self.action)
        self.iface.removeToolBarIcon(self.action)



    def run(self):
        if os.path.exists(os.getenv("HOME")+'/workpath'):
         fpath = open(os.getenv("HOME")+'/workpath', 'r') 
         read_path = fpath.read()
         fpath.close
        else:
          read_path ="."     
        (filename, filter) = QFileDialog.getOpenFileNamesAndFilter(self.iface.mainWindow(),
                    "Seleziona un file cxf da caricare...",read_path,
                    "CXF files (*.cxf)",
                    "Filtro per selezione file")
        if len(filename)==0:
            return
        
        
        ###### selettore unico sr by Salvatore Caligiore
        selcrs=QgsGenericProjectionSelector()
        result=selcrs.exec_() 
        
        stringacrs=''
       
        if  result==1 :     
            crs=QgsCoordinateReferenceSystem()
            crs.createFromSrsId(selcrs.selectedCrsId ())   
            stringacrs="crs="+crs.toWkt()
            
            
        else:
             selcrs=QgsProjectionSelector()
             result=selcrs.exec_() 
             if  result==1 :  
                 crs=QgsCoordinateReferenceSystem()
                 crs.createFromSrsId(selcrs.selectedCrsId ())   
                 stringacrs="crs="+crs.toWkt()
             else:
                 stringacrs=''
             
        
             
        del selcrs
        ##########################    
        QMessageBox.information(None, "DEBUG:",stringacrs)  
        vl_conf= QgsVectorLayer("Polygon?"+stringacrs+"&field=Codice_comune:string(50)&field=Foglio:string(5)&field=Mappale:string(5)&field=Allegato:string(5)&field=Sviluppo:string(5)&field=Htxt:Double&field=Rtxt:Double&field=Xtxt:Double&field=Ytxt:Double",
                           "Confine", "memory")  
        #QgsMapLayerRegistry.instance().addMapLayer(vl_conf)     
        vl_part = QgsVectorLayer("Polygon?"+stringacrs+"&field=Codice_comune:string(50)&field=Foglio:string(5)&field=Mappale:string(5)&field=Allegato:string(5)&field=Sviluppo:string(5)&field=Htxt:Double&field=Rtxt:Double&field=Xtxt:Double&field=Ytxt:Double",
                           "Particelle", "memory")
        #QgsMapLayerRegistry.instance().addMapLayer(vl_part)   
        vl_ed= QgsVectorLayer("Polygon?"+stringacrs+"&field=Codice_comune:string(50)&field=Foglio:string(5)&field=Mappale:string(5)&field=Allegato:string(5)&field=Sviluppo:string(5)&field=Htxt:Double&field=Rtxt:Double&field=Xtxt:Double&field=Ytxt:Double",
                           "Fabbricati", "memory")  
        #QgsMapLayerRegistry.instance().addMapLayer(vl_ed)   
        vl_st= QgsVectorLayer("Polygon?"+stringacrs+"&field=Codice_comune:string(50)&field=Foglio:string(5)&field=Mappale:string(5)&field=Allegato:string(5)&field=Sviluppo:string(5)&field=Htxt:Double&field=Rtxt:Double&field=Xtxt:Double&field=Ytxt:Double",
                           "Strade", "memory")  
        #QgsMapLayerRegistry.instance().addMapLayer(vl_st)
        vl_aq= QgsVectorLayer("Polygon?"+stringacrs+"&field=Codice_comune:string(50)&field=Foglio:string(5)&field=Mappale:string(5)&field=Allegato:string(5)&field=Sviluppo:string(5)&field=Htxt:Double&field=Rtxt:Double&field=Xtxt:Double&field=Ytxt:Double",
                           "Acque", "memory")  
        #QgsMapLayerRegistry.instance().addMapLayer(vl_aq)
        vl_linee= QgsVectorLayer("Linestring?"+stringacrs+"&field=Codice_comune:string(50)&field=Fg:string(5)&field=Mappale:string(5)&field=All:string(5)&field=Sez:string(5)&field=Cod_linea:string(5)",
                           "Linee", "memory")
 
        #QgsMapLayerRegistry.instance().addMapLayer(vl_linee) 
        vl_point= QgsVectorLayer("Point?"+stringacrs+"&field=Codice_comune:string(50)&field=Fg:string(5)&field=Mappale:string(5)&field=All:string(5)&field=Sez:string(5)&field=Simbolo:string(5)&field=Rot:Double",
                           "Simboli", "memory")  
        #QgsMapLayerRegistry.instance().addMapLayer(vl_point)
        
        livelligruppofoglio=[vl_point,vl_linee,vl_aq,vl_st, vl_ed,vl_part,vl_conf]
        QgsMapLayerRegistry.instance().addMapLayers(livelligruppofoglio)
        
        
                        
        #QMessageBox.information(None, "DEBUG:",os.environ["PYTHONPATH"]+'/Cxf_in/part.qml') 
        vl_aq.loadNamedStyle(os.getenv("HOME")+'/.qgis2/python/plugins/Cxf_in/acque.qml')
        vl_part.loadNamedStyle(os.getenv("HOME")+'/.qgis2/python/plugins/Cxf_in/part.qml')
        vl_ed.loadNamedStyle(os.getenv("HOME")+'/.qgis2/python/plugins/Cxf_in/fab.qml')
        vl_st.loadNamedStyle(os.getenv("HOME")+'/.qgis2/python/plugins/Cxf_in/strade.qml')
        vl_conf.loadNamedStyle(os.getenv("HOME")+'/.qgis2/python/plugins/Cxf_in/conf.qml')
        vl_point.loadNamedStyle(os.getenv("HOME")+'/.qgis2/python/plugins/Cxf_in/simboli.qml')

        vl_linee.loadNamedStyle(os.getenv("HOME")+'/.qgis2/python/plugins/Cxf_in/linee.qml')
        
        fpath = open(os.getenv("HOME")+'/workpath', 'w') 
        fpath.write(os.path.dirname(filename[0])) 
        fpath.close  
              
              
              
              
        for f in filename:
        

            liv=os.path.basename (os.path.splitext( str(f))[0])
            load_cxf(str(f),liv,vl_part,vl_ed,vl_st,vl_aq,vl_conf,vl_linee,vl_point)

        vl_part.commitChanges()
        vl_ed.commitChanges()
        vl_st.commitChanges()
        vl_aq.commitChanges() 
        vl_conf.commitChanges()
        vl_linee.commitChanges()
        vl_point.commitChanges()  
        
        li = iface.legendInterface()    
        index=li.addGroup(liv[0:10]) 
        
        for l in livelligruppofoglio:
            li.moveLayer(l, index)


 
def load_cxf(filename,liv,vl_part,vl_ed,vl_st,vl_aq,vl_conf,vl_linee,vl_point):
  try:
      in_file = open(filename,"r")
  except IOError:
      print 'Impossibile aprire il file', filename
      sys.exit()
      
  def dispoint(livello,codice ):
        geometria=[]
        simbolo= in_file.readline().strip()
        angolo= in_file.readline().strip()
        x=float(in_file.readline().strip())
        y=float(in_file.readline().strip()) 
        sgeometria="point ("+str(x)+" "+str(y)+")"
         
        feature = QgsFeature()
        feature.setGeometry(QgsGeometry.fromWkt(sgeometria))
        values = [(liv[0:4]),
                     (liv[5:9]),
                     (codice),                     
                     (liv[9:10]),
                     (liv[10:11]), 
                     (simbolo),            
                     (360-math.degrees(float(angolo)))
                     
                ]
        #QMessageBox.information(None, "DEBUG:",str(math.degrees(float(angolo))))  
       # QMessageBox.information(None, "DEBUG:",angolo)               
        feature.setAttributes(values)        
        vl_point.addFeature(feature,True)
        vl_point.updateExtents()       
        
        
        
  def dislinee(livello,codice ):

        geometria=[]
        lt_testo  = in_file.readline().strip()      
        vert=int(in_file.readline().strip())
        sgeometria="Linestring ("
        for n in range (0,vert):
                 
                  x=float(in_file.readline().strip())
                  y=float(in_file.readline().strip()) 
                 
                  geom= coord=[x,y]
                  if n == vert-1:
                    sgeometria=sgeometria+str(x)+" "+str(y)+")"
                  else:
                    sgeometria=sgeometria+str(x)+" "+str(y)+","
                
        #QMessageBox.information(None, "DEBUG:", sgeometria) 

        feature = QgsFeature()
        feature.setGeometry(QgsGeometry.fromWkt(sgeometria))
        values = [(liv[0:4]),
                     (liv[5:9]),
                     (codice),                      
                     (liv[9:10]),
                     (liv[10:11]),
                     (float(lt_testo)),
]
        feature.setAttributes(values)        
        vl_linee.addFeature(feature,True)
        vl_linee.updateExtents()        
        
        
  def disarea(livello,codice ):

        geometria=[]
        area=[]
        lt_testo  = in_file.readline().strip()
        angolo  = in_file.readline().strip()
        #in_line  = in_file.readline().strip()
        x=float(in_file.readline().strip())
        y=float(in_file.readline().strip())
        orig1=[x,y]
        x=float(in_file.readline().strip())
        y=float(in_file.readline().strip())
        orig2=[x,y]
        #print orig1
        nrisole=int(in_file.readline().strip())
        nrverttot=int(in_file.readline().strip())
        #if nrisole > 0 :
        nrvertisola=[]

        for x in range(1,nrisole+1):
            nrvertisola.append(int(in_file.readline()))
        #print nrvertisola
        nrvertisola.insert(0,nrverttot-sum(nrvertisola))
        nrvertisola.insert(0,nrverttot-sum(nrvertisola))

        sgeometria="POLYGON"
        for isola,vert in enumerate(nrvertisola):
              sgeometria=sgeometria+"("
              for n in range (0,vert):
                  x=float(in_file.readline().strip())
                  y=float(in_file.readline().strip()) 
                 
                  geom= coord=[x,y]
                  if n == vert-1:
                    if isola==nrisole+1:
                        sgeom=str(x)+" "+str(y)+")"
                    else:
                        sgeom=str(x)+" "+str(y)+"),"
                  else:
                    sgeom=str(x)+" "+str(y)+","
                  sgeometria=sgeometria+sgeom
                  geometria.append(coord)
              area.append(geometria)
        sgeometria=sgeometria+")"
        feature = QgsFeature()
        feature.setGeometry(QgsGeometry.fromWkt(sgeometria))
        
        values = [(liv[0:4]),
                     (liv[5:9]),
                     (codice),                      
                     (liv[9:10]),
                     (liv[10:11]),
                     (float(lt_testo)),
                     (float(angolo)),
                     (float(orig1[0])),
                     (float(orig1[1]))]
        if livello=="Acque":
           
           feature.setAttributes(values)

           vl_aq.addFeature(feature,True)
           vl_aq.updateExtents()   
        if livello=="Confine":

           
           feature.setAttributes(values)

           vl_conf.addFeature(feature,True)
           vl_conf.updateExtents()     
        if livello=="Strade":

           feature.setAttributes(values)

           vl_st.addFeature(feature,True)
           vl_st.updateExtents()
           
        if livello=="FABBRICATI":
              
            feature.setAttributes(values)       
            vl_ed.addFeature(feature,True)
            vl_ed.updateExtents()   
           
           
           
             
        if livello=="Particelle":

           feature.setAttributes(values)
           vl_part.addFeature(feature,True)
           vl_part.updateExtents()            
           if (orig1[0] <>  orig2[0]) and (orig1[1] <>  orig2[1]):
              sgeometria="Linestring ("+str(orig1[0])+" "+str(orig1[1])+","+str(orig2[0])+" "+str(orig2[1])+")"      
              feature = QgsFeature()
              feature.setGeometry(QgsGeometry.fromWkt(sgeometria))
              values = [(liv[0:4]),
                           (liv[5:9]),
                           (codice),                      
                           (liv[9:10]),
                           (liv[10:11]),
                           (float(lt_testo)),
      ]
              feature.setAttributes(values)        
              vl_linee.addFeature(feature,True)
              vl_linee.updateExtents()         
            


    
  file =ntpath.split(filename)[1]
 
  vl_part.startEditing()
  vl_ed.startEditing()
  vl_st.startEditing()
  vl_aq.startEditing()
  vl_conf.startEditing()
  vl_linee.startEditing()
  vl_point.startEditing()
  while True:
    in_line= in_file.readline().strip()
    if in_line == "":
        break

    if in_line in  ("MAPPA","QUADRO D\'UNIONE"):
       mappa = in_file.readline().strip()
       
       if in_line == 'QUADRO D\'UNIONE':
        mappa = "QU"
       scala=in_file.readline().strip()

    elif in_line == 'BORDO':
        in_line  = in_file.readline().strip()
        if in_line[len(in_line)-1] == '+':
            disarea('FABBRICATI',in_line)
        elif in_line  == 'STRADA':
            disarea('Strade',in_line)
        elif in_line  == 'ACQUA':
            disarea('Acque',in_line)
        elif in_line  == mappa:
            disarea('Confine',in_line)
        elif mappa=="QU":
            disarea('Confine',in_line)            
        elif len(in_line) == 11 :
            disarea('Sezioni',in_line)
        else:
            disarea('Particelle',in_line)
    if in_line == "LINEA" :
            dislinee("Linee",in_line) 
    if in_line == "SIMBOLO" :
            dispoint("Simboli",in_line)            
  in_file.close()
  

  #vl_part.commitChanges()
#
  #vl_ed.commitChanges()
  #li = iface.legendInterface()
#
  #index=li.addGroup(liv)
#  
  #for l in li.layers():
   ##QMessageBox.information(None, "DEBUG:", str(l.name().find(liv))) 
   #if l.name().find(liv)  > 0:
      #li.moveLayer(l, index)


      


