"""
/***************************************************************************
CARICA CXF 
                                 A QGIS plugin

                             -------------------
        begin                : 2012-09-13
        copyright            : (C) 2012 by Arch. Fabio SAccon
        email                : saccon@gisplan.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from PyQt4.QtGui import *
from PyQt4.QtCore import *

from qgis.core import *
import sys
import os
import string
import resources
import ntpath
explorer = None
class cxf_in():
    __module__ = __name__

    def __init__(self, iface):
        self.iface = iface



    def initGui(self):
        self.pluginname = '&QGIS Importatore CXF '
        self.action = QAction(QIcon(':/plugins/cxf_in/icon.png'), self.pluginname, self.iface.mainWindow())
        self.action.triggered.connect(self.run)
        self.iface.addToolBarIcon(self.action)
        self.iface.addPluginToMenu('&CXF import', self.action)
        for action in self.iface.pluginMenu().actions():
            if (action.text() == self.pluginname):
                action.setIcon(QIcon(':/plugins/cxf_in/icon.png'))




    def unload(self):
        self.iface.removePluginMenu('&CXF import', self.action)
        self.iface.removeToolBarIcon(self.action)



    def run(self):
        (filename, filter) = QFileDialog.getOpenFileNameAndFilter(self.iface.mainWindow(),
                    "Selezione un file cxf da caricare...",
                    ".",
                    "CXF files (*.cxf)",
                    "Filttro per selezione file")
        if len(filename)==0:
            return

        load_cxf(filename)



 
def load_cxf(filename):
  try:
      in_file = open(filename,"r")
  except IOError:
      print 'Impossibile aprire il file', filename
      sys.exit()

  
  def disarea(livello,codice ):

        geometria=[]
        area=[]
        lt_testo  = in_file.readline().strip()
        angolo  = in_file.readline().strip()
        #in_line  = in_file.readline().strip()
        x=float(in_file.readline().strip())
        y=float(in_file.readline().strip())
        orig1=[x,y]
        x=float(in_file.readline().strip())
        y=float(in_file.readline().strip())
        orig2=[x,y]
        #print orig1
        nrisole=int(in_file.readline().strip())
        nrverttot=int(in_file.readline().strip())
        #if nrisole > 0 :
        nrvertisola=[]

        for x in range(1,nrisole+1):
            nrvertisola.append(int(in_file.readline()))
        #print nrvertisola
        nrvertisola.insert(0,nrverttot-sum(nrvertisola))
        nrvertisola.insert(0,nrverttot-sum(nrvertisola))

        sgeometria="POLYGON"
        for isola,vert in enumerate(nrvertisola):
              sgeometria=sgeometria+"("
              for n in range (0,vert):
                  x=float(in_file.readline().strip())
                  y=float(in_file.readline().strip()) 
                 
                  geom= coord=[x,y]
                  if n == vert-1:
                    if isola==nrisole+1:
                        sgeom=str(x)+" "+str(y)+")"
                    else:
                        sgeom=str(x)+" "+str(y)+"),"
                  else:
                    sgeom=str(x)+" "+str(y)+","
                  sgeometria=sgeometria+sgeom
                  geometria.append(coord)
              area.append(geometria)
        sgeometria=sgeometria+")"
        feature = QgsFeature()
        feature.setGeometry(QgsGeometry.fromWkt(sgeometria))


        if livello=="Particelle":

           values = [(mappa[0:4]),
                    (mappa[5:9]),
                     (codice), 
                     (float(lt_testo)),
                     (float(angolo)),
                     (float(orig1[0])),
                     (float(orig1[1]))]
           feature.setAttributes(values)

           vl_part.addFeature(feature,True)
           vl_part.updateExtents()
        if livello=="FABBRICATI":
            values = [(mappa[0:4]),
                     (mappa[5:9]),
                     (codice), 
                     (float(lt_testo)),
                     (float(angolo)),
                     (float(orig1[0])),
                     (float(orig1[1]))]
            feature.setAttributes(values)       
            vl_ed.addFeature(feature,True)
            vl_ed.updateExtents()
 
 
  vl_part = QgsVectorLayer("Polygon?field=Codice_comune:string(50)&field=Fg:string(5)&field=Mapp:string(5)&field=Htxt:Double&field=Rtxt:Double&field=Xtxt:Double&field=Ytxt:Double",
                           "Particella", "memory")


  QgsMapLayerRegistry.instance().addMapLayer(vl_part)   
  vl_ed= QgsVectorLayer("Polygon?field=Codice_comune:string(50)&field=Fg:string(5)&field=Mapp:string(5)&field=Htxt:Double&field=Rtxt:Double&field=Xtxt:Double&field=Ytxt:Double",
                           "Edifici", "memory") 
 
  QgsMapLayerRegistry.instance().addMapLayer(vl_ed)   
    
  file =ntpath.split(filename)[1]
 
  vl_part.startEditing()
  vl_ed.startEditing()
  while True:
    in_line= in_file.readline().strip()
    if in_line == "":
        break

    if in_line == 'MAPPA':
       mappa = in_file.readline().strip()
       scala=in_file.readline().strip()
    elif in_line == 'BORDO':
        in_line  = in_file.readline().strip()
        if in_line[len(in_line)-1] == '+':
            disarea('FABBRICATI',in_line)
        elif in_line  == 'STRADA':
            disarea('Strade',in_line)
        elif in_line  == 'ACQUA':
            disarea('Acque',in_line)
        elif in_line  == mappa:
            disarea('Confine',in_line)
        elif len(in_line) == 11 :
            disarea('Sezioni',in_line)
        elif in_line  == 'STRADA':
            disarea('Strade',in_line)
        else:
            disarea('Particelle',in_line)
  in_file.close()

  vl_part.commitChanges()

  vl_ed.commitChanges()




      


