"""
/***************************************************************************
CARICA CXF 
                                 A QGIS plugin

                             -------------------
        begin                : 2012-09-13
        copyright            : (C) 2012 by Arch. Fabio SAccon
        email                : saccon@gisplan.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from PyQt4.QtGui import *
from PyQt4.QtCore import *

from qgis.core import *
import sys
import os
import string
import resources
from CXF import CXFIN
explorer = None
class cxf_in():
    __module__ = __name__

    def __init__(self, iface):
        self.iface = iface



    def initGui(self):
        self.pluginname = '&QGIS Importatore CXF '
        self.action = QAction(QIcon(':/plugins/cxf_in/icon.png'), self.pluginname, self.iface.mainWindow())
        self.action.triggered.connect(self.run)
        self.iface.addToolBarIcon(self.action)
        self.iface.addPluginToMenu('&CXF import', self.action)
        for action in self.iface.pluginMenu().actions():
            if (action.text() == QString(self.pluginname)):
                action.setIcon(QIcon(':/plugins/cxf_in/icon.png'))




    def unload(self):
        self.iface.removePluginMenu('&CXF import', self.action)
        self.iface.removeToolBarIcon(self.action)



    def run(self):
        global explorer
        if (explorer is None):
            explorer = CXFIN()
            explorer.LoadFiles()
            explorer.fileOpenRequest.connect(self.openFile)
            explorer.show()
        else:
            explorer.setVisible((not explorer.isVisible()))



    def openFile(self, filePath):
        filename = unicode(filePath.toUtf8(), 'utf-8')



#if (__name__ == '__main__'):
   # app = QApplication(sys.argv)
   # win = QMainWindow(None)
   # explorer = fileDialog()
   # explorer.LoadFiles()
   # win.show()
   # retval = app.exec_()
   # sys.exit(retval)


