"""
/***************************************************************************
CARICA CXF 
                                 A QGIS plugin

                             -------------------
        begin                : 2012-09-13
        copyright            : (C) 2012 by Arch. Fabio SAccon
        email                : saccon@gisplan.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""


      
true = 1
false = 0

from qgis.core import *
from qgis.gui import *
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from ui_cxf_in import Ui_cxf_in
import os
import sys
import ntpath
import xml.etree.ElementTree as etree
#Should find a better way to do this rather then using regex
#Needs to be refactored into different lists.
# Need to add these with correct regex
# Spatial Data Transfer Standard (*catd.ddf *CATD.DDF) :  "^.*\.(shp)$"
# X-Plane/Flightgear (apt.dat nav.dat fix.dat awy.dat APT.DAT NAV.DAT FIX.DAT AWY.DAT)" :  "^.*\.(shp)$"
filters = {
   '[Vettore] File Agenzia del Territorio (*.cxf *.CXF)' : '^.*\.(cxf)$'
   
  }
class foglio(object):
    pass
class eAF(object):
    pass



class CXFIN(QDockWidget):
    #Signal notify when a file needs to be opened
    fileOpenRequest = pyqtSignal(QString)
 


    def __init__(self):
        QDockWidget.__init__(self)
        # Set up the user interface from Designer.
        self.ui = Ui_cxf_in()
        self.ui.setupUi(self)

        #Load the filter list
        for key in sorted(filters.iterkeys()):
            self.ui.filtercombobox.addItem(key)

    def LoadFiles(self):
        self.model = QFileSystemModel(self.ui.Listafile)
        self.model.setRootPath(QDir.homePath())
        self.proxy = MyFilter()
        self.proxy.setSourceModel(self.model)
        self.proxy.setFilterKeyColumn(0)

        self.proxy.setFilterRegExp(QRegExp(filters[unicode(self.ui.filtercombobox.currentText())],Qt.CaseInsensitive,QRegExp.RegExp))

        self.ui.Listafile.setModel(self.proxy)
        self.ui.Listafile.setSortingEnabled(True)
        self.ui.Listafile.sortByColumn(0, Qt.AscendingOrder)  
        self.ui.Listafile.hideColumn(1)
        self.ui.Listafile.hideColumn(2)
        self.ui.Listafile.hideColumn(3)
        #Hack to make sure the horizontal scroll bar shows up
        self.ui.Listafile.header().setStretchLastSection(False)
        self.ui.Listafile.header().setResizeMode(QHeaderView.ResizeToContents)
        self.ui.Listafile.setColumnWidth(0,280)

        #Just hide the header because we don't need to see it.
        self.ui.Listafile.header().hide()
        self.ui.Listafile
        self.ui.filtercombobox.currentIndexChanged[QString].connect(self.filterChanged)
        self.ui.Listafile
        self.ui.Listafile.doubleClicked.connect(self.itemClicked)

    def filterChanged(self, text):
        self.proxy.setFilterRegExp(QRegExp(filters[str(text)],Qt.CaseInsensitive,QRegExp.RegExp))

    def itemClicked(self, item):
        index = item.model().mapToSource(item)
        filepath = unicode(self.model.filePath(index).toUtf8(),"utf-8")
        #We don't need to do anything if filepath is a directory.
        if os.path.isdir(filepath):
            return

        load_cxf(filepath)

    def updateFilter(self, text):
        self.proxy.setFilterRegExp(QRegExp(text,Qt.CaseInsensitive,QRegExp.RegExp))
 
 
def load_cxf(filename):
  try:
      in_file = open(filename,"r")
  except IOError:
      print 'Impossibile aprire il file', filename
      sys.exit()
  #else:
  #print filename, 'ha', len(in_file.readlines()), 'linee'
  #in_file = open(filename,"r")
  
  def disarea(livello,codice ):

        geometria=[]
        area=[]
        lt_testo  = in_file.readline().strip()
        angolo  = in_file.readline().strip()
        #in_line  = in_file.readline().strip()
        x=float(in_file.readline().strip())
        y=float(in_file.readline().strip())
        orig1=[x,y]
        x=float(in_file.readline().strip())
        y=float(in_file.readline().strip())
        orig2=[x,y]
        #print orig1
        nrisole=int(in_file.readline().strip())
        nrverttot=int(in_file.readline().strip())
        #if nrisole > 0 :
        nrvertisola=[]

        for x in range(1,nrisole+1):
            nrvertisola.append(int(in_file.readline()))
        #print nrvertisola
        nrvertisola.insert(0,nrverttot-sum(nrvertisola))
        nrvertisola.insert(0,nrverttot-sum(nrvertisola))

        sgeometria="POLYGON"
        for isola,vert in enumerate(nrvertisola):
              sgeometria=sgeometria+"("
              for n in range (0,vert):
                  x=float(in_file.readline().strip())
                  y=float(in_file.readline().strip()) 
                 
                  geom= coord=[x,y]
                  if n == vert-1:
                    if isola==nrisole+1:
                        sgeom=str(x)+" "+str(y)+")"
                    else:
                        sgeom=str(x)+" "+str(y)+"),"
                  else:
                    sgeom=str(x)+" "+str(y)+","
                  sgeometria=sgeometria+sgeom
                  geometria.append(coord)
              area.append(geometria)
        sgeometria=sgeometria+")"
       # print sgeometria
        fet = QgsFeature()
        fet.setGeometry(QgsGeometry.fromWkt(sgeometria))


        if livello=="Particelle":

           fet.setAttributeMap( {0 : QVariant(mappa[0:4]),
                                 1 : QVariant(mappa[5:9]),
                                 2 : QVariant(codice), 
                                 3 : QVariant(float(lt_testo)),
                                 4 : QVariant(float(angolo)),
                                 5 : QVariant(float(orig1[0])),
                                 6 : QVariant(float(orig1[1]))} )  
           part.addFeatures( [ fet ] )
           vl_part.updateExtents()

        if livello=="FABBRICATI":
           fet.setAttributeMap( {0 : QVariant(mappa[0:4]),
                                 1 : QVariant(mappa[5:9]),
                                 2 : QVariant(codice), 
                                 3 : QVariant(float(lt_testo)),
                                 4 : QVariant(float(angolo)),
                                 5 : QVariant(float(orig1[0])),
                                 6 : QVariant(float(orig1[1]))} )  
           ed.addFeatures( [ fet ] )       
           vl_ed.updateExtents()
         
 
 
  vl_part = QgsVectorLayer('Polygon', 'Particella', 'memory')
  part = vl_part.dataProvider()   
  part.addAttributes( [ QgsField("Codice_comune", QVariant.String),
                      QgsField("Fg", QVariant.String), 
                      QgsField("Mapp", QVariant.String),
                      QgsField("Htxt", QVariant.Double),
                      QgsField("Rtxt", QVariant.Double),
                      QgsField("Xtxt", QVariant.Double),
                      QgsField("Ytxt", QVariant.Double)]
                      )

  QgsMapLayerRegistry.instance().addMapLayer(vl_part)    
  vl_ed = QgsVectorLayer('Polygon', 'Edifici', 'memory')
  ed = vl_ed.dataProvider()
  ed.addAttributes( [ QgsField("Codice_comune", QVariant.String),
                      QgsField("Fg", QVariant.String), 
                      QgsField("Mapp", QVariant.String),
                      QgsField("Htxt", QVariant.Double),
                      QgsField("Rtxt", QVariant.Double),
                      QgsField("Xtxt", QVariant.Double),
                      QgsField("Ytxt", QVariant.Double)]
                      )
  QgsMapLayerRegistry.instance().addMapLayer(vl_ed)          
  file =ntpath.split(filename)[1]
 

  while true:
    in_line= in_file.readline().strip()
    if in_line == "":
        break
    #in_line = in_line[:-1]
    if in_line == 'MAPPA':
       mappa = in_file.readline().strip()
       scala=in_file.readline().strip()
    elif in_line == 'BORDO':
        in_line  = in_file.readline().strip()
        if in_line[len(in_line)-1] == '+':
            disarea('FABBRICATI',in_line)
        elif in_line  == 'STRADA':
            disarea('Strade',in_line)
        elif in_line  == 'ACQUA':
            disarea('Acque',in_line)
        elif in_line  == mappa:
            disarea('Confine',in_line)
        elif len(in_line) == 11 :
            disarea('Sezioni',in_line)
        elif in_line  == 'STRADA':
            disarea('Strade',in_line)
        else:
            disarea('Particelle',in_line)
  in_file.close()
  vl_part.startEditing()
  vl_part.commitChanges()
  vl_ed.startEditing()
  vl_ed.commitChanges()


class MyFilter(QSortFilterProxyModel):
    def __init__(self,parent=None):
        super(MyFilter, self).__init__(parent)

    def filterAcceptsRow (self, source_row, source_parent ):
        if self.filterRegExp() =="":
            return True #Shortcut for common case

        source_index = self.sourceModel().index(source_row, 0, source_parent)

        if self.sourceModel().isDir(source_index):
            return True

        return self.sourceModel().data(source_index).toString().contains(self.filterRegExp())

      

















