# Create Grid QGIS Plugin

**Create Grid** is a QGIS plugin that allows users to generate a grid of polygons within a selected polygon layer. This is useful for spatial analysis, sampling, or dividing areas into manageable units.

## Features

- Generate square grids within selected polygon features
- Customize grid size and extent
- Supports QGIS 3.0 and above

## Requirements

- QGIS 3.0 or later

## Installation

1. **Download or Clone the Repository**
   ```bash
   git clone https://github.com/sivansakthi/CreateGrid.git

## Author
- **Sivansakthi SG** - [sivansakthisgs@gmail.com](mailto:sivansakthisgs@gmail.com)


## Copy the Plugin Folder
Copy the CreateGrid folder into your QGIS plugins directory:

Windows: C:\Users\<YourUsername>\AppData\Roaming\QGIS\QGIS3\profiles\default\python\plugins
Linux: ~/.local/share/QGIS/QGIS3/profiles/default/python/plugins/
macOS: ~/Library/Application Support/QGIS/QGIS3/profiles/default/python/plugins/

## Grid Creation Instructions

  ![image](https://github.com/sivansakthi/CreateGrid/blob/main/Image.png)

 
**1.Select a Polygon to Generate Grids**
Choose the polygon for which you want to create grids. The grid will be automatically generated based on the specified width and length dimensions.


**2.Specify Grid Size**
Enter the desired grid size. Units will be calculated based on the projection of the selected cover polygon.


**3.Grid Numbering**
Grid numbers will be automatically updated and displayed in either vertical or horizontal order, as shown in the reference example.


**4.Save Grid Data**
When a folder is selected, the grid data will be saved as text files for future reference.


**5.Assign Existing Grids to Polygon Attributes**
If existing grids are available, you can assign them to the selected polygon (Grid Layer). Choose the appropriate field to be used as the grid number.


Finalize and Monitor Progress
Click OK to start the process. You can monitor the progress in the status bar.



## Enable the Plugin

Open QGIS
Go to Plugins > Manage and Install Plugins
Search for Create Grid and enable it
