
from qgis.PyQt.QtGui import QIcon
from qgis.core import QgsApplication, QgsProcessingProvider

from .coordinate_txt_exporter import CoordinateTxtExporter
from .txt_to_vector_importer import TxtToVectorImporter
from .batch_txt_importer import BatchTxtToVectorImporter


class CoordProvider(QgsProcessingProvider):
    def loadAlgorithms(self):
        self.addAlgorithm(CoordinateTxtExporter())
        self.addAlgorithm(TxtToVectorImporter())
        self.addAlgorithm(BatchTxtToVectorImporter())

    def id(self):
        return "coordinate_tools"

    def name(self):
        return "Coordinate Tools"

    def icon(self):
        return QIcon()


class CoordinatePlugin:
    def __init__(self, iface):
        self.provider = CoordProvider()

    def initGui(self):
        QgsApplication.processingRegistry().addProvider(self.provider)

    def unload(self):
        QgsApplication.processingRegistry().removeProvider(self.provider)


def classFactory(iface):
    return CoordinatePlugin(iface)
