# -*- coding: utf-8 -*-
# (c) JC BAUDIN 2019 10 14
# import de QGIS
from PyQt5 import QtCore
from PyQt5 import QtGui
from PyQt5.QtCore import QVariant
from qgis.PyQt.QtWidgets import     (QMessageBox,
                                    QCheckBox,
                                    QDialog,
                                    QProgressBar,
                                    QDialogButtonBox,
                                    QAction,
                                    QLabel,
                                    QComboBox,
                                    QPushButton,
                                    QLineEdit,
                                    QApplication)

 

from qgis.core import  (QgsProject,
                        QgsMapLayer,
                        QgsWkbTypes,
                       QgsVectorLayer,
                       QgsField,
                       QgsFields,
                       QgsFeature,
                       QgsFeatureSink,
                       QgsFeatureRequest,
                       QgsGeometry,
                       QgsPointXY,
                       QgsPoint,
                       QgsWkbTypes,
                       QgsRectangle,
                       QgsFeature,
                       QgsSpatialIndex,
                       QgsCoordinateTransform,
                       QgsFeatureRequest,
                       QgsVector,
                       QgsProject,
                       QgsCoordinateReferenceSystem,
                       QgsCoordinateTransform)
                       
from qgis.utils import iface

import os
import os.path
import fonctionsF
import doAboutClosestPoint
from math import sqrt

def vect(p1, p2):
    #Vecteur définit par deux points
    v_x = p2.x() - p1.x()
    v_y = p2.y() - p1.y()
    Vec=QgsPoint(v_x,v_y)
    return Vec

def mag(p):
    magn=0.0
    if (p.x(),p.y())==(0.0,0.0):
        return 1
    else:
        # magnitude d'un vecteur point
        magn=sqrt(p.x()**2 + p.y()**2)
    return magn
    
class Ui_Dialog(object):
    """
    def __init__(self, iface):
        self.iface = iface
    """
    def setupUi(self, Dialog):
        self.iface = iface
        Dialog.setObjectName("Dialog")
        Dialog.resize(QtCore.QSize(QtCore.QRect(0,0,360,320).size()).expandedTo(Dialog.minimumSizeHint()))
        Dialog.setWindowTitle("ClosestPoint")
        
        # QLabel lancer recherche
        self.label10 = QLabel(Dialog)
        self.label10.setGeometry(QtCore.QRect(15,15,360,18))
        self.label10.setObjectName("label10")
        self.label10.setText("Select a layer of points to project (with points selected):  ")

        ListeCouchesPoint=[""]
        NbCouches=self.iface.mapCanvas().layerCount()
        if NbCouches==0: QMessageBox.information(None,"information:","No layers ! ")
        else:
            for i in range(0,NbCouches):
                couche=self.iface.mapCanvas().layer(i)
                # 0 pour point
                if couche.geometryType()== 0 or couche.geometryType()==3 :
                    if couche.isValid():
                       ListeCouchesPoint.append(couche.name())
                    else:
                       QMessageBox.information(None,"information:","No layers with points ! ")
                       return None
        self.ComboBoxPoints = QComboBox(Dialog)
        self.ComboBoxPoints.setMinimumSize(QtCore.QSize(330, 25))
        self.ComboBoxPoints.setMaximumSize(QtCore.QSize(330, 25))
        self.ComboBoxPoints.setGeometry(QtCore.QRect(10, 35, 330,25))
        self.ComboBoxPoints.setObjectName("ComboBoxPoints")
        for i in range(len(ListeCouchesPoint)):  self.ComboBoxPoints.addItem(ListeCouchesPoint[i])

        # QLabel de couche ligne
        self.label = QLabel(Dialog)
        self.label.setGeometry(QtCore.QRect(15,70,320,18))
        self.label.setObjectName("label")
        self.label.setText("Select a layer of lines (with lines selected): ")

        ListeCouchesLigne=[""]
        NbCouches=self.iface.mapCanvas().layerCount()
        for i in range(0,NbCouches):
            couche=self.iface.mapCanvas().layer(i)
            # 1 pour ligne
            if couche.geometryType()== 1 or couche.geometryType()== 4 :
                if couche.isValid():
                   ListeCouchesLigne.append(couche.name())
                else:
                   QMessageBox.information(None,"information:","no layer with lines ! ")
                   return None
        
        self.ComboBoxLignes = QComboBox(Dialog)
        self.ComboBoxLignes.setMinimumSize(QtCore.QSize(330, 25))
        self.ComboBoxLignes.setMaximumSize(QtCore.QSize(330, 25))
        self.ComboBoxLignes.setGeometry(QtCore.QRect(10, 90, 330,25))
        self.ComboBoxLignes.setObjectName("ComboBoxLignes")
        for i in range(len(ListeCouchesLigne)):  self.ComboBoxLignes.addItem(ListeCouchesLigne[i])

        # QLabel entrer le facteur k nearest neighbor
        self.labelKNearestNeighbor = QLabel(Dialog)
        self.labelKNearestNeighbor.setGeometry(QtCore.QRect(15,120,280,23))
        self.labelKNearestNeighbor.setObjectName(" KNearestNeighbor")
        self.labelKNearestNeighbor.setText("Enter the k number (see Read-me try 3):")
        
        self.TextEditKNearestNeighbor = QLineEdit(Dialog)
        self.TextEditKNearestNeighbor.setMinimumSize(QtCore.QSize(40, 20))
        self.TextEditKNearestNeighbor.setMaximumSize(QtCore.QSize(40, 20))
        self.TextEditKNearestNeighbor.setGeometry(QtCore.QRect(265,120,40,20))
        self.TextEditKNearestNeighbor.setObjectName("TextEditKNearestNeighbor")
        
        #Exemple de QPushButton
        self.DoButton = QPushButton(Dialog)
        self.DoButton.setMinimumSize(QtCore.QSize(200, 20))
        self.DoButton.setMaximumSize(QtCore.QSize(200, 20))        
        self.DoButton.setGeometry(QtCore.QRect(60,150, 200, 20))
        self.DoButton.setObjectName("DoButton")
        self.DoButton.setText(" Plot the nearest points !")
 
     
        #Exemple de QLCDNumber
        self.progressBar = QProgressBar(Dialog)
        self.progressBar.setProperty("value", 0)
        self.progressBar.setMinimumSize(QtCore.QSize(260, 15))
        self.progressBar.setMaximumSize(QtCore.QSize(260, 15))
        self.progressBar.setGeometry(QtCore.QRect(30,180,260,15))
        self.progressBar.setAlignment(QtCore.Qt.AlignCenter)
        self.progressBar.setTextVisible(True)
        self.progressBar.setObjectName("progressBar")
        self.progressBar.setStyleSheet(
            """QProgressBar {border: 2px solid grey; border-radius: 5px; text-align: center;}"""
            """QProgressBar::chunk {background-color: #6C96C6; width: 20px;}"""
        )
        #Pose a minima une valeur de la barre de progression / slide contrôle
        self.progressBar.setValue(0)
    
        #Exemple de QPushButton
        self.DoButton2 = QPushButton(Dialog)
        self.DoButton2.setMinimumSize(QtCore.QSize(220, 20))
        self.DoButton2.setMaximumSize(QtCore.QSize(220, 20))        
        self.DoButton2.setGeometry(QtCore.QRect(60,200, 200, 20))
        self.DoButton2.setObjectName("DoButton2")
        self.DoButton2.setText(" Produce cut lines layers by points !")

        #Exemple de QLCDNumber
        self.progressBar2 = QProgressBar(Dialog)
        self.progressBar2.setProperty("value", 0)
        self.progressBar2.setMinimumSize(QtCore.QSize(260, 15))
        self.progressBar2.setMaximumSize(QtCore.QSize(260, 15))
        self.progressBar2.setGeometry(QtCore.QRect(30,235,260,15))
        self.progressBar2.setAlignment(QtCore.Qt.AlignCenter)
        self.progressBar2.setTextVisible(True)
        self.progressBar2.setObjectName("progressBar2")
        self.progressBar2.setStyleSheet(
            """QProgressBar {border: 2px solid grey; border-radius: 5px; text-align: center;}"""
            """QProgressBar::chunk {background-color: #6C96C6; width: 20px;}"""
        )
        #Pose a minima une valeur de la barre de progression / slide contrôle
        self.progressBar2.setValue(0)
        
        #Exemple de QPushButton
        self.aboutButton = QPushButton(Dialog)
        self.aboutButton.setMinimumSize(QtCore.QSize(70, 20))
        self.aboutButton.setMaximumSize(QtCore.QSize(70, 20))        
        self.aboutButton.setGeometry(QtCore.QRect(30, 270, 70, 23))
        self.aboutButton.setObjectName("aboutButton")
        self.aboutButton.setText(" Read me ")
        
        self.PushButton = QPushButton(Dialog)
        self.PushButton.setMinimumSize(QtCore.QSize(100, 20))
        self.PushButton.setMaximumSize(QtCore.QSize(100, 20))
        self.PushButton.setGeometry(QtCore.QRect(185, 270, 100,20))
        self.PushButton.setObjectName("PushButton")
        self.PushButton.setText("Close")

        self.PushButton.clicked.connect(Dialog.reject)
        self.ComboBoxPoints.activated[str].connect(self.onComboP)
        self.ComboBoxLignes.activated[str].connect(self.onComboL)
        self.aboutButton.clicked.connect(self.doAbout)
        self.DoButton.clicked.connect(self.Run)
        self.DoButton2.clicked.connect(self.Verif)
        
        QtCore.QMetaObject.connectSlotsByName(Dialog)
                                                   
    def onComboP(self):
        SelectionP = self.ComboBoxPoints.currentText()
        #QMessageBox.information(None,"information:","couche selectionnee: "+ (SelectionP))
        CoucheP=fonctionsF.getVectorLayerByName(SelectionP)
        counterP=0
        for featP in CoucheP.selectedFeatures():
            counterP+=1
        if counterP==0:
            QMessageBox.information(None,"information:","Select a least one point feature in "+ str(CoucheP.name())+" layer !")
        # Selected point only are used with :
        # EnregistrementsP=CoucheP.selectedFeatures()
        # to work with all the points of a layer change for: 
        # Enregistrements=Couche.getFeatures(QgsFeatureRequest())
        
    def onComboL(self):
        SelectionL = self.ComboBoxLignes.currentText()
        #QMessageBox.information(None,"information:","couche selectionnee: "+ (SelectionL))
        CoucheL=fonctionsF.getVectorLayerByName(SelectionL)
        counterL=0
        for featL in CoucheL.selectedFeatures():
            counterL+=1
        if counterL==0:
            QMessageBox.information(None,"information:","Select a least one line feature in "+ str(CoucheL.name())+ " layer !") 
        
                
    def doAbout(self):
        d = doAboutClosestPoint.Dialog()
        d.exec_()


    
    def Run(self):
        global CoucheL,CoucheP
        SelectionP = self.ComboBoxPoints.currentText()
        CoucheP=fonctionsF.getVectorLayerByName(SelectionP)
        SelectionL = self.ComboBoxLignes.currentText()
        CoucheL=fonctionsF.getVectorLayerByName(SelectionL)
        counterP=counterL=counterN=counterProgess=0
        for featP in CoucheP.selectedFeatures():
            counterP+=1
        counterSelec=0
        counterSelec = int(self.TextEditKNearestNeighbor.text())
        if counterSelec==0 :
            QMessageBox.information(None,"information:","enter a value for k, at least 1 ") 
        
        #zdim est le compteur de la progress bar    
        zDim = counterP
        indexBerge=QgsSpatialIndex()
        for featL in CoucheL.selectedFeatures():
            indexBerge.insertFeature(featL)
            counterL+=1
            #QMessageBox.information(None,"DEBUGindex:",str(indexBerge)) 
        if counterP!=0:
            if  counterL!=0:
                # creation couche de points projetes
                # making of projected points layer
                PtsProj= QgsVectorLayer("Point", str(CoucheP.name())+"_Projected", "memory")
                QgsProject.instance().addMapLayer(PtsProj)
                prPtsProj = PtsProj.dataProvider()
                providerP = CoucheP.dataProvider()
                fieldsP = providerP.fields()
                for f in fieldsP:
                    znameField= f.name()
                    Type= str(f.typeName())
                    if Type == 'Integer': prPtsProj.addAttributes([ QgsField( znameField, QVariant.Int)])
                    if Type == 'Real': prPtsProj.addAttributes([ QgsField( znameField, QVariant.Double)])
                    if Type == 'String': prPtsProj.addAttributes([ QgsField( znameField, QVariant.String)])
                    else : prPtsProj.addAttributes([ QgsField( znameField, QVariant.String)])
                prPtsProj.addAttributes([QgsField("DistanceP", QVariant.Double),
                                          QgsField("XDep", QVariant.Double),
                                          QgsField("YDep", QVariant.Double),
                                          QgsField("Xproj", QVariant.Double),
                                          QgsField("Yproj", QVariant.Double)])
                # QMessageBox.information(None,"DEBUG3:","npos ")
                # creation de la couche de lignes
                # making of projected shortest lines layer
                SEGMENTS= QgsVectorLayer("MultiLineString", "Shortest_Lines_from_"+ str(CoucheP.name()), "memory")
                QgsProject.instance().addMapLayer(SEGMENTS)
                prSEGMENTS =SEGMENTS.dataProvider()
                listFields = [          QgsField("ID_Point", QVariant.Int),
                                          QgsField("DistanceP", QVariant.Double),
                                          QgsField("XDep", QVariant.Double),
                                          QgsField("YDep", QVariant.Double),
                                          QgsField("Xproj", QVariant.Double),
                                          QgsField("Yproj", QVariant.Double)]
                
                prSEGMENTS.addAttributes(listFields)
                SEGMENTS.startEditing()
                newfeatSEGMENTS=QgsFeature()
                
                ###
                attributs=[]
                global DicoP,DicoL
                DicoP={}
                DicoL={}# le dictionnaire des lignes sur lesquelles au moins un point se projette
                for featP in CoucheP.selectedFeatures():
                    attributs=featP.attributes()
                    counterProgess+=1
                    geomP=featP.geometry()
                    PointP=geomP.asPoint()
                    Point_id = featP.id()
                    nearestsfids=indexBerge.nearestNeighbor(geomP.asPoint(),counterSelec)
                    #QMessageBox.information(None,"DEBUGnearestIndex:",str(nearestsfids))
                    #http://blog.vitu.ch/10212013-1331/advanced-feature-requests-qgis
                    #layer.getFeatures( QgsFeatureRequest().setFilterFid( fid ) )
                    request = QgsFeatureRequest().setFilterFids( nearestsfids )
                    #list = [ feat for feat in CoucheL.getFeatures( request ) ]
                    # QMessageBox.information(None,"DEBUGnearestIndex:",str(list))
                    min_dist=Distance=0.0
                    nearest_point = None
                    minVal=0.0
                    first= True
                    for featL in CoucheL.getFeatures(request):
                        geomL=featL.geometry()
                        fidL=featL.id()
                        distinit,mindistpt,aftervertexinit,leftoff=geomL.closestSegmentWithContext(PointP)
                        #https://qgis.org/api/classQgsGeometry.html
                        #https://gis.stackexchange.com/questions/214728/qgis-cut-line-feature-by-the-nearest-point
                        #QMessageBox.information(None,"DEBUG", 'aftervertexinit:  ' +str(aftervertexinit))
                        #liste_vertex.append(aftervertexinit)
                        ProjPoint=QgsPointXY(mindistpt[0],mindistpt[1])
                        Distance=fonctionsF.magnitude(PointP, ProjPoint)
                        #QMessageBox.information(None,"DEBUG", 'Distance:  Distance' +str(Distance))
                        if first:
                            minVal,nearest_point,after_vertex_init,fidLV,geomLV,first = Distance,ProjPoint,aftervertexinit,fidL,geomL,False
                        else:
                            if Distance < minVal: minVal,nearest_point,after_vertex_init,fidLV,geomLV=Distance,ProjPoint,aftervertexinit,fidL,geomL
                    PProjMin=nearest_point
                    min_dist=minVal
                    DicoP[Point_id]=[fidLV,PProjMin,after_vertex_init]
                    DicoL[fidLV]=[geomLV,fidL]
                    Geom= QgsGeometry().fromPointXY(PProjMin)    
                    PX=float(format(geomP.asPoint().x(), '.2f'))
                    PY=float(format(geomP.asPoint().y(), '.2f'))
                    newfeat = QgsFeature()
                    newfeat.setGeometry(Geom)
                    Values= featP.attributes()
                    Values.append(min_dist)
                    Values.append(fonctionsF.twodecimal(PX))
                    Values.append(fonctionsF.twodecimal(PY))
                    Values.append(fonctionsF.twodecimal(PProjMin.x()))
                    Values.append(fonctionsF.twodecimal(PProjMin.y()))
                    newfeat.setAttributes(Values)
                    PtsProj.startEditing()
                    prPtsProj.addFeatures([ newfeat ])
                    PtsProj.commitChanges()
                    PP=QgsPoint(PX,PY)
                    PPP=QgsPoint(PProjMin.x(),PProjMin.y())
                    geomppp=QgsGeometry().fromPointXY(PProjMin)
                    MultiLine=[]
                    MultiLine=[PPP,PProjMin]
                    GeomLine=QgsGeometry.fromPolyline((PP,PPP)) #index 0 has type 'QgsPointXY' but 'QgsPoint' is expected 
                    newfeatSEGMENTS.setGeometry(GeomLine)
                    ValuesSegments=[Point_id]
                    ValuesSegments.append(min_dist)
                    ValuesSegments.append(fonctionsF.twodecimal(PX))
                    ValuesSegments.append(fonctionsF.twodecimal(PY))
                    ValuesSegments.append(fonctionsF.twodecimal(PProjMin.x()))
                    ValuesSegments.append(fonctionsF.twodecimal(PProjMin.y()))
                    newfeatSEGMENTS.setAttributes(ValuesSegments)
                    prSEGMENTS.addFeatures([newfeatSEGMENTS ])
                    SEGMENTS.commitChanges()
                    
                zPercent = int(100 * counterProgess / zDim)
                self.progressBar.setValue(zPercent)
                self.iface.mapCanvas().refresh()

    def Verif(self):
        c=0
        for k in list(DicoL.keys()):c+=1
        if c>1 :
                    ##########################################################################################################
                    # Fabrication d'un dictionnaire DicoLP de lignes à modifier 
                    # On rassemble d'abord tous les points en rapport à avec une ligne a découper dans:
                    # - des listes des ids des points de départ (pour ajout d'attribut éventuel plus tard)
                    # - des listes de point projetés
                    # - des listes de numero de vertex de projection sur la ligne initiale
                    ###########################################################################!""
                    Liste_Pid=[] # la liste des ids des points qui se projette sur cette ligne
                    Liste_Pproj=[] # la liste des points qui se projette sur cette ligne
                    Liste_Vertex=[] # la liste des vertex ou se projettent les points sur cette ligne
                    liste_coord_vertex=[]
                    Liste_Distance_Sur_Vertex=[]
                    nb_pt_proj=1 # le nombre de points projetés sur une ligne
                    DicoLP={}
                    for keyL in list(DicoL.keys()):
                        geomL=DicoL[keyL][0]
                        fidL=DicoL[keyL][1]
                        my_line = geomL.asPolyline()
                        first= True
                        for key in list(DicoP.keys()):  
                            id_ligne=DicoP[key][0]
                            if keyL==id_ligne:
                                if first:
                                    nb_pt_proj=1
                                    Liste_Pid=[key]
                                    Liste_Pproj=[DicoP[key][1]]
                                    Liste_Vertex=[DicoP[key][2]]
                                    for idx in range(len(my_line)):
                                        if idx == DicoP[key][2]-1:
                                            liste_coord_vertex.append(my_line[idx])
                                            Liste_Distance_Sur_Vertex.append(mag(vect(my_line[idx],DicoP[key][1])))
                                    first=False
                                else:
                                    nb_pt_proj+=1
                                    Liste_Pid.append(key)
                                    Liste_Pproj.append(DicoP[key][1])
                                    Liste_Vertex.append(DicoP[key][2])
                                    for idx in range(len(my_line)):
                                        if idx == DicoP[key][2]-1:
                                            liste_coord_vertex.append(my_line[idx])
                                            Liste_Distance_Sur_Vertex.append(mag(vect(my_line[idx],DicoP[key][1])))
                        DicoLP[keyL]=[nb_pt_proj,Liste_Pid,Liste_Pproj,Liste_Vertex,my_line,liste_coord_vertex,Liste_Distance_Sur_Vertex,fidL]
                             
                    #QMessageBox.information(None,"DEBUG", 'nb_pt_proj:  ' +str(nb_pt_proj))            
                    #QMessageBox.information(None,"DEBUG", 'dicoLP non ordonné:  ' +str(DicoLP))
                        
                    ###########################################################################################################
                    #   Fabrication d'un dictionnaire DicoLPP de lignes à modifier avec listes des points projetés ordonnées 
                    #   Les listes sont ordonnées et à un numéro d'index donné chaque éléments point, numéro de vertex, correspond.
                    #   Boucle pour ordonner la listes des numéros de vertex des positions initiales et les autres  listes en fonction de cet ordre
                    #   Rappel DicoLPP[keyL]=[nb_pt_proj,Liste_Pid,Liste_Pproj,Liste_Vertex,my_line,liste_coord_vertex,Liste_Distance_Sur_Vertex,fidL]
                    #   Certains point sont projetés sur un même vertex, il faut les ordonner selon la distance au point de départ du vertex
                    DicoLPP={}
                    for keyLP in list(DicoLP.keys()):  
                        nb_insertions=DicoLP[keyLP][0]
                        Listes_pt_id=DicoLP[keyLP][1]
                        Liste_Pproj=DicoLP[keyLP][2]
                        Liste_Vertex=DicoLP[keyLP][3]
                        glines=DicoLP[keyLP][4]
                        FIDL=DicoLP[keyLP][7]
                        liste_coord_vertex=DicoLP[keyLP][5]
                        Liste_Distance_Sur_Vertex=DicoLP[keyLP][6]
                        #
                        Liste_pt_id_ordonne=[]
                        Listes_pt_proj_ordonne=[]
                        Listes_vertex_ordonne=[]
                        k=0
                        #Pour une ligne on regarde tous les points et on les trie par numéro de vertex
                        while k < nb_insertions:
                            first_point=True
                            for index_pt,id_pt in enumerate(Listes_pt_id):
                                if first_point: # on prend le premier point que l'on va comparer au suivant
                                    first_point=False
                                    pt_id_min=id_pt
                                    min_index=index_pt
                                    dmin=Liste_Distance_Sur_Vertex[ index_pt]
                                    minVertex=Liste_Vertex[ index_pt]
                                    point_proj=Liste_Pproj[ index_pt]
                                else:
                                    for index,val in enumerate(Liste_Vertex): 
                                        d=Liste_Distance_Sur_Vertex[index]
                                        vertex=val
                                        pt_id=Listes_pt_id[index]
                                        if minVertex > vertex: # si un pt est sur un plus petit vertex il est peut être le premier
                                            pt_id_min=pt_id
                                            min_index=index
                                            dmin=d
                                            minVertex=vertex
                                            point_proj=Liste_Pproj[index]
                                        if  minVertex==vertex: # sauf si un point est sur un mêeme vertex alors on regarde la distance au début du vertex
                                            if  dmin > d:
                                                pt_id_min=pt_id
                                                min_index=index
                                                dmin=d
                                                minVertex=vertex
                                                point_proj=Liste_Pproj[index]
                            Liste_pt_id_ordonne.append(pt_id_min)
                            Listes_pt_proj_ordonne.append(point_proj)
                            Listes_vertex_ordonne.append(minVertex)
                            Listes_pt_id.pop(min_index)
                            Liste_Pproj.pop(min_index)
                            Liste_Vertex.pop(min_index)
                            Liste_Distance_Sur_Vertex.pop(min_index)
                            k+=1
                        #QMessageBox.information(None,"DEBUG", 'Listes_vertex_ordonne:' +str(Listes_vertex_ordonne))
                        DicoLPP[keyLP]=[nb_insertions,Liste_pt_id_ordonne,Listes_pt_proj_ordonne,Listes_vertex_ordonne,glines,FIDL]
                        #QMessageBox.information(None,"DEBUG", 'DicoLPP avec listes ordonnées:' +str(DicoLPP))
                    #################################################################################################################
                    # Le numero de vertex d'insertion est valable pour l'insertion d'un point sur la ligne.
                    # Mais il va se trouver modifié au fur et à mesure qu'on ajoute d'autres noeuds à la ligne à partir du premier.
                    # En effet ce numéro du vertex d'insertion s'incrémente, se décalle de 1 à chaque nouvelle insertion d'un point projeté après le premier
                    # une fois inséré un point, le second s'insère à ertx +2 de la nouvelle géométrie
                    ###################################################################################################################
                    # Boucle de fabrication des nouvelles geométries ..... de ligne à polylignes Modèle 1
                    # Frist methode argh
                    DicoFinalGeom={}
                    # rappel DicoLPP[keyLP]=[nb_insertions,Liste_pt_id_ordonne,Listes_pt_proj_ordonne,Listes_vertex_ordonne,glines,FIDL]
                    for keyLPP in list(DicoLPP.keys()):
                        my_line = DicoLPP[keyLPP][4]
                        FIDL=DicoLPP[keyLPP][5]
                        #QMessageBox.information(None,"DEBUG", ' my_line:' +str(my_line))
                        nb_cut=DicoLPP[keyLPP][0]
                        Liste_Pid=DicoLPP[keyLPP][1] # la liste des ids des points qui se projette sur cette ligne
                        Liste_Pproj=DicoLPP[keyLPP][2] # la liste des points qui se projette sur cette ligne
                        Liste_Vertex=DicoLPP[keyLPP][3] # la liste des vertex ou se projettent les points sur cette ligne
                        #QMessageBox.information(None,"DEBUG", 'Liste_Vertex:' +str(Liste_Vertex)+'\n'+' nb cut: '+str(nb_cut)+'\n'+' Liste_Pid: '+str(Liste_Pid))
                        k=0
                        #new_Polyline=[]
                        new_Polyline={}
                        new_line=[]
                        Pid_start=''
                        Pid_end=''
                        #try:
                        idx=0
                        while idx <(len(my_line)):
                            point=my_line[idx]
                            new_line.append(QgsPoint(point))
                            # nb_cut commence à 1 ! 
                            while k < nb_cut and idx == Liste_Vertex[k]-1: # on passe au k vertex suivant qui peut être toujous le même pour idx
                                PProjMin=Liste_Pproj[k]
                                new_line.append(QgsPoint(PProjMin.x(),PProjMin.y()))
                                Pid_start=Liste_Pid[k]
                                #QMessageBox.information(None,"DEBUG", 'PProjMin:' +str(PProjMin))
                                new_Polyline[k]=[new_line,Pid_start,Pid_end,k]
                                # fin d'un segment de ligne début d'un segment suivant
                                new_line=[]
                                new_line.append(QgsPoint(PProjMin.x(),PProjMin.y()))
                                Pid_end=Liste_Pid[k]
                                Pid_start=''
                                k+=1
                            idx+=1  
                        new_Polyline[k]=[new_line,Pid_start,Pid_end]
                        DicoFinalGeom[keyLPP]=[new_Polyline,nb_cut+1,FIDL]

                    ###
                    #Generateur test de lignes finales
                    mem_layer_test= QgsVectorLayer("MultiLineString", "cut_lines_test_from_"+ str(CoucheL.name()), "memory")
                    QgsProject.instance().addMapLayer(mem_layer_test)
                    pr_mem_layer_test=mem_layer_test.dataProvider()
                    pr_mem_layer_test.addAttributes([QgsField("ID_Line", QVariant.String)])
                    pr_mem_layer_test.addAttributes([QgsField("NB_PART", QVariant.Int)])
                    pr_mem_layer_test.addAttributes([QgsField("ID_PART", QVariant.String)])
                    pr_mem_layer_test.addAttributes([QgsField("ID_PT_INIT", QVariant.String)])
                    pr_mem_layer_test.addAttributes([QgsField("ID_PT_END", QVariant.String)])
                    mem_layer_test.startEditing()
                    
                    for keyPL in list(DicoFinalGeom.keys()):
                        lines=DicoFinalGeom[keyPL][0]
                        for keyL in list(lines.keys()): # rappel new_Polyline[idx]=[new_line,Pid_start,Pid_end]
                            attributs=[]
                            attributs.append(DicoFinalGeom[keyPL][2])
                            attributs.append(DicoFinalGeom[keyPL][1]) # nb part DicoFinalGeom[keyL]=[new_Polyline,nb_cut+1,FIDL]
                            attributs.append(str(DicoFinalGeom[keyPL][2])+'_'+str(keyL))
                            attributs.append(lines[keyL][1])
                            attributs.append(lines[keyL][2])
                            feat = QgsFeature()
                            feat.setAttributes(attributs)
                            line=lines[keyL][0]
                            feat.setGeometry(QgsGeometry.fromPolyline(line))
                            pr_mem_layer_test.addFeatures([feat])
                    mem_layer_test.commitChanges()
                    ##############################
                    # copie de la couche de ligne
                    #################################
                    CUT_LINES= QgsVectorLayer("MultiLineString", "Lines_from_"+ str(CoucheL.name())+"_cut_by_"+str(CoucheP.name()), "memory")
                    QgsProject.instance().addMapLayer(CUT_LINES)
                    prCUT_LINES =CUT_LINES.dataProvider()
                    providerL = CoucheL.dataProvider()
                    fieldsL = providerL.fields()
                    for f in fieldsL:
                        znameField= f.name()
                        Type= str(f.typeName())
                        if Type == 'Integer': prCUT_LINES.addAttributes([ QgsField( znameField, QVariant.Int)])
                        if Type == 'Real': prCUT_LINES.addAttributes([ QgsField( znameField, QVariant.Double)])
                        if Type == 'String': prCUT_LINES.addAttributes([ QgsField( znameField, QVariant.String)])
                        else : prCUT_LINES.addAttributes([ QgsField( znameField, QVariant.String)])
                    prCUT_LINES.addAttributes([QgsField("ID_Line", QVariant.String)])
                    prCUT_LINES.addAttributes([QgsField("NB_PART", QVariant.Int)])
                    prCUT_LINES.addAttributes([QgsField("ID_PART", QVariant.String)])
                    prCUT_LINES.addAttributes([QgsField("ID_PT_AV", QVariant.String)])
                    prCUT_LINES.addAttributes([QgsField("ID_PT_AM", QVariant.String)])
                    CUT_LINES.startEditing()
                    counterProgess2=0
                    zDim2=0
                    for featL in CoucheL.getFeatures():
                        zDim2+=1
                    for featL in CoucheL.getFeatures():
                        counterProgess2+=1
                        geomL=featL.geometry()
                        fidL=featL.id()
                        c=0
                        for keyPL in list(DicoFinalGeom.keys()): #DicoFinalGeom[keyL]=[new_Polyline,nb_cut+1,FIDL]
                            if keyPL==fidL:
                                c+=1
                                lines=DicoFinalGeom[keyPL][0]
                                for keyL in list(lines.keys()): # rappel new_Polyline[idx]=[new_line,Pid_start,Pid_end]
                                    valuesLines=[]
                                    valuesLines=featL.attributes()
                                    valuesLines.append(DicoFinalGeom[keyPL][2])
                                    valuesLines.append(DicoFinalGeom[keyPL][1]) # nb part DicoFinalGeom[keyL]=[new_Polyline,nb_cut+1,FIDL]
                                    valuesLines.append(str(DicoFinalGeom[keyPL][2])+'_'+str(keyL))
                                    valuesLines.append(lines[keyL][1])
                                    valuesLines.append(lines[keyL][2])
                                    line=lines[keyL][0]
                                    newfeatCUT_LINES=QgsFeature()
                                    newfeatCUT_LINES.setGeometry(QgsGeometry.fromPolyline(line))
                                    newfeatCUT_LINES.setAttributes(valuesLines)
                                    prCUT_LINES.addFeatures([newfeatCUT_LINES])
                        if c==0:       
                            # on recopie la couche initiale sauf si la ligne est coupée donc dans DicoFinalGeom
                            newfeatCUT_LINES=QgsFeature()
                            newfeatCUT_LINES.setGeometry(geomL)
                            valuesLines=[]
                            valuesLines=featL.attributes()
                            valuesLines.append(fidL) # ID_Line =0 si ligne non coupée
                            valuesLines.append(1) # nb partie =1 si ligne non coupée
                            valuesLines.append('') # NEW_ID égale fid
                            valuesLines.append('') # ID_PT_AV
                            valuesLines.append('') # ID_PT_AM
                            newfeatCUT_LINES.setAttributes(valuesLines)
                            prCUT_LINES.addFeatures([newfeatCUT_LINES])
                        zPercent2 = int(100 * counterProgess2 / zDim2)
                        self.progressBar2.setValue(zPercent2)
                        self.iface.mapCanvas().refresh()
                    CUT_LINES.commitChanges()
                    
                        
             

                
             
