# -*- coding: utf-8 -*-

"""
/***************************************************************************
 CivilEng
                                 A QGIS plugin
 CivilEng
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2022-04-02
        copyright            : (C) 2022 by Iñigo Marin
        email                : proy.mbr@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Iñigo Marin'
__date__ = '2022-04-02'
__copyright__ = '(C) 2022 by Iñigo Marin'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import os
import sys
import inspect

from qgis.PyQt.QtWidgets import QAction
from qgis.PyQt.QtGui import QIcon

from qgis.core import QgsProcessingAlgorithm, QgsApplication
import processing
from .CivilEng_provider import CivilEngProvider

cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]

if cmd_folder not in sys.path:
    sys.path.insert(0, cmd_folder)

      
class CivilEngPlugin(object):

    def __init__(self, iface):
        self.provider = None
        self.iface = iface
        
    def initProcessing(self):
        """Init Processing provider for QGIS >= 3.8."""
        self.provider = CivilEngProvider()
        QgsApplication.processingRegistry().addProvider(self.provider)
        
        
    def initGui(self):
        self.initProcessing()
        icon = os.path.join(os.path.join(cmd_folder, 'CivilEng.png'))
        self.action = QAction(
            QIcon(icon),
            u"Reservoir", self.iface.mainWindow())
        self.action.triggered.connect(self.run_Reservoir)
        self.iface.addPluginToMenu(u"&CivilEng", self.action)
        self.iface.addToolBarIcon(self.action)

        icon2 = os.path.join(os.path.join(cmd_folder, 'Earthworks.png'))
        self.action2 = QAction(
            QIcon(icon2),
            u"Earthworks", self.iface.mainWindow())
        self.action2.triggered.connect(self.run_Earthworks)
        self.iface.addPluginToMenu(u"&CivilEng", self.action2)
        self.iface.addToolBarIcon(self.action2)    

        icon3 = os.path.join(os.path.join(cmd_folder, 'LRS.png'))
        self.action3 = QAction(
            QIcon(icon3),
            u"LRS", self.iface.mainWindow())
        self.action3.triggered.connect(self.run_LRS)
        self.iface.addPluginToMenu(u"&CivilEng", self.action3)
        self.iface.addToolBarIcon(self.action3)   
        
                        
    def unload(self):
        QgsApplication.processingRegistry().removeProvider(self.provider)
        self.iface.removePluginMenu(u"&CivilEng", self.action)
        self.iface.removeToolBarIcon(self.action)
        self.iface.removePluginMenu(u"&CivilEng", self.action2)
        self.iface.removeToolBarIcon(self.action2)
        self.iface.removePluginMenu(u"&CivilEng", self.action3)
        self.iface.removeToolBarIcon(self.action3) 
        del self.action
        del self.action2
        del self.action3
        
    def run_Reservoir(self):
      processing.execAlgorithmDialog("CivilEng:Reservoir")
      
    def run_Earthworks(self):
      processing.execAlgorithmDialog("CivilEng:Earthworks")
      
    def run_LRS(self):
      processing.execAlgorithmDialog("CivilEng:LRS")