# -*- coding: utf-8 -*-

"""
/***************************************************************************
Earthworks
                                 A QGIS plugin
 
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2022-04-02
        copyright            : (C) 2022 by Iñigo Marin
        email                : proy.mbr@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Iñigo Marin'
__date__ = '2022-04-02'
__copyright__ = '(C) 2022 by Iñigo Marin'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.PyQt.QtCore import QCoreApplication
from qgis.core import QgsProcessing
from qgis.core import QgsProcessingAlgorithm
from qgis.core import QgsProcessingMultiStepFeedback
from qgis.core import QgsProcessingParameterNumber
from qgis.core import QgsProcessingParameterRasterLayer
from qgis.core import QgsProcessingParameterVectorLayer
from qgis.core import QgsProcessingParameterPoint
from qgis.core import QgsProcessingParameterRasterDestination
from qgis.core import QgsProcessingParameterVectorDestination
from qgis.core import QgsProcessingParameterFeatureSink
from qgis.core import QgsExpression
from os import path
from PyQt5.QtGui import QIcon
import processing


class EarthworksAlgorithm(QgsProcessingAlgorithm):
    """
    
    All Processing algorithms should extend the QgsProcessingAlgorithm
    class.
    """

    # Constants used to refer to parameters and outputs. They will be
    # used when calling the algorithm from another algorithm, or when
    # calling from the QGIS console.

    OUTPUT = 'OUTPUT'
    INPUT = 'INPUT'

    def initAlgorithm(self, config):
        """
        Here we define the inputs and output of the algorithm, along
        with some other properties.
        """

        self.addParameter(QgsProcessingParameterRasterLayer('DEM', 'Existing DEM raster layer', defaultValue=None))
        self.addParameter(QgsProcessingParameterVectorLayer('platform', 'Platform vector layer', types=[QgsProcessing.TypeVector], defaultValue=None))
        self.addParameter(QgsProcessingParameterNumber('platform_level', 'Platform base level', type=QgsProcessingParameterNumber.Double, defaultValue=0))
        self.addParameter(QgsProcessingParameterNumber('cut_slope', 'Cut Slope 1:H', type=QgsProcessingParameterNumber.Double, minValue=0, defaultValue=1))
        self.addParameter(QgsProcessingParameterNumber('fill_slope', 'Fill Slope 1:H', type=QgsProcessingParameterNumber.Double, minValue=0,  defaultValue=1))
        self.addParameter(QgsProcessingParameterRasterDestination('new_DEM', 'Modified DEM raster layer', createByDefault=True, defaultValue=''))


    def processAlgorithm(self, parameters, context, model_feedback):
        """
        Here is where the processing itself takes place.
        """
        # Use a multi-step feedback, so that individual child algorithm progress reports are adjusted for the
        # overall progress through the model
        feedback = QgsProcessingMultiStepFeedback(6, model_feedback)
        results = {}
        outputs = {}

        # Búfer múlti-anillos (distancia constante)
        alg_params = {
            'DISTANCE': 1,
            'INPUT': parameters['platform'],
            'RINGS': 100,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['BferMltianillosDistanciaConstante'] = processing.run('native:multiringconstantbuffer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

       
                
        feedback.setCurrentStep(1)
        if feedback.isCanceled():
            return {}

        # Calculadora de campos
        alg_params = {
            'FIELD_LENGTH': 10,
            'FIELD_NAME': 'platform_level',
            'FIELD_PRECISION': 3,
            'FIELD_TYPE': 0,  # Float
            'FORMULA': parameters['platform_level'],
            'INPUT': outputs['BferMltianillosDistanciaConstante']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT 
        }
        outputs['CalculadoraDeCampos1'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
       
        # Calculadora de campos
        alg_params = {
            'FIELD_LENGTH': 10,
            'FIELD_NAME': 'fill_slope',
            'FIELD_PRECISION': 3,
            'FIELD_TYPE': 0,  # Float
            'FORMULA': parameters['fill_slope'],
            'INPUT': outputs['CalculadoraDeCampos1']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['CalculadoraDeCampos2'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

              
        # Calculadora de campos
        alg_params = {
            'FIELD_LENGTH': 10,
            'FIELD_NAME': 'cut_slope',
            'FIELD_PRECISION': 3,
            'FIELD_TYPE': 0,  # Float
            'FORMULA': parameters['cut_slope'],
            'INPUT': outputs['CalculadoraDeCampos2']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['CalculadoraDeCampos3'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        
        # Advanced Python field calculator
        alg_params = {
            'FIELD_LENGTH': 10,
            'FIELD_NAME': 'cut_level',
            'FIELD_PRECISION': 3,
            'FIELD_TYPE': 1,  # Float
            'FORMULA': 'value = <platform_level>+<distance>/<cut_slope>',
            'GLOBAL': '',
            'INPUT': outputs['CalculadoraDeCampos3']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['AdvancedPythonFieldCalculator1'] = processing.run('qgis:advancedpythonfieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        
        # Advanced Python field calculator
        alg_params = {
            'FIELD_LENGTH': 10,
            'FIELD_NAME': 'fill_level',
            'FIELD_PRECISION': 3,
            'FIELD_TYPE': 1,  # Float
            'FORMULA': 'value = <platform_level>-<distance>/<fill_slope>',
            'GLOBAL': '',
            'INPUT': outputs['CalculadoraDeCampos2']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['AdvancedPythonFieldCalculator2'] = processing.run('qgis:advancedpythonfieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
          
        
        feedback.setCurrentStep(2)
        if feedback.isCanceled():
            return {}

        # Rasterizar (vectorial a ráster)
        alg_params = {
            'BURN': None,
            'DATA_TYPE': 5,  # Float32
            'EXTENT': parameters['DEM'],
            'EXTRA': '',
            'FIELD': 'cut_level',
            'HEIGHT': 1,
            'INIT': 0,
            'INPUT': outputs['AdvancedPythonFieldCalculator1']['OUTPUT'],
            'INVERT': False,
            'NODATA': None,
            'OPTIONS': '',
            'UNITS': 1,  # Georeferenced units
            'USE_Z': False,
            'WIDTH': 1,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['RasterizarVectorialARster1'] = processing.run('gdal:rasterize', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        
        # Rasterizar (vectorial a ráster)
        alg_params = {
            'BURN': None,
            'DATA_TYPE': 5,  # Float32
            'EXTENT': parameters['DEM'],
            'EXTRA': '',
            'FIELD': 'fill_level',
            'HEIGHT': 1,
            'INIT': 0,
            'INPUT': outputs['AdvancedPythonFieldCalculator2']['OUTPUT'],
            'INVERT': False,
            'NODATA': None,
            'OPTIONS': '',
            'UNITS': 1,  # Georeferenced units
            'USE_Z': False,
            'WIDTH': 1,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['RasterizarVectorialARster2'] = processing.run('gdal:rasterize', alg_params, context=context, feedback=feedback, is_child_algorithm=True)


        feedback.setCurrentStep(3)
        if feedback.isCanceled():
            return {}

        # Raster calculator
        alg_params = {
            'BAND_A': 1,
            'BAND_B': 1,
            'BAND_C': 1,
            'BAND_D': None,
            'BAND_E': None,
            'BAND_F': None,
            'EXTRA': '--hide',
            'FORMULA': '(((A<B)*B + (A>=B)*A)>C)*C  + (((A<B)*B+(A>=B)*A)<=C)*((A<B)*B + (A>=B)*A)',
            'INPUT_A': parameters['DEM'],
            'INPUT_B': outputs['RasterizarVectorialARster2']['OUTPUT'],
            'INPUT_C': outputs['RasterizarVectorialARster1']['OUTPUT'],
            'INPUT_D': None,
            'INPUT_E': None,
            'INPUT_F': None,
            'NO_DATA': 0,
            'OPTIONS': '',
            'RTYPE': 5,  # Float32
            'OUTPUT': parameters['new_DEM']
        }
        outputs['RasterCalculator'] = processing.run('gdal:rastercalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['new_DEM'] = outputs['RasterCalculator']['OUTPUT']

        

        return results

    def name(self):
        """
        Returns the algorithm name, used for identifying the algorithm. This
        string should be fixed for the algorithm, and must not be localised.
        The name should be unique within each provider. Names should contain
        lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'Earthworks'

    def icon(self):
        """
        Should return a QIcon which is used for your provider inside
        the Processing toolbox.
        """
        return QIcon(path.dirname(__file__) +'/Earthworks.png')
        
    def displayName(self):
        """
        Returns the translated algorithm name, which should be used for any
        user-visible display of the algorithm name.
        """
        return self.tr(self.name())
  
       
    def group(self):
        """
        Returns the name of the group this algorithm belongs to. This string
        should be localised.
        """
        return self.tr(self.groupId())

    def groupId(self):
        """
        Returns the unique ID of the group this algorithm belongs to. This
        string should be fixed for the algorithm, and must not be localised.
        The group id should be unique within each provider. Group id should
        contain lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return ''

    def tr(self, string):
        return QCoreApplication.translate('Processing', string)

    def shortHelpString(self):
        return """<html><body><p>Earthworks algorithm modifies a DEM carving or filing it from a vector layer representing the baseline of the eartwork</p>
<h2>Input parameters</h2>
<h3>Existing DEM raster layer</h3>
<p>Existing initial terrain DEM to be modified</p>
<h3>Platform vector layer</h3>
<p>Vector layer (line or polygon) representing the baseline or base platform from wich the earthwork or DEM modification is going to be performed</p>
<h3>Platform base level</h3>
<p>Absolute level of the baseline or base platform from wich the earthwork or DEM modification is going to be performed</p>
<h3>Cut slope</h3>
<p> Cut slope of the earthwork as rate of vertical to horizontal lenght (1:H)</p>
<h3>Fill slope</h3>
<p> Fill slope of the earthwork as rate of vertical to horizontal lenght (1:H)</p>
<h2>Outputs</h2>
<h3>Modified DEM raster layer</h3>
<p>Modified DEM raster layer as result of the earthwork</p>
<br><p align="right">Algorithm author: Iñigo Marin</p><p align="right">Algorithm version: v. 0.1</p></body></html>"""

    def helpUrl(self):
        return 'https://github.com/MBR111/CivilEng'


    def createInstance(self):
        return EarthworksAlgorithm()
