# -*- coding: utf-8 -*-

"""
/***************************************************************************
 CityTimer
                                 A QGIS plugin
 temp description
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2022-07-22
        copyright            : (C) 2022 by Carlo Andrea Biraghi, Andrea Folini
        email                : carloandrea.biraghi@polimi.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Carlo Andrea Biraghi, Andrea Folini'
__date__ = '2022-07-22'
__copyright__ = '(C) 2022 by Carlo Andrea Biraghi, Andrea Folini'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.PyQt.QtCore import QCoreApplication
from qgis.core import (QgsProcessing,
                       QgsFeatureSink,
                       QgsProcessingAlgorithm,
                       QgsProcessingParameterFeatureSource,
                       QgsProcessingParameterFeatureSink,
                       QgsProcessingParameterField,
                       QgsProcessingParameterVectorLayer,
                       QgsProcessingParameterMultipleLayers,
                       QgsProcessingMultiStepFeedback,
                       QgsExpression,
                       QgsProcessingUtils,
                       QgsProcessingLayerPostProcessorInterface)
import processing

class CityTimerAlgorithm(QgsProcessingAlgorithm):
    """
    This is an example algorithm that takes a vector layer and
    creates a new identical one.

    It is meant to be used as an example of how to create your own
    algorithms and explain methods and variables used to do it. An
    algorithm like this will be available in all elements, and there
    is not need for additional work.

    All Processing algorithms should extend the QgsProcessingAlgorithm
    class.
    """

    # Constants used to refer to parameters and outputs. They will be
    # used when calling the algorithm from another algorithm, or when
    # calling from the QGIS console.

    grid_layer = None
    geometry_layer = None
    t_stat_layer = None
    c_stat_layer = None

    def initAlgorithm(self, config):
        """
        Here we define the inputs and output of the algorithm, along
        with some other properties.
        """

        self.addParameter(QgsProcessingParameterVectorLayer('Sourcepoints', 'Source points',
                                                            types=[QgsProcessing.TypeVectorPoint,
                                                                   QgsProcessing.TypeVectorLine,
                                                                   QgsProcessing.TypeVectorPolygon,
                                                                   QgsProcessing.TypeVectorAnyGeometry],
                                                            defaultValue=None))

        self.addParameter(QgsProcessingParameterField('ID', 'Source_id', type=QgsProcessingParameterField.Any,
                                                      parentLayerParameterName='Sourcepoints', allowMultiple=False,
                                                      defaultValue=''))
        self.addParameter(QgsProcessingParameterVectorLayer('Network', 'Network', types=[QgsProcessing.TypeVectorLine],
                                                            defaultValue=None))

        self.addParameter(QgsProcessingParameterMultipleLayers('TargetLayers', "Target points layers",
                                                               QgsProcessing.TypeVectorPoint, defaultValue = None))

        self.addParameter(QgsProcessingParameterFeatureSink('GridOutput', 'Grid output',
                                                            type=QgsProcessing.TypeVectorAnyGeometry,
                                                            createByDefault=True, defaultValue=None))

        self.addParameter(
            QgsProcessingParameterFeatureSink('ConvexHull', 'Convex Hull', type=QgsProcessing.TypeVectorPolygon,
                                              createByDefault=True, defaultValue=None))

        self.addParameter(
            QgsProcessingParameterFeatureSink('CategoryStat', 'Category stat', type=QgsProcessing.TypeVectorAnyGeometry,
                                              createByDefault=True, defaultValue='TEMPORARY_OUTPUT'))

        self.addParameter(
            QgsProcessingParameterFeatureSink('TargetStat', 'Target stat', type=QgsProcessing.TypeVectorAnyGeometry,
                                              createByDefault=True, defaultValue=None))


    def shortHelpString(self):
        return  "<b>Parameters (required):</b><br>"\
                "Following Parameters must be set to run the algorithm:"\
                "<ul><li>Source points <br> Vector layer. In case of Polygons or Line layers the centroid will be used</li>" \
                "<li>Source_id<br> ID field of the source layer</li>" \
                "<li>Network<br>Georeferenced street network layer</li>" \
                "<li>Target points layers<br>One or more point layers</li></ul>" \
                "<b>Output:</b><br>"\
                "<ul><li>Grid Output <br> The Source points layer enriched with the statistics of network distance and " \
                "linear distance for the different target points (max, 3rd quartile, mean)</li>" \
                "<li>Convex Hull <br> The convex polygons centred in the source points having as vertex all the nearest point" \
                " of each target layer. It is correctly generated only if 3 or more target layers are used. </li>" \
                "<li>Category Stat <br> A table containing the statistics of network and linear distance for the different target " \
                "point layers. Each layer is represented by a single row </li>"\
                "<li>Target Stat <br> A target points layer enriched with the statistics of network distance and linear distance " \
                "for the different source points (max, 3rd quartile, mean) </li>"\
                "</ul>"

    def processAlgorithm(self, parameters, context, feedback):
        """
        Here is where the processing itself takes place.
        """
        outputs = {}
        results = {}
        to_merge = []
        target_layers = self.parameterAsLayerList(parameters, 'TargetLayers', context)
        steps = (len(target_layers) * 6) + 18
        current_step = 1
        target_id_start = 0
        multi_feedback = QgsProcessingMultiStepFeedback(steps, feedback)


        # Centroids
        alg_params = {
            'ALL_PARTS': False,
            'INPUT': parameters['Sourcepoints'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Centroids'] = processing.run('native:centroids', alg_params, context=context, feedback=multi_feedback,
                                              is_child_algorithm=True)

        multi_feedback.setCurrentStep(current_step)
        current_step = current_step + 1
        if multi_feedback.isCanceled():
            return {}

        for target in target_layers:

            loop_outputs = {}
            category =  "'%s'" % target.name()
            target_id_expression = '@row_number + %d' % target_id_start
            target_id_start = target_id_start + target.featureCount()
            # Field calculator ID
            alg_params = {
                'FIELD_LENGTH': 10,
                'FIELD_NAME': 'T_ID',
                'FIELD_PRECISION': 0,
                'FIELD_TYPE': 1,  # Integer
                'FORMULA': target_id_expression,
                'INPUT': target,
                'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }
            loop_outputs['FieldCalculatorId'] = processing.run('native:fieldcalculator', alg_params, context=context,
                                                          feedback=multi_feedback, is_child_algorithm=True)

            multi_feedback.setCurrentStep(current_step)
            current_step = current_step + 1
            if multi_feedback.isCanceled():
                return {}

            # OD Matrix from Layers as Lines (m:n)
            alg_params = {
                'DEFAULT_DIRECTION': 2,
                'DEFAULT_SPEED': 5,
                'DIRECTION_FIELD': '',
                'ENTRY_COST_CALCULATION_METHOD': 0,
                'FROM_ID_FIELD': parameters['ID'],
                'FROM_POINT_LAYER':  outputs['Centroids']['OUTPUT'],
                'INPUT': parameters['Network'],
                'SPEED_FIELD': '',
                'STRATEGY': 1,
                'TOLERANCE': 0,
                'TO_ID_FIELD': 'T_ID',
                'TO_POINT_LAYER': loop_outputs['FieldCalculatorId']['OUTPUT'],
                'VALUE_BACKWARD': '',
                'VALUE_BOTH': '',
                'VALUE_FORWARD': '',
                'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }
            loop_outputs['OdMatrixFromLayersAsLinesMn'] = processing.run('qneat3:OdMatrixFromLayersAsLines', alg_params,
                                                                    context=context, feedback=multi_feedback,
                                                                    is_child_algorithm=True)

            multi_feedback.setCurrentStep(current_step)
            current_step = current_step + 1
            if multi_feedback.isCanceled():
                return {}

            # Extract by expression
            alg_params = {
                'EXPRESSION': '"total_cost" = minimum ("total_cost", "origin_id")',
                'INPUT': loop_outputs['OdMatrixFromLayersAsLinesMn']['OUTPUT'],
                'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }
            loop_outputs['ExtractByExpression'] = processing.run('native:extractbyexpression', alg_params, context=context,
                                                            feedback=multi_feedback, is_child_algorithm=True)

            multi_feedback.setCurrentStep(current_step)
            current_step = current_step + 1
            if multi_feedback.isCanceled():
                return {}

            # Delete duplicates by attribute
            alg_params = {
                'FIELDS': ['origin_id'],
                'INPUT': loop_outputs['ExtractByExpression']['OUTPUT'],
                'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }
            loop_outputs['DeleteDuplicatesByAttribute'] = processing.run('native:removeduplicatesbyattribute', alg_params,
                                                                    context=context, feedback=multi_feedback,
                                                                    is_child_algorithm=True)

            multi_feedback.setCurrentStep(current_step)
            current_step = current_step + 1
            if multi_feedback.isCanceled():
                return {}

            # Field calculator
            alg_params = {
                'FIELD_LENGTH': 10,
                'FIELD_NAME': 'length',
                'FIELD_PRECISION': 2,
                'FIELD_TYPE': 0,
                'FORMULA': '$length',
                'INPUT': loop_outputs['DeleteDuplicatesByAttribute']['OUTPUT'],
                'OUTPUT':  QgsProcessing.TEMPORARY_OUTPUT
            }

            loop_outputs['FieldCalculatorLength'] = processing.run('native:fieldcalculator', alg_params, context=context,
                                                        feedback=multi_feedback, is_child_algorithm=True)

            multi_feedback.setCurrentStep(current_step)
            current_step = current_step + 1
            if multi_feedback.isCanceled():
                return {}

            # Field calculator
            alg_params = {
                'FIELD_LENGTH': 50,
                'FIELD_NAME': 'Category',
                'FIELD_PRECISION': 0,
                'FIELD_TYPE': 2,  # String
                'FORMULA': category,
                'INPUT': loop_outputs['FieldCalculatorLength']['OUTPUT'],
                'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }
            loop_outputs['FieldCalculatorCategory'] = processing.run('native:fieldcalculator', alg_params, context=context,
                                                            feedback=multi_feedback, is_child_algorithm=True)

            to_merge.append(loop_outputs['FieldCalculatorCategory']['OUTPUT'])

            multi_feedback.setCurrentStep(current_step)
            current_step = current_step + 1
            if multi_feedback.isCanceled():
                return {}

        # Merge layers
        alg_params = {
        'LAYERS' : to_merge,
        'OUTPUT':  QgsProcessing.TEMPORARY_OUTPUT
        }

        outputs['MergeVectorLayers'] = processing.run('native:mergevectorlayers', alg_params, context = context,
                                                      feedback = multi_feedback, is_child_algorithm=True)

        multi_feedback.setCurrentStep(current_step)
        current_step = current_step + 1
        if multi_feedback.isCanceled():
            return {}

        # Aggregate target
        alg_params = {
            'AGGREGATES': [{'aggregate': 'first_value', 'delimiter': ',', 'input': '"destination_id"', 'length': 10,
                            'name': 'Target_id', 'precision': 0, 'type': 4},
                           {'aggregate': 'mean', 'delimiter': ',', 'input': '"exit_cost"', 'length': 10,
                            'name': 'ExCMean', 'precision': 2, 'type': 6},
                           {'aggregate': 'minimum', 'delimiter': ',', 'input': '"total_cost"', 'length': 10,
                            'name': 'TotCMin', 'precision': 2, 'type': 6},
                           {'aggregate': 'maximum', 'delimiter': ',', 'input': '"total_cost"', 'length': 10,
                            'name': 'TotCMax', 'precision': 2, 'type': 6},
                           {'aggregate': 'sum', 'delimiter': ',', 'input': '"total_cost"', 'length': 10,
                            'name': 'TotCSum', 'precision': 2, 'type': 6},
                           {'aggregate': 'mean', 'delimiter': ',', 'input': '"total_cost"', 'length': 10,
                            'name': 'TotCMean', 'precision': 2, 'type': 6},
                           {'aggregate': 'q3', 'delimiter': ',', 'input': '"total_cost"', 'length': 10,
                            'name': 'TotCQ3', 'precision': 2, 'type': 6},
                           {'aggregate': 'minimum', 'delimiter': ',', 'input': '"length"', 'length': 10, 'name': 'DMin',
                            'precision': 2, 'type': 6},
                           {'aggregate': 'maximum', 'delimiter': ',', 'input': '"length"', 'length': 10, 'name': 'DMax',
                            'precision': 2, 'type': 6},
                           {'aggregate': 'sum', 'delimiter': ',', 'input': '"length"', 'length': 10, 'name': 'DSum',
                            'precision': 2, 'type': 6},
                           {'aggregate': 'mean', 'delimiter': ',', 'input': '"length"', 'length': 10, 'name': 'DMean',
                            'precision': 2, 'type': 6},
                           {'aggregate': 'q3', 'delimiter': ',', 'input': '"length"', 'length': 10, 'name': 'DQ3',
                            'precision': 2, 'type': 6},
                           {'aggregate': 'first_value', 'delimiter': ',', 'input': '"Category"', 'length': 0,
                            'name': 'Category', 'precision': 0, 'type': 10}],
            'GROUP_BY': 'destination_id',
            'INPUT': outputs['MergeVectorLayers']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['AggregateTarget'] = processing.run('native:aggregate', alg_params, context=context, feedback=multi_feedback,
                                              is_child_algorithm=True)

        multi_feedback.setCurrentStep(current_step)
        current_step = current_step + 1
        if multi_feedback.isCanceled():
            return {}

        # Extract specific vertices
        alg_params = {
            'INPUT': outputs['AggregateTarget']['OUTPUT'],
            'VERTICES': '-1',
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['ExtractSpecificVertices'] = processing.run('native:extractspecificvertices', alg_params,
                                                            context=context, feedback=feedback,
                                                            is_child_algorithm=True)

        multi_feedback.setCurrentStep(current_step)
        current_step = current_step + 1
        if multi_feedback.isCanceled():
            return {}

        # Field calculator 0
        alg_params = {
            'FIELD_LENGTH': 10,
            'FIELD_NAME': 'Tmax',
            'FIELD_PRECISION': 2,
            'FIELD_TYPE': 0,  # Float
            'FORMULA': '"TotCMax"/83.33',
            'INPUT': outputs['ExtractSpecificVertices']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['TargetFieldCalculator0'] = processing.run('native:fieldcalculator', alg_params, context=context,
                                                         feedback=feedback, is_child_algorithm=True)

        multi_feedback.setCurrentStep(current_step)
        current_step = current_step + 1
        if multi_feedback.isCanceled():
            return {}

        # Field calculator 1
        alg_params = {
            'FIELD_LENGTH': 10,
            'FIELD_NAME': 'TQ3',
            'FIELD_PRECISION': 2,
            'FIELD_TYPE': 0,  # Float
            'FORMULA': '"TotCQ3"/83.33',
            'INPUT': outputs['TargetFieldCalculator0']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['TargetFieldCalculator1'] = processing.run('native:fieldcalculator', alg_params, context=context,
                                                         feedback=feedback, is_child_algorithm=True)

        multi_feedback.setCurrentStep(current_step)
        current_step = current_step + 1
        if multi_feedback.isCanceled():
            return {}

        # Field calculator 2
        alg_params = {
            'FIELD_LENGTH': 10,
            'FIELD_NAME': 'TMean',
            'FIELD_PRECISION': 2,
            'FIELD_TYPE': 0,  # Float
            'FORMULA': '"TotCMean"/83.33',
            'INPUT': outputs['TargetFieldCalculator1']['OUTPUT'],
            'OUTPUT': parameters['TargetStat']
        }
        outputs['TargetFieldCalculator2'] = processing.run('native:fieldcalculator', alg_params, context=context,
                                                         feedback=feedback, is_child_algorithm=True)

        results['TargetStat'] = outputs['TargetFieldCalculator2']['OUTPUT']
        self.t_stat_layer = outputs['TargetFieldCalculator2']['OUTPUT']

        multi_feedback.setCurrentStep(current_step)
        current_step = current_step + 1
        if multi_feedback.isCanceled():
            return {}

        # Minimum bounding geometry
        alg_params = {
            'FIELD': 'origin_id',
            'INPUT': outputs['MergeVectorLayers']['OUTPUT'],
            'TYPE': 3,
            'OUTPUT': parameters['ConvexHull']
        }
        outputs['MinimumBoundingGeometry'] = processing.run('qgis:minimumboundinggeometry', alg_params,
                                                            context=context, feedback=multi_feedback,
                                                            is_child_algorithm=True)
        results['ConvexHull'] = outputs['MinimumBoundingGeometry']['OUTPUT']
        self.geometry_layer = outputs['MinimumBoundingGeometry']['OUTPUT']

        multi_feedback.setCurrentStep(current_step)
        current_step = current_step + 1
        if multi_feedback.isCanceled():
            return {}

        # Aggregate source
        alg_params = {
            'AGGREGATES': [{'aggregate': 'first_value', 'delimiter': ',', 'input': '"origin_id"', 'length': 10,
                            'name': 'Source_id', 'precision': 0, 'type': 4},
                           {'aggregate': 'mean', 'delimiter': ',', 'input': '"entry_cost"', 'length': 10,
                            'name': 'EnCMean', 'precision': 2, 'type': 6},
                           {'aggregate': 'minimum', 'delimiter': ',', 'input': '"total_cost"', 'length': 10,
                            'name': 'TotCMin', 'precision': 2, 'type': 6},
                           {'aggregate': 'maximum', 'delimiter': ',', 'input': '"total_cost"', 'length': 10,
                            'name': 'TotCMax', 'precision': 2, 'type': 6},
                           {'aggregate': 'sum', 'delimiter': ',', 'input': '"total_cost"', 'length': 10,
                            'name': 'TotCSum', 'precision': 2, 'type': 6},
                           {'aggregate': 'mean', 'delimiter': ',', 'input': '"total_cost"', 'length': 10,
                            'name': 'TotCMean', 'precision': 2, 'type': 6},
                           {'aggregate': 'q3', 'delimiter': ',', 'input': '"total_cost"', 'length': 10,
                            'name': 'TotCQ3', 'precision': 2, 'type': 6},
                           {'aggregate': 'minimum', 'delimiter': ',', 'input': '"length"', 'length': 10, 'name': 'Dmin',
                            'precision': 2, 'type': 6},
                           {'aggregate': 'maximum', 'delimiter': ',', 'input': '"length"', 'length': 10, 'name': 'Dmax',
                            'precision': 2, 'type': 6},
                           {'aggregate': 'sum', 'delimiter': ',', 'input': '"length"', 'length': 10, 'name': 'Dsum',
                            'precision': 2, 'type': 6},
                           {'aggregate': 'mean', 'delimiter': ',', 'input': '"length"', 'length': 10, 'name': 'Dmean',
                            'precision': 2, 'type': 6},
                           {'aggregate': 'q3', 'delimiter': ',', 'input': '"length"', 'length': 10, 'name': 'DQ3',
                            'precision': 2, 'type': 6}],
            'GROUP_BY': 'origin_id',
            'INPUT': outputs['MergeVectorLayers']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['AggregateOrigin'] = processing.run('native:aggregate', alg_params, context=context, feedback=multi_feedback,
                                              is_child_algorithm=True)

        multi_feedback.setCurrentStep(current_step)
        current_step = current_step + 1
        if multi_feedback.isCanceled():
            return {}

        # Join attributes by field value
        alg_params = {
            'DISCARD_NONMATCHING': False,
            'FIELD': parameters['ID'],
            'FIELDS_TO_COPY': [''],
            'FIELD_2': 'Source_id',
            'INPUT': parameters['Sourcepoints'],
            'INPUT_2': outputs['AggregateOrigin']['OUTPUT'],
            'METHOD': 1,
            'PREFIX': '',
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['JoinAttributesByFieldValue'] = processing.run('native:joinattributestable', alg_params,
                                                               context=context, feedback=multi_feedback,
                                                               is_child_algorithm=True)

        multi_feedback.setCurrentStep(current_step)
        current_step = current_step + 1
        if multi_feedback.isCanceled():
            return {}

        # Field calculator 0
        alg_params = {
            'FIELD_LENGTH': 10,
            'FIELD_NAME': 'Tmax',
            'FIELD_PRECISION': 2,
            'FIELD_TYPE': 0,  # Float
            'FORMULA': '"TotCMax"/83.33',
            'INPUT': outputs['JoinAttributesByFieldValue']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['GridFieldCalculator0'] = processing.run('native:fieldcalculator', alg_params, context=context,
                                                             feedback=feedback, is_child_algorithm=True)

        multi_feedback.setCurrentStep(current_step)
        current_step = current_step + 1
        if multi_feedback.isCanceled():
            return {}

        # Field calculator 1
        alg_params = {
            'FIELD_LENGTH': 10,
            'FIELD_NAME': 'TQ3',
            'FIELD_PRECISION': 2,
            'FIELD_TYPE': 0,  # Float
            'FORMULA': '"TotCQ3"/83.33',
            'INPUT': outputs['GridFieldCalculator0']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['GridFieldCalculator1'] = processing.run('native:fieldcalculator', alg_params, context=context,
                                                             feedback=feedback, is_child_algorithm=True)

        multi_feedback.setCurrentStep(current_step)
        current_step = current_step + 1
        if multi_feedback.isCanceled():
            return {}

        # Field calculator 2
        alg_params = {
            'FIELD_LENGTH': 10,
            'FIELD_NAME': 'TMean',
            'FIELD_PRECISION': 2,
            'FIELD_TYPE': 0,  # Float
            'FORMULA': '"TotCMean"/83.33',
            'INPUT': outputs['GridFieldCalculator1']['OUTPUT'],
            'OUTPUT': parameters['GridOutput']
        }
        outputs['GridFieldCalculator2'] = processing.run('native:fieldcalculator', alg_params, context=context,
                                                             feedback=feedback, is_child_algorithm=True)

        results['GridOutput'] = outputs['GridFieldCalculator2']['OUTPUT']
        self.grid_layer = outputs['GridFieldCalculator2']['OUTPUT']

        multi_feedback.setCurrentStep(current_step)
        current_step = current_step + 1
        if multi_feedback.isCanceled():
            return {}

        # Aggregate category
        alg_params = {
            'AGGREGATES': [{'aggregate': 'first_value', 'delimiter': ',', 'input': '"Category"', 'length': 0,
                            'name': 'Category', 'precision': 0, 'type': 10},
                           {'aggregate': 'minimum', 'delimiter': ',', 'input': '"TotCMin"', 'length': 10,
                            'name': 'TotCMin', 'precision': 2, 'type': 6},
                           {'aggregate': 'maximum', 'delimiter': ',', 'input': '"TotCMax"', 'length': 10,
                            'name': 'TotCMax', 'precision': 2, 'type': 6},
                           {'aggregate': 'sum', 'delimiter': ',', 'input': '"TotCSum"', 'length': 10,
                            'name': 'TotCSum', 'precision': 2, 'type': 6},
                           {'aggregate': 'mean', 'delimiter': ',', 'input': '"TotCMean"', 'length': 10,
                            'name': 'TotCMean', 'precision': 2, 'type': 6},
                           {'aggregate': 'q3', 'delimiter': ',', 'input': '"TotCQ3"', 'length': 10,
                            'name': 'TotCQ3', 'precision': 2, 'type': 6},
                           {'aggregate': 'minimum', 'delimiter': ',', 'input': '"DMin"', 'length': 10,
                            'name': 'DMin', 'precision': 2, 'type': 6},
                           {'aggregate': 'maximum', 'delimiter': ',', 'input': '"DMax"', 'length': 10,
                            'name': 'DMax', 'precision': 2, 'type': 6},
                           {'aggregate': 'sum', 'delimiter': ',', 'input': '"DSum"', 'length': 10, 'name': 'DSum',
                            'precision': 2, 'type': 6},
                           {'aggregate': 'mean', 'delimiter': ',', 'input': '"DMean"', 'length': 10,
                            'name': 'DMean', 'precision': 2, 'type': 6},
                           {'aggregate': 'q3', 'delimiter': ',', 'input': '"DQ3"', 'length': 10, 'name': 'DQ3',
                            'precision': 2, 'type': 6}],
            'GROUP_BY': 'Category',
            'INPUT': outputs['AggregateTarget']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['AggregateCategory'] = processing.run('native:aggregate', alg_params, context=context, feedback=feedback,
                                              is_child_algorithm=True)

        multi_feedback.setCurrentStep(current_step)
        current_step = current_step + 1
        if multi_feedback.isCanceled():
            return {}

        # Drop geometries
        alg_params = {
            'INPUT': outputs['AggregateCategory']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['DropGeometries'] = processing.run('native:dropgeometries', alg_params, context=context,
                                                   feedback=feedback, is_child_algorithm=True)

        multi_feedback.setCurrentStep(current_step)
        current_step = current_step + 1
        if multi_feedback.isCanceled():
            return {}

        # Field calculator 0
        alg_params = {
            'FIELD_LENGTH': 10,
            'FIELD_NAME': 'Tmax',
            'FIELD_PRECISION': 2,
            'FIELD_TYPE': 0,  # Float
            'FORMULA': '"TotCMax"/83.33',
            'INPUT': outputs['DropGeometries']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['CategoryFieldCalculator0'] = processing.run('native:fieldcalculator', alg_params, context=context,
                                                     feedback=feedback, is_child_algorithm=True)

        multi_feedback.setCurrentStep(current_step)
        current_step = current_step + 1
        if multi_feedback.isCanceled():
            return {}

        # Field calculator 1
        alg_params = {
            'FIELD_LENGTH': 10,
            'FIELD_NAME': 'TQ3',
            'FIELD_PRECISION': 2,
            'FIELD_TYPE': 0,  # Float
            'FORMULA': '"TotCQ3"/83.33',
            'INPUT': outputs['CategoryFieldCalculator0']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['CategoryFieldCalculator1'] = processing.run('native:fieldcalculator', alg_params, context=context,
                                                     feedback=feedback, is_child_algorithm=True)

        multi_feedback.setCurrentStep(current_step)
        current_step = current_step + 1
        if multi_feedback.isCanceled():
            return {}

        # Field calculator 2
        alg_params = {
            'FIELD_LENGTH': 10,
            'FIELD_NAME': 'TMean',
            'FIELD_PRECISION': 2,
            'FIELD_TYPE': 0,  # Float
            'FORMULA': '"TotCMean"/83.33',
            'INPUT': outputs['CategoryFieldCalculator1']['OUTPUT'],
            'OUTPUT': parameters['CategoryStat']
        }
        outputs['CategoryFieldCalculator2'] = processing.run('native:fieldcalculator', alg_params, context=context,
                                                     feedback=feedback, is_child_algorithm=True)

        results['CategoryStat'] = outputs['CategoryFieldCalculator2']['OUTPUT']
        self.c_stat_layer = outputs['CategoryFieldCalculator2']['OUTPUT']

        # Rename output layers
        global renamer_grid
        global renamer_geometry
        global renamer_target
        global renamer_category
        renamer_grid = Renamer('Grid Output')
        context.layerToLoadOnCompletionDetails(self.grid_layer).setPostProcessor(renamer_grid)
        renamer_geometry = Renamer('Convex Hull')
        context.layerToLoadOnCompletionDetails(self.geometry_layer).setPostProcessor(renamer_geometry)
        renamer_target = Renamer('Target Stat')
        context.layerToLoadOnCompletionDetails(self.t_stat_layer).setPostProcessor(renamer_target)
        renamer_category = Renamer('Category Stat')
        context.layerToLoadOnCompletionDetails(self.c_stat_layer).setPostProcessor(renamer_category)

        return results


    def name(self):
        """
        Returns the algorithm name, used for identifying the algorithm. This
        string should be fixed for the algorithm, and must not be localised.
        The name should be unique within each provider. Names should contain
        lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'City Timer'

    def displayName(self):
        """
        Returns the translated algorithm name, which should be used for any
        user-visible display of the algorithm name.
        """
        return self.tr(self.name())

    def group(self):
        """
        Returns the name of the group this algorithm belongs to. This string
        should be localised.
        """
        return self.tr(self.groupId())

    def groupId(self):
        """
        Returns the unique ID of the group this algorithm belongs to. This
        string should be fixed for the algorithm, and must not be localised.
        The group id should be unique within each provider. Group id should
        contain lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return ''

    def tr(self, string):
        return QCoreApplication.translate('Processing', string)

    def createInstance(self):
        return CityTimerAlgorithm()


class Renamer(QgsProcessingLayerPostProcessorInterface):
    def __init__(self, layer_name):
        self.name = layer_name
        super().__init__()

    def postProcessLayer(self, layer, context, feedback):
        layer.setName(self.name)

