"""A module that contains sample geometries for tests"""

example_multisurface_with_semantics = [{
    "type": "MultiSurface",
    "boundaries": [
        [[0, 3, 2, 1]], [[4, 5, 6, 7]], [[0, 1, 5, 4]], [[0, 2, 3, 8]], [[10, 12, 23, 48]]
    ],
    "semantics": {
        "surfaces" : [
            {
                "type": "WallSurface",
                "slope": 33.4,
                "children": [2]
            }, 
            {
                "type": "RoofSurface",
                "slope": 66.6
            },
            {
                "type": "Door",
                "parent": 0,
                "colour": "blue"
            }
        ],
        "values": [0, 0, None, 1, 2]
    }
}]

example_solid_with_semantics = [
    {
        "type": "CompositeSolid",
        "lod": 2,
        "boundaries": [
            [
            [ [[0, 3, 2, 1, 22]], [[4, 5, 6, 7]], [[0, 1, 5, 4]], [[1, 2, 6, 5]] ]
            ],
            [
            [ [[666, 667, 668]], [[74, 75, 76]], [[880, 881, 885]], [[111, 122, 226]] ] 
            ]    
        ],
        "semantics": {
            "surfaces" : [
            {      
                "type": "RoofSurface",
            }, 
            {
                "type": "WallSurface",
            }
            ],
            "values": [
            [
                [0, 1, 1, None]
            ],
            [
                None
            ]
            ]
        }
    }  
]

example_composite_solid = [{
    "type": "CompositeSolid",
    "lod": 3,
    "boundaries": [
        [
        [ [[0, 3, 2, 1, 22]], [[4, 5, 6, 7]], [[0, 1, 5, 4]], [[1, 2, 6, 5]] ],
        [ [[240, 243, 124]], [[244, 246, 724]], [[34, 414, 45]], [[111, 246, 5]] ]
        ],
        [
        [ [[666, 667, 668]], [[74, 75, 76]], [[880, 881, 885]], [[111, 122, 226]] ] 
        ]    
    ]
}]

example_geometry_instance = [
    {
        "type": "GeometryInstance",
        "template": 0,
        "boundaries": [372],
        "transformationMatrix": [
        2.0, 0.0, 0.0, 0.0,
        0.0, 2.0, 0.0, 0.0,
        0.0, 0.0, 2.0, 0.0,
        0.0, 0.0, 0.0, 1.0
        ]
    }
]

example_geometry_template = {
    "templates": [
        {
        "type": "MultiSurface",
        "lod": 2,
        "boundaries": [ 
            [[0, 3, 2, 1]], [[4, 5, 6, 7]], [[0, 1, 5, 4]]
        ]
        },
        {
        "type": "MultiSurface",
        "lod": 1,
        "boundaries": [ 
            [[1, 2, 6, 5]], [[2, 3, 7, 6]], [[3, 0, 4, 7]]
        ]
        }
    ],
    "vertices-templates": [[0.112,0.121,0.502],[0.107,0.121,0.502],[0.103,0.119,0.502],[0.1,0.116,0.502],[0.099,0.112,0.502],[0.099,0.107,0.502],[0.101,0.103,0.502],[0.104,0.1,0.502],[0.108,0.099,0.502],[0.112,0.099,0.502],[0.116,0.101,0.502],[0.119,0.104,0.502],[0.121,0.108,0.502],[0.121,0.112,0.502],[0.119,0.116,0.502],[0.116,0.119,0.502],[0.016,0.17,0.13],[0.0,0.13,0.13],[0.001,0.086,0.13],[0.018,0.046,0.13],[0.049,0.016,0.13],[0.089,0.0,0.13],[0.133,0.001,0.13],[0.173,0.018,0.13],[0.203,0.049,0.13],[0.219,0.089,0.13],[0.219,0.133,0.13],[0.202,0.173,0.13],[0.17,0.203,0.13],[0.13,0.219,0.13],[0.086,0.219,0.13],[0.046,0.202,0.13],[0.112,0.124,0.186],[0.107,0.124,0.186],[0.101,0.122,0.186],[0.097,0.118,0.186],[0.095,0.112,0.186],[0.095,0.107,0.186],[0.097,0.101,0.186],[0.102,0.097,0.186],[0.107,0.095,0.186],[0.113,0.095,0.186],[0.118,0.097,0.186],[0.122,0.102,0.186],[0.124,0.107,0.186],[0.124,0.113,0.186],[0.122,0.118,0.186],[0.118,0.122,0.186],[0.091,0.122,0.0],[0.088,0.114,0.0],[0.088,0.105,0.0],[0.091,0.097,0.0],[0.098,0.091,0.0],[0.106,0.088,0.0],[0.114,0.088,0.0],[0.122,0.091,0.0],[0.128,0.098,0.0],[0.132,0.106,0.0],[0.132,0.114,0.0],[0.128,0.122,0.0],[0.122,0.128,0.0],[0.114,0.132,0.0],[0.105,0.132,0.0],[0.097,0.128,0.0],[0.115,0.127,0.188],[0.109,0.127,0.188],[0.104,0.125,0.188],[0.1,0.121,0.188],[0.098,0.115,0.188],[0.098,0.109,0.188],[0.1,0.104,0.188],[0.104,0.1,0.188],[0.11,0.098,0.188],[0.116,0.098,0.188],[0.121,0.1,0.188],[0.125,0.104,0.188],[0.127,0.11,0.188],[0.127,0.116,0.188],[0.125,0.121,0.188],[0.121,0.125,0.188],[0.094,0.125,0.0],[0.09,0.117,0.0],[0.09,0.108,0.0],[0.094,0.1,0.0],[0.1,0.094,0.0],[0.108,0.09,0.0],[0.117,0.09,0.0],[0.125,0.094,0.0],[0.131,0.1,0.0],[0.135,0.108,0.0],[0.135,0.117,0.0],[0.131,0.125,0.0],[0.125,0.131,0.0],[0.117,0.135,0.0],[0.108,0.135,0.0],[0.1,0.131,0.0],[0.004,0.144,0.301],[0.006,0.143,0.33],[0.008,0.151,0.327],[0.01,0.158,0.321],[0.012,0.162,0.312],[0.012,0.164,0.301],[0.012,0.162,0.29],[0.01,0.158,0.281],[0.008,0.151,0.274],[0.006,0.143,0.272],[0.004,0.135,0.274],[0.002,0.128,0.281],[0.0,0.123,0.29],[0.0,0.122,0.301],[0.0,0.123,0.312],[0.002,0.128,0.321],[0.004,0.135,0.327],[0.012,0.141,0.357],[0.017,0.157,0.353],[0.021,0.171,0.341],[0.023,0.18,0.322],[0.024,0.183,0.301],[0.023,0.18,0.279],[0.021,0.171,0.261],[0.017,0.157,0.249],[0.012,0.141,0.245],[0.008,0.125,0.249],[0.004,0.112,0.261],[0.001,0.103,0.279],[0.0,0.1,0.301],[0.001,0.103,0.322],[0.004,0.112,0.341],[0.008,0.125,0.353],[0.022,0.138,0.382],[0.029,0.161,0.376],[0.034,0.181,0.359],[0.038,0.194,0.332],[0.04,0.199,0.301],[0.038,0.194,0.27],[0.034,0.181,0.243],[0.029,0.161,0.226],[0.022,0.138,0.219],[0.016,0.115,0.226],[0.01,0.096,0.243],[0.006,0.083,0.27],[0.005,0.078,0.301],[0.006,0.083,0.332],[0.01,0.096,0.359],[0.016,0.115,0.376],[0.036,0.134,0.405],[0.044,0.164,0.397],[0.051,0.189,0.374],[0.056,0.205,0.341],[0.058,0.211,0.301],[0.056,0.205,0.261],[0.051,0.189,0.228],[0.044,0.164,0.205],[0.036,0.134,0.197],[0.027,0.105,0.205],[0.02,0.08,0.228],[0.015,0.064,0.261],[0.014,0.058,0.301],[0.015,0.064,0.341],[0.02,0.08,0.374],[0.027,0.105,0.397],[0.052,0.13,0.423],[0.062,0.164,0.414],[0.07,0.194,0.387],[0.076,0.213,0.348],[0.078,0.22,0.301],[0.076,0.213,0.254],[0.07,0.194,0.215],[0.062,0.164,0.188],[0.052,0.13,0.179],[0.042,0.095,0.188],[0.034,0.066,0.215],[0.028,0.046,0.254],[0.026,0.04,0.301],[0.028,0.046,0.348],[0.034,0.066,0.387],[0.042,0.095,0.414],[0.071,0.124,0.436],[0.082,0.163,0.426],[0.091,0.195,0.397],[0.097,0.217,0.353],[0.1,0.225,0.301],[0.097,0.217,0.249],[0.091,0.195,0.205],[0.082,0.163,0.176],[0.071,0.124,0.165],[0.06,0.086,0.176],[0.051,0.053,0.205],[0.044,0.032,0.249],[0.042,0.024,0.301],[0.044,0.032,0.353],[0.051,0.053,0.397],[0.06,0.086,0.426],[0.091,0.119,0.445],[0.103,0.159,0.434],[0.113,0.194,0.403],[0.119,0.217,0.356],[0.122,0.225,0.301],[0.119,0.217,0.246],[0.113,0.194,0.199],[0.103,0.159,0.168],[0.091,0.119,0.157],[0.08,0.078,0.168],[0.07,0.043,0.199],[0.063,0.02,0.246],[0.061,0.012,0.301],[0.063,0.02,0.356],[0.07,0.043,0.403],[0.08,0.078,0.434],[0.112,0.112,0.448],[0.124,0.154,0.436],[0.134,0.189,0.405],[0.141,0.213,0.357],[0.144,0.221,0.301],[0.141,0.213,0.245],[0.134,0.189,0.197],[0.124,0.154,0.165],[0.112,0.112,0.154],[0.101,0.071,0.165],[0.091,0.036,0.197],[0.084,0.012,0.245],[0.081,0.004,0.301],[0.084,0.012,0.357],[0.091,0.036,0.405],[0.101,0.071,0.436],[0.134,0.106,0.445],[0.145,0.147,0.434],[0.155,0.182,0.403],[0.162,0.205,0.356],[0.164,0.213,0.301],[0.162,0.205,0.246],[0.155,0.182,0.199],[0.145,0.147,0.168],[0.134,0.106,0.157],[0.122,0.066,0.168],[0.112,0.031,0.199],[0.106,0.008,0.246],[0.103,0.0,0.301],[0.106,0.008,0.356],[0.112,0.031,0.403],[0.122,0.066,0.434],[0.154,0.101,0.436],[0.165,0.139,0.426],[0.174,0.171,0.397],[0.18,0.193,0.353],[0.183,0.201,0.301],[0.18,0.193,0.249],[0.174,0.171,0.205],[0.165,0.139,0.176],[0.154,0.101,0.165],[0.143,0.062,0.176],[0.134,0.03,0.205],[0.127,0.008,0.249],[0.125,0.0,0.301],[0.127,0.008,0.353],[0.134,0.03,0.397],[0.143,0.062,0.426],[0.173,0.095,0.423],[0.183,0.13,0.414],[0.191,0.159,0.387],[0.197,0.179,0.348],[0.199,0.185,0.301],[0.197,0.179,0.254],[0.191,0.159,0.215],[0.183,0.13,0.188],[0.173,0.095,0.179],[0.163,0.061,0.188],[0.154,0.031,0.215],[0.149,0.012,0.254],[0.147,0.005,0.301],[0.149,0.012,0.348],[0.154,0.031,0.387],[0.163,0.061,0.414],[0.189,0.091,0.405],[0.198,0.12,0.397],[0.205,0.145,0.374],[0.209,0.161,0.341],[0.211,0.167,0.301],[0.209,0.161,0.261],[0.205,0.145,0.228],[0.198,0.12,0.205],[0.189,0.091,0.197],[0.181,0.061,0.205],[0.174,0.036,0.228],[0.169,0.02,0.261],[0.167,0.014,0.301],[0.169,0.02,0.341],[0.174,0.036,0.374],[0.181,0.061,0.397],[0.203,0.087,0.382],[0.209,0.11,0.376],[0.215,0.129,0.359],[0.219,0.142,0.332],[0.22,0.147,0.301],[0.219,0.142,0.27],[0.215,0.129,0.243],[0.209,0.11,0.226],[0.203,0.087,0.219],[0.196,0.064,0.226],[0.19,0.044,0.243],[0.187,0.031,0.27],[0.185,0.026,0.301],[0.187,0.031,0.332],[0.19,0.044,0.359],[0.196,0.064,0.376],[0.213,0.084,0.357],[0.217,0.1,0.353],[0.221,0.113,0.341],[0.224,0.122,0.322],[0.225,0.125,0.301],[0.224,0.122,0.279],[0.221,0.113,0.261],[0.217,0.1,0.249],[0.213,0.084,0.245],[0.208,0.068,0.249],[0.204,0.054,0.261],[0.202,0.045,0.279],[0.201,0.042,0.301],[0.202,0.045,0.322],[0.204,0.054,0.341],[0.208,0.068,0.353],[0.219,0.082,0.33],[0.221,0.09,0.327],[0.223,0.097,0.321],[0.224,0.102,0.312],[0.225,0.103,0.301],[0.224,0.102,0.29],[0.223,0.097,0.281],[0.221,0.09,0.274],[0.219,0.082,0.272],[0.217,0.074,0.274],[0.215,0.067,0.281],[0.213,0.062,0.29],[0.213,0.061,0.301],[0.213,0.062,0.312],[0.215,0.067,0.321],[0.217,0.074,0.327],[0.221,0.081,0.301]]
}
