/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import org.geotools.data.DataUtilities;
import org.geotools.styling.ResourceLocator;
import org.geotools.util.logging.Logging;

public class DefaultResourceLocator
implements ResourceLocator {
    URL sourceUrl;
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.styling");

    public void setSourceUrl(URL sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    @Override
    public URL locateResource(String uri) {
        URL url;
        block4: {
            url = null;
            try {
                URL validated;
                URL relativeUrl;
                url = new URL(uri);
                File f = DataUtilities.urlToFile(url);
                if (f != null && !f.isAbsolute() && !f.exists() && this.sourceUrl != null && (relativeUrl = this.makeRelativeURL(f.getPath())) != null && (validated = this.validateRelativeURL(relativeUrl)) != null) {
                    url = validated;
                }
            }
            catch (MalformedURLException mfe) {
                LOGGER.fine("Looks like " + uri + " is a relative path..");
                if (this.sourceUrl != null) {
                    url = this.makeRelativeURL(uri);
                }
                if (url != null || (url = this.getClass().getResource(uri)) != null) break block4;
                LOGGER.warning("can't parse " + uri + " as a java resource present in the classpath");
            }
        }
        return url;
    }

    protected URL validateRelativeURL(URL relativeUrl) {
        File f = DataUtilities.urlToFile(relativeUrl);
        if (f.exists()) {
            return relativeUrl;
        }
        return null;
    }

    URL makeRelativeURL(String uri) {
        try {
            return new URL(this.sourceUrl, uri);
        }
        catch (MalformedURLException e) {
            LOGGER.warning("can't parse " + uri + " as relative to" + this.sourceUrl.toExternalForm());
            return null;
        }
    }
}

