/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.arcgrid;

import it.geosolutions.imageio.plugins.arcgrid.AsciiGridsImageMetadataFormat;
import it.geosolutions.imageio.plugins.arcgrid.raster.AsciiGridRaster;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataFormat;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;

public final class AsciiGridsImageMetadata
extends IIOMetadata {
    public static final String nativeMetadataFormatName = "it.geosolutions.imageio.plugins.arcgrid.AsciiGridsImageMetadata_1.0";
    public static final String[] metadataFormatNames = new String[]{"it.geosolutions.imageio.plugins.arcgrid.AsciiGridsImageMetadata_1.0"};
    private double noData = Double.NaN;
    private double cellSizeX;
    private double cellSizeY;
    private int nCols;
    private int nRows;
    private double lowerLeftX = 0.0;
    private double lowerLeftY = 0.0;
    private RasterSpaceType rasterSpaceType = null;
    private AsciiGridRaster.AsciiGridRasterType rasterFileType;

    public AsciiGridsImageMetadata(AsciiGridRaster raster) {
        this();
        this.inizializeFromRaster(raster);
    }

    public AsciiGridsImageMetadata() {
        super(false, nativeMetadataFormatName, "it.geosolutions.imageio.plugins.arcgrid.AsciiGridsImageMetadataFormat", null, null);
    }

    public AsciiGridsImageMetadata(int cols, int rows, double cellsizeX, double cellsizeY, double xll, double yll, boolean isCorner, boolean grass, double inNoData) {
        this();
        this.rasterFileType = grass ? AsciiGridRaster.AsciiGridRasterType.GRASS : AsciiGridRaster.AsciiGridRasterType.ESRI;
        this.nCols = cols;
        this.nRows = rows;
        this.lowerLeftX = xll;
        this.lowerLeftY = yll;
        this.rasterSpaceType = isCorner ? RasterSpaceType.PixelIsArea : RasterSpaceType.PixelIsPoint;
        this.cellSizeX = cellsizeX;
        this.cellSizeY = cellsizeY;
        this.noData = inNoData;
    }

    public Node getAsTree(String formatName) {
        if (formatName.equals(nativeMetadataFormatName)) {
            return this.getNativeTree();
        }
        if (formatName.equals("javax_imageio_1.0")) {
            return this.getStandardTree();
        }
        throw new IllegalArgumentException("Not a recognized format!");
    }

    public boolean isReadOnly() {
        return false;
    }

    public void mergeTree(String formatName, Node root) throws IIOInvalidTreeException {
    }

    public void reset() {
        this.lowerLeftY = -1.0;
        this.lowerLeftX = -1.0;
        this.cellSizeY = -1.0;
        this.cellSizeX = -1.0;
        this.nRows = -1;
        this.nCols = -1;
        this.rasterSpaceType = RasterSpaceType.Undefined;
    }

    public IIOMetadataFormat getMetadataFormat(String formatName) {
        if (formatName.equals(nativeMetadataFormatName)) {
            return new AsciiGridsImageMetadataFormat();
        }
        throw new IllegalArgumentException("Not a recognized format!");
    }

    private void inizializeFromRaster(AsciiGridRaster inputRaster) {
        if (inputRaster == null) {
            throw new NullPointerException("Null inputRaster provided.");
        }
        this.nRows = inputRaster.getNRows();
        this.nCols = inputRaster.getNCols();
        this.noData = inputRaster.getNoData();
        this.cellSizeX = inputRaster.getCellSizeX();
        this.cellSizeY = inputRaster.getCellSizeY();
        this.rasterSpaceType = inputRaster.isCorner() ? RasterSpaceType.PixelIsArea : RasterSpaceType.PixelIsPoint;
        this.lowerLeftX = inputRaster.getXllCellCoordinate();
        this.lowerLeftY = inputRaster.getYllCellCoordinate();
        this.rasterFileType = inputRaster.getRasterType();
    }

    protected IIOMetadataNode getStandardChromaNode() {
        IIOMetadataNode node = new IIOMetadataNode("Chroma");
        IIOMetadataNode subNode = new IIOMetadataNode("ColorSpaceType");
        String colorSpaceType = "GRAY";
        subNode.setAttribute("name", colorSpaceType);
        node.appendChild(subNode);
        subNode = new IIOMetadataNode("NumChannels");
        String numChannels = "1";
        subNode.setAttribute("value", numChannels);
        node.appendChild(subNode);
        return node;
    }

    protected IIOMetadataNode getStandardCompressionNode() {
        IIOMetadataNode node = new IIOMetadataNode("Compression");
        IIOMetadataNode subNode = new IIOMetadataNode("Lossless");
        subNode.setAttribute("value", "TRUE");
        node.appendChild(subNode);
        return node;
    }

    private Node getNativeTree() {
        IIOMetadataNode root = new IIOMetadataNode(nativeMetadataFormatName);
        IIOMetadataNode node = new IIOMetadataNode("formatDescriptor");
        node.setAttribute("GRASS", Boolean.toString(this.rasterFileType.equals((Object)AsciiGridRaster.AsciiGridRasterType.GRASS)));
        root.appendChild(node);
        node = new IIOMetadataNode("gridDescriptor");
        node.setAttribute("nColumns", Integer.toString(this.nCols));
        node.setAttribute("nRows", Integer.toString(this.nRows));
        node.setAttribute("rasterSpaceType", this.rasterSpaceType.toString());
        node.setAttribute("noDataValue", Double.toString(this.noData));
        root.appendChild(node);
        node = new IIOMetadataNode("envelopeDescriptor");
        node.setAttribute("cellsizeX", Double.toString(this.cellSizeX));
        node.setAttribute("cellsizeY", Double.toString(this.cellSizeY));
        node.setAttribute("xll", Double.toString(this.lowerLeftX));
        node.setAttribute("yll", Double.toString(this.lowerLeftY));
        root.appendChild(node);
        return root;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RasterSpaceType {
        PixelIsPoint,
        PixelIsArea,
        Undefined;


        public RasterSpaceType getDefault() {
            return PixelIsArea;
        }
    }
}

