/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.IJ;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.TextRoi;
import ij.plugin.PlugIn;
import ij.plugin.frame.PlugInFrame;
import java.awt.Choice;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;

public class Fonts
extends PlugInFrame
implements PlugIn,
ItemListener {
    private static String[] sizes = new String[]{"8", "9", "10", "12", "14", "18", "24", "28", "36", "48", "60", "72"};
    private static int[] isizes = new int[]{8, 9, 10, 12, 14, 18, 24, 28, 36, 48, 60, 72};
    private Panel panel;
    private Choice font;
    private Choice size;
    private Choice style;
    private static Frame instance;

    public Fonts() {
        super("Fonts");
        if (instance != null) {
            instance.toFront();
            return;
        }
        WindowManager.addWindow(this);
        instance = this;
        this.setLayout(new FlowLayout(1, 10, 5));
        this.font = new Choice();
        if (IJ.isJava2()) {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            String[] fonts = ge.getAvailableFontFamilyNames();
            this.font.add("SansSerif");
            this.font.add("Serif");
            this.font.add("Monospaced");
            int i = 0;
            while (i < fonts.length) {
                String f = fonts[i];
                if (!(f.equals("SansSerif") || f.equals("Serif") || f.equals("Monospaced"))) {
                    this.font.add(f);
                }
                ++i;
            }
        } else {
            String[] fonts = Toolkit.getDefaultToolkit().getFontList();
            int i = 0;
            while (i < fonts.length) {
                this.font.add(fonts[i]);
                ++i;
            }
        }
        this.font.select(TextRoi.getFont());
        this.font.addItemListener(this);
        this.add(this.font);
        this.size = new Choice();
        int i = 0;
        while (i < sizes.length) {
            this.size.add(sizes[i]);
            ++i;
        }
        this.size.select(this.getSizeIndex());
        this.size.addItemListener(this);
        this.add(this.size);
        this.style = new Choice();
        this.style.add("Plain");
        this.style.add("Bold");
        this.style.add("Italic");
        this.style.add("Bold+Italic");
        i = TextRoi.getStyle();
        String s = "Plain";
        if (i == 1) {
            s = "Bold";
        } else if (i == 2) {
            s = "Italic";
        } else if (i == 3) {
            s = "Bold+Italic";
        }
        this.style.select(s);
        this.style.addItemListener(this);
        this.add(this.style);
        this.pack();
        GUI.center(this);
        this.show();
        IJ.register(Fonts.class);
    }

    int getSizeIndex() {
        int size = TextRoi.getSize();
        int index = 0;
        int i = 0;
        while (i < isizes.length) {
            if (size >= isizes[i]) {
                index = i;
            }
            ++i;
        }
        return index;
    }

    public void itemStateChanged(ItemEvent e) {
        String fontName = this.font.getSelectedItem();
        int fontSize = Integer.parseInt(this.size.getSelectedItem());
        String styleName = this.style.getSelectedItem();
        int fontStyle = 0;
        if (styleName.equals("Bold")) {
            fontStyle = 1;
        } else if (styleName.equals("Italic")) {
            fontStyle = 2;
        } else if (styleName.equals("Bold+Italic")) {
            fontStyle = 3;
        }
        TextRoi.setFont(fontName, fontSize, fontStyle);
        IJ.showStatus(String.valueOf(fontSize) + " point " + fontName + " " + styleName);
    }

    public void windowClosing(WindowEvent e) {
        super.windowClosing(e);
        instance = null;
    }
}

