/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Line;
import ij.gui.ProfilePlot;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.measure.Calibration;
import ij.plugin.Plots;
import ij.plugin.PlotsCanvas;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ImageConverter;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.IndexColorModel;
import java.util.Properties;

public class GelAnalyzer
implements PlugIn {
    static final String GEL = "gel.options";
    static final int OD = 1;
    static final int PERCENT = 2;
    static final int OUTLINE = 4;
    static final int INVERT = 8;
    static int saveID;
    static int nLanes;
    static Rectangle firstRect;
    static final int MAX_LANES = 100;
    static int[] x;
    static PlotsCanvas plotsCanvas;
    static ImageProcessor ipLanes;
    static ImagePlus lanes;
    static ImagePlus gel;
    static int plotHeight;
    static int options;
    static boolean uncalibratedOD;
    static boolean labelWithPercentages;
    static boolean outlineLanes;
    static boolean invertPeaks;
    boolean invertedLut;
    ImagePlus imp;
    Font f;
    double odMin = Double.MAX_VALUE;
    double odMax = -1.7976931348623157E308;
    static boolean isVertical;

    static {
        nLanes = 0;
        x = new int[101];
        options = Prefs.getInt(GEL, 2);
        uncalibratedOD = (options & 1) != 0;
        labelWithPercentages = (options & 2) != 0;
        outlineLanes = (options & 4) != 0;
        invertPeaks = (options & 8) != 0;
    }

    public void run(String arg) {
        Roi roi;
        if (arg.equals("options")) {
            this.showDialog();
            return;
        }
        this.imp = WindowManager.getCurrentImage();
        if (this.imp == null) {
            IJ.noImage();
            return;
        }
        if (arg.equals("reset")) {
            nLanes = 0;
            saveID = 0;
            if (plotsCanvas != null) {
                plotsCanvas.reset();
            }
            ipLanes = null;
            return;
        }
        if (arg.equals("percent") && plotsCanvas != null) {
            plotsCanvas.displayPercentages();
            return;
        }
        if (arg.equals("label") && plotsCanvas != null) {
            if (GelAnalyzer.plotsCanvas.counter == 0) {
                this.show("There are no peak area measurements.");
            } else {
                plotsCanvas.labelPeaks();
            }
            return;
        }
        if (this.imp.getID() != saveID) {
            nLanes = 0;
            ipLanes = null;
            saveID = 0;
        }
        if ((roi = this.imp.getRoi()) == null || roi.getType() != 0) {
            this.show("Rectangular selection required.");
            return;
        }
        Rectangle rect = roi.getBounds();
        if (nLanes == 0) {
            this.invertedLut = this.imp.isInvertedLut();
            IJ.register(GelAnalyzer.class);
        }
        if (arg.equals("first")) {
            this.selectFirstLane(rect);
            return;
        }
        if (nLanes == 0) {
            this.show("You must first use the \"Outline First Lane\" command.");
            return;
        }
        if (arg.equals("next")) {
            this.selectNextLane(rect);
            return;
        }
        if (arg.equals("plot")) {
            if (isVertical && rect.x != x[nLanes] || !isVertical && rect.y != x[nLanes]) {
                this.selectNextLane(rect);
            }
            if (lanes != null) {
                lanes.killRoi();
            }
            this.plotLanes(gel);
            return;
        }
    }

    void showDialog() {
        GenericDialog gd = new GenericDialog("Gel Analyzer");
        gd.addCheckbox("Uncalibrated OD", uncalibratedOD);
        gd.addCheckbox("Label with Percentages", labelWithPercentages);
        gd.addCheckbox("Outline Lanes", outlineLanes);
        gd.addCheckbox("Invert Peaks", invertPeaks);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        uncalibratedOD = gd.getNextBoolean();
        labelWithPercentages = gd.getNextBoolean();
        outlineLanes = gd.getNextBoolean();
        invertPeaks = gd.getNextBoolean();
        options = 0;
        if (uncalibratedOD) {
            options |= 1;
        }
        if (labelWithPercentages) {
            options |= 2;
        }
        if (outlineLanes) {
            options |= 4;
        }
        if (invertPeaks) {
            options |= 8;
        }
    }

    void selectFirstLane(Rectangle rect) {
        isVertical = rect.width / rect.height < 2 && !IJ.altKeyDown();
        IJ.showStatus("Lane 1 selected (" + (isVertical ? "vertical" : "horizontal") + " lanes)");
        firstRect = rect;
        nLanes = 1;
        GelAnalyzer.x[1] = isVertical ? rect.x : rect.y;
        if (outlineLanes) {
            this.outlineLane(x[1]);
        } else {
            gel = this.imp;
            saveID = this.imp.getID();
        }
    }

    void selectNextLane(Rectangle rect) {
        if (rect.width != GelAnalyzer.firstRect.width || rect.height != GelAnalyzer.firstRect.height) {
            this.show("Selections must all be the same size.");
            return;
        }
        if (nLanes < 100) {
            ++nLanes;
        }
        IJ.showStatus("Lane " + nLanes + " selected");
        GelAnalyzer.x[GelAnalyzer.nLanes] = isVertical ? rect.x : rect.y;
        if (outlineLanes) {
            this.outlineLane(x[nLanes]);
        } else if (isVertical && rect.y != GelAnalyzer.firstRect.y) {
            rect.y = GelAnalyzer.firstRect.y;
            gel.setRoi(rect);
        } else if (!isVertical && rect.x != GelAnalyzer.firstRect.x) {
            rect.x = GelAnalyzer.firstRect.x;
            gel.setRoi(rect);
        }
    }

    void outlineLane(int x) {
        if (!outlineLanes) {
            return;
        }
        int lineWidth = (int)(1.0 / this.imp.getCanvas().getMagnification());
        if (lineWidth < 1) {
            lineWidth = 1;
        }
        if (nLanes == 1) {
            this.f = new Font("Helvetica", 0, 12 * lineWidth);
            ImageProcessor ip = this.imp.getProcessor();
            gel = this.imp;
            ipLanes = ip.duplicate();
            if (!(ipLanes instanceof ByteProcessor)) {
                ipLanes = ipLanes.convertToByte(true);
            }
            ipLanes.setFont(this.f);
            ipLanes.setLineWidth(lineWidth);
            this.setCustomLut(ipLanes);
            lanes = new ImagePlus("Lanes of " + this.imp.getShortTitle(), ipLanes);
            GelAnalyzer.lanes.changes = true;
            lanes.show();
            lanes.setRoi(this.imp.getRoi());
            this.imp.killRoi();
            saveID = lanes.getID();
        }
        if (ipLanes == null) {
            return;
        }
        if (isVertical) {
            ipLanes.drawRect(x, GelAnalyzer.firstRect.y, GelAnalyzer.firstRect.width, GelAnalyzer.firstRect.height);
        } else {
            ipLanes.drawRect(GelAnalyzer.firstRect.x, x, GelAnalyzer.firstRect.width, GelAnalyzer.firstRect.height);
        }
        String s = "" + nLanes;
        if (isVertical) {
            int yloc = GelAnalyzer.firstRect.y;
            if (yloc < lineWidth * 12) {
                yloc += lineWidth * 14;
            }
            ipLanes.drawString(s, x + GelAnalyzer.firstRect.width / 2 - ipLanes.getStringWidth(s) / 2, yloc);
        } else {
            int xloc = GelAnalyzer.firstRect.x - ipLanes.getStringWidth(s) - 2;
            if (xloc < lineWidth * 10) {
                xloc = GelAnalyzer.firstRect.x + 2;
            }
            ipLanes.drawString(s, xloc, x + GelAnalyzer.firstRect.height / 2 + 6);
        }
        lanes.updateAndDraw();
    }

    void plotLanes(ImagePlus imp) {
        int plotWidth;
        int topMargin = 16;
        int bottomMargin = 2;
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        double[][] profiles = new double[101][];
        IJ.showStatus("Plotting " + nLanes + " lanes");
        ImageProcessor ipRotated = imp.getProcessor();
        if (isVertical) {
            ipRotated = ipRotated.rotateLeft();
        }
        ImagePlus imp2 = new ImagePlus("", ipRotated);
        imp2.setCalibration(imp.getCalibration());
        if (uncalibratedOD && (imp2.getType() == 1 || imp2.getType() == 2)) {
            new ImageConverter(imp2).convertToGray8();
        }
        if (invertPeaks) {
            ImageProcessor ip2 = imp2.getProcessor().duplicate();
            ip2.invert();
            imp2.setProcessor(null, ip2);
        }
        int i = 1;
        while (i <= nLanes) {
            if (isVertical) {
                imp2.setRoi(GelAnalyzer.firstRect.y, ipRotated.getHeight() - x[i] - GelAnalyzer.firstRect.width, GelAnalyzer.firstRect.height, GelAnalyzer.firstRect.width);
            } else {
                imp2.setRoi(GelAnalyzer.firstRect.x, x[i], GelAnalyzer.firstRect.width, GelAnalyzer.firstRect.height);
            }
            ProfilePlot pp = new ProfilePlot(imp2);
            profiles[i] = pp.getProfile();
            if (pp.getMin() < min) {
                min = pp.getMin();
            }
            if (pp.getMax() > max) {
                max = pp.getMax();
            }
            if (uncalibratedOD) {
                profiles[i] = this.od(profiles[i]);
            }
            ++i;
        }
        if (uncalibratedOD) {
            min = this.odMin;
            max = this.odMax;
        }
        if ((plotWidth = isVertical ? GelAnalyzer.firstRect.height : GelAnalyzer.firstRect.width) < 500) {
            plotWidth = 500;
        }
        if (isVertical) {
            if (plotWidth > 2 * GelAnalyzer.firstRect.height) {
                plotWidth = 2 * GelAnalyzer.firstRect.height;
            }
        } else if (plotWidth > 2 * GelAnalyzer.firstRect.width) {
            plotWidth = 2 * GelAnalyzer.firstRect.width;
        }
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        if (plotWidth > screen.width - 40) {
            plotWidth = screen.width - 40;
        }
        if ((plotHeight = plotWidth / 2) < 200) {
            plotHeight = 200;
        }
        if (plotHeight > 400) {
            plotHeight = 400;
        }
        ByteProcessor ip = new ByteProcessor(plotWidth, topMargin + nLanes * plotHeight + bottomMargin);
        ((ImageProcessor)ip).setColor(Color.white);
        ip.fill();
        ((ImageProcessor)ip).setColor(Color.black);
        int h = ip.getHeight();
        ip.moveTo(0, 0);
        ip.lineTo(plotWidth - 1, 0);
        ip.lineTo(plotWidth - 1, h - 1);
        ip.lineTo(0, h - 1);
        ip.lineTo(0, 0);
        ip.moveTo(0, h - 2);
        ip.lineTo(plotWidth - 1, h - 2);
        String s = String.valueOf(imp.getTitle()) + "; ";
        Calibration cal = imp.getCalibration();
        s = cal.calibrated() ? String.valueOf(s) + cal.getValueUnit() : (uncalibratedOD ? String.valueOf(s) + "Uncalibrated OD" : String.valueOf(s) + "Uncalibrated");
        ip.moveTo(5, topMargin);
        ip.drawString(s);
        double xScale = (double)plotWidth / (double)profiles[1].length;
        double yScale = max - min == 0.0 ? 1.0 : (double)plotHeight / (max - min);
        int i2 = 1;
        while (i2 <= nLanes) {
            double[] profile = profiles[i2];
            int top = (i2 - 1) * plotHeight + topMargin;
            int base = top + plotHeight;
            ip.moveTo(0, base);
            ip.lineTo((int)((double)profile.length * xScale), base);
            ip.moveTo(0, base - (int)((profile[0] - min) * yScale));
            int j = 1;
            while (j < profile.length) {
                ip.lineTo((int)((double)j * xScale + 0.5), base - (int)((profile[j] - min) * yScale + 0.5));
                ++j;
            }
            ++i2;
        }
        Line.setWidth(1);
        Plots plots = new Plots();
        plots.setProcessor("Plots of " + imp.getShortTitle(), ip);
        plots.changes = true;
        ip.setThreshold(0.0, 0.0, 2);
        if (cal.calibrated()) {
            double pixelsAveraged = isVertical ? GelAnalyzer.firstRect.width : GelAnalyzer.firstRect.height;
            double scale = Math.sqrt(xScale * yScale / pixelsAveraged);
            Calibration plotsCal = plots.getCalibration();
            plotsCal.setUnit("unit");
            plotsCal.pixelWidth = 1.0 / scale;
            plotsCal.pixelHeight = 1.0 / scale;
        }
        ((ImagePlus)plots).show();
        nLanes = 0;
        saveID = 0;
        lanes = null;
        gel = null;
        ipLanes = null;
        Toolbar toolbar = Toolbar.getInstance();
        toolbar.setColor(Color.black);
        toolbar.setTool(4);
        ImageWindow win = WindowManager.getCurrentWindow();
        ImageCanvas canvas = win.getCanvas();
        plotsCanvas = canvas instanceof PlotsCanvas ? (PlotsCanvas)canvas : null;
    }

    double[] od(double[] profile) {
        int i = 0;
        while (i < profile.length) {
            double v = 0.434294481 * Math.log(255.0 / (255.0 - profile[i]));
            if (v < this.odMin) {
                this.odMin = v;
            }
            if (v > this.odMax) {
                this.odMax = v;
            }
            profile[i] = v;
            ++i;
        }
        return profile;
    }

    void setCustomLut(ImageProcessor ip) {
        IndexColorModel cm = (IndexColorModel)ip.getColorModel();
        byte[] reds = new byte[256];
        byte[] greens = new byte[256];
        byte[] blues = new byte[256];
        cm.getReds(reds);
        cm.getGreens(greens);
        cm.getBlues(blues);
        reds[1] = -1;
        greens[1] = 0;
        blues[1] = 0;
        ip.setColorModel(new IndexColorModel(8, 256, reds, greens, blues));
        byte[] pixels = (byte[])ip.getPixels();
        int i = 0;
        while (i < pixels.length) {
            if ((pixels[i] & 0xFF) == 1) {
                pixels[i] = 0;
            }
            ++i;
        }
        ip.setColor(1);
    }

    void show(String msg) {
        IJ.showMessage("Gel Analyzer", msg);
    }

    public static void savePreferences(Properties prefs) {
        prefs.put(GEL, Integer.toString(options));
    }
}

