/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.io.OpenDialog;
import ij.measure.Calibration;
import ij.plugin.DicomDecoder;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.io.IOException;

public class DICOM
extends ImagePlus
implements PlugIn {
    private boolean showErrors = true;

    public void run(String arg) {
        FileInfo fi;
        DicomDecoder dd;
        String fileName;
        block17: {
            OpenDialog od = new OpenDialog("Open Dicom...", arg);
            String directory = od.getDirectory();
            fileName = od.getFileName();
            if (fileName == null) {
                return;
            }
            dd = new DicomDecoder(directory, fileName);
            fi = null;
            try {
                fi = dd.getFileInfo();
            }
            catch (IOException e) {
                String msg = e.getMessage();
                IJ.showStatus("");
                if (msg.indexOf("EOF") < 0 && this.showErrors) {
                    IJ.error("DicomDecoder", msg);
                    return;
                }
                if (dd.dicmFound() || !this.showErrors) break block17;
                msg = "This does not appear to be a valid\nDICOM file. It does not have the\ncharacters 'DICM' at offset 128.";
                IJ.error("DicomDecoder", msg);
                return;
            }
        }
        if (fi != null && fi.width > 0 && fi.height > 0 && fi.offset > 0) {
            FileOpener fo = new FileOpener(fi);
            ImagePlus imp = fo.open(false);
            ImageProcessor ip = imp.getProcessor();
            if (fi.fileType == 1) {
                if (dd.rescaleIntercept != 0.0 && dd.rescaleSlope == 1.0) {
                    ip.add(dd.rescaleIntercept);
                }
            } else if (dd.rescaleIntercept != 0.0 && dd.rescaleSlope == 1.0) {
                double[] coeff = new double[]{dd.rescaleIntercept, dd.rescaleSlope};
                imp.getCalibration().setFunction(0, coeff, "gray value");
            }
            if (dd.windowWidth > 0.0) {
                double min = dd.windowCenter - dd.windowWidth / 2.0;
                double max = dd.windowCenter + dd.windowWidth / 2.0;
                Calibration cal = imp.getCalibration();
                if (cal.getCValue(0) != 0.0) {
                    min -= cal.getCValue(0);
                    max -= cal.getCValue(0);
                }
                ip.setMinAndMax(min, max);
                if (IJ.debugMode) {
                    IJ.log("window: " + min + "-" + max);
                }
            }
            if (imp.getStackSize() > 1) {
                this.setStack(fileName, imp.getStack());
            } else {
                this.setProcessor(fileName, imp.getProcessor());
            }
            this.setCalibration(imp.getCalibration());
            this.setProperty("Info", dd.getDicomInfo());
            this.setFileInfo(fi);
            if (arg.equals("")) {
                this.show();
            }
        } else if (this.showErrors) {
            IJ.error("DicomDecoder", "Unable to decode DICOM header.");
        }
        IJ.showStatus("");
    }

    public void open(String path) {
        this.showErrors = false;
        this.run(path);
    }

    void convertToUnsigned(ImagePlus imp, FileInfo fi) {
        ImageProcessor ip = imp.getProcessor();
        short[] pixels = (short[])ip.getPixels();
        int min = Integer.MAX_VALUE;
        int i = 0;
        while (i < pixels.length) {
            int value = pixels[i] & 0xFFFF;
            if (value < min) {
                min = value;
            }
            ++i;
        }
        if (IJ.debugMode) {
            IJ.log("min: " + (min - 32768));
        }
        if (min >= 32768) {
            i = 0;
            while (i < pixels.length) {
                pixels[i] = (short)(pixels[i] - 32768);
                ++i;
            }
            ip.resetMinAndMax();
            Calibration cal = imp.getCalibration();
            cal.setFunction(20, null, "Gray Value");
            fi.fileType = 2;
        }
    }
}

