/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.Menus;
import ij.Prefs;
import ij.plugin.PlugIn;
import java.io.File;
import java.util.Vector;

public class ClassChecker
implements PlugIn {
    char separatorChar = Prefs.separator.charAt(0);

    public void run(String arg) {
        this.deleteDuplicates();
    }

    void deleteDuplicates() {
        String[] paths = this.getClassFiles();
        if (paths == null) {
            return;
        }
        int i = 0;
        while (i < paths.length) {
            String name = this.getName(paths[i]);
            if (!name.endsWith("classx")) {
                int j = i + 1;
                while (j < paths.length) {
                    if (paths[j].endsWith(name)) {
                        File file1 = new File(paths[i]);
                        File file2 = new File(paths[j]);
                        if (file1 != null && file2 != null) {
                            long date2;
                            long date1 = file1.lastModified();
                            if (date1 < (date2 = file2.lastModified())) {
                                this.write(paths[i]);
                                file1.delete();
                                break;
                            }
                            if (date2 < date1) {
                                this.write(paths[j]);
                                int n = j;
                                paths[n] = String.valueOf(paths[n]) + "x";
                                file2.delete();
                            } else {
                                if (paths[i].endsWith("plugins" + name)) {
                                    this.write(paths[i]);
                                    file1.delete();
                                    break;
                                }
                                if (paths[j].endsWith("plugins" + name)) {
                                    this.write(paths[j]);
                                    int n = j;
                                    paths[n] = String.valueOf(paths[n]) + "x";
                                    file2.delete();
                                }
                            }
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    void write(String path) {
        IJ.log("Deleting duplicate class: " + path);
    }

    public String getName(String path) {
        int index = path.lastIndexOf(this.separatorChar);
        return index < 0 ? path : path.substring(index);
    }

    String[] getClassFiles() {
        String path = Menus.getPlugInsPath();
        if (path == null) {
            return null;
        }
        File f = new File(path);
        Object[] list = f.list();
        if (list == null) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        int i = 0;
        while (i < list.length) {
            String name = list[i];
            boolean isClassFile = name.endsWith(".class");
            if (isClassFile) {
                v.addElement(String.valueOf(path) + name);
            } else if (!isClassFile) {
                this.getSubdirectoryClassFiles(path, name, v);
            }
            ++i;
        }
        list = new String[v.size()];
        v.copyInto(list);
        return list;
    }

    void getSubdirectoryClassFiles(String path, String dir, Vector v) {
        if (dir.endsWith(".java")) {
            return;
        }
        File f = new File(path, dir);
        if (!f.isDirectory()) {
            return;
        }
        String[] list = f.list();
        if (list == null) {
            return;
        }
        dir = String.valueOf(dir) + Prefs.separator;
        int i = 0;
        while (i < list.length) {
            String name = list[i];
            if (name.endsWith(".class")) {
                v.addElement(String.valueOf(path) + dir + name);
            }
            ++i;
        }
    }
}

