/*
 * Decompiled with CFR 0.152.
 */
package ij.macro;

import ij.IJ;
import ij.macro.MacroConstants;
import ij.macro.Program;
import ij.macro.Symbol;
import java.io.StreamTokenizer;
import java.io.StringReader;

public class Tokenizer
implements MacroConstants {
    private StreamTokenizer st;
    private int token;
    private String tokenString;
    private double tokenValue;
    private Program pgm;
    private boolean hasUserFunctions;

    public Program tokenize(String program) {
        this.st = new StreamTokenizer(new StringReader(program));
        this.st.eolIsSignificant(true);
        this.st.ordinaryChar(45);
        this.st.ordinaryChar(47);
        this.st.ordinaryChar(46);
        this.st.wordChars(95, 95);
        this.st.whitespaceChars(128, 255);
        this.st.slashStarComments(true);
        this.st.slashSlashComments(true);
        this.pgm = new Program();
        do {
            this.getToken();
            this.addToken();
        } while (this.token != 128);
        if (this.hasUserFunctions) {
            this.addUserFunctions();
        }
        if (IJ.debugMode) {
            this.pgm.dumpSymbolTable();
            this.pgm.dumpProgram();
        }
        return this.pgm;
    }

    final void getToken() {
        try {
            this.token = this.st.nextToken();
            String ret = null;
            switch (this.st.ttype) {
                case -1: {
                    ret = "EOF";
                    this.token = 128;
                    break;
                }
                case 10: {
                    ret = "EOL";
                    this.token = 132;
                    break;
                }
                case -3: {
                    ret = this.st.sval;
                    this.token = 129;
                    break;
                }
                case -2: {
                    ret = "" + this.st.nval;
                    this.tokenValue = this.st.nval;
                    if (this.tokenValue == 0.0) {
                        this.tokenValue = this.getHexConstant();
                    }
                    this.token = 130;
                    break;
                }
                case 34: 
                case 39: {
                    ret = this.st.sval;
                    this.token = 133;
                    break;
                }
                case 43: {
                    int nextToken = this.st.nextToken();
                    if (nextToken == 43) {
                        this.token = 1;
                        break;
                    }
                    if (nextToken == 61) {
                        this.token = 9;
                        break;
                    }
                    this.st.pushBack();
                    break;
                }
                case 45: {
                    int nextToken = this.st.nextToken();
                    if (nextToken == 45) {
                        this.token = 2;
                        break;
                    }
                    if (nextToken == 61) {
                        this.token = 10;
                        break;
                    }
                    this.st.pushBack();
                    break;
                }
                case 42: {
                    int nextToken = this.st.nextToken();
                    if (nextToken == 61) {
                        this.token = 11;
                        break;
                    }
                    this.st.pushBack();
                    break;
                }
                case 47: {
                    int nextToken = this.st.nextToken();
                    if (nextToken == 61) {
                        this.token = 12;
                        break;
                    }
                    this.st.pushBack();
                    break;
                }
                case 61: {
                    int nextToken = this.st.nextToken();
                    if (nextToken == 61) {
                        this.token = 3;
                        break;
                    }
                    this.st.pushBack();
                    break;
                }
                case 33: {
                    int nextToken = this.st.nextToken();
                    if (nextToken == 61) {
                        this.token = 4;
                        break;
                    }
                    this.st.pushBack();
                    break;
                }
                case 62: {
                    int nextToken = this.st.nextToken();
                    if (nextToken == 61) {
                        this.token = 6;
                        break;
                    }
                    if (nextToken == 62) {
                        this.token = 15;
                        break;
                    }
                    this.st.pushBack();
                    this.token = 5;
                    break;
                }
                case 60: {
                    int nextToken = this.st.nextToken();
                    if (nextToken == 61) {
                        this.token = 8;
                        break;
                    }
                    if (nextToken == 60) {
                        this.token = 16;
                        break;
                    }
                    this.st.pushBack();
                    this.token = 7;
                    break;
                }
                case 38: {
                    int nextToken = this.st.nextToken();
                    if (nextToken == 38) {
                        this.token = 13;
                        break;
                    }
                    this.st.pushBack();
                    break;
                }
                case 124: {
                    int nextToken = this.st.nextToken();
                    if (nextToken == 124) {
                        this.token = 14;
                        break;
                    }
                    this.st.pushBack();
                }
            }
            this.tokenString = ret;
        }
        catch (Exception e) {
            return;
        }
    }

    final void addToken() {
        int tok = this.token;
        switch (this.token) {
            case 129: {
                Symbol symbol = this.pgm.lookupWord(this.tokenString);
                if (symbol != null) {
                    int type = symbol.getFunctionType();
                    if (type == 0) {
                        tok = symbol.type;
                        if (tok == 207) {
                            this.hasUserFunctions = true;
                        }
                        if (tok == 201) {
                            this.pgm.hasVars = true;
                        }
                    } else {
                        tok = type;
                    }
                    tok += this.pgm.symTabLoc << 12;
                    break;
                }
                this.pgm.addSymbol(new Symbol(this.token, this.tokenString));
                tok += this.pgm.stLoc << 12;
                break;
            }
            case 133: {
                this.pgm.addSymbol(new Symbol(this.token, this.tokenString));
                tok += this.pgm.stLoc << 12;
                break;
            }
            case 130: {
                this.pgm.addSymbol(new Symbol(this.tokenValue));
                tok += this.pgm.stLoc << 12;
                break;
            }
        }
        this.pgm.addToken(tok);
    }

    double getHexConstant() {
        try {
            this.token = this.st.nextToken();
        }
        catch (Exception e) {
            return 0.0;
        }
        if (this.st.ttype != -3) {
            this.st.pushBack();
            return 0.0;
        }
        if (!this.st.sval.startsWith("x")) {
            this.st.pushBack();
            return 0.0;
        }
        String s = this.st.sval.substring(1, this.st.sval.length());
        double n = 0.0;
        try {
            n = Integer.parseInt(s, 16);
        }
        catch (NumberFormatException e) {
            this.st.pushBack();
            n = 0.0;
        }
        return n;
    }

    void addUserFunctions() {
        int[] code = this.pgm.getCode();
        Symbol[] symbolTable = this.pgm.getSymbolTable();
        int i = 0;
        while (i < code.length) {
            this.token = code[i] & 0xFFF;
            if (this.token == 207) {
                int nextToken = code[i + 1] & 0xFFF;
                if (nextToken == 129 || nextToken >= 134 && nextToken <= 137) {
                    int address2;
                    int address = address2 = code[i + 1] >> 12;
                    if (nextToken != 129) {
                        this.pgm.addSymbol(new Symbol(129, symbolTable[address].str));
                        address2 = this.pgm.stLoc;
                        code[i + 1] = 129 + (address2 << 12);
                    }
                    Symbol sym = symbolTable[address2];
                    sym.type = 138;
                    sym.value = i + 1;
                    int j = 0;
                    while (j < code.length) {
                        this.token = code[j] & 0xFFF;
                        if ((this.token == 129 || this.token >= 134 && this.token <= 137) && code[j] >> 12 == address && (j == 0 || (code[j - 1] & 0xFFF) != 207)) {
                            code[j] = 138;
                            int n = j;
                            code[n] = code[n] + (address2 << 12);
                        } else if (this.token == 128) break;
                        ++j;
                    }
                }
            } else if (this.token == 128) break;
            ++i;
        }
    }
}

