/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.ImagePlus;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.plugin.filter.Analyzer;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;

public class PointRoi
extends PolygonRoi {
    public PointRoi(int[] ox, int[] oy, int points) {
        super(ox, oy, points, 10);
        ++this.width;
        ++this.height;
    }

    public PointRoi(int sx, int sy, ImagePlus imp) {
        super(PointRoi.makeXArray(sx, imp), PointRoi.makeYArray(sy, imp), 1, 10);
        this.setImage(imp);
        this.width = 1;
        this.height = 1;
        imp.draw(this.x - 5, this.y - 5, this.width + 10, this.height + 10);
    }

    static int[] makeXArray(int value, ImagePlus imp) {
        int[] array = new int[]{imp != null ? imp.getCanvas().offScreenX(value) : value};
        return array;
    }

    static int[] makeYArray(int value, ImagePlus imp) {
        int[] array = new int[]{imp != null ? imp.getCanvas().offScreenY(value) : value};
        return array;
    }

    void handleMouseMove(int ox, int oy) {
    }

    protected void handleMouseUp(int sx, int sy) {
        super.handleMouseUp(sx, sy);
        this.modifyRoi();
    }

    public void draw(Graphics g) {
        this.updatePolygon();
        if (this.ic != null) {
            this.mag = this.ic.getMagnification();
        }
        int size2 = 2;
        int i = 0;
        while (i < this.nPoints) {
            this.drawPoint(g, this.xp2[i] - size2, this.yp2[i] - size2);
            ++i;
        }
        if (this.updateFullWindow) {
            this.updateFullWindow = false;
            this.imp.draw();
        }
    }

    void drawPoint(Graphics g, int x, int y) {
        g.setColor(ROIColor);
        g.fillRect(x + 1, y + 1, 3, 3);
        g.setColor(Color.black);
        g.drawRect(x, y, 4, 4);
    }

    public void drawPixels(ImageProcessor ip) {
        ip.setLineWidth(Analyzer.markWidth);
        int i = 0;
        while (i < this.nPoints) {
            ip.moveTo(this.x + this.xp[i], this.y + this.yp[i]);
            ip.lineTo(this.x + this.xp[i], this.y + this.yp[i]);
            ++i;
        }
    }

    public PointRoi addPoint(int x, int y) {
        Polygon poly = this.getPolygon();
        poly.addPoint(x, y);
        PointRoi p = new PointRoi(poly.xpoints, poly.ypoints, poly.npoints);
        return p;
    }

    public PointRoi subtractPoints(Roi roi) {
        Polygon points = this.getPolygon();
        Polygon poly = roi.getPolygon();
        Polygon points2 = new Polygon();
        int i = 0;
        while (i < points.npoints) {
            if (!poly.contains(points.xpoints[i], points.ypoints[i])) {
                points2.addPoint(points.xpoints[i], points.ypoints[i]);
            }
            ++i;
        }
        if (points2.npoints == 0) {
            return null;
        }
        return new PointRoi(points2.xpoints, points2.ypoints, points2.npoints);
    }

    public ImageProcessor getMask() {
        if (this.cachedMask != null && this.cachedMask.getPixels() != null) {
            return this.cachedMask;
        }
        ByteProcessor mask = new ByteProcessor(this.width, this.height);
        int i = 0;
        while (i < this.nPoints) {
            ((ImageProcessor)mask).putPixel(this.xp[i], this.yp[i], 255);
            ++i;
        }
        this.cachedMask = mask;
        return mask;
    }
}

