/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.chloe.model;

import com.csvreader.CsvReader;
import com.csvreader.CsvWriter;
import com.vividsolutions.jts.geom.GeometryFactory;
import fr.inra.sad.bagap.apiland.analysis.Analysis;
import fr.inra.sad.bagap.apiland.analysis.AnalysisObserver;
import fr.inra.sad.bagap.apiland.analysis.AnalysisState;
import fr.inra.sad.bagap.apiland.analysis.matrix.ChamferDistance;
import fr.inra.sad.bagap.apiland.analysis.matrix.cluster.ClusteringAnalysis;
import fr.inra.sad.bagap.apiland.analysis.matrix.cluster.ClusteringCsvOutput;
import fr.inra.sad.bagap.apiland.analysis.matrix.cluster.ClusteringEuclidianDistanceAnalysis;
import fr.inra.sad.bagap.apiland.analysis.matrix.cluster.ClusteringFunctionalDistanceAnalysis;
import fr.inra.sad.bagap.apiland.analysis.matrix.cluster.ClusteringQueenAnalysis;
import fr.inra.sad.bagap.apiland.analysis.matrix.cluster.ClusteringRookAnalysis;
import fr.inra.sad.bagap.apiland.analysis.matrix.pixel.Classification;
import fr.inra.sad.bagap.apiland.analysis.matrix.pixel.Pixel2PixelMatrixCalculation;
import fr.inra.sad.bagap.apiland.analysis.matrix.util.AsciiGridManager;
import fr.inra.sad.bagap.apiland.analysis.matrix.util.ExportAsciiGridFromShapefileAnalysis;
import fr.inra.sad.bagap.apiland.analysis.matrix.util.SpatialCsvManager;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.shape.WindowShapeType;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.RasterManager;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.CoordinateManager;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Friction;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.JaiMatrixFactory;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.MatrixManager;
import fr.inra.sad.bagap.apiland.domain.Domain;
import fr.inra.sad.bagap.apiland.treatment.Treatment;
import fr.inra.sad.bagap.apiland.treatment.TreatmentException;
import fr.inra.sad.bagap.apiland.treatment.TreatmentObserver;
import fr.inra.sad.bagap.apiland.treatment.TreatmentState;
import fr.inra.sad.bagap.apiland.treatment.window.GridWindowMatrixTreatment;
import fr.inra.sad.bagap.apiland.treatment.window.MapWindowMatrixTreatment;
import fr.inra.sad.bagap.apiland.treatment.window.SelectedWindowMatrixTreatment;
import fr.inra.sad.bagap.apiland.treatment.window.SlidingWindowMatrixTreatment;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.data.shapefile.dbf.DbaseFileHeader;
import org.geotools.data.shapefile.dbf.DbaseFileReader;
import org.geotools.data.shapefile.files.ShpFiles;
import org.geotools.data.shapefile.shp.ShapefileException;
import org.geotools.data.shapefile.shp.ShapefileHeader;
import org.geotools.data.shapefile.shp.ShapefileReader;

public class Model
implements TreatmentObserver,
AnalysisObserver {
    private int progress;
    private int globalProgress;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private boolean batch = false;

    public void setProgress(int progress) {
        if (this.batch) {
            System.out.println("## " + progress + " / 100");
        } else {
            this.pcs.firePropertyChange(new PropertyChangeEvent(this, ACTION.PROGRESS.toString(), null, progress));
        }
    }

    public void publish(String text) {
        if (this.batch) {
            System.out.println("## " + text);
        } else {
            this.pcs.firePropertyChange(new PropertyChangeEvent(this, ACTION.PUBLISH.toString(), "", text));
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    @Override
    public void notify(Analysis ma, AnalysisState state) {
    }

    @Override
    public void notify(Treatment t, TreatmentState s) {
    }

    @Override
    public void updateProgression(Analysis ma, int total) {
        this.updateProgression(total);
    }

    @Override
    public void updateProgression(Treatment t, int total) {
        this.updateProgression(total);
    }

    public void updateProgression(int total) {
        ++this.progress;
        int gprogress = new Double((double)this.progress / (double)total * 100.0).intValue();
        if (this.globalProgress != gprogress) {
            this.globalProgress = gprogress;
            this.setProgress(this.globalProgress);
        }
    }

    public boolean runSlidingWindow(boolean batch, Set<Matrix> inputMatrix, WindowShapeType shape, Friction friction, Matrix frictionMatrix, List<Integer> windowSizes, int delta, boolean interpolate, double minRate, Set<String> metrics, String outputFolder, String outputAsc, String outputCsv, boolean viewAsciiOutput, boolean exportCsv, boolean exportAscii, Set<Integer> filters, Set<Integer> unfilters) {
        this.batch = batch;
        SlidingWindowMatrixTreatment treatment = new SlidingWindowMatrixTreatment();
        try {
            treatment.setInput("shape", (Object)shape);
            treatment.setInput("delta", delta);
            treatment.setInput("interpolation", interpolate);
            treatment.setInput("min_rate", minRate);
            treatment.setInput("metrics", metrics);
            treatment.setInput("filters", filters);
            treatment.setInput("unfilters", unfilters);
            if (friction != null) {
                treatment.setInput("friction_map", friction);
            }
            if (frictionMatrix != null) {
                treatment.setInput("friction_matrix", frictionMatrix);
            }
            if (shape == WindowShapeType.FUNCTIONAL) {
                for (Matrix matrix : inputMatrix) {
                    String name = new File(matrix.getFile()).getName().replace(".asc", "");
                    treatment.setInput("matrix", matrix);
                    for (int wsize : windowSizes) {
                        this.publish("treatment of the matrix " + name + " using window size = " + wsize);
                        treatment.addObserver(this);
                        this.progress = 0;
                        ArrayList<Integer> ws = new ArrayList<Integer>();
                        ws.add(wsize);
                        treatment.setInput("window_sizes", ws);
                        if (exportCsv) {
                            if (outputCsv != null) {
                                treatment.setInput("csv", outputCsv);
                            } else {
                                treatment.setInput("csv", outputFolder + "/" + name + "_" + WindowShapeType.getAbreviation(shape) + "_w" + wsize + ".csv");
                            }
                        }
                        if (exportAscii) {
                            if (outputAsc != null) {
                                treatment.setInput("ascii", outputAsc);
                            } else {
                                treatment.setInput("ascii", outputFolder + "/" + name + "_" + WindowShapeType.getAbreviation(shape) + "_w" + wsize + "_");
                            }
                        }
                        try {
                            treatment.allRun();
                            treatment.clearObservers();
                            treatment.clearOutputs();
                        }
                        catch (TreatmentException e) {
                            e.printStackTrace();
                        }
                    }
                }
            } else {
                for (Matrix matrix : inputMatrix) {
                    String name = new File(matrix.getFile()).getName().replace(".asc", "");
                    treatment.setInput("matrix", matrix);
                    this.publish("treatment of the matrix " + name + " using window size = " + windowSizes);
                    treatment.addObserver(this);
                    this.progress = 0;
                    treatment.setInput("window_sizes", windowSizes);
                    if (exportCsv) {
                        if (outputCsv != null) {
                            treatment.setInput("csv", outputCsv);
                        } else {
                            treatment.setInput("csv", outputFolder + "/" + name + "_" + WindowShapeType.getAbreviation(shape) + ".csv");
                        }
                    }
                    if (exportAscii) {
                        if (outputAsc != null) {
                            treatment.setInput("ascii", outputAsc);
                        } else {
                            treatment.setInput("ascii", outputFolder + "/" + name + "_" + WindowShapeType.getAbreviation(shape) + "_");
                        }
                    }
                    try {
                        treatment.allRun();
                        treatment.clearObservers();
                        treatment.clearOutputs();
                    }
                    catch (TreatmentException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (viewAsciiOutput) {
                if (outputAsc != null) {
                    MatrixManager.visualize(outputAsc);
                } else {
                    MatrixManager.visualize(outputFolder);
                }
            }
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public boolean runSelectedWindow(boolean batch, Set<Matrix> inputMatrix, double minRate, WindowShapeType shape, Friction friction, Matrix frictionMatrix, List<Integer> windowSizes, Set<Pixel> pixels, Set<String> metrics, String outputFolder, String outputAsc, String outputCsv, boolean viewAsciiOutput, boolean exportCsv, boolean exportAscii) {
        this.batch = batch;
        SelectedWindowMatrixTreatment treatment = new SelectedWindowMatrixTreatment();
        try {
            if (outputFolder != null) {
                treatment.setInput("path", outputFolder);
            } else {
                treatment.setInput("path", new File(outputCsv).getParent());
            }
            treatment.setInput("shape", (Object)shape);
            treatment.setInput("pixels", pixels);
            treatment.setInput("metrics", metrics);
            treatment.setInput("min_rate", minRate);
            if (friction != null) {
                treatment.setInput("friction_map", friction);
            }
            if (frictionMatrix != null) {
                treatment.setInput("friction_matrix", frictionMatrix);
            }
            if (shape == WindowShapeType.FUNCTIONAL) {
                for (Matrix matrix : inputMatrix) {
                    String name = new File(matrix.getFile()).getName().replace(".asc", "");
                    treatment.setInput("matrix", matrix);
                    for (int wsize : windowSizes) {
                        this.publish("treatment of the matrix " + name + " using window size = " + wsize);
                        treatment.addObserver(this);
                        this.progress = 0;
                        ArrayList<Integer> ws = new ArrayList<Integer>();
                        ws.add(wsize);
                        treatment.setInput("window_sizes", ws);
                        if (exportCsv) {
                            if (outputCsv != null) {
                                treatment.setInput("csv", outputCsv);
                            } else {
                                treatment.setInput("csv", outputFolder + "/" + name + "_w" + wsize + ".csv");
                            }
                        }
                        if (exportAscii) {
                            if (outputAsc != null) {
                                treatment.setInput("ascii", outputAsc);
                            } else {
                                treatment.setInput("ascii", outputFolder + "/" + name + "_w" + wsize + "_");
                            }
                        }
                        try {
                            treatment.allRun();
                            treatment.clearObservers();
                            treatment.clearOutputs();
                        }
                        catch (TreatmentException e) {
                            e.printStackTrace();
                        }
                    }
                }
            } else {
                for (Matrix matrix : inputMatrix) {
                    String name = new File(matrix.getFile()).getName().replace(".asc", "");
                    treatment.setInput("matrix", matrix);
                    this.publish("treatment of the matrix " + name + " using window size = " + windowSizes);
                    treatment.addObserver(this);
                    this.progress = 0;
                    treatment.setInput("window_sizes", windowSizes);
                    if (exportCsv) {
                        if (outputCsv != null) {
                            treatment.setInput("csv", outputCsv);
                        } else {
                            treatment.setInput("csv", outputFolder + "/" + name + "_" + WindowShapeType.getAbreviation(shape) + ".csv");
                        }
                    }
                    if (exportAscii) {
                        if (outputAsc != null) {
                            treatment.setInput("ascii", outputAsc);
                        } else {
                            treatment.setInput("ascii", outputFolder + "/" + name + "_" + WindowShapeType.getAbreviation(shape) + "_");
                        }
                    }
                    try {
                        treatment.allRun();
                        treatment.clearObservers();
                        treatment.clearOutputs();
                    }
                    catch (TreatmentException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (viewAsciiOutput) {
                if (outputAsc != null) {
                    MatrixManager.visualize(outputAsc);
                } else {
                    MatrixManager.visualize(outputFolder);
                }
            }
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public boolean runMapWindow(boolean batch, Set<Matrix> inputMatrix, Set<String> metrics, String csvOutput) {
        this.batch = batch;
        MapWindowMatrixTreatment treatment = new MapWindowMatrixTreatment();
        try {
            treatment.setInput("metrics", metrics);
            try {
                CsvWriter cw = new CsvWriter(csvOutput);
                cw.setDelimiter(';');
                cw.write("name");
                for (String m : metrics) {
                    cw.write(m);
                }
                cw.endRecord();
                for (Matrix matrix : inputMatrix) {
                    this.publish("treatment of the matrix " + matrix);
                    treatment.addObserver(this);
                    this.progress = 0;
                    treatment.setInput("matrix", matrix);
                    treatment.setInput("csv", cw);
                    try {
                        treatment.allRun();
                        treatment.clearObservers();
                        treatment.clearOutputs();
                    }
                    catch (TreatmentException e) {
                        e.printStackTrace();
                    }
                }
                cw.close();
            }
            catch (CsvWriter.FinalizedException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public boolean runGridWindow(boolean batch, Set<Matrix> inputMatrix, List<Integer> gridSizes, double minRate, Set<String> metrics, String outputFolder, String outputAsc, String outputCsv, boolean viewAsciiOutput, boolean exportCsv, boolean exportAscii) {
        this.batch = batch;
        GridWindowMatrixTreatment treatment = new GridWindowMatrixTreatment();
        try {
            treatment.setInput("metrics", metrics);
            treatment.setInput("min_rate", minRate);
            for (Matrix matrix : inputMatrix) {
                String name = new File(matrix.getFile()).getName().replace(".asc", "");
                treatment.setInput("matrix", matrix);
                for (int gsize : gridSizes) {
                    this.publish("treatment of the matrix " + name + " using grid size = " + gsize);
                    treatment.addObserver(this);
                    this.progress = 0;
                    treatment.setInput("grid_size", gsize);
                    if (exportCsv) {
                        if (outputCsv != null) {
                            treatment.setInput("csv", outputCsv);
                        } else {
                            treatment.setInput("csv", outputFolder + "/" + name + "_g" + gsize + ".csv");
                        }
                    }
                    if (exportAscii) {
                        if (outputAsc != null) {
                            treatment.setInput("ascii", outputAsc);
                        } else {
                            treatment.setInput("ascii", outputFolder + "/" + name + "_g" + gsize + "_");
                        }
                    }
                    try {
                        treatment.allRun();
                        treatment.clearObservers();
                        treatment.clearOutputs();
                    }
                    catch (TreatmentException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (viewAsciiOutput) {
                if (outputAsc != null) {
                    MatrixManager.visualize(outputAsc);
                } else {
                    MatrixManager.visualize(outputFolder);
                }
            }
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public boolean importAsciiGrid(Collection<Matrix> matrix, String ascii) {
        try {
            this.publish("import matrix " + ascii);
            Matrix m = JaiMatrixFactory.get().createWithAsciiGridOld(ascii, true);
            matrix.add(m);
            return true;
        }
        catch (NumberFormatException ex) {
            ex.printStackTrace();
            return false;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public Matrix importAsciiGrid(Matrix matrix, String ascii) {
        try {
            Matrix m;
            this.publish("import matrix " + ascii);
            matrix = m = JaiMatrixFactory.get().createWithAsciiGridOld(ascii, true);
            return matrix;
        }
        catch (NumberFormatException ex) {
            ex.printStackTrace();
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public boolean getAttributesAndEnvelopeFromShapefile(String shape, Map<String, String> attributes, double[] envelope) {
        try {
            this.publish("import shapefile " + shape);
            ShpFiles sf = new ShpFiles(shape);
            ShapefileReader sfr = new ShapefileReader(sf, true, false, new GeometryFactory());
            ShapefileHeader sfh = sfr.getHeader();
            envelope[0] = sfh.minX();
            envelope[1] = sfh.maxX();
            envelope[2] = sfh.minY();
            envelope[3] = sfh.maxY();
            sfr.close();
            DbaseFileReader dfr = new DbaseFileReader(sf, true, Charset.defaultCharset());
            DbaseFileHeader dfh = dfr.getHeader();
            block10: for (int i = 0; i < dfh.getNumFields(); ++i) {
                switch (dfh.getFieldType(i)) {
                    case 'C': {
                        attributes.put(dfh.getFieldName(i).toLowerCase(), "String");
                        continue block10;
                    }
                    case 'N': {
                        attributes.put(dfh.getFieldName(i).toLowerCase(), "Number");
                        continue block10;
                    }
                    case 'L': {
                        attributes.put(dfh.getFieldName(i).toLowerCase(), "Boolean");
                        continue block10;
                    }
                    case 'D': {
                        attributes.put(dfh.getFieldName(i).toLowerCase(), "Date");
                    }
                }
            }
            dfr.close();
            return true;
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (ShapefileException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return false;
    }

    public boolean dispatch(Set<Pixel> pixels, Matrix m, Integer n, int distance, Set<Integer> with, Set<Integer> without) {
        try {
            this.publish("dispatch de " + n + " pixels");
            CoordinateManager.dispatch(pixels, m, (int)n, distance, with, without);
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public boolean dispatch(Set<Pixel> pixels, Set<Matrix> matrix, Integer n, int distance, Set<Integer> with, Set<Integer> without) {
        try {
            this.publish("dispatch de " + n + " pixels");
            CoordinateManager.dispatch(pixels, matrix, (int)n, distance, with, without);
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public boolean exportAsciiGridFromCsv(boolean batch, String inputCsv, String folder, String outputAsc, Set<String> variables, int ncols, int nrows, double xllcorner, double yllcorner, double cellsize, int nodatavalue, boolean viewAscii) {
        this.batch = batch;
        try {
            this.publish("export ascii grid from csv file(s)");
            File f = new File(inputCsv);
            if (f.isDirectory()) {
                for (String c : new File(inputCsv).list()) {
                    if (!c.endsWith(".csv")) continue;
                    SpatialCsvManager.exportAsciiGrid(f + "/" + c, folder, outputAsc, variables, ncols, nrows, xllcorner, yllcorner, 1, cellsize, nodatavalue);
                }
            } else {
                SpatialCsvManager.exportAsciiGrid(inputCsv, folder, outputAsc, variables, ncols, nrows, xllcorner, yllcorner, 1, cellsize, nodatavalue);
            }
            if (viewAscii) {
                if (outputAsc != null) {
                    MatrixManager.visualize(outputAsc);
                } else {
                    MatrixManager.visualize(folder);
                }
            }
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public boolean sortCsv(String inputCsv) {
        try {
            this.publish("sort csv file(s)");
            File f = new File(inputCsv);
            if (f.isDirectory()) {
                for (String c : new File(inputCsv).list()) {
                    if (!c.endsWith(".csv")) continue;
                    SpatialCsvManager.sort(f + "/" + c);
                }
            } else {
                SpatialCsvManager.sort(inputCsv);
            }
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    private String formatDoubleToString(double d) {
        int i = new Double(d).intValue();
        String s = new Integer(i).toString();
        while (s.length() < 4) {
            s = "0" + s;
        }
        return s;
    }

    public boolean runSearchAndReplace(boolean batch, Set<String> asciis, int noData, Map<Integer, Number> changes, String outputFolder, String outputAsc, boolean viewAscii) {
        this.batch = batch;
        try {
            for (String ascii : asciis) {
                this.publish("search and replace : " + ascii);
                String out = outputAsc != null ? outputAsc : outputFolder + "/" + new File(ascii).getName();
                AsciiGridManager.searchAndReplace(ascii, out, noData, changes);
            }
            if (viewAscii) {
                if (outputAsc != null) {
                    MatrixManager.visualize(outputAsc);
                } else {
                    MatrixManager.visualize(outputFolder);
                }
            }
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public boolean cleanAsciiGrid(String ascii) {
        try {
            this.publish("clean ascii grid file : " + ascii);
            AsciiGridManager.clean(ascii, ascii);
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public boolean exportAsciiGridFromShapefile(boolean batch, Set<String> layers, String attribute, String lookupTable, Set<Double> cellsizes, String outputFolder, String outputAsc, boolean viewAscii, Double minx, Double maxx, Double miny, Double maxy) {
        this.batch = batch;
        try {
            this.publish("export ascii grid from shapefile");
            for (String layer : layers) {
                String name = new File(layer).getName().replace(".shp", "");
                for (double cellsize : cellsizes) {
                    String ascii;
                    if (outputAsc != null) {
                        this.publish("export " + outputAsc + " with cellsize " + cellsize);
                        ascii = outputAsc;
                    } else {
                        this.publish("export " + name + " with cellsize " + cellsize);
                        ascii = outputFolder + "/" + name + "_" + this.formatDoubleToString(cellsize) + ".asc";
                    }
                    HashMap<String, String> map = null;
                    if (!lookupTable.equalsIgnoreCase("")) {
                        map = new HashMap<String, String>();
                        CsvReader cr = new CsvReader(lookupTable);
                        cr.setDelimiter(';');
                        cr.readHeaders();
                        while (cr.readRecord()) {
                            map.put(cr.get(0).replace(" ", ""), cr.get(1).replaceAll(" ", ""));
                        }
                        cr.close();
                    }
                    ExportAsciiGridFromShapefileAnalysis a = minx == null ? new ExportAsciiGridFromShapefileAnalysis(ascii, layer, attribute, cellsize, map) : new ExportAsciiGridFromShapefileAnalysis(ascii, layer, attribute, cellsize, minx, maxx, miny, maxy, map);
                    a.addObserver(this);
                    this.progress = 0;
                    a.allRun();
                }
            }
            if (viewAscii) {
                if (outputAsc != null) {
                    MatrixManager.visualize(outputAsc);
                } else {
                    MatrixManager.visualize(outputFolder);
                }
            }
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public boolean runDistance(boolean batch, Set<Matrix> matrix, Set<Integer> values, String asciiOutput, String outputAsc, boolean viewAsciiOutput) {
        this.batch = batch;
        try {
            for (final Matrix m : matrix) {
                String name = new File(m.getFile()).getName().replace(".asc", "");
                this.publish("distance calculation: " + m.getFile());
                this.progress = 0;
                ChamferDistance cd = new ChamferDistance(m, values);
                cd.addObserver(this);
                final Matrix m2 = cd.allRun();
                this.publish("normalize the distance matrix");
                this.progress = 0;
                Pixel2PixelMatrixCalculation pp = new Pixel2PixelMatrixCalculation(new Matrix[]{m, m2}){

                    @Override
                    protected double treatPixel(Pixel p) {
                        if (m.get(p) != (double)Raster.getNoDataValue()) {
                            return m2.get(p);
                        }
                        return Raster.getNoDataValue();
                    }
                };
                pp.addObserver(this);
                Matrix m3 = pp.allRun();
                if (outputAsc != null) {
                    MatrixManager.exportAsciiGrid(m3, outputAsc);
                    continue;
                }
                MatrixManager.exportAsciiGrid(m3, asciiOutput + "/" + name + "_dist-" + values + ".asc");
            }
            if (viewAsciiOutput) {
                if (outputAsc != null) {
                    MatrixManager.visualize(outputAsc);
                } else {
                    MatrixManager.visualize(asciiOutput);
                }
            }
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public boolean runFilter(boolean batch, Set<Matrix> matrix, Matrix filterMatrix, final Set<Integer> values, String asciiOutput, String outputAsc, boolean viewAsciiOutput) {
        this.batch = batch;
        try {
            for (Matrix m : matrix) {
                String name = new File(m.getFile()).getName().replace(".asc", "");
                this.publish("filter calculation: " + m.getFile());
                this.progress = 0;
                Pixel2PixelMatrixCalculation pp = new Pixel2PixelMatrixCalculation(new Matrix[]{m, filterMatrix}){

                    @Override
                    protected double treatPixel(Pixel p) {
                        double f = this.matrix(1).get(p);
                        Iterator iterator = values.iterator();
                        while (iterator.hasNext()) {
                            int v = (Integer)iterator.next();
                            if ((double)v != f) continue;
                            return this.matrix(0).get(p);
                        }
                        return 0.0;
                    }
                };
                pp.addObserver(this);
                Matrix m2 = pp.allRun();
                if (outputAsc != null) {
                    MatrixManager.exportAsciiGrid(m2, outputAsc);
                    continue;
                }
                MatrixManager.exportAsciiGrid(m2, asciiOutput + "/" + name + "_filter-" + values + ".asc");
            }
            if (viewAsciiOutput) {
                if (outputAsc != null) {
                    MatrixManager.visualize(outputAsc);
                } else {
                    MatrixManager.visualize(asciiOutput);
                }
            }
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public boolean runClassification(boolean batch, Set<Matrix> matrix, Map<Domain<Double, Double>, Integer> domains, String asciiOutput, String outputAsc, boolean viewAsciiOutput) {
        this.batch = batch;
        try {
            for (Matrix m : matrix) {
                this.progress = 0;
                String name = new File(m.getFile()).getName().replace(".asc", "");
                this.publish("classification : " + m.getFile());
                Classification c = new Classification(m, domains);
                c.addObserver(this);
                Matrix m2 = c.allRun();
                if (outputAsc != null) {
                    MatrixManager.exportAsciiGrid(m2, outputAsc);
                    continue;
                }
                MatrixManager.exportAsciiGrid(m2, asciiOutput + "/" + name + "_class.asc");
            }
            if (viewAsciiOutput) {
                if (outputAsc != null) {
                    MatrixManager.visualize(outputAsc);
                } else {
                    MatrixManager.visualize(asciiOutput);
                }
            }
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public boolean runOverlay(boolean batch, List<Matrix> matrix, String asciiOutput, String outputAsc, boolean viewAsciiOutput) {
        this.batch = batch;
        try {
            this.progress = 0;
            StringBuffer n = new StringBuffer();
            for (Matrix matrix2 : matrix) {
                n.append(new File(matrix2.getFile()).getName().replace(".asc", "") + "+");
            }
            String name = "overlay";
            this.publish("overlay : " + n.toString());
            Matrix[] matrixArray = matrix.toArray(new Matrix[matrix.size()]);
            Pixel2PixelMatrixCalculation ppm = new Pixel2PixelMatrixCalculation(matrixArray){

                @Override
                protected double treatPixel(Pixel p) {
                    boolean zero = false;
                    for (Matrix m : this.wholeMatrix()) {
                        double v = m.get(p);
                        if (v != 0.0 && v != (double)Raster.getNoDataValue()) {
                            return v;
                        }
                        if (v != 0.0) continue;
                        zero = true;
                    }
                    if (zero) {
                        return 0.0;
                    }
                    return Raster.getNoDataValue();
                }
            };
            ppm.addObserver(this);
            Matrix mo = ppm.allRun();
            if (outputAsc != null) {
                MatrixManager.exportAsciiGrid(mo, outputAsc);
                if (viewAsciiOutput) {
                    MatrixManager.visualize(outputAsc);
                }
            } else {
                MatrixManager.exportAsciiGrid(mo, asciiOutput + "/" + name + ".asc");
                if (viewAsciiOutput) {
                    MatrixManager.visualize(asciiOutput + "/" + name + ".asc");
                }
            }
            return true;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean runCombine(List<Matrix> matrix, final List<Double> factors, String asciiOutput, boolean viewAsciiOutput) {
        try {
            this.progress = 0;
            String name = "combine";
            this.publish("combine");
            Matrix[] m = matrix.toArray(new Matrix[matrix.size()]);
            Pixel2PixelMatrixCalculation ppm = new Pixel2PixelMatrixCalculation(m){

                @Override
                protected double treatPixel(Pixel p) {
                    double value = 0.0;
                    int index = 0;
                    for (Matrix m : this.wholeMatrix()) {
                        double v = m.get(p);
                        if (v == (double)Raster.getNoDataValue()) {
                            return Raster.getNoDataValue();
                        }
                        value += v * (Double)factors.get(index);
                        ++index;
                    }
                    return value;
                }
            };
            ppm.addObserver(this);
            Matrix mo = ppm.allRun();
            MatrixManager.exportAsciiGrid(mo, asciiOutput + "/" + name + ".asc");
            if (viewAsciiOutput) {
                MatrixManager.visualize(asciiOutput + "/" + name + ".asc");
            }
            return true;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean runCluster(boolean batch, Set<Matrix> matrix, Set<Integer> values, String typeCluster, double distance, Friction friction, Matrix frictionMatrix, String asciiOutput, String outputAsc, boolean viewAsciiOutput) {
        this.batch = batch;
        try {
            String name = "cluster";
            for (final Matrix m : matrix) {
                this.progress = 0;
                String suf = new File(m.getFile()).getName().replace(".asc", "");
                this.publish("cluster : " + suf);
                ClusteringAnalysis ca = null;
                switch (typeCluster) {
                    case "rook": {
                        ca = new ClusteringRookAnalysis(m, values);
                        break;
                    }
                    case "queen": {
                        ca = new ClusteringQueenAnalysis(m, values);
                        break;
                    }
                    case "euclidian": {
                        ca = new ClusteringEuclidianDistanceAnalysis(m, distance, values);
                        break;
                    }
                    case "functional": {
                        ca = friction != null ? new ClusteringFunctionalDistanceAnalysis(m, distance, values, friction) : new ClusteringFunctionalDistanceAnalysis(m, distance, values, frictionMatrix);
                    }
                }
                if (outputAsc != null) {
                    ca.addObserver(new ClusteringCsvOutput(outputAsc.replace(".asc", "") + ".csv"));
                } else {
                    ca.addObserver(new ClusteringCsvOutput(asciiOutput + "/" + name + "_" + suf + ".csv"));
                }
                ca.addObserver(this);
                Raster r = (Raster)ca.allRun();
                final Matrix m2 = RasterManager.exportMatrix(r, m);
                Pixel2PixelMatrixCalculation ppt = new Pixel2PixelMatrixCalculation(new Matrix[]{m, m2}){

                    @Override
                    protected double treatPixel(Pixel p) {
                        double v = m2.get(p);
                        if (v != (double)Raster.getNoDataValue()) {
                            return v;
                        }
                        if (m.get(p) != (double)Raster.getNoDataValue()) {
                            return 0.0;
                        }
                        return Raster.getNoDataValue();
                    }
                };
                if (outputAsc != null) {
                    MatrixManager.exportAsciiGrid(ppt.allRun(), outputAsc);
                    continue;
                }
                MatrixManager.exportAsciiGrid(ppt.allRun(), asciiOutput + "/" + name + "_" + suf + ".asc");
            }
            if (viewAsciiOutput) {
                if (outputAsc != null) {
                    MatrixManager.visualize(outputAsc);
                } else {
                    MatrixManager.visualize(asciiOutput);
                }
            }
            return true;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static enum ACTION {
        PROGRESS,
        PUBLISH;

    }
}

