/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.chloe.controller;

import com.csvreader.CsvReader;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.shape.WindowShapeType;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Friction;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import fr.inra.sad.bagap.apiland.domain.Domain;
import fr.inra.sad.bagap.chloe.controller.LocalContext;
import fr.inra.sad.bagap.chloe.model.Model;
import fr.inra.sad.bagap.chloe.view.Ihm;
import fr.inra.sad.bagap.chloe.view.TreatmentWorker;
import fr.inra.sad.bagap.chloe.view.treatment.TreatmentPanel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;

public class Controller {
    private final Ihm ihm;
    private final Model model;

    public Controller(Ihm i, Model m) {
        this.ihm = i;
        this.ihm.setController(this);
        this.model = m;
        this.model.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent pce) {
                if (Model.ACTION.PROGRESS.toString().equals(pce.getPropertyName())) {
                    Controller.this.ihm.setProgress((Integer)pce.getNewValue());
                } else if (Model.ACTION.PUBLISH.toString().equals(pce.getPropertyName())) {
                    Controller.this.ihm.publish((String)pce.getNewValue());
                }
            }
        });
    }

    public void close() {
        try {
            LocalContext.save();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public Ihm getIhm() {
        return this.ihm;
    }

    public void runSlidingWindow(final Set<Matrix> inputMatrix, final WindowShapeType shape, final Friction friction, final Matrix frictionMatrix, final List<Integer> windowSizes, final int delta, final boolean interpolate, final double minRate, final Set<String> metrics, final String outputFolder, final boolean viewAsciiOutput, final boolean exportCsv, final boolean exportAscii, final Set<Integer> filters, final Set<Integer> unfilters) {
        TreatmentWorker swingworker = new TreatmentWorker(this.ihm){

            @Override
            protected Boolean doInBackground() throws Exception {
                Controller.this.ihm.start();
                return Controller.this.model.runSlidingWindow(false, inputMatrix, shape, friction, frictionMatrix, windowSizes, delta, interpolate, minRate, metrics, outputFolder, null, null, viewAsciiOutput, exportCsv, exportAscii, filters, unfilters);
            }

            @Override
            protected void done() {
                super.done();
                Controller.this.ihm.reset();
            }
        };
        swingworker.execute();
    }

    public void runSelectedWindow(final Set<Matrix> inputMatrix, final double minRate, final WindowShapeType shape, final Friction friction, final Matrix frictionMatrix, final List<Integer> windowSizes, final Set<Pixel> pixels, final Set<String> metrics, final String asciiOutput, final boolean viewAsciiOutput, final boolean exportCsv, final boolean exportAscii) {
        TreatmentWorker swingworker = new TreatmentWorker(this.ihm){

            @Override
            protected Boolean doInBackground() throws Exception {
                Controller.this.ihm.start();
                return Controller.this.model.runSelectedWindow(false, inputMatrix, minRate, shape, friction, frictionMatrix, windowSizes, pixels, metrics, asciiOutput, null, null, viewAsciiOutput, exportCsv, exportAscii);
            }

            @Override
            protected void done() {
                super.done();
                Controller.this.ihm.reset();
            }
        };
        swingworker.execute();
    }

    public void runMapWindow(final Set<Matrix> inputMatrix, final Set<String> metrics, final String csvOutput) {
        TreatmentWorker swingworker = new TreatmentWorker(this.ihm){

            @Override
            protected Boolean doInBackground() throws Exception {
                Controller.this.ihm.start();
                return Controller.this.model.runMapWindow(false, inputMatrix, metrics, csvOutput);
            }

            @Override
            protected void done() {
                super.done();
                Controller.this.ihm.reset();
            }
        };
        swingworker.execute();
    }

    public void runGridWindow(final Set<Matrix> inputMatrix, final List<Integer> gridSizes, final double minRate, final Set<String> metrics, final String asciiOutput, final boolean viewAsciiOutput, final boolean exportCsv, final boolean exportAscii) {
        TreatmentWorker swingworker = new TreatmentWorker(this.ihm){

            @Override
            protected Boolean doInBackground() throws Exception {
                Controller.this.ihm.start();
                return Controller.this.model.runGridWindow(false, inputMatrix, gridSizes, minRate, metrics, asciiOutput, null, null, viewAsciiOutput, exportCsv, exportAscii);
            }

            @Override
            protected void done() {
                super.done();
                Controller.this.ihm.reset();
            }
        };
        swingworker.execute();
    }

    public void importAsciiGridFilter(TreatmentPanel panel, Set<Matrix> matrix, String ascii) {
        if (this.model.importAsciiGrid(matrix, ascii)) {
            panel.displayIhm4(ascii);
        }
    }

    public void importAsciiGridFriction(TreatmentPanel panel, final Matrix matrix, final String ascii) {
        TreatmentWorker swingworker = new TreatmentWorker(this.ihm){

            @Override
            protected Boolean doInBackground() throws Exception {
                Controller.this.ihm.start();
                try {
                    Controller.this.model.importAsciiGrid(matrix, ascii);
                    if (matrix != null) {
                        return true;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return false;
                }
                return false;
            }

            @Override
            protected void done() {
                super.done();
                Controller.this.ihm.resetProgressBar();
            }
        };
        swingworker.execute();
    }

    public void importAsciiGrid(TreatmentPanel panel, Collection<Matrix> matrix, String ascii) {
        File file = new File(ascii);
        if (file.isFile()) {
            if (this.model.importAsciiGrid(matrix, ascii)) {
                panel.displayIhm();
            } else {
                System.err.println("not possible to import this file : " + ascii + ", try to clean it");
                this.ihm.publish("not possible to import this file : " + ascii + ", try to clean it");
                this.model.cleanAsciiGrid(ascii);
                if (this.model.importAsciiGrid(matrix, ascii)) {
                    panel.displayIhm();
                } else {
                    System.err.println("not possible to import this file : " + ascii);
                    this.ihm.publish("not possible to import this file : " + ascii);
                }
            }
        } else {
            for (File f : file.listFiles()) {
                if (!f.isFile() || !f.getName().endsWith(".asc") || this.model.importAsciiGrid(matrix, f.toString())) continue;
                this.ihm.publish("not possible to import this file : " + f.toString() + ", try to clean it");
                this.model.cleanAsciiGrid(f.toString());
            }
            panel.displayIhm();
        }
    }

    public void importAsciiGrid2(TreatmentPanel panel, Collection<Matrix> matrix, String ascii) {
        File file = new File(ascii);
        if (file.isFile()) {
            if (this.model.importAsciiGrid(matrix, ascii)) {
                panel.displayIhm2(ascii);
            } else {
                System.err.println("not possible to import this file : " + ascii + ", try to clean it");
                this.ihm.publish("not possible to import this file : " + ascii + ", try to clean it");
                this.model.cleanAsciiGrid(ascii);
                if (this.model.importAsciiGrid(matrix, ascii)) {
                    panel.displayIhm2(ascii);
                } else {
                    System.err.println("not possible to import this file : " + ascii);
                    this.ihm.publish("not possible to import this file : " + ascii);
                }
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void importAsciiGrid3(TreatmentPanel panel, Collection<Matrix> matrix, String ascii) {
        File file = new File(ascii);
        if (file.isFile()) {
            if (this.model.importAsciiGrid(matrix, ascii)) {
                panel.displayIhm3(ascii);
            } else {
                System.err.println("not possible to import this file : " + ascii + ", try to clean it");
                this.ihm.publish("not possible to import this file : " + ascii + ", try to clean it");
                this.model.cleanAsciiGrid(ascii);
                if (this.model.importAsciiGrid(matrix, ascii)) {
                    panel.displayIhm3(ascii);
                } else {
                    System.err.println("not possible to import this file : " + ascii);
                    this.ihm.publish("not possible to import this file : " + ascii);
                }
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void importShapefile(TreatmentPanel panel, String inputShape, Set<String> shapes) {
        TreeMap<String, String> attributes = new TreeMap<String, String>();
        File f = new File(inputShape);
        if (f.isDirectory()) {
            double[] totalenvelope = new double[]{Double.MAX_VALUE, Double.MIN_VALUE, Double.MAX_VALUE, Double.MIN_VALUE};
            for (String file : f.list()) {
                if (!file.endsWith(".shp")) continue;
                double[] envelope = new double[4];
                this.model.getAttributesAndEnvelopeFromShapefile(inputShape + "/" + file, attributes, envelope);
                shapes.add(inputShape + "/" + file);
                totalenvelope[0] = Math.min(totalenvelope[0], envelope[0]);
                totalenvelope[1] = Math.max(totalenvelope[1], envelope[1]);
                totalenvelope[2] = Math.min(totalenvelope[2], envelope[2]);
                totalenvelope[3] = Math.max(totalenvelope[3], envelope[3]);
            }
            panel.displayAttributes(inputShape, false, attributes, totalenvelope);
        } else if (inputShape.endsWith(".shp")) {
            double[] envelope = new double[4];
            this.model.getAttributesAndEnvelopeFromShapefile(inputShape, attributes, envelope);
            shapes.add(inputShape);
            panel.displayAttributes(inputShape, true, attributes, envelope);
        }
    }

    public void importXYCsv(TreatmentPanel panel, String inputCsv, Set<String> variables) {
        try {
            File fcsv = new File(inputCsv);
            if (fcsv.isDirectory()) {
                for (String csv : fcsv.list()) {
                    if (!csv.endsWith(".csv")) continue;
                    CsvReader cr = new CsvReader(inputCsv + "/" + csv);
                    cr.setDelimiter(';');
                    cr.readHeaders();
                    for (String h : cr.getHeaders()) {
                        if (h.equalsIgnoreCase("X") || h.equalsIgnoreCase("Y")) continue;
                        variables.add(h);
                    }
                    cr.close();
                }
                panel.displayVariables();
                panel.enabledIhm();
            } else {
                CsvReader cr = new CsvReader(inputCsv);
                cr.setDelimiter(';');
                cr.readHeaders();
                for (String h : cr.getHeaders()) {
                    if (h.equalsIgnoreCase("X") || h.equalsIgnoreCase("Y")) continue;
                    variables.add(h);
                }
                cr.close();
                panel.displayVariables();
                panel.enabledIhm();
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (CsvReader.FinalizedException e1) {
            e1.printStackTrace();
        }
        catch (CsvReader.CatastrophicException e1) {
            e1.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void importMapCsv(TreatmentPanel panel, String inputCsv, Set<String> variables) {
        try {
            CsvReader cr = new CsvReader(inputCsv);
            cr.setDelimiter(';');
            cr.readHeaders();
            for (String h : cr.getHeaders()) {
                if (h.equalsIgnoreCase("id")) continue;
                variables.add(h);
            }
            cr.close();
            panel.displayVMap();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (CsvReader.FinalizedException e1) {
            e1.printStackTrace();
        }
        catch (CsvReader.CatastrophicException e1) {
            e1.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void runSearchAndReplace(final Set<String> asciis, final int noData, final Map<Integer, Number> changes, final String asciiOutput, final boolean viewAsciiOutput) {
        TreatmentWorker swingworker = new TreatmentWorker(this.ihm){

            @Override
            protected Boolean doInBackground() throws Exception {
                Controller.this.ihm.start();
                return Controller.this.model.runSearchAndReplace(false, asciis, noData, changes, asciiOutput, null, viewAsciiOutput);
            }

            @Override
            protected void done() {
                super.done();
                Controller.this.ihm.reset();
            }
        };
        swingworker.execute();
    }

    public void generatePixels(final Set<Pixel> pixels, final Matrix m, final Integer value, final int distance, final Set<Integer> with, final Set<Integer> without) {
        TreatmentWorker swingworker = new TreatmentWorker(this.ihm){

            @Override
            protected Boolean doInBackground() throws Exception {
                Controller.this.ihm.start();
                if (Controller.this.model.dispatch((Set<Pixel>)pixels, m, value, distance, (Set<Integer>)with, (Set<Integer>)without)) {
                    TreatmentPanel.enabledAfterDispatch();
                    return true;
                }
                this.publish("pixel generation : wrong parameters");
                return false;
            }

            @Override
            protected void done() {
                super.done();
                try {
                    if (!((Boolean)this.get()).booleanValue()) {
                        Thread.sleep(2000L);
                    }
                    Controller.this.ihm.resetProgressBar();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
        };
        swingworker.execute();
    }

    public void generatePixels(final Set<Pixel> pixels, final Set<Matrix> matrix, final Integer value, final int distance, final Set<Integer> with, final Set<Integer> without) {
        TreatmentWorker swingworker = new TreatmentWorker(this.ihm){

            @Override
            protected Boolean doInBackground() throws Exception {
                Controller.this.ihm.start();
                if (Controller.this.model.dispatch((Set<Pixel>)pixels, matrix, value, distance, (Set<Integer>)with, (Set<Integer>)without)) {
                    TreatmentPanel.enabledAfterDispatch();
                    return true;
                }
                this.publish("pixel generation : wrong parameters");
                return false;
            }

            @Override
            protected void done() {
                super.done();
                try {
                    if (!((Boolean)this.get()).booleanValue()) {
                        Thread.sleep(2000L);
                    }
                    Controller.this.ihm.resetProgressBar();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
        };
        swingworker.execute();
    }

    public void exportAsciiGridFromCsv(final String inputCsv, final String folder, final Set<String> variables, final int ncols, final int nrows, final double xllcorner, final double yllcorner, final double cellsize, final int nodatavalue, final boolean viewAscii) {
        TreatmentWorker swingworker = new TreatmentWorker(this.ihm){

            @Override
            protected Boolean doInBackground() throws Exception {
                Controller.this.ihm.start();
                return Controller.this.model.exportAsciiGridFromCsv(false, inputCsv, folder, null, variables, ncols, nrows, xllcorner, yllcorner, cellsize, nodatavalue, viewAscii);
            }

            @Override
            protected void done() {
                super.done();
                Controller.this.ihm.reset();
            }
        };
        swingworker.execute();
    }

    public void sortCsv(final String inputCsv) {
        TreatmentWorker swingworker = new TreatmentWorker(this.ihm){

            @Override
            protected Boolean doInBackground() throws Exception {
                Controller.this.ihm.start();
                return Controller.this.model.sortCsv(inputCsv);
            }

            @Override
            protected void done() {
                super.done();
                Controller.this.ihm.resetProgressBar();
            }
        };
        swingworker.execute();
    }

    public void exportAsciiGridFromShapefile(final Set<String> shapes, final String attribute, final String lookupTable, final Set<Double> cellsizes, final String outputFolder, final boolean viewAscii, final Double minx, final Double maxx, final Double miny, final Double maxy) {
        TreatmentWorker swingworker = new TreatmentWorker(this.ihm){

            @Override
            protected Boolean doInBackground() throws Exception {
                Controller.this.ihm.start();
                return Controller.this.model.exportAsciiGridFromShapefile(false, shapes, attribute, lookupTable, cellsizes, outputFolder, null, viewAscii, minx, maxx, miny, maxy);
            }

            @Override
            protected void done() {
                super.done();
                Controller.this.ihm.reset();
            }
        };
        swingworker.execute();
    }

    public void runDistance(final Set<Matrix> matrix, final Set<Integer> values, final String asciiOutput, final boolean viewAsciiOutput) {
        TreatmentWorker swingworker = new TreatmentWorker(this.ihm){

            @Override
            protected Boolean doInBackground() throws Exception {
                Controller.this.ihm.start();
                return Controller.this.model.runDistance(false, matrix, values, asciiOutput, null, viewAsciiOutput);
            }

            @Override
            protected void done() {
                super.done();
                Controller.this.ihm.reset();
            }
        };
        swingworker.execute();
    }

    public void runFilter(final Set<Matrix> matrix, final Matrix filterMatrix, final Set<Integer> values, final String asciiOutput, final boolean viewAsciiOutput) {
        TreatmentWorker swingworker = new TreatmentWorker(this.ihm){

            @Override
            protected Boolean doInBackground() throws Exception {
                Controller.this.ihm.start();
                return Controller.this.model.runFilter(false, matrix, filterMatrix, values, asciiOutput, null, viewAsciiOutput);
            }

            @Override
            protected void done() {
                super.done();
                Controller.this.ihm.reset();
            }
        };
        swingworker.execute();
    }

    public void runOverlay(final List<Matrix> matrix, final String asciiOutput, final boolean viewAsciiOutput) {
        TreatmentWorker swingworker = new TreatmentWorker(this.ihm){

            @Override
            protected Boolean doInBackground() throws Exception {
                Controller.this.ihm.start();
                return Controller.this.model.runOverlay(false, matrix, asciiOutput, null, viewAsciiOutput);
            }

            @Override
            protected void done() {
                super.done();
                Controller.this.ihm.reset();
            }
        };
        swingworker.execute();
    }

    public void runCombine(final List<Matrix> matrix, final List<Double> factors, final String asciiOutput, final boolean viewAsciiOutput) {
        TreatmentWorker swingworker = new TreatmentWorker(this.ihm){

            @Override
            protected Boolean doInBackground() throws Exception {
                Controller.this.ihm.start();
                return Controller.this.model.runCombine(matrix, factors, asciiOutput, viewAsciiOutput);
            }

            @Override
            protected void done() {
                super.done();
                Controller.this.ihm.reset();
            }
        };
        swingworker.execute();
    }

    public void runClassification(final TreatmentPanel panel, final Set<Matrix> inputMatrix, final Map<Domain<Double, Double>, Integer> domains, final String asciiOutput, final boolean viewAsciiOutput) {
        TreatmentWorker swingworker = new TreatmentWorker(this.ihm){

            @Override
            protected Boolean doInBackground() throws Exception {
                Controller.this.ihm.start();
                panel.cleanDomains();
                return Controller.this.model.runClassification(false, inputMatrix, domains, asciiOutput, null, viewAsciiOutput);
            }

            @Override
            protected void done() {
                super.done();
                Controller.this.ihm.reset();
            }
        };
        swingworker.execute();
    }

    public void runCluster(final Set<Matrix> matrix, final Set<Integer> values, final String typeCluster, final double distance, final Friction friction, final Matrix frictionMatrix, final String asciiOutput, final boolean viewAsciiOutput) {
        TreatmentWorker swingworker = new TreatmentWorker(this.ihm){

            @Override
            protected Boolean doInBackground() throws Exception {
                Controller.this.ihm.start();
                return Controller.this.model.runCluster(false, matrix, values, typeCluster, distance, friction, frictionMatrix, asciiOutput, null, viewAsciiOutput);
            }

            @Override
            protected void done() {
                super.done();
                Controller.this.ihm.reset();
            }
        };
        swingworker.execute();
    }
}

