/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.chloe;

import fr.inra.sad.bagap.apiland.analysis.matrix.pixel.Pixel2PixelMatrixCalculation;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.Raster;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.JaiMatrixFactory;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.MatrixManager;
import java.io.IOException;

public class AnalyzeDifference
extends Pixel2PixelMatrixCalculation {
    private double exact;
    private double total;
    private double sommeE;
    private double sommeT;

    public AnalyzeDifference(Matrix ... m) {
        super(m);
    }

    @Override
    protected double treatPixel(Pixel p) {
        double vi = this.matrix().get(p);
        if (vi != (double)Raster.getNoDataValue()) {
            this.total += 1.0;
            this.sommeT += vi;
            double vt = this.matrix(1).get(p);
            this.sommeE += vt;
            if (vt == vi) {
                this.exact += 1.0;
                return 0.0;
            }
            return vt - vi;
        }
        return 0.0;
    }

    @Override
    protected void doInit() {
        this.exact = 0.0;
        this.total = 0.0;
        this.sommeE = 0.0;
        this.sommeT = 0.0;
    }

    @Override
    protected void doClose() {
        System.out.println("nombre de valeurs exactes = " + this.exact + " (sur " + this.total + ") soit un taux d'exactitude de " + this.exact * 100.0 / this.total + "%");
        System.out.println("somme exacte = " + this.sommeE + " (contre " + this.sommeT + ") soit un taux de corr\u00e9lation globale de " + this.sommeE * 100.0 / this.sommeT + "%");
    }

    public static void main(String[] args) {
        try {
            Matrix bonne = JaiMatrixFactory.get().createWithAsciiGrid("C:/Hugues/temp/chloe/outputs/raster2007_SHDI_0.asc");
            Matrix test = JaiMatrixFactory.get().createWithAsciiGrid("C:/Hugues/temp/chloe/outputs/raster2007_SHDI_2355.asc");
            Matrix diff = new AnalyzeDifference(bonne, test).allRun();
            MatrixManager.exportAsciiGridAndVisualize(diff, "C:/Hugues/temp/chloe/outputs/diff.asc");
            Matrix test2 = JaiMatrixFactory.get().createWithAsciiGrid("C:/Hugues/temp/chloe/outputs/raster2007_SHDI_false.asc");
            Matrix diff2 = new AnalyzeDifference(bonne, test2).allRun();
            MatrixManager.exportAsciiGridAndVisualize(diff2, "C:/Hugues/temp/chloe/outputs/diff2.asc");
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

