/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.chloe.view.treatment;

import fr.inra.sad.bagap.apiland.analysis.matrix.window.shape.WindowShapeType;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Friction;
import fr.inra.sad.bagap.chloe.view.treatment.TreatmentPanel;
import fr.inra.sad.bagap.chloe.view.wizard.Wizard;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;

public class SelectedWindowPanel
extends TreatmentPanel {
    private static final long serialVersionUID = 1L;

    public SelectedWindowPanel(Wizard wizard) {
        super(wizard);
    }

    @Override
    public String toString() {
        return "selected";
    }

    @Override
    protected void locateComponents() {
        title.setText("Selected Window Analysis");
        c = new GridBagConstraints();
        SelectedWindowPanel.c.insets = new Insets(5, 5, 5, 5);
        SelectedWindowPanel.c.gridx = 0;
        SelectedWindowPanel.c.gridy = 0;
        SelectedWindowPanel.c.gridwidth = 0;
        SelectedWindowPanel.c.anchor = 10;
        this.add((Component)title, c);
        SelectedWindowPanel.c.gridx = 0;
        SelectedWindowPanel.c.gridy = 1;
        SelectedWindowPanel.c.gridwidth = 1;
        SelectedWindowPanel.c.anchor = 22;
        this.add((Component)lAsciiInput, c);
        SelectedWindowPanel.c.gridx = 1;
        SelectedWindowPanel.c.gridy = 1;
        SelectedWindowPanel.c.gridwidth = 5;
        SelectedWindowPanel.c.anchor = 21;
        SelectedWindowPanel.c.fill = 2;
        SelectedWindowPanel.c.weightx = 1.0;
        this.add((Component)taAsciiInput, c);
        SelectedWindowPanel.c.gridx = 6;
        SelectedWindowPanel.c.gridy = 1;
        SelectedWindowPanel.c.gridwidth = 1;
        SelectedWindowPanel.c.anchor = 10;
        SelectedWindowPanel.c.fill = 0;
        SelectedWindowPanel.c.weightx = 0.0;
        SelectedWindowPanel.c.weighty = 0.0;
        this.add((Component)bAsciiInput, c);
        SelectedWindowPanel.c.gridx = 7;
        SelectedWindowPanel.c.gridy = 1;
        this.add((Component)bViewAsciiInput, c);
        SelectedWindowPanel.c.gridx = 0;
        SelectedWindowPanel.c.gridy = 3;
        SelectedWindowPanel.c.anchor = 22;
        this.add((Component)lShape, c);
        SelectedWindowPanel.c.gridx = 1;
        SelectedWindowPanel.c.gridy = 3;
        SelectedWindowPanel.c.anchor = 21;
        this.add((Component)cbShape, c);
        SelectedWindowPanel.c.gridx = 2;
        SelectedWindowPanel.c.gridy = 3;
        SelectedWindowPanel.c.anchor = 22;
        this.add((Component)lFriction, c);
        SelectedWindowPanel.c.gridx = 3;
        SelectedWindowPanel.c.gridy = 3;
        SelectedWindowPanel.c.gridwidth = 3;
        SelectedWindowPanel.c.anchor = 21;
        SelectedWindowPanel.c.fill = 2;
        this.add((Component)taFriction, c);
        SelectedWindowPanel.c.gridx = 6;
        SelectedWindowPanel.c.gridy = 3;
        SelectedWindowPanel.c.gridwidth = 1;
        SelectedWindowPanel.c.fill = 0;
        SelectedWindowPanel.c.anchor = 10;
        this.add((Component)bFriction, c);
        SelectedWindowPanel.c.gridx = 0;
        SelectedWindowPanel.c.gridy = 5;
        SelectedWindowPanel.c.anchor = 24;
        this.add((Component)lSize, c);
        SelectedWindowPanel.c.gridx = 1;
        SelectedWindowPanel.c.gridy = 5;
        SelectedWindowPanel.c.anchor = 23;
        this.add((Component)spSize, c);
        SelectedWindowPanel.c.gridx = 2;
        SelectedWindowPanel.c.gridy = 5;
        this.add((Component)bsAdd, c);
        SelectedWindowPanel.c.gridx = 3;
        SelectedWindowPanel.c.gridy = 5;
        this.add((Component)pSize, c);
        SelectedWindowPanel.c.gridx = 4;
        SelectedWindowPanel.c.gridy = 5;
        this.add((Component)bsRem, c);
        SelectedWindowPanel.c.gridx = 0;
        SelectedWindowPanel.c.gridy = 6;
        SelectedWindowPanel.c.anchor = 24;
        this.add((Component)lppSelection, c);
        SelectedWindowPanel.c.gridx = 0;
        SelectedWindowPanel.c.gridy = 7;
        SelectedWindowPanel.c.anchor = 22;
        this.add((Component)rbPixel, c);
        SelectedWindowPanel.c.gridx = 1;
        SelectedWindowPanel.c.gridy = 7;
        SelectedWindowPanel.c.gridwidth = 5;
        SelectedWindowPanel.c.anchor = 21;
        SelectedWindowPanel.c.fill = 2;
        this.add((Component)taPixel, c);
        SelectedWindowPanel.c.gridx = 6;
        SelectedWindowPanel.c.gridy = 7;
        SelectedWindowPanel.c.gridwidth = 1;
        SelectedWindowPanel.c.anchor = 10;
        SelectedWindowPanel.c.fill = 0;
        this.add((Component)bPixel, c);
        SelectedWindowPanel.c.gridx = 0;
        SelectedWindowPanel.c.gridy = 8;
        SelectedWindowPanel.c.anchor = 22;
        this.add((Component)rbPoint, c);
        SelectedWindowPanel.c.gridx = 1;
        SelectedWindowPanel.c.gridy = 8;
        SelectedWindowPanel.c.gridwidth = 5;
        SelectedWindowPanel.c.anchor = 21;
        SelectedWindowPanel.c.fill = 2;
        this.add((Component)taPoint, c);
        SelectedWindowPanel.c.gridx = 6;
        SelectedWindowPanel.c.gridy = 8;
        SelectedWindowPanel.c.gridwidth = 1;
        SelectedWindowPanel.c.anchor = 10;
        SelectedWindowPanel.c.fill = 0;
        this.add((Component)bPoint, c);
        SelectedWindowPanel.c.gridx = 0;
        SelectedWindowPanel.c.gridy = 9;
        SelectedWindowPanel.c.anchor = 22;
        this.add((Component)rbGPixel, c);
        SelectedWindowPanel.c.gridx = 1;
        SelectedWindowPanel.c.gridy = 9;
        this.add((Component)lNPixel, c);
        SelectedWindowPanel.c.gridx = 2;
        SelectedWindowPanel.c.gridy = 9;
        SelectedWindowPanel.c.anchor = 21;
        this.add((Component)spNPixel, c);
        SelectedWindowPanel.c.gridx = 6;
        SelectedWindowPanel.c.gridy = 9;
        SelectedWindowPanel.c.anchor = 10;
        this.add((Component)bRunPixel, c);
        SelectedWindowPanel.c.gridx = 0;
        SelectedWindowPanel.c.gridy = 10;
        SelectedWindowPanel.c.anchor = 22;
        this.add((Component)lConstraint, c);
        SelectedWindowPanel.c.gridx = 1;
        SelectedWindowPanel.c.gridy = 10;
        SelectedWindowPanel.c.anchor = 21;
        this.add((Component)cbMinDistance, c);
        SelectedWindowPanel.c.gridx = 2;
        SelectedWindowPanel.c.gridy = 10;
        this.add((Component)spMinDistance, c);
        SelectedWindowPanel.c.gridx = 1;
        SelectedWindowPanel.c.gridy = 11;
        SelectedWindowPanel.c.anchor = 23;
        this.add((Component)cbCI, c);
        SelectedWindowPanel.c.gridx = 2;
        SelectedWindowPanel.c.gridy = 11;
        this.add((Component)pCI, c);
        SelectedWindowPanel.c.gridx = 4;
        SelectedWindowPanel.c.gridy = 11;
        this.add((Component)cbCNI, c);
        SelectedWindowPanel.c.gridx = 5;
        SelectedWindowPanel.c.gridy = 11;
        this.add((Component)pCNI, c);
        SelectedWindowPanel.c.gridx = 6;
        SelectedWindowPanel.c.gridy = 11;
        this.add((Component)bExportPixel, c);
        SelectedWindowPanel.c.gridx = 7;
        SelectedWindowPanel.c.gridy = 11;
        this.add((Component)bExportPoint, c);
        SelectedWindowPanel.c.gridx = 0;
        SelectedWindowPanel.c.gridy = 13;
        SelectedWindowPanel.c.anchor = 22;
        this.add((Component)lType, c);
        SelectedWindowPanel.c.gridx = 1;
        SelectedWindowPanel.c.gridy = 13;
        SelectedWindowPanel.c.anchor = 21;
        this.add((Component)cbType, c);
        SelectedWindowPanel.c.gridx = 3;
        SelectedWindowPanel.c.gridy = 13;
        SelectedWindowPanel.c.anchor = 22;
        this.add((Component)lMaxRate, c);
        SelectedWindowPanel.c.gridx = 4;
        SelectedWindowPanel.c.gridy = 13;
        SelectedWindowPanel.c.anchor = 21;
        this.add((Component)spMaxRate, c);
        SelectedWindowPanel.c.gridx = 0;
        SelectedWindowPanel.c.gridy = 14;
        SelectedWindowPanel.c.anchor = 24;
        this.add((Component)lMetrics, c);
        SelectedWindowPanel.c.gridx = 1;
        SelectedWindowPanel.c.gridy = 14;
        SelectedWindowPanel.c.gridheight = 3;
        SelectedWindowPanel.c.gridwidth = 2;
        SelectedWindowPanel.c.anchor = 21;
        SelectedWindowPanel.c.fill = 2;
        this.add((Component)pLMetrics, c);
        SelectedWindowPanel.c.gridx = 3;
        SelectedWindowPanel.c.gridy = 14;
        SelectedWindowPanel.c.gridheight = 1;
        SelectedWindowPanel.c.gridwidth = 1;
        SelectedWindowPanel.c.anchor = 10;
        SelectedWindowPanel.c.fill = 0;
        this.add((Component)bmAll, c);
        SelectedWindowPanel.c.gridx = 3;
        SelectedWindowPanel.c.gridy = 15;
        this.add((Component)bmAdd, c);
        SelectedWindowPanel.c.gridx = 3;
        SelectedWindowPanel.c.gridy = 16;
        SelectedWindowPanel.c.anchor = 19;
        this.add((Component)bmRem, c);
        SelectedWindowPanel.c.gridx = 4;
        SelectedWindowPanel.c.gridy = 14;
        SelectedWindowPanel.c.gridheight = 3;
        SelectedWindowPanel.c.gridwidth = 2;
        SelectedWindowPanel.c.anchor = 21;
        SelectedWindowPanel.c.fill = 2;
        this.add((Component)pCMetrics, c);
        SelectedWindowPanel.c.gridx = 0;
        SelectedWindowPanel.c.gridy = 17;
        SelectedWindowPanel.c.gridheight = 1;
        SelectedWindowPanel.c.gridwidth = 1;
        SelectedWindowPanel.c.fill = 0;
        SelectedWindowPanel.c.anchor = 22;
        this.add((Component)lOutputFolder, c);
        SelectedWindowPanel.c.gridx = 1;
        SelectedWindowPanel.c.gridy = 17;
        SelectedWindowPanel.c.gridwidth = 5;
        SelectedWindowPanel.c.anchor = 23;
        SelectedWindowPanel.c.fill = 2;
        SelectedWindowPanel.c.weightx = 1.0;
        this.add((Component)taOutputFolder, c);
        SelectedWindowPanel.c.gridx = 6;
        SelectedWindowPanel.c.gridy = 17;
        SelectedWindowPanel.c.gridwidth = 1;
        SelectedWindowPanel.c.anchor = 19;
        SelectedWindowPanel.c.fill = 0;
        SelectedWindowPanel.c.weightx = 0.0;
        this.add((Component)bOutputFolder, c);
        SelectedWindowPanel.c.gridx = 1;
        SelectedWindowPanel.c.gridy = 18;
        SelectedWindowPanel.c.weighty = 1.0;
        SelectedWindowPanel.c.anchor = 23;
        SelectedWindowPanel.c.fill = 0;
        this.add((Component)exportCsv, c);
        SelectedWindowPanel.c.gridx = 2;
        SelectedWindowPanel.c.gridy = 18;
        this.add((Component)exportAscii, c);
        SelectedWindowPanel.c.gridx = 3;
        SelectedWindowPanel.c.gridy = 18;
        this.add((Component)viewAsciiOutput, c);
    }

    @Override
    public boolean validateRun(List<String> list) {
        int r;
        boolean validate = true;
        if (inputMatrix.size() == 0) {
            list.add("Please choose an ascci grid input matrix file");
            validate = false;
        }
        if (tSize.getModel().getRowCount() < 1) {
            list.add("Please select at least one window size");
            validate = false;
        } else {
            windowSizes = new ArrayList();
            for (r = 0; r < tSize.getModel().getRowCount(); ++r) {
                windowSizes.add((Integer)tSize.getModel().getValueAt(r, 0));
            }
        }
        if (cbShape.getSelectedItem().equals((Object)WindowShapeType.FUNCTIONAL)) {
            if (frictionMatrix == null) {
                friction = new Friction(taFriction.getText());
            }
        } else {
            friction = null;
        }
        if (tCMetrics.getModel().getRowCount() == 0) {
            list.add("Please choose metrics to calculate");
            validate = false;
        } else {
            metrics = new TreeSet();
            for (r = 0; r < tCMetrics.getModel().getRowCount(); ++r) {
                metrics.add((String)tCMetrics.getModel().getValueAt(r, 0));
            }
        }
        if (taOutputFolder.getText().equalsIgnoreCase("")) {
            list.add("Please choose an ascci grid output matrix file");
            validate = false;
        }
        return validate;
    }

    @Override
    public void doImport(Properties properties) {
        this.importInputAscii(properties);
        this.importShape(properties);
        this.importWindowSizes(properties);
        this.importMaximumNoValueRate(properties);
        this.importPixels(properties);
        this.importPoints(properties);
        this.importGeneratedPixels(properties);
        this.importMinimumDistance(properties);
        this.importFilters(properties);
        this.importUnfilters(properties);
        this.importMetrics(properties);
        this.importOutputFolder(properties);
        this.importExportCsv(properties);
        this.importExportAscii(properties);
        this.importVisualizeAscii(properties);
    }

    @Override
    public void doExport(Properties properties) {
        this.exportInputAscii(properties);
        this.exportShape(properties);
        this.exportWindowSizes(properties);
        this.exportMaximumNoValueRate(properties);
        this.exportPixels(properties);
        this.exportPoints(properties);
        this.exportGeneratedPixels(properties);
        this.exportMinimumDistance(properties);
        this.exportFilters(properties);
        this.exportUnfilters(properties);
        this.exportMetrics(properties);
        this.exportOutputFolder(properties);
        this.exportExportCsv(properties);
        this.exportExportAscii(properties);
        this.exportVisualizeAscii(properties);
    }

    @Override
    public void run() {
        SelectedWindowPanel.getController().runSelectedWindow(inputMatrix, 1.0 - (double)((Integer)spMaxRate.getValue()).intValue() / 100.0, (WindowShapeType)((Object)cbShape.getSelectedItem()), friction, frictionMatrix, windowSizes, pixels, metrics, taOutputFolder.getText(), exportAscii.isSelected() && viewAsciiOutput.isSelected(), exportCsv.isSelected(), exportAscii.isSelected());
    }
}

