/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.chloe.view.treatment;

import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Friction;
import fr.inra.sad.bagap.chloe.view.treatment.TreatmentPanel;
import fr.inra.sad.bagap.chloe.view.wizard.Wizard;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class ClusterPanel
extends TreatmentPanel {
    private static final long serialVersionUID = 1L;
    private Set<Integer> vclusters;
    private String typeCluster;
    private double distance;

    public ClusterPanel(Wizard wizard) {
        super(wizard);
    }

    @Override
    public String toString() {
        return "cluster";
    }

    @Override
    protected void locateComponents() {
        title.setText("Cluster");
        c = new GridBagConstraints();
        ClusterPanel.c.insets = new Insets(10, 10, 10, 10);
        ClusterPanel.c.gridx = 0;
        ClusterPanel.c.gridy = 0;
        ClusterPanel.c.gridwidth = 0;
        ClusterPanel.c.anchor = 10;
        this.add((Component)title, c);
        ClusterPanel.c.gridx = 0;
        ClusterPanel.c.gridy = 1;
        ClusterPanel.c.gridwidth = 1;
        ClusterPanel.c.anchor = 22;
        this.add((Component)lAsciiInput, c);
        ClusterPanel.c.gridx = 1;
        ClusterPanel.c.gridy = 1;
        ClusterPanel.c.anchor = 21;
        ClusterPanel.c.fill = 2;
        ClusterPanel.c.weightx = 3.0;
        ClusterPanel.c.gridwidth = 3;
        this.add((Component)taAsciiInput, c);
        ClusterPanel.c.gridx = 4;
        ClusterPanel.c.gridy = 1;
        ClusterPanel.c.anchor = 10;
        ClusterPanel.c.fill = 0;
        ClusterPanel.c.weightx = 0.0;
        ClusterPanel.c.gridwidth = 1;
        this.add((Component)bAsciiInput, c);
        ClusterPanel.c.gridx = 5;
        ClusterPanel.c.gridy = 1;
        this.add((Component)bViewAsciiInput, c);
        ClusterPanel.c.gridx = 0;
        ClusterPanel.c.gridy = 3;
        ClusterPanel.c.anchor = 24;
        this.add((Component)lClusters, c);
        ClusterPanel.c.gridx = 1;
        ClusterPanel.c.gridy = 3;
        ClusterPanel.c.anchor = 23;
        ClusterPanel.c.fill = 0;
        ClusterPanel.c.weighty = 0.0;
        ClusterPanel.c.gridheight = 4;
        this.add((Component)pDistances, c);
        ClusterPanel.c.gridx = 2;
        ClusterPanel.c.gridy = 3;
        ClusterPanel.c.gridheight = 1;
        ClusterPanel.c.anchor = 23;
        ClusterPanel.c.anchor = 21;
        this.add((Component)rbRook, c);
        ClusterPanel.c.gridx = 2;
        ClusterPanel.c.gridy = 4;
        this.add((Component)rbQueen, c);
        ClusterPanel.c.gridx = 2;
        ClusterPanel.c.gridy = 5;
        this.add((Component)rbEuclidianDistance, c);
        ClusterPanel.c.gridx = 3;
        ClusterPanel.c.gridy = 5;
        this.add((Component)spEuclidianDistanceCluster, c);
        ClusterPanel.c.gridx = 2;
        ClusterPanel.c.gridy = 6;
        this.add((Component)rbFunctionalDistance, c);
        ClusterPanel.c.gridx = 3;
        ClusterPanel.c.gridy = 6;
        this.add((Component)spFunctionalDistanceCluster, c);
        ClusterPanel.c.gridx = 2;
        ClusterPanel.c.gridy = 7;
        ClusterPanel.c.anchor = 22;
        this.add((Component)lFriction, c);
        ClusterPanel.c.gridx = 3;
        ClusterPanel.c.gridy = 7;
        ClusterPanel.c.anchor = 21;
        ClusterPanel.c.fill = 2;
        this.add((Component)taFrictionCluster, c);
        ClusterPanel.c.gridx = 4;
        ClusterPanel.c.gridy = 7;
        ClusterPanel.c.anchor = 21;
        ClusterPanel.c.fill = 0;
        this.add((Component)bFrictionCluster, c);
        ClusterPanel.c.gridx = 0;
        ClusterPanel.c.gridy = 8;
        ClusterPanel.c.anchor = 22;
        this.add((Component)lOutputFolder, c);
        ClusterPanel.c.gridx = 1;
        ClusterPanel.c.gridy = 8;
        ClusterPanel.c.anchor = 23;
        ClusterPanel.c.fill = 2;
        ClusterPanel.c.weightx = 1.0;
        ClusterPanel.c.gridwidth = 3;
        this.add((Component)taOutputFolder, c);
        ClusterPanel.c.gridx = 4;
        ClusterPanel.c.gridy = 8;
        ClusterPanel.c.anchor = 19;
        ClusterPanel.c.fill = 0;
        ClusterPanel.c.weightx = 0.0;
        ClusterPanel.c.gridwidth = 1;
        this.add((Component)bOutputFolder, c);
        ClusterPanel.c.gridx = 1;
        ClusterPanel.c.gridy = 9;
        ClusterPanel.c.weighty = 1.0;
        ClusterPanel.c.anchor = 23;
        ClusterPanel.c.fill = 0;
        this.add((Component)viewAsciiOutput, c);
    }

    @Override
    public boolean validateRun(List<String> list) {
        boolean validate = true;
        this.vclusters = new HashSet<Integer>();
        for (int r : tDistances.getSelectedRows()) {
            this.vclusters.add((Integer)tDistances.getModel().getValueAt(r, 0));
        }
        if (rbRook.isSelected()) {
            this.typeCluster = "rook";
        } else if (rbQueen.isSelected()) {
            this.typeCluster = "queen";
        } else if (rbEuclidianDistance.isSelected()) {
            this.typeCluster = "euclidian";
            this.distance = (Double)spEuclidianDistanceCluster.getValue();
        } else {
            this.typeCluster = "functional";
            this.distance = (Double)spFunctionalDistanceCluster.getValue();
            if (clusterFrictionMatrix == null) {
                clusterFriction = new Friction(taFrictionCluster.getText());
            }
        }
        if (taOutputFolder.getText().equalsIgnoreCase("")) {
            list.add("Please choose an ascci grid output matrix file");
            validate = false;
        }
        return validate;
    }

    @Override
    public void doImport(Properties properties) {
        this.importInputAscii(properties);
        this.importCluster(properties);
        this.importClusterType(properties);
        this.importClusterDistance(properties);
        this.importClusterFriction(properties);
        this.importClusterFrictionMatrix(properties);
        this.importOutputFolder(properties);
        this.importVisualizeAscii(properties);
    }

    @Override
    public void doExport(Properties properties) {
        this.exportInputAscii(properties);
        this.exportCluster(properties);
        this.exportClusterType(properties);
        this.exportClusterDistance(properties);
        this.exportClusterFriction(properties);
        this.exportClusterFrictionMatrix(properties);
        this.exportOutputFolder(properties);
        this.exportVisualizeAscii(properties);
    }

    @Override
    public void run() {
        ClusterPanel.getController().runCluster(inputMatrix, this.vclusters, this.typeCluster, this.distance, clusterFriction, clusterFrictionMatrix, taOutputFolder.getText(), viewAsciiOutput.isSelected());
    }
}

