/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.visitor;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.visitor.Aggregate;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.FeatureAttributeVisitor;
import org.geotools.feature.visitor.FeatureCalc;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.expression.Expression;
import org.opengis.util.ProgressListener;

public class GroupByVisitor
implements FeatureCalc,
FeatureAttributeVisitor {
    private final Aggregate aggregateVisitor;
    private final Expression aggregateAttribute;
    private final FeatureCalc aggregateVisitorProtoType;
    private final List<Expression> groupByAttributes;
    private final ProgressListener progressListener;
    private final InMemoryGroupBy inMemoryGroupBy = new InMemoryGroupBy();
    private CalcResult optimizationResult = CalcResult.NULL_RESULT;

    public GroupByVisitor(Aggregate aggregateVisitor, Expression aggregateAttribute, List<Expression> groupByAttributes, ProgressListener progressListener) {
        this.aggregateVisitor = aggregateVisitor;
        this.aggregateAttribute = aggregateAttribute;
        this.groupByAttributes = groupByAttributes;
        this.progressListener = progressListener;
        this.aggregateVisitorProtoType = aggregateVisitor.create(aggregateAttribute);
    }

    public boolean wasOptimized() {
        return this.optimizationResult != null;
    }

    public boolean wasVisited() {
        return !this.inMemoryGroupBy.groupByIndexes.isEmpty();
    }

    @Override
    public CalcResult getResult() {
        Map<List<Object>, CalcResult> results = this.inMemoryGroupBy.visit();
        GroupByResult result = new GroupByResult(results, this.aggregateVisitor, this.groupByAttributes);
        if (this.optimizationResult == CalcResult.NULL_RESULT) {
            return result;
        }
        return this.optimizationResult.merge(result);
    }

    public void visit(Feature feature) {
        this.inMemoryGroupBy.index((SimpleFeature)feature);
    }

    public Expression getExpression() {
        return this.aggregateAttribute;
    }

    public FeatureVisitor getAggregateVisitor() {
        return this.aggregateVisitorProtoType;
    }

    public List<Expression> getGroupByAttributes() {
        return this.groupByAttributes;
    }

    public void setValue(List<GroupByRawResult> value) {
        HashMap<List<Object>, CalcResult> results = new HashMap<List<Object>, CalcResult>();
        for (GroupByRawResult groupByRawResult : value) {
            results.put(groupByRawResult.groupByValues, this.aggregateVisitor.wrap(this.aggregateAttribute, groupByRawResult.visitorValue));
        }
        GroupByResult newResult = new GroupByResult(results, this.aggregateVisitor, this.groupByAttributes);
        this.optimizationResult = this.optimizationResult == CalcResult.NULL_RESULT ? newResult : this.optimizationResult.merge(newResult);
    }

    @Override
    public List<Expression> getExpressions() {
        ArrayList<Expression> result = new ArrayList<Expression>(this.groupByAttributes);
        result.add(this.aggregateAttribute);
        return result;
    }

    public static class GroupByResult
    implements CalcResult {
        private final Map<List<Object>, CalcResult> results;
        private final Aggregate aggregateVisitor;
        private final List<Expression> groupByAttributes;

        public GroupByResult(Map<List<Object>, CalcResult> results, Aggregate aggregateVisitor, List<Expression> groupByAttributes) {
            this.results = results;
            this.aggregateVisitor = aggregateVisitor;
            this.groupByAttributes = groupByAttributes;
        }

        public Map<List<Object>, CalcResult> getResults() {
            return this.results;
        }

        public Aggregate getAggregateVisitor() {
            return this.aggregateVisitor;
        }

        public List<Expression> getGroupByAttributes() {
            return this.groupByAttributes;
        }

        @Override
        public boolean isCompatible(CalcResult newResult) {
            if (newResult == CalcResult.NULL_RESULT) {
                return true;
            }
            if (!(newResult instanceof GroupByResult)) {
                return false;
            }
            GroupByResult groupByResult = (GroupByResult)newResult;
            return this.aggregateVisitor == groupByResult.getAggregateVisitor() && this.groupByAttributes.equals(groupByResult.getGroupByAttributes());
        }

        @Override
        public CalcResult merge(CalcResult newResult) {
            if (!this.isCompatible(newResult)) {
                throw new IllegalArgumentException(String.format("Feature calculation result '%s' is not compatible it this result '%s'.", newResult.getClass().getSimpleName(), GroupByResult.class.getSimpleName()));
            }
            if (newResult == CalcResult.NULL_RESULT) {
                return new GroupByResult(this.results, this.aggregateVisitor, this.groupByAttributes);
            }
            HashMap<List<Object>, CalcResult> mergedResults = new HashMap<List<Object>, CalcResult>(this.results);
            for (Map.Entry<List<Object>, CalcResult> entry : ((GroupByResult)newResult).getResults().entrySet()) {
                CalcResult existingResult = (CalcResult)mergedResults.get(entry.getKey());
                if (existingResult != null) {
                    mergedResults.put(entry.getKey(), existingResult.merge(entry.getValue()));
                    continue;
                }
                mergedResults.put(entry.getKey(), entry.getValue());
            }
            return new GroupByResult(mergedResults, this.aggregateVisitor, this.groupByAttributes);
        }

        @Override
        public Object getValue() {
            return this.toArray();
        }

        @Override
        public int toInt() {
            return 0;
        }

        @Override
        public double toDouble() {
            return 0.0;
        }

        @Override
        public String toString() {
            return null;
        }

        @Override
        public long toLong() {
            return 0L;
        }

        @Override
        public float toFloat() {
            return 0.0f;
        }

        @Override
        public Geometry toGeometry() {
            return null;
        }

        @Override
        public Envelope toEnvelope() {
            return null;
        }

        @Override
        public Point toPoint() {
            return null;
        }

        @Override
        public Set toSet() {
            HashSet<Object[]> set = new HashSet<Object[]>();
            for (Map.Entry<List<Object>, CalcResult> result : this.results.entrySet()) {
                set.add(this.entryToArray(result));
            }
            return set;
        }

        @Override
        public List toList() {
            ArrayList<Object[]> list = new ArrayList<Object[]>();
            for (Map.Entry<List<Object>, CalcResult> result : this.results.entrySet()) {
                list.add(this.entryToArray(result));
            }
            return list;
        }

        @Override
        public Object[] toArray() {
            Object[][] array = new Object[this.results.size()][];
            int index = 0;
            for (Map.Entry<List<Object>, CalcResult> result : this.results.entrySet()) {
                array[index] = this.entryToArray(result);
                ++index;
            }
            return array;
        }

        @Override
        public Map toMap() {
            HashMap<List<Object>, Object> map = new HashMap<List<Object>, Object>();
            for (Map.Entry<List<Object>, CalcResult> result : this.results.entrySet()) {
                map.put(result.getKey(), result.getValue().getValue());
            }
            return map;
        }

        private Object[] entryToArray(Map.Entry<List<Object>, CalcResult> entry) {
            Object[] result = Arrays.copyOf(entry.getKey().toArray(), entry.getKey().size() + 1);
            result[entry.getKey().size()] = entry.getValue().getValue();
            return result;
        }
    }

    private class InMemoryGroupBy {
        private final Map<List<Object>, DefaultFeatureCollection> groupByIndexes = new HashMap<List<Object>, DefaultFeatureCollection>();

        private InMemoryGroupBy() {
        }

        void index(SimpleFeature feature) {
            ArrayList<Object> groupByValues = new ArrayList<Object>();
            for (Expression expression : GroupByVisitor.this.groupByAttributes) {
                groupByValues.add(expression.evaluate((Object)feature));
            }
            DefaultFeatureCollection featureCollection = this.groupByIndexes.get(groupByValues);
            if (featureCollection == null) {
                featureCollection = new DefaultFeatureCollection();
                this.groupByIndexes.put(groupByValues, featureCollection);
            }
            featureCollection.add(feature);
        }

        Map<List<Object>, CalcResult> visit() {
            HashMap<List<Object>, CalcResult> results = new HashMap<List<Object>, CalcResult>();
            for (Map.Entry<List<Object>, DefaultFeatureCollection> entry : this.groupByIndexes.entrySet()) {
                FeatureCalc visitor = GroupByVisitor.this.aggregateVisitor.create(GroupByVisitor.this.aggregateAttribute);
                try {
                    entry.getValue().accepts(visitor, GroupByVisitor.this.progressListener);
                }
                catch (Exception exception) {
                    throw new RuntimeException("Error visiting features collections.", exception);
                }
                results.put(entry.getKey(), visitor.getResult());
            }
            return results;
        }
    }

    public static class GroupByRawResult {
        final List<Object> groupByValues;
        final Object visitorValue;

        public GroupByRawResult(List<Object> groupByValues, Object visitorsValue) {
            this.groupByValues = groupByValues;
            this.visitorValue = visitorsValue;
        }
    }
}

