/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite.gridcoverage2d;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.geotools.filter.FilterFactoryImpl;
import org.geotools.styling.ColorMap;
import org.geotools.styling.ColorMapEntry;
import org.geotools.styling.ColorMapEntryImpl;
import org.geotools.styling.ColorMapImpl;
import org.geotools.util.SoftValueHashMap;
import org.geotools.util.Utilities;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class GradientColorMapGenerator {
    public static final String RGB_INLINEVALUE_MARKER = "rgb(";
    public static final String HEX_INLINEVALUE_MARKER = "#";
    private LinearGradientEntry[] entries;
    private static SoftValueHashMap<String, GradientColorMapGenerator> cache = new SoftValueHashMap();
    private static FilterFactory filterFactory = new FilterFactoryImpl();

    private GradientColorMapGenerator(LinearGradientEntry[] entries) {
        this.entries = entries;
    }

    public ColorMap generateColorMap(double min, double max) {
        int i;
        int numEntries = this.entries.length;
        double range = max - min;
        boolean intervals = false;
        for (int i2 = 0; i2 < numEntries - 2; i2 += 2) {
            intervals = Double.compare(this.entries[i2 + 1].percentage, this.entries[i2 + 2].percentage) == 0;
        }
        ColorMapImpl colorMap = new ColorMapImpl();
        double start = min - (intervals ? 0.0 : 0.01);
        ColorMapEntry entry = this.entries[0].getColorMapEntry(start);
        entry.setOpacity((Expression)filterFactory.literal(0));
        colorMap.addColorMapEntry(entry);
        if (intervals) {
            colorMap.setType(2);
            for (i = 1; i < numEntries - 1; i += 2) {
                colorMap.addColorMapEntry(this.entries[i].getColorMapEntry(min, range));
            }
        } else {
            colorMap.setType(1);
            for (i = 0; i < numEntries - 1; ++i) {
                colorMap.addColorMapEntry(this.entries[i].getColorMapEntry(min, range));
            }
        }
        colorMap.addColorMapEntry(this.entries[numEntries - 1].getColorMapEntry(max));
        ColorMapEntry entryEnd = this.entries[numEntries - 1].getColorMapEntry(max + 0.01);
        entryEnd.setOpacity((Expression)filterFactory.literal(0));
        colorMap.addColorMapEntry(entryEnd);
        return colorMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GradientColorMapGenerator getColorMapGenerator(File file) throws SAXException, IOException, ParserConfigurationException {
        GradientColorMapGenerator generator = null;
        Utilities.ensureNonNull((String)"file", (Object)file);
        String identifier = file.getAbsolutePath();
        SoftValueHashMap<String, GradientColorMapGenerator> softValueHashMap = cache;
        synchronized (softValueHashMap) {
            if (cache.containsKey((Object)identifier)) {
                generator = (GradientColorMapGenerator)cache.get((Object)identifier);
            } else {
                generator = GradientColorMapGenerator.parseSVG(file);
                cache.put((Object)identifier, (Object)generator);
            }
        }
        return generator;
    }

    public static GradientColorMapGenerator getColorMapGenerator(String colorValues) throws IOException, ParserConfigurationException {
        Utilities.ensureNonNull((String)"colorValues", (Object)colorValues);
        if (colorValues.startsWith(RGB_INLINEVALUE_MARKER) || colorValues.startsWith(HEX_INLINEVALUE_MARKER)) {
            String rampType = "ramp";
            if (colorValues.contains(":")) {
                int rampTypeIndex = colorValues.indexOf(":");
                rampType = colorValues.substring(rampTypeIndex + 1);
                colorValues = colorValues.substring(0, rampTypeIndex);
            }
            String[] colors = colorValues.split(";");
            int numEntries = colors.length;
            LinearGradientEntry[] entries = new LinearGradientEntry[numEntries];
            double step = 1.0 / (double)(numEntries - 1);
            for (int i = 0; i < numEntries; ++i) {
                entries[i] = new LinearGradientEntry(step * (double)i, GradientColorMapGenerator.createColor(colors[i]), 1.0);
            }
            GradientColorMapGenerator generator = new GradientColorMapGenerator(entries);
            return generator;
        }
        throw new IOException("Unable to parse the specified colors: " + colorValues);
    }

    private static GradientColorMapGenerator parseSVG(File xmlFile) throws SAXException, IOException, ParserConfigurationException {
        Utilities.ensureNonNull((String)"xmlFile", (Object)xmlFile);
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(xmlFile);
        doc.getDocumentElement().normalize();
        NodeList nList = doc.getElementsByTagName("stop");
        int numEntries = nList.getLength();
        LinearGradientEntry[] gradientEntries = new LinearGradientEntry[numEntries];
        for (int i = 0; i < numEntries; ++i) {
            Node node = nList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            String offset = element.getAttribute("offset");
            String stopColor = element.getAttribute("stop-color");
            String stopOpacity = element.getAttribute("stop-opacity");
            double percentage = Double.parseDouble(offset.substring(0, offset.length() - 1)) / 100.0;
            double opacity = Double.parseDouble(stopOpacity);
            Color color = GradientColorMapGenerator.createColor(stopColor);
            gradientEntries[i] = new LinearGradientEntry(percentage, color, opacity);
        }
        GradientColorMapGenerator generator = new GradientColorMapGenerator(gradientEntries);
        return generator;
    }

    private static Color createColor(String color) {
        Utilities.ensureNonNull((String)"color", (Object)color);
        if (color.contains("rgb")) {
            String colorString = color.substring(4, color.length() - 1);
            String[] rgbs = colorString.split(",");
            return new Color(Integer.parseInt(rgbs[0]), Integer.parseInt(rgbs[1]), Integer.parseInt(rgbs[2]));
        }
        if (color.startsWith(HEX_INLINEVALUE_MARKER) && color.length() == 7) {
            return GradientColorMapGenerator.hex2Rgb(color);
        }
        throw new UnsupportedOperationException("Support for the following color ins't currently supported: " + color);
    }

    public static Color hex2Rgb(String colorStr) {
        return new Color(Integer.valueOf(colorStr.substring(1, 3), 16), Integer.valueOf(colorStr.substring(3, 5), 16), Integer.valueOf(colorStr.substring(5, 7), 16));
    }

    static class LinearGradientEntry {
        private double opacity;
        private double percentage;
        private Color color;

        public LinearGradientEntry(double percentage, Color color, double opacity) {
            this.percentage = percentage;
            this.opacity = opacity;
            this.color = color;
        }

        private ColorMapEntry getColorMapEntry(double value) {
            return this.getColorMapEntry(value, Double.NaN);
        }

        private ColorMapEntry getColorMapEntry(double min, double range) {
            ColorMapEntryImpl entry = new ColorMapEntryImpl();
            entry.setOpacity((Expression)filterFactory.literal(this.opacity));
            entry.setColor((Expression)filterFactory.literal((Object)LinearGradientEntry.toHexColor(this.color)));
            entry.setQuantity((Expression)filterFactory.literal(min + (Double.isNaN(range) ? 0.0 : this.percentage * range)));
            return entry;
        }

        private static String toHexColor(Color color) {
            Utilities.ensureNonNull((String)"color", (Object)color);
            String hexColour = Integer.toHexString(color.getRGB() & 0xFFFFFF);
            return GradientColorMapGenerator.HEX_INLINEVALUE_MARKER + hexColour;
        }
    }
}

