/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.imageioimpl.imagereadmt;

import it.geosolutions.imageio.imageioimpl.imagereadmt.CloneableImageReadParam;
import it.geosolutions.imageio.imageioimpl.imagereadmt.I18N;
import it.geosolutions.imageio.imageioimpl.imagereadmt.ImageReadMTCRIF;
import it.geosolutions.imageio.imageioimpl.imagereadmt.ImageReadPropertyGenerator;
import java.awt.RenderingHints;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.InputStream;
import java.net.Socket;
import java.util.Collection;
import java.util.EventListener;
import java.util.Locale;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.OperationRegistry;
import javax.media.jai.PropertyGenerator;
import javax.media.jai.RegistryElementDescriptor;
import javax.media.jai.RenderableOp;
import javax.media.jai.RenderedOp;

public class ImageReadDescriptorMT
extends OperationDescriptorImpl {
    public static final String PROPERTY_NAME_IMAGE_READ_PARAM = "JAI.ImageReadParam";
    public static final String PROPERTY_NAME_IMAGE_READER = "JAI.ImageReader";
    public static final String PROPERTY_NAME_METADATA_IMAGE = "JAI.ImageMetadata";
    public static final String PROPERTY_NAME_METADATA_STREAM = "JAI.StreamMetadata";
    public static final String PROPERTY_NAME_THUMBNAILS = "JAI.Thumbnails";
    public static final String PROPERTY_NAME_RENDERABLE_INPUT = "JAI.RenderableInput";
    private static final String OPERATION_NAME = "ImageReadMT";
    private static final String[][] resources = new String[][]{{"GlobalName", "ImageReadMT"}, {"LocalName", "ImageReadMT"}, {"Vendor", "it.geosolutions"}, {"Description", I18N.getString("ImageReadDescriptor0")}, {"DocURL", "http://java.sun.com/products/java-media/jai/forDevelopers/jai-apidocs/javax/media/jai/operator/ImageReadDescriptorMT.html"}, {"Version", I18N.getString("DescriptorVersion")}, {"arg0Desc", I18N.getString("ImageReadDescriptor1")}, {"arg1Desc", I18N.getString("ImageReadDescriptor2")}, {"arg2Desc", I18N.getString("ImageReadDescriptor3")}, {"arg3Desc", I18N.getString("ImageReadDescriptor4")}, {"arg4Desc", I18N.getString("ImageReadDescriptor5")}, {"arg5Desc", I18N.getString("ImageReadDescriptor6")}, {"arg6Desc", I18N.getString("ImageReadDescriptor7")}, {"arg7Desc", I18N.getString("ImageReadDescriptor8")}, {"arg8Desc", I18N.getString("ImageReadDescriptor9")}};
    private static final String[] paramNames = new String[]{"Input", "ImageChoice", "ReadMetadata", "ReadThumbnails", "VerifyInput", "Listeners", "Locale", "ReadParam", "Reader"};
    private static final Class[] renderedParamClasses = new Class[]{Object.class, Integer.class, Boolean.class, Boolean.class, Boolean.class, EventListener[].class, Locale.class, CloneableImageReadParam.class, ImageReader.class};
    private static final Object[] renderedParamDefaults = new Object[]{NO_PARAMETER_DEFAULT, new Integer(0), Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, null, null, null, null};
    private static final Class[] renderableParamClasses = new Class[]{Object.class, int[].class, Boolean.class, Boolean.class, Boolean.class, EventListener[].class, Locale.class, ImageReadParam.class, ImageReader.class};
    private static final Object[] renderableParamDefaults = new Object[]{NO_PARAMETER_DEFAULT, null, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, null, null, null, null};
    private static final Class[] collectionParamClasses = renderableParamClasses;
    private static final Object[] collectionParamDefaults = renderableParamDefaults;

    public static synchronized void register(JAI jai) {
        OperationRegistry registry = jai.getOperationRegistry();
        try {
            registry.registerDescriptor((RegistryElementDescriptor)new ImageReadDescriptorMT());
            registry.registerFactory("rendered", OPERATION_NAME, "it.geosolutions", (Object)new ImageReadMTCRIF());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public ImageReadDescriptorMT() {
        super(resources, new String[]{"rendered", "renderable", "collection"}, null, (Class[][])new Class[][]{null, null, null}, paramNames, (Class[][])new Class[][]{renderedParamClasses, renderableParamClasses, collectionParamClasses}, (Object[][])new Object[][]{renderedParamDefaults, renderableParamDefaults, collectionParamDefaults}, (Object[][])new Object[][]{null, null, null});
    }

    public static RenderedOp create(ImageInputStream input, Integer imageChoice, Boolean readMetadata, Boolean readThumbnails, Boolean verifyInput, EventListener[] listeners, Locale locale, CloneableImageReadParam readParam, ImageReader reader, RenderingHints hints) {
        ParameterBlock args = new ParameterBlock();
        args.add(input);
        args.add(imageChoice);
        args.add(readMetadata);
        args.add(readThumbnails);
        args.add(verifyInput);
        args.add(listeners);
        args.add(locale);
        args.add(readParam);
        args.add(reader);
        return JAI.create((String)OPERATION_NAME, (ParameterBlock)args, (RenderingHints)hints);
    }

    public static Collection createCollection(ImageInputStream input, int[] imageChoice, Boolean readMetadata, Boolean readThumbnails, Boolean verifyInput, EventListener[] listeners, Locale locale, ImageReadParam readParam, ImageReader reader, RenderingHints hints) {
        ParameterBlock args = new ParameterBlock();
        args.add(input);
        args.add(imageChoice);
        args.add(readMetadata);
        args.add(readThumbnails);
        args.add(verifyInput);
        args.add(listeners);
        args.add(locale);
        args.add(readParam);
        args.add(reader);
        return JAI.createCollection((String)OPERATION_NAME, (ParameterBlock)args, (RenderingHints)hints);
    }

    public static RenderableOp createRenderable(ImageInputStream input, int[] imageChoice, Boolean readMetadata, Boolean readThumbnails, Boolean verifyInput, EventListener[] listeners, Locale locale, ImageReadParam readParam, ImageReader reader, RenderingHints hints) {
        ParameterBlock args = new ParameterBlock();
        args.add(input);
        args.add(imageChoice);
        args.add(readMetadata);
        args.add(readThumbnails);
        args.add(verifyInput);
        args.add(listeners);
        args.add(locale);
        args.add(readParam);
        args.add(reader);
        return JAI.createRenderable((String)OPERATION_NAME, (ParameterBlock)args, (RenderingHints)hints);
    }

    public PropertyGenerator[] getPropertyGenerators(String modeName) {
        PropertyGenerator[] propertyGeneratorArray;
        if (modeName.equalsIgnoreCase("renderable")) {
            PropertyGenerator[] propertyGeneratorArray2 = new PropertyGenerator[1];
            propertyGeneratorArray = propertyGeneratorArray2;
            propertyGeneratorArray2[0] = new ImageReadPropertyGenerator();
        } else {
            propertyGeneratorArray = null;
        }
        return propertyGeneratorArray;
    }

    protected boolean validateParameters(String modeName, ParameterBlock args, StringBuffer msg) {
        Boolean verifyInput;
        if (!super.validateParameters(modeName, args, msg)) {
            return false;
        }
        if (modeName.equalsIgnoreCase("rendered")) {
            if (args.getIntParameter(1) < 0) {
                msg.append(I18N.getString("ImageReadDescriptor10"));
                return false;
            }
        } else {
            int[] imageIndices = (int[])args.getObjectParameter(1);
            if (imageIndices != null) {
                for (int i = 0; i < imageIndices.length; ++i) {
                    if (imageIndices[i] >= 0) continue;
                    msg.append(I18N.getString("ImageReadDescriptor10"));
                    return false;
                }
            }
        }
        if ((verifyInput = (Boolean)args.getObjectParameter(4)).booleanValue()) {
            Object input = args.getObjectParameter(0);
            if (input instanceof File || input instanceof String) {
                File file = null;
                String path = null;
                if (input instanceof File) {
                    file = (File)input;
                    path = file.getPath();
                } else if (input instanceof String) {
                    path = (String)input;
                    file = new File(path);
                }
                if (file != null) {
                    if (!file.exists()) {
                        InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream((String)input);
                        if (is == null) {
                            msg.append("\"" + path + "\": " + I18N.getString("ImageReadDescriptor11"));
                            return false;
                        }
                    } else if (!file.canRead()) {
                        msg.append("\"" + path + "\": " + I18N.getString("ImageReadDescriptor12"));
                        return false;
                    }
                }
            } else if (input instanceof Socket) {
                Socket socket = (Socket)input;
                if (socket.isInputShutdown()) {
                    msg.append("\"" + socket + "\": " + I18N.getString("ImageReadDescriptor13"));
                    return false;
                }
                if (socket.isClosed()) {
                    msg.append("\"" + socket + "\": " + I18N.getString("ImageReadDescriptor14"));
                    return false;
                }
                if (!socket.isBound()) {
                    msg.append("\"" + socket + "\": " + I18N.getString("ImageReadDescriptor15"));
                    return false;
                }
                if (!socket.isConnected()) {
                    msg.append("\"" + socket + "\": " + I18N.getString("ImageReadDescriptor16"));
                    return false;
                }
            }
        }
        return true;
    }
}

