/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.util.Tools;
import java.awt.TextField;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Locale;
import java.util.Vector;

public class ImageProperties
implements PlugInFilter,
TextListener {
    ImagePlus imp;
    static final int NANOMETER = 0;
    static final int MICROMETER = 1;
    static final int MILLIMETER = 2;
    static final int CENTIMETER = 3;
    static final int METER = 4;
    static final int KILOMETER = 5;
    static final int INCH = 6;
    static final int FOOT = 7;
    static final int MILE = 8;
    static final int PIXEL = 9;
    static final int OTHER_UNIT = 10;
    int oldUnitIndex;
    double oldUnitsPerCm;
    double oldScale;
    Vector nfields;
    Vector sfields;
    boolean duplicatePixelWidth = true;
    String calUnit;
    double calPixelWidth;
    double calPixelHeight;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return 159;
    }

    public void run(ImageProcessor ip) {
        this.showDialog(this.imp);
    }

    void showDialog(ImagePlus imp) {
        String options = Macro.getOptions();
        if (options != null && IJ.isJava14()) {
            String options2 = options.replaceAll(" depth=", " slices=");
            options2 = options2.replaceAll(" frame=", " interval=");
            Macro.setOptions(options2);
        }
        Calibration cal = imp.getCalibration();
        Calibration calOrig = cal.copy();
        this.oldUnitIndex = this.getUnitIndex(cal.getUnit());
        this.oldUnitsPerCm = this.getUnitsPerCm(this.oldUnitIndex);
        int stackSize = imp.getImageStackSize();
        int channels = imp.getNChannels();
        int slices = imp.getNSlices();
        int frames = imp.getNFrames();
        boolean global1 = imp.getGlobalCalibration() != null;
        GenericDialog gd = new GenericDialog(imp.getTitle());
        gd.addNumericField("Width:", imp.getWidth(), 0);
        gd.addNumericField("Height:", imp.getHeight(), 0);
        gd.addNumericField("Channels:", channels, 0);
        gd.addNumericField("Slices (z):", slices, 0);
        gd.addNumericField("Frames (t):", frames, 0);
        gd.setInsets(10, 0, 5);
        gd.addStringField("Unit of Length:", cal.getUnit());
        this.oldScale = cal.pixelWidth != 0.0 ? 1.0 / cal.pixelWidth : 0.0;
        gd.addNumericField("Pixel_Width:", cal.pixelWidth, 5, 8, null);
        gd.addNumericField("Pixel_Height:", cal.pixelHeight, 5, 8, null);
        gd.addNumericField("Voxel_Depth:", cal.pixelDepth, 5, 8, null);
        gd.setInsets(10, 0, 5);
        double interval = cal.frameInterval;
        gd.addNumericField("Interval (sec.):", interval, (double)((int)interval) == interval ? 0 : 2, 8, null);
        String xo = cal.xOrigin == (double)((int)cal.xOrigin) ? IJ.d2s(cal.xOrigin, 0) : IJ.d2s(cal.xOrigin, 2);
        String yo = cal.yOrigin == (double)((int)cal.yOrigin) ? IJ.d2s(cal.yOrigin, 0) : IJ.d2s(cal.yOrigin, 2);
        String zo = "";
        if (cal.zOrigin != 0.0) {
            zo = cal.zOrigin == (double)((int)cal.zOrigin) ? IJ.d2s(cal.zOrigin, 0) : IJ.d2s(cal.zOrigin, 2);
            zo = "," + zo;
        }
        gd.addStringField("Origin (pixels):", String.valueOf(xo) + "," + yo + zo);
        gd.setInsets(5, 20, 0);
        gd.addCheckbox("Global", global1);
        this.nfields = gd.getNumericFields();
        int i = 0;
        while (i < this.nfields.size()) {
            ((TextField)this.nfields.elementAt(i)).addTextListener(this);
            ++i;
        }
        this.sfields = gd.getStringFields();
        i = 0;
        while (i < this.sfields.size()) {
            ((TextField)this.sfields.elementAt(i)).addTextListener(this);
            ++i;
        }
        this.calUnit = cal.getUnit();
        this.calPixelWidth = cal.pixelWidth;
        this.calPixelHeight = cal.pixelHeight;
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        double width = gd.getNextNumber();
        double height = gd.getNextNumber();
        channels = (int)gd.getNextNumber();
        if (channels < 1) {
            channels = 1;
        }
        if ((slices = (int)gd.getNextNumber()) < 1) {
            slices = 1;
        }
        if ((frames = (int)gd.getNextNumber()) < 1) {
            frames = 1;
        }
        if (width != (double)imp.getWidth() || height != (double)imp.getHeight()) {
            IJ.error("Properties", "Use Image>Adjust>Size to change the image size.");
            return;
        }
        if (channels * slices * frames == stackSize) {
            imp.setDimensions(channels, slices, frames);
        } else {
            IJ.error("Properties", "The product of channels (" + channels + "), slices (" + slices + ")\n and frames (" + frames + ") must equal the stack size (" + stackSize + ").");
        }
        String unit = gd.getNextString();
        if (unit.equals("um")) {
            unit = "\u00b5m";
        } else if (unit.equals("u")) {
            unit = "\u00b5";
        } else if (unit.equals("A")) {
            unit = "\u00c5";
        }
        double pixelWidth = gd.getNextNumber();
        double pixelHeight = gd.getNextNumber();
        double pixelDepth = gd.getNextNumber();
        if (unit.equals("") || unit.equalsIgnoreCase("none") || pixelWidth == 0.0) {
            cal.setUnit(null);
            cal.pixelWidth = 1.0;
            cal.pixelHeight = 1.0;
        } else {
            cal.setUnit(unit);
            cal.pixelWidth = pixelWidth;
            cal.pixelHeight = pixelHeight;
            cal.pixelDepth = pixelDepth;
        }
        cal.frameInterval = gd.getNextNumber();
        String[] origin = Tools.split(gd.getNextString(), " ,");
        double x = Tools.parseDouble(origin[0]);
        double y = origin.length >= 2 ? Tools.parseDouble(origin[1]) : Double.NaN;
        double z = origin.length >= 3 ? Tools.parseDouble(origin[2]) : Double.NaN;
        cal.xOrigin = Double.isNaN(x) ? 0.0 : x;
        cal.yOrigin = Double.isNaN(y) ? cal.xOrigin : y;
        cal.zOrigin = Double.isNaN(z) ? 0.0 : z;
        boolean global2 = gd.getNextBoolean();
        if (!cal.equals(calOrig)) {
            imp.setCalibration(cal);
        }
        imp.setGlobalCalibration(global2 ? cal : null);
        if (global2 || global2 != global1) {
            WindowManager.repaintImageWindows();
        } else {
            imp.repaintWindow();
        }
    }

    double getNewScale(String newUnit) {
        if (this.oldUnitsPerCm == 0.0) {
            return 0.0;
        }
        double newScale = 0.0;
        int newUnitIndex = this.getUnitIndex(newUnit);
        if (newUnitIndex != this.oldUnitIndex) {
            double newUnitsPerCm = this.getUnitsPerCm(newUnitIndex);
            if (this.oldUnitsPerCm != 0.0 && newUnitsPerCm != 0.0) {
                newScale = this.oldScale * (this.oldUnitsPerCm / newUnitsPerCm);
            }
        }
        return newScale;
    }

    int getUnitIndex(String unit) {
        if ((unit = unit.toLowerCase(Locale.US)).equals("cm") || unit.startsWith("cent")) {
            return 3;
        }
        if (unit.equals("mm") || unit.startsWith("milli")) {
            return 2;
        }
        if (unit.startsWith("inch")) {
            return 6;
        }
        if (unit.startsWith("\u00b5") || unit.startsWith("u") || unit.startsWith("micro")) {
            return 1;
        }
        if (unit.equals("nm") || unit.startsWith("nano")) {
            return 0;
        }
        if (unit.startsWith("meter")) {
            return 4;
        }
        if (unit.equals("km") || unit.startsWith("kilo")) {
            return 5;
        }
        if (unit.equals("ft") || unit.equals("foot") || unit.equals("feet")) {
            return 7;
        }
        if (unit.equals("mi") || unit.startsWith("mile")) {
            return 2;
        }
        return 10;
    }

    double getUnitsPerCm(int unitIndex) {
        switch (unitIndex) {
            case 0: {
                return 1.0E7;
            }
            case 1: {
                return 10000.0;
            }
            case 2: {
                return 10.0;
            }
            case 3: {
                return 1.0;
            }
            case 4: {
                return 0.01;
            }
            case 5: {
                return 1.0E-5;
            }
            case 6: {
                return 0.3937;
            }
            case 7: {
                return 0.0328083;
            }
            case 8: {
                return 6.213E-6;
            }
        }
        return 0.0;
    }

    public void textValueChanged(TextEvent e) {
        TextField widthField = (TextField)this.nfields.elementAt(0);
        int width = (int)Tools.parseDouble(widthField.getText(), -99.0);
        TextField heightField = (TextField)this.nfields.elementAt(1);
        int height = (int)Tools.parseDouble(heightField.getText(), -99.0);
        int channels = (int)Tools.parseDouble(((TextField)this.nfields.elementAt(2)).getText(), -99.0);
        int depth = (int)Tools.parseDouble(((TextField)this.nfields.elementAt(3)).getText(), -99.0);
        int frames = (int)Tools.parseDouble(((TextField)this.nfields.elementAt(4)).getText(), -99.0);
        TextField pixelWidthField = (TextField)this.nfields.elementAt(5);
        String newWidthText = pixelWidthField.getText();
        double newPixelWidth = Tools.parseDouble(newWidthText, -99.0);
        TextField pixelHeightField = (TextField)this.nfields.elementAt(6);
        String newHeightText = pixelHeightField.getText();
        double newPixelHeight = Tools.parseDouble(newHeightText, -99.0);
        if (newPixelWidth != -99.0 && newPixelHeight != -99.0) {
            if (newPixelHeight != this.calPixelHeight) {
                this.duplicatePixelWidth = false;
            }
            if (this.duplicatePixelWidth && newPixelWidth != this.calPixelWidth && newPixelWidth != -99.0) {
                pixelHeightField.setText(newWidthText);
                this.calPixelHeight = Tools.parseDouble(newWidthText, -99.0);
            }
        }
        this.calPixelWidth = newPixelWidth;
        this.calPixelHeight = newPixelHeight;
        TextField unitField = (TextField)this.sfields.elementAt(0);
        String newUnit = unitField.getText();
        if (!newUnit.equals(this.calUnit)) {
            double newScale = this.getNewScale(newUnit);
            if (newScale != 0.0) {
                pixelWidthField.setText(IJ.d2s(1.0 / newScale, 6));
                pixelHeightField.setText(IJ.d2s(1.0 / newScale, 6));
                this.oldUnitIndex = this.getUnitIndex(newUnit);
                this.oldUnitsPerCm = this.getUnitsPerCm(this.oldUnitIndex);
                this.oldScale = newScale;
            }
            this.calUnit = newUnit;
        }
    }
}

