/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.io.SaveDialog;
import ij.plugin.PlugIn;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class XYCoordinates
implements PlugIn {
    static boolean processStack;

    public void run(String arg) {
        SaveDialog sd;
        String name;
        String bg;
        ImagePlus imp = IJ.getImage();
        ImageProcessor ip = imp.getProcessor();
        int width = imp.getWidth();
        int height = imp.getHeight();
        double background = ip.getPixelValue(0, 0);
        if (ip instanceof ColorProcessor) {
            int c = ip.getPixel(0, 0);
            int r = (c & 0xFF0000) >> 16;
            int g = (c & 0xFF00) >> 8;
            int b = c & 0xFF;
            bg = String.valueOf(r) + "," + g + "," + b;
        } else {
            bg = (double)((int)background) == background ? IJ.d2s(background, 0) : "" + background;
        }
        imp.killRoi();
        int slices = imp.getStackSize();
        String msg = "This plugin writes to a text file the XY coordinates and\npixel value of all non-background pixels. Backround\nis assumed to be the value of the pixel in the\nupper left corner of the image.\n \n    Width: " + width + "\n" + "    Height: " + height + "\n" + (slices > 1 ? "    Depth: " + slices + "\n" : "") + "    Background value: " + bg + "\n";
        GenericDialog gd = new GenericDialog("Save XY Coordinates");
        gd.addMessage(msg);
        if (slices > 1) {
            gd.addCheckbox("Process all " + slices + " images", processStack);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        processStack = slices > 1 ? gd.getNextBoolean() : false;
        if (!processStack) {
            slices = 1;
        }
        if ((name = (sd = new SaveDialog("Save Coordinates as Text...", imp.getTitle(), ".txt")).getFileName()) == null) {
            return;
        }
        String directory = sd.getDirectory();
        PrintWriter pw = null;
        try {
            FileOutputStream fos = new FileOutputStream(String.valueOf(directory) + name);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            pw = new PrintWriter(bos);
        }
        catch (IOException e) {
            IJ.write("" + e);
            return;
        }
        IJ.showStatus("Saving coordinates...");
        int count = 0;
        int type = imp.getType();
        ImageStack stack = imp.getStack();
        int z = 0;
        while (z < slices) {
            if (slices > 1) {
                ip = stack.getProcessor(z + 1);
            }
            String zstr = slices > 1 ? String.valueOf(z) + "\t" : "";
            int y = height - 1;
            while (y >= 0) {
                int x = 0;
                while (x < width) {
                    float v = ip.getPixelValue(x, y);
                    if ((double)v != background) {
                        if (type == 2) {
                            pw.println(String.valueOf(x) + "\t" + (height - 1 - y) + "\t" + zstr + v);
                        } else if (type == 4) {
                            int c = ip.getPixel(x, y);
                            int r = (c & 0xFF0000) >> 16;
                            int g = (c & 0xFF00) >> 8;
                            int b = c & 0xFF;
                            pw.println(String.valueOf(x) + "\t" + (height - 1 - y) + "\t" + zstr + r + "\t" + g + "\t" + b);
                        } else {
                            pw.println(String.valueOf(x) + "\t" + (height - 1 - y) + "\t" + zstr + (int)v);
                        }
                        ++count;
                    }
                    ++x;
                }
                if (slices == 1 && y % 10 == 0) {
                    IJ.showProgress((double)(height - y) / (double)height);
                }
                --y;
            }
            if (slices > 1) {
                IJ.showProgress(z + 1, slices);
            }
            String img = slices > 1 ? "-" + (z + 1) : "";
            IJ.log(String.valueOf(imp.getTitle()) + img + ": " + count + " pixels (" + IJ.d2s((double)count * 100.0 / (double)(width * height)) + "%)\n");
            count = 0;
            ++z;
        }
        IJ.showProgress(1.0);
        IJ.showStatus("");
        pw.close();
    }
}

