/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.plugin.frame.Editor;

public class NewPlugin
implements PlugIn {
    public static final int MACRO = 0;
    public static final int PLUGIN = 1;
    public static final int PLUGIN_FILTER = 2;
    public static final int PLUGIN_FRAME = 3;
    public static final int TEXT_FILE = 4;
    private static int type = 0;
    private static String name = "Macro";
    private static String[] types = new String[]{"Macro", "Plugin", "Plugin Filter", "Plugin Frame", "Text File"};
    private Editor ed;

    public void run(String arg) {
        if (arg.equals("") && !this.showDialog()) {
            return;
        }
        if (arg.equals("text")) {
            type = 4;
            arg = "";
        }
        if (arg.equals("")) {
            if (type == 0 || type == 4) {
                if (type == 4 && name.equals("Macro")) {
                    name = "Untitled.txt";
                }
                this.createMacro(name);
            } else {
                this.createPlugin(name, type, arg);
            }
        } else {
            this.createPlugin("Converted_Macro.java", 1, arg);
        }
        IJ.register(NewPlugin.class);
    }

    public void createMacro(String name) {
        this.ed = (Editor)IJ.runPlugIn("ij.plugin.frame.Editor", "");
        if (this.ed == null) {
            return;
        }
        if (name.endsWith(".java")) {
            name = name.substring(0, name.length() - 5);
        }
        if (!name.endsWith(".txt")) {
            name = String.valueOf(name) + ".txt";
        }
        this.ed.create(name, "");
    }

    public void createPlugin(String name, int type, String methods) {
        this.ed = (Editor)IJ.runPlugIn("ij.plugin.frame.Editor", "");
        if (this.ed == null) {
            return;
        }
        if (name.equals("Macro") || name.equals("Macro.txt") || name.equals("Untitled.txt")) {
            switch (type) {
                case 1: {
                    name = "My_Plugin.java";
                    break;
                }
                case 2: {
                    name = "Filter_Plugin.java";
                    break;
                }
                case 3: {
                    name = "Plugin_Frame.java";
                }
            }
        }
        String pluginName = name;
        if (!name.endsWith(".java") && !name.endsWith(".JAVA")) {
            if (pluginName.endsWith(".txt")) {
                pluginName = pluginName.substring(0, pluginName.length() - 4);
            }
            pluginName = String.valueOf(pluginName) + ".java";
        }
        String className = pluginName.substring(0, pluginName.length() - 5);
        String text = "";
        text = String.valueOf(text) + "import ij.*;\n";
        text = String.valueOf(text) + "import ij.process.*;\n";
        text = String.valueOf(text) + "import ij.gui.*;\n";
        text = String.valueOf(text) + "import java.awt.*;\n";
        switch (type) {
            case 1: {
                text = String.valueOf(text) + "import ij.plugin.*;\n";
                text = String.valueOf(text) + "\n";
                text = String.valueOf(text) + "public class " + className + " implements PlugIn {\n";
                text = String.valueOf(text) + "\n";
                text = String.valueOf(text) + "\tpublic void run(String arg) {\n";
                text = methods.equals("") ? String.valueOf(text) + "\t\tIJ.showMessage(\"" + className + "\",\"Hello world!\");\n" : String.valueOf(text) + methods;
                text = String.valueOf(text) + "\t}\n";
                break;
            }
            case 2: {
                text = String.valueOf(text) + "import ij.plugin.filter.*;\n";
                text = String.valueOf(text) + "\n";
                text = String.valueOf(text) + "public class " + className + " implements PlugInFilter {\n";
                text = String.valueOf(text) + "\tImagePlus imp;\n";
                text = String.valueOf(text) + "\n";
                text = String.valueOf(text) + "\tpublic int setup(String arg, ImagePlus imp) {\n";
                text = String.valueOf(text) + "\t\tthis.imp = imp;\n";
                text = String.valueOf(text) + "\t\treturn DOES_ALL;\n";
                text = String.valueOf(text) + "\t}\n";
                text = String.valueOf(text) + "\n";
                text = String.valueOf(text) + "\tpublic void run(ImageProcessor ip) {\n";
                text = String.valueOf(text) + "\t\tip.invert();\n";
                text = String.valueOf(text) + "\t\timp.updateAndDraw();\n";
                text = String.valueOf(text) + "\t\tIJ.wait(500);\n";
                text = String.valueOf(text) + "\t\tip.invert();\n";
                text = String.valueOf(text) + "\t\timp.updateAndDraw();\n";
                text = String.valueOf(text) + "\t}\n";
                break;
            }
            case 3: {
                text = String.valueOf(text) + "import ij.plugin.frame.*;\n";
                text = String.valueOf(text) + "\n";
                text = String.valueOf(text) + "public class " + className + " extends PlugInFrame {\n";
                text = String.valueOf(text) + "\n";
                text = String.valueOf(text) + "\tpublic " + className + "() {\n";
                text = String.valueOf(text) + "\t\tsuper(\"" + className + "\");\n";
                text = String.valueOf(text) + "\t\tTextArea ta = new TextArea(15, 50);\n";
                text = String.valueOf(text) + "\t\tadd(ta);\n";
                text = String.valueOf(text) + "\t\tpack();\n";
                text = String.valueOf(text) + "\t\tGUI.center(this);\n";
                text = String.valueOf(text) + "\t\tshow();\n";
                text = String.valueOf(text) + "\t}\n";
            }
        }
        text = String.valueOf(text) + "\n";
        text = String.valueOf(text) + "}\n";
        this.ed.create(pluginName, text);
    }

    public boolean showDialog() {
        GenericDialog gd = new GenericDialog("New...");
        gd.addStringField("Name:", name, 16);
        gd.addChoice("Type:", types, types[type]);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        name = gd.getNextString();
        type = gd.getNextChoiceIndex();
        return true;
    }

    public Editor getEditor() {
        return this.ed;
    }
}

