/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.gui.GenericDialog;
import ij.gui.HistogramWindow;
import ij.gui.YesNoCancelDialog;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.plugin.frame.Recorder;
import ij.process.ImageProcessor;
import ij.process.StackStatistics;
import ij.util.Tools;
import java.awt.Checkbox;
import java.awt.Frame;
import java.awt.TextField;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Vector;

public class Histogram
implements PlugIn,
TextListener {
    private static int nBins = 256;
    private static boolean useImageMinAndMax = true;
    private static double xMin;
    private static double xMax;
    private static String yMax;
    private static boolean stackHistogram;
    private static int imageID;
    private Checkbox checkbox;
    private TextField minField;
    private TextField maxField;
    private String defaultMin;
    private String defaultMax;

    static {
        yMax = "Auto";
    }

    public void run(String arg) {
        boolean customHistogram;
        ImagePlus imp = IJ.getImage();
        int bitDepth = imp.getBitDepth();
        if (bitDepth == 32 || IJ.altKeyDown()) {
            IJ.setKeyUp(18);
            if (!this.showDialog(imp)) {
                return;
            }
        } else {
            int flags = this.setupDialog(imp, 0);
            if (flags == 4096) {
                return;
            }
            stackHistogram = flags == 32;
            Calibration cal = imp.getCalibration();
            nBins = 256;
            if (stackHistogram && (bitDepth == 8 && !cal.calibrated() || bitDepth == 24)) {
                xMin = 0.0;
                xMax = 256.0;
                useImageMinAndMax = false;
            } else {
                useImageMinAndMax = true;
            }
            yMax = "Auto";
        }
        StackStatistics stats = null;
        if (useImageMinAndMax) {
            xMin = 0.0;
            xMax = 0.0;
        }
        int iyMax = (int)Tools.parseDouble(yMax, 0.0);
        boolean bl = customHistogram = !(bitDepth != 8 && bitDepth != 24 || xMin == 0.0 && xMax == 0.0 && nBins == 256 && iyMax <= 0);
        if (stackHistogram || customHistogram) {
            ImagePlus imp2 = imp;
            if (customHistogram && !stackHistogram && imp.getStackSize() > 1) {
                imp2 = new ImagePlus("Temp", imp.getProcessor());
            }
            stats = new StackStatistics(imp2, nBins, xMin, xMax);
            stats.histYMax = iyMax;
            new HistogramWindow("Histogram of " + imp.getShortTitle(), imp, stats);
        } else {
            new HistogramWindow("Histogram of " + imp.getShortTitle(), imp, nBins, xMin, xMax, iyMax);
        }
    }

    boolean showDialog(ImagePlus imp) {
        ImageProcessor ip = imp.getProcessor();
        double min = ip.getMin();
        double max = ip.getMax();
        if (imp.getID() != imageID || min == xMin && min == xMax) {
            useImageMinAndMax = true;
        }
        if (imp.getID() != imageID || useImageMinAndMax) {
            xMin = min;
            xMax = max;
            Calibration cal = imp.getCalibration();
            xMin = cal.getCValue(xMin);
            xMax = cal.getCValue(xMax);
        }
        this.defaultMin = IJ.d2s(xMin, 2);
        this.defaultMax = IJ.d2s(xMax, 2);
        imageID = imp.getID();
        int stackSize = imp.getStackSize();
        GenericDialog gd = new GenericDialog("Histogram");
        gd.addNumericField("Bins:", HistogramWindow.nBins, 0);
        gd.addCheckbox("Use min/max or:", useImageMinAndMax);
        gd.addMessage("");
        int fwidth = 6;
        int nwidth = Math.max(IJ.d2s(xMin, 2).length(), IJ.d2s(xMax, 2).length());
        if (nwidth > fwidth) {
            fwidth = nwidth;
        }
        gd.addNumericField("X_Min:", xMin, 2, fwidth, null);
        gd.addNumericField("X_Max:", xMax, 2, fwidth, null);
        gd.addMessage(" ");
        gd.addStringField("Y_Max:", yMax, 6);
        if (stackSize > 1) {
            gd.addCheckbox("Stack Histogram", stackHistogram);
        }
        Vector numbers = gd.getNumericFields();
        this.minField = (TextField)numbers.elementAt(1);
        this.minField.addTextListener(this);
        this.maxField = (TextField)numbers.elementAt(2);
        this.maxField.addTextListener(this);
        this.checkbox = (Checkbox)gd.getCheckboxes().elementAt(0);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        nBins = (int)gd.getNextNumber();
        if (nBins >= 2 && nBins <= 1000) {
            HistogramWindow.nBins = nBins;
        }
        useImageMinAndMax = gd.getNextBoolean();
        xMin = gd.getNextNumber();
        xMax = gd.getNextNumber();
        yMax = gd.getNextString();
        stackHistogram = stackSize > 1 ? gd.getNextBoolean() : false;
        IJ.register(Histogram.class);
        return true;
    }

    public void textValueChanged(TextEvent e) {
        boolean rangeChanged;
        boolean bl = rangeChanged = !this.defaultMin.equals(this.minField.getText()) || !this.defaultMax.equals(this.maxField.getText());
        if (rangeChanged) {
            this.checkbox.setState(false);
        }
    }

    int setupDialog(ImagePlus imp, int flags) {
        int stackSize = imp.getStackSize();
        if (stackSize > 1) {
            String macroOptions = Macro.getOptions();
            if (macroOptions != null) {
                if (macroOptions.indexOf("stack ") >= 0) {
                    return flags + 32;
                }
                return flags;
            }
            YesNoCancelDialog d = new YesNoCancelDialog((Frame)IJ.getInstance(), "Histogram", "Include all " + stackSize + " slices?");
            if (d.cancelPressed()) {
                return 4096;
            }
            if (d.yesPressed()) {
                if (Recorder.record) {
                    Recorder.recordOption("stack");
                }
                return flags + 32;
            }
            if (Recorder.record) {
                Recorder.recordOption("slice");
            }
        }
        return flags;
    }
}

