/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.IJ;
import ij.io.BitBuffer;
import ij.io.ByteVector;
import ij.io.FileInfo;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class ImageReader {
    private static final int CLEAR_CODE = 256;
    private static final int EOI_CODE = 257;
    private FileInfo fi;
    private int width;
    private int height;
    private long skipCount;
    private int bytesPerPixel;
    private int bufferSize;
    private int byteCount;
    private int nPixels;
    private boolean showProgressBar = true;
    private int eofErrorCount;

    public ImageReader(FileInfo fi) {
        this.fi = fi;
        this.width = fi.width;
        this.height = fi.height;
        this.skipCount = fi.longOffset > 0L ? fi.longOffset : (long)fi.offset;
    }

    void eofError() {
        ++this.eofErrorCount;
    }

    byte[] read8bitImage(InputStream in) throws IOException {
        if (this.fi.compression == 2 || this.fi.compression == 3) {
            return this.readCompressed8bitImage(in);
        }
        byte[] pixels = new byte[this.nPixels];
        int totalRead = 0;
        while (totalRead < this.byteCount) {
            int count = totalRead + this.bufferSize > this.byteCount ? this.byteCount - totalRead : this.bufferSize;
            int actuallyRead = in.read(pixels, totalRead, count);
            if (actuallyRead == -1) {
                this.eofError();
                break;
            }
            this.showProgress((double)(totalRead += actuallyRead) / (double)this.byteCount);
        }
        return pixels;
    }

    byte[] readCompressed8bitImage(InputStream in) throws IOException {
        byte[] pixels = new byte[this.nPixels];
        int current = 0;
        byte last = 0;
        int i = 0;
        while (i < this.fi.stripOffsets.length) {
            int length;
            int skip;
            if (i > 0 && (skip = this.fi.stripOffsets[i] - this.fi.stripOffsets[i - 1] - this.fi.stripLengths[i - 1]) > 0) {
                in.skip(skip);
            }
            byte[] byteArray = new byte[this.fi.stripLengths[i]];
            int read = 0;
            int left = byteArray.length;
            while (left > 0) {
                int r = in.read(byteArray, read, left);
                if (r == -1) {
                    this.eofError();
                    break;
                }
                read += r;
                left -= r;
            }
            byteArray = this.lzwUncompress(byteArray);
            if (this.fi.compression == 3) {
                int b = 0;
                while (b < byteArray.length) {
                    int n = b;
                    byteArray[n] = (byte)(byteArray[n] + last);
                    last = b % this.fi.width == this.fi.width - 1 ? (byte)0 : byteArray[b];
                    ++b;
                }
            }
            if (current + (length = byteArray.length) > pixels.length) {
                length = pixels.length - current;
            }
            System.arraycopy(byteArray, 0, pixels, current, length);
            current += byteArray.length;
            IJ.showProgress(i + 1, this.fi.stripOffsets.length);
            ++i;
        }
        return pixels;
    }

    private void showProgress(double progress) {
        if (this.showProgressBar) {
            IJ.showProgress(progress);
        }
    }

    short[] read16bitImage(InputStream in) throws IOException {
        if (this.fi.compression == 2 || this.fi.compression == 3) {
            return this.readCompressed16bitImage(in);
        }
        byte[] buffer = new byte[this.bufferSize];
        short[] pixels = new short[this.nPixels];
        int totalRead = 0;
        int base = 0;
        while (totalRead < this.byteCount) {
            int j;
            int i;
            if (totalRead + this.bufferSize > this.byteCount) {
                this.bufferSize = this.byteCount - totalRead;
            }
            int bufferCount = 0;
            while (bufferCount < this.bufferSize) {
                int count = in.read(buffer, bufferCount, this.bufferSize - bufferCount);
                if (count == -1) {
                    this.eofError();
                    if (this.fi.fileType == 1) {
                        i = base;
                        while (i < pixels.length) {
                            pixels[i] = Short.MIN_VALUE;
                            ++i;
                        }
                    }
                    return pixels;
                }
                bufferCount += count;
            }
            this.showProgress((double)(totalRead += this.bufferSize) / (double)this.byteCount);
            int pixelsRead = this.bufferSize / this.bytesPerPixel;
            if (this.fi.intelByteOrder) {
                if (this.fi.fileType == 1) {
                    i = base;
                    j = 0;
                    while (i < base + pixelsRead) {
                        pixels[i] = (short)(((buffer[j + 1] & 0xFF) << 8 | buffer[j] & 0xFF) + 32768);
                        ++i;
                        j += 2;
                    }
                } else {
                    i = base;
                    j = 0;
                    while (i < base + pixelsRead) {
                        pixels[i] = (short)((buffer[j + 1] & 0xFF) << 8 | buffer[j] & 0xFF);
                        ++i;
                        j += 2;
                    }
                }
            } else if (this.fi.fileType == 1) {
                i = base;
                j = 0;
                while (i < base + pixelsRead) {
                    pixels[i] = (short)(((buffer[j] & 0xFF) << 8 | buffer[j + 1] & 0xFF) + 32768);
                    ++i;
                    j += 2;
                }
            } else {
                i = base;
                j = 0;
                while (i < base + pixelsRead) {
                    pixels[i] = (short)((buffer[j] & 0xFF) << 8 | buffer[j + 1] & 0xFF);
                    ++i;
                    j += 2;
                }
            }
            base += pixelsRead;
        }
        return pixels;
    }

    short[] readCompressed16bitImage(InputStream in) throws IOException {
        short[] pixels = new short[this.nPixels];
        int base = 0;
        short last = 0;
        int k = 0;
        while (k < this.fi.stripOffsets.length) {
            int j;
            int i;
            int skip;
            if (k > 0 && (skip = this.fi.stripOffsets[k] - this.fi.stripOffsets[k - 1] - this.fi.stripLengths[k - 1]) > 0) {
                in.skip(skip);
            }
            byte[] byteArray = new byte[this.fi.stripLengths[k]];
            int read = 0;
            int left = byteArray.length;
            while (left > 0) {
                int r = in.read(byteArray, read, left);
                if (r == -1) {
                    this.eofError();
                    break;
                }
                read += r;
                left -= r;
            }
            byteArray = this.lzwUncompress(byteArray);
            int pixelsRead = byteArray.length / this.bytesPerPixel;
            int pmax = base + pixelsRead;
            if (pmax > this.nPixels) {
                pmax = this.nPixels;
            }
            if (this.fi.intelByteOrder) {
                if (this.fi.fileType == 1) {
                    i = base;
                    j = 0;
                    while (i < pmax) {
                        pixels[i] = (short)(((byteArray[j + 1] & 0xFF) << 8 | byteArray[j] & 0xFF) + 32768);
                        ++i;
                        j += 2;
                    }
                } else {
                    i = base;
                    j = 0;
                    while (i < pmax) {
                        pixels[i] = (short)((byteArray[j + 1] & 0xFF) << 8 | byteArray[j] & 0xFF);
                        ++i;
                        j += 2;
                    }
                }
            } else if (this.fi.fileType == 1) {
                i = base;
                j = 0;
                while (i < pmax) {
                    pixels[i] = (short)(((byteArray[j] & 0xFF) << 8 | byteArray[j + 1] & 0xFF) + 32768);
                    ++i;
                    j += 2;
                }
            } else {
                i = base;
                j = 0;
                while (i < pmax) {
                    pixels[i] = (short)((byteArray[j] & 0xFF) << 8 | byteArray[j + 1] & 0xFF);
                    ++i;
                    j += 2;
                }
            }
            if (this.fi.compression == 3) {
                int b = base + 1;
                while (b < pmax) {
                    int n = b;
                    pixels[n] = (short)(pixels[n] + last);
                    last = b % this.fi.width == this.fi.width - 1 ? (short)0 : pixels[b];
                    ++b;
                }
            }
            base += pixelsRead;
            IJ.showProgress(k + 1, this.fi.stripOffsets.length);
            ++k;
        }
        return pixels;
    }

    float[] read32bitImage(InputStream in) throws IOException {
        byte[] buffer = new byte[this.bufferSize];
        float[] pixels = new float[this.nPixels];
        int totalRead = 0;
        int base = 0;
        while (totalRead < this.byteCount) {
            int tmp;
            int i;
            if (totalRead + this.bufferSize > this.byteCount) {
                this.bufferSize = this.byteCount - totalRead;
            }
            int bufferCount = 0;
            while (bufferCount < this.bufferSize) {
                int count = in.read(buffer, bufferCount, this.bufferSize - bufferCount);
                if (count == -1) {
                    this.eofError();
                    return pixels;
                }
                bufferCount += count;
            }
            this.showProgress((double)(totalRead += this.bufferSize) / (double)this.byteCount);
            int pixelsRead = this.bufferSize / this.bytesPerPixel;
            int j = 0;
            if (this.fi.intelByteOrder) {
                i = base;
                while (i < base + pixelsRead) {
                    tmp = (buffer[j + 3] & 0xFF) << 24 | (buffer[j + 2] & 0xFF) << 16 | (buffer[j + 1] & 0xFF) << 8 | buffer[j] & 0xFF;
                    pixels[i] = this.fi.fileType == 4 ? Float.intBitsToFloat(tmp) : (this.fi.fileType == 11 ? (float)((long)tmp & 0xFFFFFFFFL) : (float)tmp);
                    j += 4;
                    ++i;
                }
            } else {
                i = base;
                while (i < base + pixelsRead) {
                    tmp = (buffer[j] & 0xFF) << 24 | (buffer[j + 1] & 0xFF) << 16 | (buffer[j + 2] & 0xFF) << 8 | buffer[j + 3] & 0xFF;
                    pixels[i] = this.fi.fileType == 4 ? Float.intBitsToFloat(tmp) : (this.fi.fileType == 11 ? (float)((long)tmp & 0xFFFFFFFFL) : (float)tmp);
                    j += 4;
                    ++i;
                }
            }
            base += pixelsRead;
        }
        return pixels;
    }

    float[] read64bitImage(InputStream in) throws IOException {
        byte[] buffer = new byte[this.bufferSize];
        float[] pixels = new float[this.nPixels];
        int totalRead = 0;
        int base = 0;
        while (totalRead < this.byteCount) {
            if (totalRead + this.bufferSize > this.byteCount) {
                this.bufferSize = this.byteCount - totalRead;
            }
            int bufferCount = 0;
            while (bufferCount < this.bufferSize) {
                int count = in.read(buffer, bufferCount, this.bufferSize - bufferCount);
                if (count == -1) {
                    this.eofError();
                    return pixels;
                }
                bufferCount += count;
            }
            this.showProgress((double)(totalRead += this.bufferSize) / (double)this.byteCount);
            int pixelsRead = this.bufferSize / this.bytesPerPixel;
            int j = 0;
            int i = base;
            while (i < base + pixelsRead) {
                long b1 = buffer[j + 7] & 0xFF;
                long b2 = buffer[j + 6] & 0xFF;
                long b3 = buffer[j + 5] & 0xFF;
                long b4 = buffer[j + 4] & 0xFF;
                long b5 = buffer[j + 3] & 0xFF;
                long b6 = buffer[j + 2] & 0xFF;
                long b7 = buffer[j + 1] & 0xFF;
                long b8 = buffer[j] & 0xFF;
                long tmp = this.fi.intelByteOrder ? b1 << 56 | b2 << 48 | b3 << 40 | b4 << 32 | b5 << 24 | b6 << 16 | b7 << 8 | b8 : b8 << 56 | b7 << 48 | b6 << 40 | b5 << 32 | b4 << 24 | b3 << 16 | b2 << 8 | b1;
                pixels[i] = (float)Double.longBitsToDouble(tmp);
                j += 8;
                ++i;
            }
            base += pixelsRead;
        }
        return pixels;
    }

    int[] readChunkyRGB(InputStream in) throws IOException {
        if (this.fi.compression == 2 || this.fi.compression == 3) {
            return this.readCompressedChunkyRGB(in);
        }
        this.bufferSize = 24 * this.width;
        byte[] buffer = new byte[this.bufferSize];
        int[] pixels = new int[this.nPixels];
        int totalRead = 0;
        int base = 0;
        while (totalRead < this.byteCount) {
            if (totalRead + this.bufferSize > this.byteCount) {
                this.bufferSize = this.byteCount - totalRead;
            }
            int bufferCount = 0;
            while (bufferCount < this.bufferSize) {
                int count = in.read(buffer, bufferCount, this.bufferSize - bufferCount);
                if (count == -1) {
                    this.eofError();
                    return pixels;
                }
                bufferCount += count;
            }
            this.showProgress((double)(totalRead += this.bufferSize) / (double)this.byteCount);
            int pixelsRead = this.bufferSize / this.bytesPerPixel;
            boolean bgr = this.fi.fileType == 10;
            int j = 0;
            int i = base;
            while (i < base + pixelsRead) {
                int g;
                int r;
                int b;
                if (this.bytesPerPixel == 4) {
                    if (this.fi.fileType == 15) {
                        b = buffer[j++] & 0xFF;
                        int n = ++j;
                        r = buffer[n] & 0xFF;
                        int n2 = ++j;
                        ++j;
                        g = buffer[n2] & 0xFF;
                    } else if (this.fi.intelByteOrder) {
                        b = buffer[j++] & 0xFF;
                        g = buffer[j++] & 0xFF;
                        r = buffer[j++] & 0xFF;
                        ++j;
                    } else {
                        int n = ++j;
                        r = buffer[n] & 0xFF;
                        int n3 = ++j;
                        g = buffer[n3] & 0xFF;
                        int n4 = ++j;
                        ++j;
                        b = buffer[n4] & 0xFF;
                    }
                } else {
                    r = buffer[j++] & 0xFF;
                    g = buffer[j++] & 0xFF;
                    b = buffer[j++] & 0xFF;
                }
                pixels[i] = bgr ? 0xFF000000 | b << 16 | g << 8 | r : 0xFF000000 | r << 16 | g << 8 | b;
                ++i;
            }
            base += pixelsRead;
        }
        return pixels;
    }

    int[] readCompressedChunkyRGB(InputStream in) throws IOException {
        int[] pixels = new int[this.nPixels];
        int base = 0;
        boolean lastRed = false;
        boolean lastGreen = false;
        boolean lastBlue = false;
        int red = 0;
        int green = 0;
        int blue = 0;
        boolean bgr = this.fi.fileType == 10;
        boolean differencing = this.fi.compression == 3;
        int i = 0;
        while (i < this.fi.stripOffsets.length) {
            int skip;
            if (i > 0 && (skip = this.fi.stripOffsets[i] - this.fi.stripOffsets[i - 1] - this.fi.stripLengths[i - 1]) > 0) {
                in.skip(skip);
            }
            byte[] byteArray = new byte[this.fi.stripLengths[i]];
            int read = 0;
            int left = byteArray.length;
            while (left > 0) {
                int r = in.read(byteArray, read, left);
                if (r == -1) {
                    this.eofError();
                    break;
                }
                read += r;
                left -= r;
            }
            byteArray = this.lzwUncompress(byteArray);
            if (differencing) {
                int b = 0;
                while (b < byteArray.length) {
                    if (b / this.bytesPerPixel % this.fi.width != 0) {
                        int n = b;
                        byteArray[n] = (byte)(byteArray[n] + byteArray[b - this.bytesPerPixel]);
                    }
                    ++b;
                }
            }
            int k = 0;
            int pixelsRead = byteArray.length / this.bytesPerPixel;
            int pmax = base + pixelsRead;
            if (pmax > this.nPixels) {
                pmax = this.nPixels;
            }
            int j = base;
            while (j < pmax) {
                if (this.bytesPerPixel == 4) {
                    // empty if block
                }
                int n = ++k;
                red = byteArray[n] & 0xFF;
                int n2 = ++k;
                green = byteArray[n2] & 0xFF;
                int n3 = ++k;
                ++k;
                blue = byteArray[n3] & 0xFF;
                pixels[j] = bgr ? 0xFF000000 | blue << 16 | green << 8 | red : 0xFF000000 | red << 16 | green << 8 | blue;
                ++j;
            }
            base += pixelsRead;
            IJ.showProgress(i + 1, this.fi.stripOffsets.length);
            ++i;
        }
        return pixels;
    }

    int[] readPlanarRGB(InputStream in) throws IOException {
        int planeSize = this.nPixels;
        byte[] buffer = new byte[planeSize];
        int[] pixels = new int[this.nPixels];
        int totalRead = 0;
        this.showProgress(0.12);
        int bytesRead = in.read(buffer, 0, planeSize);
        if (bytesRead == -1) {
            this.eofError();
            return pixels;
        }
        totalRead += bytesRead;
        int i = 0;
        while (i < planeSize) {
            int r = buffer[i] & 0xFF;
            pixels[i] = 0xFF000000 | r << 16;
            ++i;
        }
        this.showProgress(0.37);
        bytesRead = in.read(buffer, 0, planeSize);
        if (bytesRead == -1) {
            this.eofError();
            return pixels;
        }
        totalRead += bytesRead;
        i = 0;
        while (i < planeSize) {
            int g = buffer[i] & 0xFF;
            int n = i++;
            pixels[n] = pixels[n] | g << 8;
        }
        this.showProgress(0.62);
        bytesRead = in.read(buffer, 0, planeSize);
        if (bytesRead == -1) {
            this.eofError();
            return pixels;
        }
        totalRead += bytesRead;
        i = 0;
        while (i < planeSize) {
            int b = buffer[i] & 0xFF;
            int n = i++;
            pixels[n] = pixels[n] | b;
        }
        this.showProgress(0.87);
        return pixels;
    }

    Object readRGB48(InputStream in) throws IOException {
        this.bufferSize = 24 * this.width;
        byte[] buffer = new byte[this.bufferSize];
        short[] red = new short[this.nPixels];
        short[] green = new short[this.nPixels];
        short[] blue = new short[this.nPixels];
        int totalRead = 0;
        int base = 0;
        Object[] stack = new Object[]{red, green, blue};
        while (totalRead < this.byteCount) {
            int j;
            int i;
            if (totalRead + this.bufferSize > this.byteCount) {
                this.bufferSize = this.byteCount - totalRead;
            }
            int bufferCount = 0;
            while (bufferCount < this.bufferSize) {
                int count = in.read(buffer, bufferCount, this.bufferSize - bufferCount);
                if (count == -1) {
                    this.eofError();
                    return stack;
                }
                bufferCount += count;
            }
            this.showProgress((double)(totalRead += this.bufferSize) / (double)this.byteCount);
            int pixelsRead = this.bufferSize / this.bytesPerPixel;
            if (this.fi.intelByteOrder) {
                i = base;
                j = 0;
                while (i < base + pixelsRead) {
                    red[i] = (short)((buffer[j + 1] & 0xFF) << 8 | buffer[j] & 0xFF);
                    green[i] = (short)((buffer[(j += 2) + 1] & 0xFF) << 8 | buffer[j] & 0xFF);
                    blue[i] = (short)((buffer[(j += 2) + 1] & 0xFF) << 8 | buffer[j] & 0xFF);
                    j += 2;
                    ++i;
                }
            } else {
                i = base;
                j = 0;
                while (i < base + pixelsRead) {
                    red[i] = (short)((buffer[j] & 0xFF) << 8 | buffer[j + 1] & 0xFF);
                    green[i] = (short)((buffer[j += 2] & 0xFF) << 8 | buffer[j + 1] & 0xFF);
                    blue[i] = (short)((buffer[j += 2] & 0xFF) << 8 | buffer[j + 1] & 0xFF);
                    j += 2;
                    ++i;
                }
            }
            base += pixelsRead;
        }
        return stack;
    }

    short[] read12bitImage(InputStream in) throws IOException {
        int nBytes = (int)((double)this.nPixels * 1.5);
        if ((this.nPixels & 1) == 1) {
            ++nBytes;
        }
        byte[] buffer = new byte[nBytes];
        short[] pixels = new short[this.nPixels];
        DataInputStream dis = new DataInputStream(in);
        dis.readFully(buffer);
        int i = 0;
        int j = 0;
        int index = 0;
        while (index < buffer.length / 3) {
            pixels[j++] = (short)((buffer[i] & 0xFF) * 16 + (buffer[i + 1] >> 4 & 0xF));
            pixels[j++] = (short)((buffer[i + 1] & 0xF) * 256 + (buffer[i + 2] & 0xFF));
            i += 3;
            ++index;
        }
        return pixels;
    }

    float[] read24bitImage(InputStream in) throws IOException {
        byte[] buffer = new byte[this.width * 3];
        float[] pixels = new float[this.nPixels];
        DataInputStream dis = new DataInputStream(in);
        int y = 0;
        while (y < this.height) {
            dis.readFully(buffer);
            int b = 0;
            int x = 0;
            while (x < this.width) {
                int b1 = buffer[b++] & 0xFF;
                int b2 = buffer[b++] & 0xFF;
                int b3 = buffer[b++] & 0xFF;
                pixels[x + y * this.width] = b3 << 16 | b2 << 8 | b1;
                ++x;
            }
            ++y;
        }
        return pixels;
    }

    void skip(InputStream in) throws IOException {
        if (this.skipCount > 0L) {
            long bytesRead = 0L;
            int skipAttempts = 0;
            while (bytesRead < this.skipCount) {
                long count = in.skip(this.skipCount - bytesRead);
                if (count == -1L || ++skipAttempts > 5) break;
                bytesRead += count;
            }
        }
        this.byteCount = this.width * this.height * this.bytesPerPixel;
        if (this.fi.fileType == 8) {
            int scan = this.width / 8;
            int pad = this.width % 8;
            if (pad > 0) {
                ++scan;
            }
            this.byteCount = scan * this.height;
        }
        this.nPixels = this.width * this.height;
        this.bufferSize = this.byteCount / 25;
        this.bufferSize = this.bufferSize < 8192 ? 8192 : this.bufferSize / 8192 * 8192;
    }

    public Object readPixels(InputStream in) {
        try {
            switch (this.fi.fileType) {
                case 0: 
                case 5: {
                    this.bytesPerPixel = 1;
                    this.skip(in);
                    return this.read8bitImage(in);
                }
                case 1: 
                case 2: {
                    this.bytesPerPixel = 2;
                    this.skip(in);
                    return this.read16bitImage(in);
                }
                case 3: 
                case 4: 
                case 11: {
                    this.bytesPerPixel = 4;
                    this.skip(in);
                    return this.read32bitImage(in);
                }
                case 16: {
                    this.bytesPerPixel = 8;
                    this.skip(in);
                    return this.read64bitImage(in);
                }
                case 6: 
                case 9: 
                case 10: 
                case 15: {
                    this.bytesPerPixel = this.fi.getBytesPerPixel();
                    this.skip(in);
                    return this.readChunkyRGB(in);
                }
                case 7: {
                    this.bytesPerPixel = 3;
                    this.skip(in);
                    return this.readPlanarRGB(in);
                }
                case 8: {
                    this.bytesPerPixel = 1;
                    this.skip(in);
                    byte[] bitmap = this.read8bitImage(in);
                    this.expandBitmap(bitmap);
                    return bitmap;
                }
                case 12: {
                    this.bytesPerPixel = 6;
                    this.skip(in);
                    return this.readRGB48(in);
                }
                case 13: {
                    this.skip(in);
                    short[] data = this.read12bitImage(in);
                    return data;
                }
                case 14: {
                    this.skip(in);
                    return this.read24bitImage(in);
                }
            }
            return null;
        }
        catch (IOException e) {
            IJ.log("" + e);
            return null;
        }
    }

    public Object readPixels(InputStream in, long skipCount) {
        this.skipCount = skipCount;
        this.showProgressBar = false;
        Object pixels = this.readPixels(in);
        if (this.eofErrorCount > 0) {
            return null;
        }
        return pixels;
    }

    public Object readPixels(String url) {
        InputStream is;
        URL theURL;
        try {
            theURL = new URL(url);
        }
        catch (MalformedURLException e) {
            IJ.log("" + e);
            return null;
        }
        try {
            is = theURL.openStream();
        }
        catch (IOException e) {
            IJ.log("" + e);
            return null;
        }
        return this.readPixels(is);
    }

    void expandBitmap(byte[] pixels) {
        int scan = this.width / 8;
        int pad = this.width % 8;
        if (pad > 0) {
            ++scan;
        }
        int len = scan * this.height;
        byte[] bitmap = new byte[len];
        System.arraycopy(pixels, 0, bitmap, 0, len);
        int y = 0;
        while (y < this.height) {
            int offset = y * scan;
            int index = y * this.width;
            int x = 0;
            while (x < scan) {
                int value1 = bitmap[offset + x] & 0xFF;
                int i = 7;
                while (i >= 0) {
                    int value2;
                    int n = value2 = (value1 & 1 << i) != 0 ? 255 : 0;
                    if (index < pixels.length) {
                        pixels[index++] = (byte)value2;
                    }
                    --i;
                }
                ++x;
            }
            ++y;
        }
    }

    public byte[] lzwUncompress(byte[] input) {
        int code;
        if (input == null || input.length == 0) {
            return input;
        }
        byte[][] symbolTable = new byte[4096][1];
        int bitsToRead = 9;
        int nextSymbol = 258;
        int oldCode = -1;
        ByteVector out = new ByteVector(8192);
        BitBuffer bb = new BitBuffer(input);
        byte[] byteBuffer1 = new byte[16];
        byte[] byteBuffer2 = new byte[16];
        while ((code = bb.getBits(bitsToRead)) != 257 && code != -1) {
            ByteVector symbol;
            if (code == 256) {
                int i = 0;
                while (i < 256) {
                    symbolTable[i][0] = (byte)i;
                    ++i;
                }
                nextSymbol = 258;
                bitsToRead = 9;
                code = bb.getBits(bitsToRead);
                if (code == 257 || code == -1) break;
                out.add(symbolTable[code]);
                oldCode = code;
                continue;
            }
            if (code < nextSymbol) {
                out.add(symbolTable[code]);
                symbol = new ByteVector(byteBuffer1);
                symbol.add(symbolTable[oldCode]);
                symbol.add(symbolTable[code][0]);
                symbolTable[nextSymbol] = symbol.toByteArray();
                oldCode = code;
                ++nextSymbol;
            } else {
                symbol = new ByteVector(byteBuffer2);
                symbol.add(symbolTable[oldCode]);
                symbol.add(symbolTable[oldCode][0]);
                byte[] outString = symbol.toByteArray();
                out.add(outString);
                symbolTable[nextSymbol] = outString;
                oldCode = code;
                ++nextSymbol;
            }
            if (nextSymbol == 511) {
                bitsToRead = 10;
            }
            if (nextSymbol == 1023) {
                bitsToRead = 11;
            }
            if (nextSymbol != 2047) continue;
            bitsToRead = 12;
        }
        return out.toByteArray();
    }
}

