/*
 * Decompiled with CFR 0.152.
 */
import ij.ImagePlus;
import ij.ImageStack;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;

class CompositeImage
extends ImagePlus {
    int[] awtImagePixels;
    boolean newPixels;
    MemoryImageSource imageSource;
    ColorModel imageColorModel;
    Image awtImage;
    int[][] awtChannelPixels;
    ImageProcessor[] channelIPs;
    Color[] colors = new Color[]{Color.red, Color.green, Color.blue};
    boolean singleChannel = false;
    int currentChannel = 0;

    public CompositeImage(String title, ImagePlus imp, int channels) {
        ImageStack stack = imp.getBitDepth() == 24 ? this.getRGBStack(imp) : imp.getStack();
        int stackSize = stack.getSize();
        if (channels < 2 || stackSize % channels != 0) {
            throw new IllegalArgumentException("channels<2 or stacksize not multiple of channels");
        }
        this.setDimensions(channels, stackSize / channels, 1);
        this.compositeImage = true;
        this.channelIPs = new ImageProcessor[channels];
        int i = 0;
        while (i < channels) {
            this.channelIPs[i] = stack.getProcessor(i + 1);
            this.channelIPs[i].setColorModel(CompositeImage.createModelFromColor(this.colors[i]));
            ++i;
        }
        this.setStack(imp.getTitle(), stack);
        this.channelIPs[this.currentChannel] = this.getProcessor();
        this.channelIPs[this.currentChannel].setColorModel(CompositeImage.createModelFromColor(this.colors[this.currentChannel]));
    }

    public Image getImage() {
        if (this.img == null) {
            this.updateImage();
        }
        return this.img;
    }

    public void updateImage() {
        int i;
        if (this.singleChannel) {
            this.img = this.ip.createImage();
            return;
        }
        int imageSize = this.width * this.height;
        int nChannels = this.getNChannels();
        if (this.awtImagePixels == null || this.awtImagePixels.length != imageSize) {
            this.awtImagePixels = new int[imageSize];
            this.newPixels = true;
        }
        if (this.awtChannelPixels == null || this.awtChannelPixels.length != nChannels || this.awtChannelPixels[0].length != imageSize) {
            this.awtChannelPixels = new int[nChannels][];
            i = 0;
            while (i < nChannels) {
                this.awtChannelPixels[i] = new int[imageSize];
                ++i;
            }
        }
        i = 0;
        while (i < nChannels) {
            PixelGrabber pg = new PixelGrabber(this.channelIPs[i].createImage(), 0, 0, this.width, this.height, this.awtChannelPixels[i], 0, this.width);
            try {
                pg.grabPixels();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++i;
        }
        i = 0;
        while (i < imageSize) {
            int redValue = 0;
            int greenValue = 0;
            int blueValue = 0;
            int j = 0;
            while (j < nChannels) {
                greenValue += this.awtChannelPixels[j][i] >> 8 & 0xFF;
                blueValue += this.awtChannelPixels[j][i] & 0xFF;
                if ((redValue += this.awtChannelPixels[j][i] >> 16 & 0xFF) > 255) {
                    redValue = 255;
                }
                if (greenValue > 255) {
                    greenValue = 255;
                }
                if (blueValue > 255) {
                    blueValue = 255;
                }
                ++j;
            }
            this.awtImagePixels[i] = redValue << 16 | greenValue << 8 | blueValue;
            ++i;
        }
        if (this.imageSource == null) {
            this.imageColorModel = new DirectColorModel(32, 0xFF0000, 65280, 255);
            this.imageSource = new MemoryImageSource(this.width, this.height, this.imageColorModel, this.awtImagePixels, 0, this.width);
            this.imageSource.setAnimated(true);
            this.imageSource.setFullBufferUpdates(true);
            this.awtImage = Toolkit.getDefaultToolkit().createImage(this.imageSource);
            this.newPixels = false;
        } else if (this.newPixels) {
            this.imageSource.newPixels(this.awtImagePixels, this.imageColorModel, 0, this.width);
            this.newPixels = false;
        } else {
            this.imageSource.newPixels();
        }
        if (this.img == null && this.awtImage != null) {
            this.img = this.awtImage;
        }
    }

    ImageStack getRGBStack(ImagePlus imp) {
        ImageProcessor ip = imp.getProcessor();
        int w = ip.getWidth();
        int h = ip.getHeight();
        int size = w * h;
        byte[] r = new byte[size];
        byte[] g = new byte[size];
        byte[] b = new byte[size];
        ((ColorProcessor)ip).getRGB(r, g, b);
        ImageStack stack = new ImageStack(w, h);
        stack.addSlice("Red", r);
        stack.addSlice("Green", g);
        stack.addSlice("Blue", b);
        return stack;
    }

    public static IndexColorModel createModelFromColor(Color color) {
        byte[] rLut = new byte[256];
        byte[] gLut = new byte[256];
        byte[] bLut = new byte[256];
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        double rIncr = (double)red / 255.0;
        double gIncr = (double)green / 255.0;
        double bIncr = (double)blue / 255.0;
        int i = 0;
        while (i < 256) {
            rLut[i] = (byte)((double)i * rIncr);
            gLut[i] = (byte)((double)i * gIncr);
            bLut[i] = (byte)((double)i * bIncr);
            ++i;
        }
        return new IndexColorModel(8, 256, rLut, gLut, bLut);
    }
}

