/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.treatment.window;

import fr.inra.sad.bagap.apiland.analysis.Analysis;
import fr.inra.sad.bagap.apiland.analysis.matrix.output.CsvOutput;
import fr.inra.sad.bagap.apiland.analysis.matrix.output.DeltaAsciiGridOutput;
import fr.inra.sad.bagap.apiland.analysis.matrix.output.HeaderAsciiGridOutput;
import fr.inra.sad.bagap.apiland.analysis.matrix.output.HeaderDeltaAsciiGridOutput;
import fr.inra.sad.bagap.apiland.analysis.matrix.output.InterpolateLinearSplineAsciiGridOutput;
import fr.inra.sad.bagap.apiland.analysis.matrix.output.InterpolateLinearSplineCsvOutput;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.MultipleWindowMatrixProcessType;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.WindowMatrixProcessType;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.metric.MatrixMetricManager;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.WindowMatrixAnalysisBuilder;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.shape.CenteredWindow;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.shape.MultipleWindow;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.shape.Window;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.shape.WindowShapeType;
import fr.inra.sad.bagap.apiland.analysis.window.WindowAnalysisType;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Friction;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import fr.inra.sad.bagap.apiland.treatment.GlobalTreatmentManager;
import fr.inra.sad.bagap.apiland.treatment.Treatment;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class SlidingWindowMatrixTreatment
extends Treatment {
    private Matrix matrix;
    private boolean interpolation;
    private WindowShapeType shape;
    private List<Integer> windowSizes;
    private int delta;
    private double minRate;
    private String csv;
    private String ascii;
    private Friction frictionMap;
    private Matrix frictionMatrix;
    private Set<String> metrics;
    private Set<Integer> filters;
    private Set<Integer> unfilters;

    public SlidingWindowMatrixTreatment() {
        super("sliding", GlobalTreatmentManager.get());
        this.defineInput("matrix", Matrix.class);
        this.defineInput("shape", WindowShapeType.class);
        this.defineInput("friction_map", Friction.class);
        this.defineInput("friction_matrix", Matrix.class);
        this.defineInput("window_sizes", List.class);
        this.defineInput("delta", Integer.class);
        this.defineInput("interpolation", Boolean.class);
        this.defineInput("min_rate", Double.class);
        this.defineInput("metrics", Set.class);
        this.defineInput("csv", String.class);
        this.defineInput("ascii", String.class);
        this.defineInput("filters", Set.class);
        this.defineInput("unfilters", Set.class);
    }

    @Override
    protected void doInit() {
        this.matrix = (Matrix)this.getInput("matrix");
        this.shape = (WindowShapeType)((Object)this.getInput("shape"));
        this.frictionMap = (Friction)this.getInput("friction_map");
        this.frictionMatrix = (Matrix)this.getInput("friction_matrix");
        this.windowSizes = (List)this.getInput("window_sizes");
        this.metrics = (Set)this.getInput("metrics");
        this.csv = (String)this.getInput("csv");
        this.ascii = (String)this.getInput("ascii");
        this.delta = (Integer)this.getInput("delta");
        this.interpolation = (Boolean)this.getInput("interpolation");
        this.minRate = (Double)this.getInput("min_rate");
        this.filters = (Set)this.getInput("filters");
        this.unfilters = (Set)this.getInput("unfilters");
    }

    @Override
    protected void doRun() {
        Window w;
        WindowMatrixProcessType pt = this.windowSizes.size() == 1 ? new WindowMatrixProcessType(this.matrix) : new MultipleWindowMatrixProcessType(this.matrix);
        for (String metric : this.metrics) {
            pt.addMetric(MatrixMetricManager.get(metric));
        }
        if (this.windowSizes.size() == 1) {
            w = this.frictionMap != null ? new CenteredWindow(this.shape.create(this.matrix, (double)this.windowSizes.get(0).intValue() * this.matrix.cellsize() / 2.0, this.frictionMap, pt)) : (this.frictionMatrix != null ? new CenteredWindow(this.shape.create(this.matrix, (double)this.windowSizes.get(0).intValue() * this.matrix.cellsize() / 2.0, this.frictionMatrix, pt)) : new CenteredWindow(this.shape.create(this.windowSizes.get(0))));
        } else {
            Collections.sort(this.windowSizes);
            Collections.reverse(this.windowSizes);
            Window[] ws = new Window[this.windowSizes.size()];
            for (int i = 0; i < this.windowSizes.size(); ++i) {
                ws[i] = this.frictionMap != null ? new CenteredWindow(this.shape.create(this.matrix, (double)this.windowSizes.get(i).intValue() * this.matrix.cellsize() / 2.0, this.frictionMap, pt)) : (this.frictionMatrix != null ? new CenteredWindow(this.shape.create(this.matrix, (double)this.windowSizes.get(i).intValue() * this.matrix.cellsize() / 2.0, this.frictionMatrix, pt)) : new CenteredWindow(this.shape.create(this.windowSizes.get(i))));
            }
            w = new MultipleWindow(ws);
        }
        WindowMatrixAnalysisBuilder builder = new WindowMatrixAnalysisBuilder(WindowAnalysisType.SLIDING);
        builder.addMatrix(this.matrix);
        builder.setWindow(w);
        builder.setProcessType(pt);
        builder.setDisplacement(this.delta);
        builder.setMinRate(this.minRate);
        builder.setFilters(this.filters);
        builder.setUnfilters(this.unfilters);
        if (this.csv != null) {
            if (this.delta != 1 && this.interpolation) {
                builder.addObserver(new InterpolateLinearSplineCsvOutput(this.matrix, this.csv, this.delta));
                builder.addObserver(new HeaderAsciiGridOutput(this.csv.replace(".csv", "") + "_header.txt", 1));
            } else {
                builder.addObserver(new CsvOutput(this.matrix, this.csv));
                builder.addObserver(new HeaderDeltaAsciiGridOutput(this.csv.replace(".csv", "") + "_header.txt", this.delta));
            }
        }
        if (this.ascii != null) {
            if (this.ascii.endsWith(".asc") && this.metrics.size() == 1 && this.windowSizes.size() == 1) {
                String metric = this.metrics.iterator().next();
                if (this.delta != 1 && this.interpolation) {
                    builder.addObserver(new InterpolateLinearSplineAsciiGridOutput(metric, this.ascii, this.delta));
                } else {
                    builder.addObserver(new DeltaAsciiGridOutput(metric, this.ascii, this.delta));
                }
            } else {
                for (String metric : this.metrics) {
                    if (this.delta != 1 && this.interpolation) {
                        if (this.windowSizes.size() == 1) {
                            builder.addObserver(new InterpolateLinearSplineAsciiGridOutput(metric, this.ascii + "w" + this.windowSizes.get(0) + "_" + metric + ".asc", this.delta));
                            continue;
                        }
                        for (int size : this.windowSizes) {
                            builder.addObserver(new InterpolateLinearSplineAsciiGridOutput("w" + size + "_" + metric, this.ascii + "w" + size + "_" + metric + ".asc", this.delta));
                        }
                        continue;
                    }
                    if (this.windowSizes.size() == 1) {
                        builder.addObserver(new DeltaAsciiGridOutput(metric, this.ascii + "w" + this.windowSizes.get(0) + "_" + metric + "_d_" + this.delta + ".asc", this.delta));
                        continue;
                    }
                    for (int size : this.windowSizes) {
                        builder.addObserver(new DeltaAsciiGridOutput("w" + size + "_" + metric, this.ascii + "w" + size + "_" + metric + ".asc", this.delta));
                    }
                }
            }
        }
        Object wa = builder.build();
        ((Analysis)wa).addObserver(this);
        ((Analysis)wa).allRun();
    }

    @Override
    protected void doClose() {
    }
}

