/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.treatment.window;

import com.csvreader.CsvWriter;
import fr.inra.sad.bagap.apiland.analysis.Analysis;
import fr.inra.sad.bagap.apiland.analysis.AnalysisObserver;
import fr.inra.sad.bagap.apiland.analysis.AnalysisState;
import fr.inra.sad.bagap.apiland.analysis.matrix.output.MapCsvOutput;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.WindowMatrixProcessType;
import fr.inra.sad.bagap.apiland.analysis.matrix.process.metric.MatrixMetricManager;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.WindowMatrixAnalysisBuilder;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.shape.CornerWindow;
import fr.inra.sad.bagap.apiland.analysis.matrix.window.shape.RectangularWindow;
import fr.inra.sad.bagap.apiland.analysis.window.WindowAnalysisType;
import fr.inra.sad.bagap.apiland.core.space.impl.raster.matrix.Matrix;
import fr.inra.sad.bagap.apiland.treatment.GlobalTreatmentManager;
import fr.inra.sad.bagap.apiland.treatment.Treatment;
import java.util.Set;

public class MapWindowMatrixTreatment
extends Treatment
implements AnalysisObserver {
    private Matrix matrix;
    private CsvWriter csv;
    private Set<String> metrics;

    public MapWindowMatrixTreatment() {
        super("whole map", GlobalTreatmentManager.get());
        this.defineInput("matrix", Matrix.class);
        this.defineInput("metrics", Set.class);
        this.defineInput("csv", CsvWriter.class);
    }

    @Override
    protected void doInit() {
        this.matrix = (Matrix)this.getInput("matrix");
        this.metrics = (Set)this.getInput("metrics");
        this.csv = (CsvWriter)this.getInput("csv");
    }

    @Override
    protected void doRun() {
        WindowMatrixProcessType pt = new WindowMatrixProcessType(this.matrix);
        for (String metric : this.metrics) {
            pt.addMetric(MatrixMetricManager.get(metric));
        }
        CornerWindow w = new CornerWindow(new RectangularWindow(this.matrix.width(), this.matrix.height()));
        WindowMatrixAnalysisBuilder builder = new WindowMatrixAnalysisBuilder(WindowAnalysisType.MAP);
        builder.addMatrix(this.matrix);
        builder.setWindow(w);
        builder.setProcessType(pt);
        builder.addObserver(new MapCsvOutput(this.metrics, this.csv));
        Object wa = builder.build();
        ((Analysis)wa).addObserver(this);
        ((Analysis)wa).allRun();
    }

    @Override
    protected void doClose() {
    }

    @Override
    public void notify(Analysis ma, AnalysisState state) {
    }
}

