/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.treatment;

import fr.inra.sad.bagap.apiland.treatment.Treatment;
import fr.inra.sad.bagap.apiland.treatment.TreatmentManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class LocalTreatmentManager
implements TreatmentManager {
    private List<Treatment> treatments = new LinkedList<Treatment>();
    private Map<Treatment, Map<String, Map<Treatment, String>>> links = new HashMap<Treatment, Map<String, Map<Treatment, String>>>();

    @Override
    public void addTreatment(Treatment t) {
        throw new UnsupportedOperationException();
    }

    protected void addTreatment(TreatmentManager manager, Treatment t) {
        this.treatments.add(t);
        t.setTreatmentManager(manager);
    }

    @Override
    public void addLink(Treatment t1, String port1, Treatment t2, String port2) {
        if (!t1.hasPort(port1)) {
            System.err.println("warning : the port named '" + port1 + "' does not exist in the treatment '" + t1 + "'");
        } else {
            if (!t2.hasPort(port2)) {
                throw new IllegalArgumentException("name error : the port '" + port2 + "' does not exist in the treatment '" + t2 + "'");
            }
            if (!t1.getPortBinding(port1).isAssignableFrom(t2.getPortBinding(port2))) {
                throw new IllegalArgumentException("cast error : the port '" + port1 + "' of the treatment '" + t1 + "' " + "and the port '" + port2 + "' of the treatment '" + t2 + "' do not have the same cast : " + "'" + t1.getPortBinding(port1) + "' against '" + t2.getPortBinding(port2) + "'");
            }
        }
        if (!this.links.containsKey(t1)) {
            this.links.put(t1, new HashMap());
        }
        if (!this.links.get(t1).containsKey(port1)) {
            this.links.get(t1).put(port1, new HashMap());
        }
        this.links.get(t1).get(port1).put(t2, port2);
    }

    @Override
    public void flow(Treatment t, String port, Object o) {
        if (this.links.containsKey(t) && this.links.get(t).containsKey(port)) {
            for (Map.Entry<Treatment, String> e : this.links.get(t).get(port).entrySet()) {
                System.out.println("flow de " + t + "(" + port + ") vers " + e.getKey() + "(" + e.getValue() + ") avec la valeur " + o);
                if (t.manager().equals(e.getKey())) {
                    e.getKey().setOutput(e.getValue(), o);
                    continue;
                }
                e.getKey().setInput(e.getValue(), o);
            }
        }
    }

    @Override
    public Iterator<Treatment> iterator() {
        return this.treatments.iterator();
    }

    @Override
    public void clear() {
        this.treatments.clear();
        this.treatments = null;
        this.links.clear();
        this.links = null;
    }
}

