/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.sad.bagap.apiland.simul.operation;

import fr.inra.sad.bagap.apiland.core.util.Landator;
import fr.inra.sad.bagap.apiland.simul.operation.Landment;
import fr.inra.sad.bagap.apiland.simul.operation.OpLandment;
import fr.inra.sad.bagap.apiland.simul.operation.OpTypeComposition;
import java.util.HashSet;
import java.util.Set;

public class OpTypeLandment
extends OpTypeComposition {
    private static final long serialVersionUID = 1L;
    private Set<Landment<Landator<?>>> landments;

    public OpTypeLandment() {
        this.reset();
    }

    @Override
    public void reset() {
        super.reset();
        this.landments = new HashSet();
    }

    private double addition() {
        double total = 0.0;
        for (Landment<Landator<?>> a : this.landments) {
            total += a.getRate();
        }
        return total;
    }

    @Override
    public boolean isValid() {
        double total = this.addition();
        if (total <= 101.0 && total >= 99.0) {
            return super.isValid();
        }
        System.err.println("invalid landment total --> " + total + ", must be (around) 100 %");
        return false;
    }

    private void setLandment(Landment<Landator<?>> affectation) {
        this.landments.add(affectation);
    }

    public Set<Landment<Landator<?>>> getLandments() {
        return this.landments;
    }

    @Override
    public boolean setParameter(String name, Object value) {
        if (name.equalsIgnoreCase("assignment")) {
            try {
                this.setLandment((Landment)value);
                return true;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        return super.setParameter(name, value);
    }

    @Override
    public OpLandment getOperation() {
        return new OpLandment(this);
    }
}

